/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.quorum;

import com.bigdata.concurrent.FutureTaskMon;
import com.bigdata.concurrent.TimeoutException;
import com.bigdata.ha.HAPipelineGlue;
import com.bigdata.quorum.AsynchronousQuorumCloseException;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.QuorumActor;
import com.bigdata.quorum.QuorumClient;
import com.bigdata.quorum.QuorumEvent;
import com.bigdata.quorum.QuorumEventEnum;
import com.bigdata.quorum.QuorumException;
import com.bigdata.quorum.QuorumListener;
import com.bigdata.quorum.QuorumMember;
import com.bigdata.quorum.QuorumWatcher;
import com.bigdata.util.InnerCause;
import com.bigdata.util.StackInfoReport;
import com.bigdata.util.concurrent.DaemonThreadFactory;
import com.bigdata.util.concurrent.ThreadGuard;
import java.io.IOException;
import java.rmi.Remote;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public abstract class AbstractQuorum<S extends Remote, C extends QuorumClient<S>>
implements Quorum<S, C> {
    protected static final transient Logger log = Logger.getLogger(AbstractQuorum.class);
    protected static final transient Logger qlog = Logger.getLogger((String)"com.bigdata.quorum.quorumState");
    protected static final transient String ERR_NOT_MEMBER = "Not a quorum member : ";
    protected static final transient String ERR_NOT_PIPELINE = "Not a pipeline member : ";
    protected static final transient String ERR_NOT_IN_CONSENSUS = "Not in a quorum consensus : ";
    protected static final transient String ERR_BAD_TOKEN = "Bad token : ";
    protected static final transient String ERR_QUORUM_MET = "Quorum is met : ";
    protected static final transient String ERR_CAN_NOT_MEET = "Quorum can not meet : ";
    protected static final transient String ERR_QUORUM_BREAK = "Quorum break";
    private final long timeout = TimeUnit.SECONDS.toNanos(1L);
    private final int k;
    protected final int kmeet;
    private volatile long token;
    private final CopyOnWriteArraySet<QuorumListener> listeners = new CopyOnWriteArraySet();
    protected final ReentrantLock lock = new ReentrantLock();
    private final Condition quorumChange = this.lock.newCondition();
    private final Condition membersChange = this.lock.newCondition();
    private final Condition pipelineChange = this.lock.newCondition();
    private final Condition votesChange = this.lock.newCondition();
    private final Condition joinedChange = this.lock.newCondition();
    private long lastValidToken;
    private final LinkedHashSet<UUID> members;
    private final TreeMap<Long, LinkedHashSet<UUID>> votes;
    private final LinkedHashSet<UUID> joined;
    private final LinkedHashSet<UUID> pipeline;
    private volatile C client;
    private QuorumWatcherBase watcher;
    private QuorumActorBase actor;
    private ThreadPoolExecutor watcherActionService;
    private final boolean singleThreadWatcher = false;
    private final long watcherShutdownTimeout = 3000L;
    private ThreadPoolExecutor actorActionService;
    private final boolean singleThreadActor = true;
    private final long actorShutdownTimeout = 3000L;
    private final Set<FutureTask<Void>> knownActorTasks = new HashSet<FutureTask<Void>>();
    private ExecutorService eventService;
    private final boolean sendSynchronous = true;
    private final ThreadGuard threadGuard = new ThreadGuard();

    protected void guard(ThreadGuard.Guard r) throws InterruptedException {
        this.threadGuard.guard(r);
    }

    protected AbstractQuorum(int k) {
        if (k < 1) {
            throw new IllegalArgumentException();
        }
        if (k % 2 == 0) {
            throw new IllegalArgumentException("k must be odd: " + k);
        }
        this.k = k;
        this.kmeet = (k + 1) / 2;
        this.lastValidToken = -1L;
        this.token = -1L;
        this.members = new LinkedHashSet(k);
        this.votes = new TreeMap();
        this.joined = new LinkedHashSet(k);
        this.pipeline = new LinkedHashSet(k * 2);
    }

    protected void finalize() throws Throwable {
        this.terminate();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(C client) {
        if (client == null) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            if (this.client != null) {
                throw new IllegalStateException();
            }
            this.lastValidToken = -1L;
            this.token = -1L;
            this.client = client;
            if (client instanceof QuorumMember) {
                this.actor = this.newActor(client.getLogicalServiceZPath(), ((QuorumMember)client).getServiceId());
            }
            this.watcherActionService = (ThreadPoolExecutor)Executors.newCachedThreadPool(new DaemonThreadFactory("WatcherActionService"));
            this.actorActionService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("ActorActionService"));
            this.lastValidToken = this.getLastValidTokenFromQuorumState(client);
            this.watcher = this.newWatcher(client.getLogicalServiceZPath());
            this.eventService = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("client=" + client));
            }
            client.start(this);
            this.watcher.start();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected long getLastValidTokenFromQuorumState(C client) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptAll() {
        Set<FutureTask<Void>> set = this.knownActorTasks;
        synchronized (set) {
            for (Future future : this.knownActorTasks) {
                future.cancel(true);
            }
            this.threadGuard.interruptAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        boolean interrupted = false;
        this.lock.lock();
        try {
            block35: {
                List<Runnable> notrun;
                block34: {
                    this.interruptAll();
                    if (this.client == null) {
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("client=" + this.client));
                    }
                    if (this.watcher != null) {
                        try {
                            this.watcher.terminate();
                        }
                        catch (Throwable t) {
                            if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                                interrupted = true;
                            }
                            this.launderThrowable(t);
                        }
                    }
                    if (this.watcherActionService != null) {
                        this.watcherActionService.shutdown();
                        try {
                            if (this.watcherActionService.awaitTermination(3000L, TimeUnit.MILLISECONDS)) break block34;
                            log.error((Object)("WatcherActionService termination timeout: activeCount=" + this.watcherActionService.getActiveCount()));
                        }
                        catch (TimeoutException ex) {
                            notrun = this.watcherActionService.shutdownNow();
                            this.watcherActionService = null;
                            for (Runnable r : notrun) {
                                if (!(r instanceof Future)) continue;
                                ((Future)((Object)r)).cancel(true);
                            }
                        }
                        catch (InterruptedException ex) {
                            interrupted = true;
                        }
                        finally {
                            notrun = this.watcherActionService.shutdownNow();
                            this.watcherActionService = null;
                            for (Runnable r : notrun) {
                                if (!(r instanceof Future)) continue;
                                ((Future)((Object)r)).cancel(true);
                            }
                        }
                    }
                }
                if (this.actorActionService != null) {
                    this.actorActionService.shutdown();
                    try {
                        if (this.actorActionService.awaitTermination(3000L, TimeUnit.MILLISECONDS)) break block35;
                        log.error((Object)"ActorActionService termination timeout");
                    }
                    catch (TimeoutException ex) {
                        notrun = this.actorActionService.shutdownNow();
                        this.actorActionService = null;
                        for (Runnable r : notrun) {
                            if (!(r instanceof Future)) continue;
                            ((Future)((Object)r)).cancel(true);
                        }
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                    }
                    finally {
                        notrun = this.actorActionService.shutdownNow();
                        this.actorActionService = null;
                        for (Runnable r : notrun) {
                            if (!(r instanceof Future)) continue;
                            ((Future)((Object)r)).cancel(true);
                        }
                    }
                }
            }
            try {
                this.client.terminate();
            }
            catch (Throwable t) {
                if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                    interrupted = true;
                }
                this.launderThrowable(t);
            }
            this.listeners.clear();
            this.lastValidToken = -1L;
            this.token = -1L;
            this.members.clear();
            this.votes.clear();
            this.joined.clear();
            this.pipeline.clear();
            this.quorumChange.signalAll();
            this.membersChange.signalAll();
            this.pipelineChange.signalAll();
            this.votesChange.signalAll();
            this.joinedChange.signalAll();
            this.client = null;
        }
        finally {
            this.lock.unlock();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    protected abstract QuorumActorBase newActor(String var1, UUID var2);

    protected abstract QuorumWatcherBase newWatcher(String var1);

    public String toString() {
        C c = this.client;
        return super.toString() + "{ k=" + this.k + ", lastValidToken=" + this.lastValidToken + ", token=" + this.token + ", members=" + Collections.unmodifiableCollection(this.members) + ", pipeline=" + Collections.unmodifiableCollection(this.pipeline) + ", votes=" + Collections.unmodifiableMap(this.votes) + ", joined=" + Collections.unmodifiableCollection(this.joined) + ", client=" + (c == null ? "N/A" : c.getClass().getName()) + ", serviceId=" + (c instanceof QuorumMember ? ((QuorumMember)c).getServiceId() : "N/A") + ", listeners=" + this.listeners + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringAtomic() {
        this.lock.lock();
        try {
            String string = this.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public C getClient() {
        this.lock.lock();
        try {
            C client = this.client;
            if (client == null) {
                throw new IllegalStateException();
            }
            C c = client;
            return c;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected C getClientNoLock() {
        C client = this.client;
        if (client == null) {
            throw new IllegalStateException();
        }
        return client;
    }

    @Override
    public QuorumMember<S> getMember() {
        this.lock.lock();
        try {
            C client = this.client;
            if (client == null) {
                throw new IllegalStateException();
            }
            if (client instanceof QuorumMember) {
                QuorumMember quorumMember = (QuorumMember)client;
                return quorumMember;
            }
            throw new UnsupportedOperationException();
        }
        finally {
            this.lock.unlock();
        }
    }

    private QuorumMember<S> getClientAsMember() {
        C client = this.client;
        if (client instanceof QuorumMember) {
            return (QuorumMember)client;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuorumActor<S, C> getActor() {
        this.lock.lock();
        try {
            if (this.client == null) {
                throw new IllegalStateException();
            }
            QuorumActorBase quorumActorBase = this.actor;
            return quorumActorBase;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QuorumWatcher<S, C> getWatcher() {
        this.lock.lock();
        try {
            if (this.client == null) {
                throw new IllegalStateException();
            }
            QuorumWatcherBase quorumWatcherBase = this.watcher;
            return quorumWatcherBase;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void addListener(QuorumListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (listener == this.client) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(listener);
    }

    @Override
    public final void removeListener(QuorumListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        if (listener == this.client) {
            throw new IllegalArgumentException();
        }
        this.listeners.remove(listener);
    }

    @Override
    public final int replicationFactor() {
        return this.k;
    }

    @Override
    public final boolean isQuorum(int njoined) {
        return njoined >= this.kmeet;
    }

    @Override
    public final boolean isHighlyAvailable() {
        return this.replicationFactor() > 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long lastValidToken() {
        this.lock.lock();
        try {
            long l = this.lastValidToken;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final UUID[] getMembers() {
        this.lock.lock();
        try {
            UUID[] uUIDArray = this.members.toArray(new UUID[0]);
            return uUIDArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Map<Long, UUID[]> getVotes() {
        this.lock.lock();
        try {
            LinkedHashMap<Long, UUID[]> tmp = new LinkedHashMap<Long, UUID[]>();
            for (Long lastCommitTime : this.votes.keySet()) {
                tmp.put(lastCommitTime, this.votes.get(lastCommitTime).toArray(new UUID[0]));
            }
            LinkedHashMap<Long, UUID[]> linkedHashMap = tmp;
            return linkedHashMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Long getCastVote(UUID serviceId) {
        this.lock.lock();
        try {
            for (Map.Entry<Long, LinkedHashSet<UUID>> entry : this.votes.entrySet()) {
                Long lastCommitTime = entry.getKey();
                Set votes = entry.getValue();
                if (!votes.contains(serviceId)) continue;
                Long l = lastCommitTime;
                return l;
            }
            Long l = null;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getCastVoteIfConsensus(UUID serviceId) {
        this.lock.lock();
        try {
            for (Map.Entry<Long, LinkedHashSet<UUID>> entry : this.votes.entrySet()) {
                Set votes = entry.getValue();
                if (!votes.contains(serviceId)) continue;
                if (this.isQuorum(votes.size())) {
                    Long l = (long)entry.getKey();
                    return l;
                }
                Long l = null;
                return l;
            }
            Long l = null;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int getIndexInVoteOrder(UUID serviceId, UUID[] voteOrder) {
        for (int i = 0; i < voteOrder.length; ++i) {
            if (!voteOrder[i].equals(serviceId)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final UUID[] getJoined() {
        this.lock.lock();
        try {
            UUID[] uUIDArray = this.joined.toArray(new UUID[0]);
            return uUIDArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final UUID[] getPipeline() {
        this.lock.lock();
        try {
            UUID[] uUIDArray = this.pipeline.toArray(new UUID[0]);
            return uUIDArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final UUID getLastInPipeline() {
        this.lock.lock();
        try {
            Iterator itr = this.pipeline.iterator();
            UUID lastId = null;
            while (itr.hasNext()) {
                lastId = (UUID)itr.next();
            }
            UUID uUID = lastId;
            return uUID;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final UUID[] getPipelinePriorAndNext(UUID serviceId) {
        if (serviceId == null) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            Iterator itr = this.pipeline.iterator();
            UUID priorId = null;
            while (itr.hasNext()) {
                UUID current = (UUID)itr.next();
                if (serviceId.equals(current)) {
                    UUID nextId = itr.hasNext() ? (UUID)itr.next() : null;
                    UUID[] uUIDArray = new UUID[]{priorId, nextId};
                    return uUIDArray;
                }
                priorId = current;
            }
            UUID[] uUIDArray = null;
            return uUIDArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final UUID getLeaderId() {
        long tmp;
        UUID leaderId = null;
        this.lock.lock();
        try {
            tmp = this.token;
            if (this.token == -1L) {
                UUID uUID = null;
                return uUID;
            }
            UUID[] joined = this.getJoined();
            if (joined.length > 0) {
                leaderId = joined[0];
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.token != tmp) {
            return null;
        }
        return leaderId;
    }

    @Override
    public final long token() {
        return this.token;
    }

    @Override
    public final void assertQuorum(long token) {
        if (this.token == -1L) {
            throw new QuorumException("Quorum not met");
        }
        if (token != -1L && this.token == token) {
            return;
        }
        throw new QuorumException("Quorum not met on token: expected=" + token + ", actual=" + this.token);
    }

    @Override
    public final void assertLeader(long token) {
        if (token == -1L) {
            throw new QuorumException("Client token is invalid.");
        }
        if (this.token == -1L) {
            throw new QuorumException("Quorum is not met.");
        }
        UUID leaderId = this.getLeaderId();
        QuorumMember<S> client = this.getClientAsMember();
        if (client == null) {
            throw new QuorumException();
        }
        if (!leaderId.equals(client.getServiceId())) {
            throw new QuorumException();
        }
        this.assertQuorum(token);
    }

    @Override
    public final boolean isQuorumMet() {
        return this.token != -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isQuorumFullyMet(long token) {
        this.lock.lock();
        try {
            if (this.joined.size() != this.k) {
                boolean bl = false;
                return bl;
            }
            this.assertQuorum(token);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long awaitQuorum() throws InterruptedException, AsynchronousQuorumCloseException {
        this.lock.lock();
        try {
            while (this.token == -1L && this.client != null) {
                this.quorumChange.await();
            }
            if (this.client == null) {
                throw new AsynchronousQuorumCloseException();
            }
            long l = this.token;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long awaitQuorum(long timeout, TimeUnit units) throws InterruptedException, java.util.concurrent.TimeoutException, AsynchronousQuorumCloseException {
        long begin = System.nanoTime();
        long nanos = units.toNanos(timeout);
        long remaining = nanos;
        if (!this.lock.tryLock(remaining, TimeUnit.NANOSECONDS)) {
            throw new java.util.concurrent.TimeoutException();
        }
        try {
            remaining = nanos - (System.nanoTime() - begin);
            while (this.token == -1L && this.client != null && remaining > 0L) {
                if (!this.quorumChange.await(remaining, TimeUnit.NANOSECONDS)) {
                    throw new java.util.concurrent.TimeoutException();
                }
                remaining = nanos - (System.nanoTime() - begin);
            }
            if (this.client == null) {
                throw new AsynchronousQuorumCloseException();
            }
            if (remaining <= 0L) {
                throw new java.util.concurrent.TimeoutException();
            }
            long l = this.token;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void awaitBreak() throws InterruptedException, AsynchronousQuorumCloseException {
        this.lock.lock();
        try {
            while (this.token != -1L && this.client != null) {
                this.quorumChange.await();
            }
            if (this.client == null) {
                throw new AsynchronousQuorumCloseException();
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void awaitBreak(long timeout, TimeUnit units) throws InterruptedException, java.util.concurrent.TimeoutException, AsynchronousQuorumCloseException {
        long begin = System.nanoTime();
        long nanos = units.toNanos(timeout);
        long remaining = nanos;
        if (!this.lock.tryLock(remaining, TimeUnit.NANOSECONDS)) {
            throw new java.util.concurrent.TimeoutException();
        }
        try {
            remaining = nanos - (System.nanoTime() - begin);
            while (this.token != -1L && this.client != null && remaining > 0L) {
                if (!this.quorumChange.await(remaining, TimeUnit.NANOSECONDS)) {
                    throw new java.util.concurrent.TimeoutException();
                }
                remaining = nanos - (System.nanoTime() - begin);
            }
            if (this.client == null) {
                throw new AsynchronousQuorumCloseException();
            }
            if (remaining <= 0L) {
                throw new java.util.concurrent.TimeoutException();
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void awaitEnoughJoinedToMeet() throws QuorumException, java.util.concurrent.TimeoutException {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        try {
            long nanos;
            long begin = System.nanoTime();
            long remaining = nanos = this.timeout;
            while (!this.isQuorum(this.joined.size()) && this.client != null && remaining > 0L) {
                if (!this.joinedChange.await(remaining, TimeUnit.NANOSECONDS)) {
                    throw new QuorumException("Not enough joined services: njoined=" + this.joined.size() + " : " + this);
                }
                remaining = nanos - (System.nanoTime() - begin);
            }
            if (this.client == null) {
                throw new AsynchronousQuorumCloseException();
            }
            if (remaining <= 0L) {
                throw new java.util.concurrent.TimeoutException();
            }
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    protected void sendEvent(QuorumEvent e) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("" + e));
        }
        this.sendEventNow(e);
    }

    private void sendEventNow(QuorumEvent e) {
        this.sendOneEvent(e, (QuorumListener)this.client);
        for (QuorumListener l : this.listeners) {
            this.sendOneEvent(e, l);
        }
    }

    private void sendOneEvent(QuorumEvent e, QuorumListener l) {
        try {
            if (l != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("event=" + e + ", listener=" + l));
                }
                l.notify(e);
            }
        }
        catch (Throwable t) {
            log.warn((Object)t, t);
        }
    }

    protected void launderThrowable(Throwable t) {
        if (InnerCause.isInnerCause(t, InterruptedException.class)) {
            Thread.currentThread().interrupt();
            return;
        }
        log.error((Object)t, t);
    }

    protected static class E
    implements QuorumEvent {
        private final QuorumEventEnum type;
        private final long lastValidToken;
        private final long token;
        private final UUID serviceId;
        private final Long lastCommitTime;

        public E(QuorumEventEnum type, long lastValidToken, long token, UUID serviceId) {
            this(type, lastValidToken, token, serviceId, -1L);
        }

        public E(QuorumEventEnum type, long lastValidToken, long token, UUID serviceId, long lastCommitTime) {
            this.type = type;
            this.lastValidToken = lastValidToken;
            this.token = token;
            this.serviceId = serviceId;
            this.lastCommitTime = lastCommitTime;
        }

        @Override
        public QuorumEventEnum getEventType() {
            return this.type;
        }

        @Override
        public UUID getServiceId() {
            return this.serviceId;
        }

        @Override
        public long lastValidToken() {
            return this.lastValidToken;
        }

        @Override
        public long token() {
            return this.token;
        }

        @Override
        public long lastCommitTime() {
            if (this.type != QuorumEventEnum.CAST_VOTE) {
                throw new UnsupportedOperationException();
            }
            return this.lastCommitTime;
        }

        public String toString() {
            return "QuorumEvent{type=" + (Object)((Object)this.type) + ",lastValidToken=" + this.lastValidToken + ",currentToken=" + this.token + ",serviceId=" + this.serviceId + (this.type == QuorumEventEnum.CAST_VOTE ? ",lastCommitTime=" + this.lastCommitTime : "") + "}";
        }
    }

    protected abstract class QuorumWatcherBase
    implements QuorumWatcher<S, C> {
        protected final String logicalServiceId;

        protected QuorumWatcherBase(String logicalServiceId) {
            if (logicalServiceId == null) {
                throw new IllegalArgumentException();
            }
            this.logicalServiceId = logicalServiceId;
        }

        protected void start() {
        }

        protected void terminate() {
        }

        protected void doAction(final Runnable r) {
            if (!AbstractQuorum.this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (AbstractQuorum.this.watcherActionService == null) {
                throw new IllegalStateException();
            }
            AbstractQuorum.this.watcherActionService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        r.run();
                    }
                    catch (Throwable t) {
                        log.error((Object)t, t);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void memberAdd(UUID serviceId) {
            block8: {
                if (serviceId == null) {
                    throw new IllegalArgumentException();
                }
                AbstractQuorum.this.lock.lock();
                try {
                    UUID clientId;
                    if (!AbstractQuorum.this.members.add(serviceId)) break block8;
                    AbstractQuorum.this.membersChange.signalAll();
                    QuorumMember client = AbstractQuorum.this.getClientAsMember();
                    if (client != null && serviceId.equals(clientId = client.getServiceId())) {
                        try {
                            client.memberAdd();
                        }
                        catch (Throwable t) {
                            AbstractQuorum.this.launderThrowable(t);
                        }
                    }
                    AbstractQuorum.this.sendEvent(new E(QuorumEventEnum.MEMBER_ADD, AbstractQuorum.this.lastValidToken, AbstractQuorum.this.token, serviceId));
                    if (log.isInfoEnabled()) {
                        log.info((Object)("serviceId=" + serviceId.toString()));
                    }
                }
                finally {
                    AbstractQuorum.this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void memberRemove(UUID serviceId) {
            block8: {
                if (serviceId == null) {
                    throw new IllegalArgumentException();
                }
                AbstractQuorum.this.lock.lock();
                try {
                    UUID clientId;
                    if (!AbstractQuorum.this.members.remove(serviceId)) break block8;
                    AbstractQuorum.this.membersChange.signalAll();
                    QuorumMember client = AbstractQuorum.this.getClientAsMember();
                    if (client != null && serviceId.equals(clientId = client.getServiceId())) {
                        try {
                            client.memberRemove();
                        }
                        catch (Throwable t) {
                            AbstractQuorum.this.launderThrowable(t);
                        }
                    }
                    AbstractQuorum.this.sendEvent(new E(QuorumEventEnum.MEMBER_REMOVE, AbstractQuorum.this.lastValidToken, AbstractQuorum.this.token, serviceId));
                    if (log.isInfoEnabled()) {
                        log.info((Object)("serviceId=" + serviceId.toString()));
                    }
                }
                finally {
                    AbstractQuorum.this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void pipelineAdd(UUID serviceId) {
            block13: {
                if (serviceId == null) {
                    throw new IllegalArgumentException();
                }
                AbstractQuorum.this.lock.lock();
                try {
                    QuorumMember client;
                    UUID lastId = AbstractQuorum.this.getLastInPipeline();
                    if (!AbstractQuorum.this.pipeline.add(serviceId)) break block13;
                    AbstractQuorum.this.pipelineChange.signalAll();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("pipeline=" + Arrays.toString(AbstractQuorum.this.getPipeline())));
                    }
                    if ((client = AbstractQuorum.this.getClientAsMember()) != null) {
                        UUID clientId = client.getServiceId();
                        if (serviceId.equals(clientId)) {
                            try {
                                client.pipelineAdd();
                            }
                            catch (Throwable t) {
                                AbstractQuorum.this.launderThrowable(t);
                            }
                        }
                        if (lastId != null && clientId.equals(lastId)) {
                            try {
                                client.pipelineChange(null, serviceId);
                            }
                            catch (Throwable t) {
                                AbstractQuorum.this.launderThrowable(t);
                            }
                        }
                    }
                    AbstractQuorum.this.sendEvent(new E(QuorumEventEnum.PIPELINE_ADD, AbstractQuorum.this.lastValidToken, AbstractQuorum.this.token, serviceId));
                    if (log.isInfoEnabled()) {
                        log.info((Object)("serviceId=" + serviceId.toString()));
                    }
                }
                finally {
                    AbstractQuorum.this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void pipelineRemove(UUID serviceId) {
            block22: {
                if (serviceId == null) {
                    throw new IllegalArgumentException();
                }
                AbstractQuorum.this.lock.lock();
                try {
                    Long lastCommitTime;
                    UUID clientId;
                    UUID[] priorNext = AbstractQuorum.this.getPipelinePriorAndNext(serviceId);
                    if (!AbstractQuorum.this.pipeline.remove(serviceId)) break block22;
                    AbstractQuorum.this.pipelineChange.signalAll();
                    QuorumMember client = AbstractQuorum.this.getClientAsMember();
                    if (client != null) {
                        clientId = client.getServiceId();
                        if (serviceId.equals(clientId)) {
                            try {
                                client.pipelineRemove();
                            }
                            catch (Throwable t) {
                                AbstractQuorum.this.launderThrowable(t);
                            }
                        }
                        if (priorNext != null && clientId.equals(priorNext[0])) {
                            try {
                                client.pipelineChange(serviceId, priorNext[1]);
                            }
                            catch (Throwable t) {
                                AbstractQuorum.this.launderThrowable(t);
                            }
                        }
                        if (priorNext != null && priorNext[0] != null && clientId.equals(priorNext[1])) {
                            try {
                                client.pipelineUpstreamChange();
                            }
                            catch (Throwable t) {
                                AbstractQuorum.this.launderThrowable(t);
                            }
                        }
                        if (priorNext != null && priorNext[0] == null && clientId.equals(priorNext[1])) {
                            try {
                                client.pipelineElectedLeader();
                            }
                            catch (Throwable t) {
                                AbstractQuorum.this.launderThrowable(t);
                            }
                        }
                    }
                    AbstractQuorum.this.sendEvent(new E(QuorumEventEnum.PIPELINE_REMOVE, AbstractQuorum.this.lastValidToken, AbstractQuorum.this.token, serviceId));
                    if (client != null && priorNext != null && priorNext[0] == null && (lastCommitTime = AbstractQuorum.this.getCastVoteIfConsensus(clientId = client.getServiceId())) != null) {
                        UUID[] pipeline;
                        int njoined;
                        UUID[] voteOrder;
                        UUID leaderId;
                        boolean isLeader;
                        if (log.isInfoEnabled()) {
                            log.info((Object)("This client is in consensus on commitTime: " + lastCommitTime));
                        }
                        if ((isLeader = (leaderId = (voteOrder = ((LinkedHashSet)AbstractQuorum.this.votes.get(lastCommitTime)).toArray(new UUID[0]))[0]).equals(clientId)) && (njoined = AbstractQuorum.this.joined.size()) >= AbstractQuorum.this.kmeet && AbstractQuorum.this.token == -1L && (pipeline = AbstractQuorum.this.getPipeline()).length > 0 && pipeline[0].equals(clientId)) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)("Electing leader: " + AbstractQuorum.this.toString()));
                            }
                            this.doAction(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractQuorum.this.actor.setToken(AbstractQuorum.this.lastValidToken + 1L);
                                }
                            });
                        }
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)("serviceId=" + serviceId.toString()));
                    }
                }
                finally {
                    AbstractQuorum.this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void castVote(UUID serviceId, long lastCommitTime) {
            block19: {
                if (serviceId == null) {
                    throw new IllegalArgumentException();
                }
                if (lastCommitTime < 0L) {
                    throw new IllegalArgumentException();
                }
                AbstractQuorum.this.lock.lock();
                try {
                    LinkedHashSet<UUID> votesForCommitTime = (LinkedHashSet<UUID>)AbstractQuorum.this.votes.get(lastCommitTime);
                    if (votesForCommitTime == null) {
                        votesForCommitTime = new LinkedHashSet<UUID>();
                        AbstractQuorum.this.votes.put(lastCommitTime, votesForCommitTime);
                    }
                    if (!votesForCommitTime.add(serviceId)) break block19;
                    AbstractQuorum.this.votesChange.signalAll();
                    int nvotes = votesForCommitTime.size();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("serviceId=" + serviceId.toString() + ", lastCommitTime=" + lastCommitTime + ", nvotes=" + nvotes));
                    }
                    AbstractQuorum.this.sendEvent(new E(QuorumEventEnum.CAST_VOTE, AbstractQuorum.this.lastValidToken, AbstractQuorum.this.token, serviceId, lastCommitTime));
                    if (!AbstractQuorum.this.isQuorum(nvotes)) break block19;
                    QuorumMember client = AbstractQuorum.this.getClientAsMember();
                    if (nvotes == AbstractQuorum.this.kmeet) {
                        if (client != null) {
                            try {
                                client.consensus(lastCommitTime);
                            }
                            catch (Throwable t) {
                                AbstractQuorum.this.launderThrowable(t);
                            }
                        }
                        AbstractQuorum.this.sendEvent(new E(QuorumEventEnum.CONSENSUS, AbstractQuorum.this.lastValidToken, AbstractQuorum.this.token, serviceId, lastCommitTime));
                    }
                    if (client != null) {
                        UUID clientId = client.getServiceId();
                        UUID[] voteOrder = votesForCommitTime.toArray(new UUID[0]);
                        if (nvotes == AbstractQuorum.this.kmeet && clientId.equals(voteOrder[0])) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)"First service will join");
                            }
                            this.doAction(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractQuorum.this.actor.serviceJoin();
                                }
                            });
                        } else if (clientId.equals(serviceId)) {
                            int index = AbstractQuorum.this.getIndexInVoteOrder(clientId, voteOrder);
                            if (index == -1) {
                                throw new AssertionError((Object)AbstractQuorum.this.toString());
                            }
                            UUID waitsFor = voteOrder[index - 1];
                            if (AbstractQuorum.this.joined.contains(waitsFor)) {
                                if (log.isInfoEnabled()) {
                                    log.info((Object)("Follower will join: " + AbstractQuorum.this.toString()));
                                }
                                this.doAction(new Runnable(){

                                    @Override
                                    public void run() {
                                        AbstractQuorum.this.actor.serviceJoin();
                                        if (qlog.isInfoEnabled()) {
                                            qlog.info((Object)("After join: " + AbstractQuorum.this));
                                        }
                                    }
                                });
                            }
                        }
                    }
                }
                finally {
                    AbstractQuorum.this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void withdrawVote(UUID serviceId) {
            if (serviceId == null) {
                throw new IllegalArgumentException();
            }
            AbstractQuorum.this.lock.lock();
            try {
                Iterator itr = AbstractQuorum.this.votes.entrySet().iterator();
                while (itr.hasNext()) {
                    QuorumMember client;
                    Map.Entry entry = itr.next();
                    Set votesForCommitTime = (Set)entry.getValue();
                    if (!votesForCommitTime.remove(serviceId)) continue;
                    AbstractQuorum.this.votesChange.signalAll();
                    AbstractQuorum.this.sendEvent(new E(QuorumEventEnum.WITHDRAW_VOTE, AbstractQuorum.this.lastValidToken, AbstractQuorum.this.token, serviceId));
                    if (votesForCommitTime.size() + 1 == AbstractQuorum.this.kmeet && (client = AbstractQuorum.this.getClientAsMember()) != null) {
                        try {
                            client.lostConsensus();
                        }
                        catch (Throwable t) {
                            AbstractQuorum.this.launderThrowable(t);
                        }
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)("serviceId=" + serviceId + ", lastCommitTime=" + entry.getKey()));
                    }
                    if (votesForCommitTime.isEmpty()) {
                        itr.remove();
                    }
                    break;
                }
            }
            finally {
                AbstractQuorum.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setToken(long newToken) {
            AbstractQuorum.this.lock.lock();
            try {
                QuorumMember client;
                if (AbstractQuorum.this.lastValidToken == newToken && AbstractQuorum.this.token == newToken) {
                    return;
                }
                if (AbstractQuorum.this.lastValidToken > newToken) {
                    log.error((Object)("Concurrent update: lastValidToken=" + AbstractQuorum.this.lastValidToken + ", newToken=" + newToken));
                    return;
                }
                try {
                    AbstractQuorum.this.awaitEnoughJoinedToMeet();
                }
                catch (java.util.concurrent.TimeoutException e1) {
                    throw new QuorumException(e1);
                }
                AbstractQuorum.this.token = (AbstractQuorum.this.lastValidToken = newToken);
                AbstractQuorum.this.quorumChange.signalAll();
                if (log.isInfoEnabled()) {
                    log.info((Object)("newToken=" + newToken));
                }
                UUID leaderId = AbstractQuorum.this.getLeaderId();
                assert (leaderId != null) : "Leader is null : " + AbstractQuorum.this.toString();
                if (log.isInfoEnabled()) {
                    log.info((Object)("leader=" + leaderId + ", newToken=" + AbstractQuorum.this.token));
                }
                if ((client = AbstractQuorum.this.getClientAsMember()) != null) {
                    try {
                        client.quorumMeet(AbstractQuorum.this.token, leaderId);
                    }
                    catch (Throwable t) {
                        AbstractQuorum.this.launderThrowable(t);
                    }
                }
                E e = new E(QuorumEventEnum.QUORUM_MEET, AbstractQuorum.this.lastValidToken, AbstractQuorum.this.token, leaderId);
                AbstractQuorum.this.sendEvent(e);
            }
            finally {
                AbstractQuorum.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void clearToken() {
            block8: {
                AbstractQuorum.this.lock.lock();
                try {
                    boolean willBreak = AbstractQuorum.this.token != -1L;
                    AbstractQuorum.this.token = -1L;
                    if (!willBreak) break block8;
                    AbstractQuorum.this.quorumChange.signalAll();
                    log.warn((Object)AbstractQuorum.ERR_QUORUM_BREAK);
                    QuorumMember client = AbstractQuorum.this.getClientAsMember();
                    if (client != null) {
                        try {
                            client.quorumBreak();
                        }
                        catch (Exception t) {
                            AbstractQuorum.this.launderThrowable(t);
                        }
                    }
                    AbstractQuorum.this.sendEvent(new E(QuorumEventEnum.QUORUM_BROKE, AbstractQuorum.this.lastValidToken, AbstractQuorum.this.token, null));
                    if (client != null) {
                        UUID clientId = client.getServiceId();
                        if (AbstractQuorum.this.joined.contains(clientId)) {
                            QuorumMember member = AbstractQuorum.this.getMember();
                            this.doAction(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractQuorum.this.actor.withdrawVote();
                                }
                            });
                        }
                    }
                }
                finally {
                    AbstractQuorum.this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void serviceJoin(UUID serviceId) {
            if (serviceId == null) {
                throw new IllegalArgumentException();
            }
            AbstractQuorum.this.lock.lock();
            try {
                Long lastCommitTime;
                UUID clientId;
                QuorumMember client;
                if (!AbstractQuorum.this.joined.add(serviceId)) {
                    return;
                }
                AbstractQuorum.this.joinedChange.signalAll();
                if (log.isInfoEnabled()) {
                    log.info((Object)("serviceId=" + serviceId.toString()));
                }
                if ((client = AbstractQuorum.this.getClientAsMember()) != null && serviceId.equals(clientId = client.getServiceId())) {
                    try {
                        client.serviceJoin();
                    }
                    catch (Throwable t) {
                        AbstractQuorum.this.launderThrowable(t);
                    }
                }
                AbstractQuorum.this.sendEvent(new E(QuorumEventEnum.SERVICE_JOIN, AbstractQuorum.this.lastValidToken, AbstractQuorum.this.token, serviceId));
                if (client != null && (lastCommitTime = AbstractQuorum.this.getCastVoteIfConsensus(clientId = client.getServiceId())) != null) {
                    UUID[] voteOrder;
                    UUID leaderId;
                    boolean isLeader;
                    if (log.isInfoEnabled()) {
                        log.info((Object)("This client is in consensus on commitTime: " + lastCommitTime));
                    }
                    if (isLeader = (leaderId = (voteOrder = ((LinkedHashSet)AbstractQuorum.this.votes.get(lastCommitTime)).toArray(new UUID[0]))[0]).equals(clientId)) {
                        int njoined = AbstractQuorum.this.joined.size();
                        if (njoined >= AbstractQuorum.this.kmeet && AbstractQuorum.this.token == -1L) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)("Ready to elect leader or reorganize pipeline: " + AbstractQuorum.this.toString()));
                            }
                            this.doAction(new Runnable(){

                                @Override
                                public void run() {
                                    if (AbstractQuorum.this.actor.reorganizePipeline()) {
                                        if (log.isInfoEnabled()) {
                                            log.info((Object)("Reorganized the pipeline: " + AbstractQuorum.this.toString()));
                                        }
                                    } else {
                                        if (log.isInfoEnabled()) {
                                            log.info((Object)("Electing leader: " + AbstractQuorum.this.toString()));
                                        }
                                        AbstractQuorum.this.actor.setToken(AbstractQuorum.this.lastValidToken + 1L);
                                    }
                                }
                            });
                        }
                    } else {
                        int index = AbstractQuorum.this.getIndexInVoteOrder(clientId, voteOrder);
                        if (index == -1) {
                            throw new AssertionError((Object)AbstractQuorum.this.toString());
                        }
                        UUID waitsFor = voteOrder[index - 1];
                        if (serviceId.equals(waitsFor)) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)("Follower will join: " + AbstractQuorum.this.toString()));
                            }
                            this.doAction(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractQuorum.this.actor.serviceJoin();
                                }
                            });
                        }
                    }
                }
            }
            finally {
                AbstractQuorum.this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void serviceLeave(UUID serviceId) {
            if (serviceId == null) {
                throw new IllegalArgumentException();
            }
            AbstractQuorum.this.lock.lock();
            try {
                QuorumMember client;
                boolean willBreak;
                UUID leaderId;
                int njoinedBefore = AbstractQuorum.this.joined.size();
                Iterator itr = AbstractQuorum.this.joined.iterator();
                UUID uUID = leaderId = itr.hasNext() ? (UUID)itr.next() : null;
                if (!AbstractQuorum.this.joined.remove(serviceId)) {
                    return;
                }
                AbstractQuorum.this.joinedChange.signalAll();
                int k = AbstractQuorum.this.replicationFactor();
                boolean wasJoined = njoinedBefore >= AbstractQuorum.this.kmeet;
                boolean leaderLeft = wasJoined && serviceId.equals(leaderId);
                boolean bl = willBreak = leaderLeft || njoinedBefore == AbstractQuorum.this.kmeet;
                if (log.isInfoEnabled()) {
                    log.info((Object)("serviceId=" + serviceId + ", k=" + k + ", njoined(before)=" + njoinedBefore + ", wasJoined=" + wasJoined + ", leaderLeft=" + leaderLeft + ", willBreak=" + willBreak));
                }
                if ((client = AbstractQuorum.this.getClientAsMember()) != null && willBreak) {
                    this.doAction(new Runnable(){

                        @Override
                        public void run() {
                            AbstractQuorum.this.actor.clearToken();
                        }
                    });
                }
                if (client != null) {
                    try {
                        UUID clientId = client.getServiceId();
                        if (serviceId.equals(clientId)) {
                            client.serviceLeave();
                        }
                    }
                    catch (Throwable t) {
                        AbstractQuorum.this.launderThrowable(t);
                    }
                }
                AbstractQuorum.this.sendEvent(new E(QuorumEventEnum.SERVICE_LEAVE, AbstractQuorum.this.lastValidToken, AbstractQuorum.this.token, serviceId));
            }
            finally {
                AbstractQuorum.this.lock.unlock();
            }
        }
    }

    protected abstract class QuorumActorBase
    implements QuorumActor<S, C> {
        protected final String logicalServiceId;
        protected final UUID serviceId;

        protected QuorumActorBase(String logicalServiceId, UUID serviceId) {
            if (logicalServiceId == null) {
                throw new IllegalArgumentException();
            }
            if (serviceId == null) {
                throw new IllegalArgumentException();
            }
            this.logicalServiceId = logicalServiceId;
            this.serviceId = serviceId;
        }

        @Override
        public final QuorumMember<S> getQuorumMember() {
            return (QuorumMember)AbstractQuorum.this.client;
        }

        @Override
        public final Quorum<S, C> getQuourm() {
            return AbstractQuorum.this;
        }

        @Override
        public final UUID getServiceId() {
            return this.serviceId;
        }

        private Executor getActorExecutor() {
            return AbstractQuorum.this.actorActionService;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runActorTask(ActorTask task) {
            FutureTaskMon<Void> ft = new FutureTaskMon<Void>(task);
            Set set = AbstractQuorum.this.knownActorTasks;
            synchronized (set) {
                if (!AbstractQuorum.this.knownActorTasks.add(ft)) {
                    throw new AssertionError();
                }
            }
            this.getActorExecutor().execute(ft);
            try {
                ft.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            finally {
                ((FutureTask)ft).cancel(true);
                Set e = AbstractQuorum.this.knownActorTasks;
                synchronized (e) {
                    if (!AbstractQuorum.this.knownActorTasks.remove(ft)) {
                        throw new AssertionError();
                    }
                }
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runActorTask(ActorTask task, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, java.util.concurrent.TimeoutException {
            FutureTaskMon<Void> ft = new FutureTaskMon<Void>(task);
            Set set = AbstractQuorum.this.knownActorTasks;
            synchronized (set) {
                if (!AbstractQuorum.this.knownActorTasks.add(ft)) {
                    throw new AssertionError();
                }
            }
            this.getActorExecutor().execute(ft);
            try {
                ft.get(timeout, unit);
            }
            finally {
                ((FutureTask)ft).cancel(true);
                set = AbstractQuorum.this.knownActorTasks;
                synchronized (set) {
                    if (!AbstractQuorum.this.knownActorTasks.remove(ft)) {
                        throw new AssertionError();
                    }
                }
            }
        }

        @Override
        public final void memberAdd() {
            this.runActorTask(new MemberAddTask());
        }

        @Override
        public final void castVote(long lastCommitTime) {
            this.runActorTask(new CastVoteTask(lastCommitTime));
        }

        @Override
        public final void pipelineAdd() {
            this.runActorTask(new PipelineAddTask());
        }

        @Override
        public final void serviceJoin() {
            this.runActorTask(new ServiceJoinTask());
        }

        @Override
        public final void setToken(long newToken) {
            this.runActorTask(new SetTokenTask(newToken));
        }

        @Override
        public final void clearToken() {
            this.runActorTask(new ClearTokenTask());
        }

        @Override
        public final void memberRemove() {
            this.runActorTask(new MemberRemoveTask());
        }

        @Override
        public final void withdrawVote() {
            this.runActorTask(new WithdrawVoteTask());
        }

        @Override
        public final void pipelineRemove() {
            this.runActorTask(new PipelineRemoveTask());
        }

        @Override
        public final void serviceLeave() {
            this.runActorTask(new ServiceLeaveTask());
        }

        private void conditionalMemberAddImpl() throws InterruptedException {
            if (!AbstractQuorum.this.members.contains(this.serviceId)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("serviceId=" + this.serviceId));
                }
                this.doMemberAdd();
                AbstractQuorum.this.guard(new ThreadGuard.Guard(){

                    @Override
                    public void run() throws InterruptedException {
                        while (!AbstractQuorum.this.members.contains(QuorumActorBase.this.serviceId)) {
                            AbstractQuorum.this.membersChange.await();
                        }
                    }
                });
            }
        }

        private void conditionalMemberRemoveImpl() throws InterruptedException {
            if (AbstractQuorum.this.members.contains(this.serviceId)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("serviceId=" + this.serviceId));
                }
                this.doMemberRemove();
                AbstractQuorum.this.guard(new ThreadGuard.Guard(){

                    @Override
                    public void run() throws InterruptedException {
                        while (AbstractQuorum.this.members.contains(QuorumActorBase.this.serviceId)) {
                            AbstractQuorum.this.membersChange.await();
                        }
                    }
                });
            }
        }

        private void conditionalCastVoteImpl(final long lastCommitTime) throws InterruptedException {
            Long lastCommitTime2;
            Set votesForCommitTime = (Set)AbstractQuorum.this.votes.get(lastCommitTime);
            if (votesForCommitTime != null && votesForCommitTime.contains(this.serviceId) && (lastCommitTime2 = AbstractQuorum.this.getCastVote(this.serviceId)) != null && lastCommitTime2 == lastCommitTime) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("serviceId=" + this.serviceId + ",lastCommitTime=" + lastCommitTime));
            }
            this.conditionalWithdrawVoteImpl();
            this.conditionalPipelineAddImpl();
            this.doCastVote(lastCommitTime);
            AbstractQuorum.this.guard(new ThreadGuard.Guard(){

                @Override
                public void run() throws InterruptedException {
                    Long t = null;
                    while ((t = AbstractQuorum.this.getCastVote(QuorumActorBase.this.serviceId)) == null || t != lastCommitTime) {
                        AbstractQuorum.this.votesChange.await();
                    }
                }
            });
        }

        private void conditionalWithdrawVoteImpl() throws InterruptedException {
            Long lastCommitTime;
            if (log.isDebugEnabled()) {
                log.debug((Object)new StackInfoReport());
            }
            while ((lastCommitTime = AbstractQuorum.this.getCastVote(this.serviceId)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("will withdraw vote: serviceId=" + this.serviceId + ",lastCommitTime=" + lastCommitTime));
                }
                this.doWithdrawVote();
                AbstractQuorum.this.guard(new ThreadGuard.Guard(){

                    @Override
                    public void run() throws InterruptedException {
                        Long tmp;
                        while ((tmp = AbstractQuorum.this.getCastVote(QuorumActorBase.this.serviceId)) != null) {
                            if (!tmp.equals(lastCommitTime)) {
                                log.warn((Object)("Concurrent vote change: old=" + lastCommitTime + ", new=" + tmp));
                                return;
                            }
                            AbstractQuorum.this.votesChange.await();
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("withdrew vote: serviceId=" + QuorumActorBase.this.serviceId + ",lastCommitTime=" + lastCommitTime));
                        }
                    }
                });
            }
        }

        private void conditionalPipelineAddImpl() throws InterruptedException {
            if (!AbstractQuorum.this.pipeline.contains(this.serviceId)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("serviceId=" + this.serviceId));
                }
                this.doPipelineAdd();
                AbstractQuorum.this.guard(new ThreadGuard.Guard(){

                    @Override
                    public void run() throws InterruptedException {
                        while (!AbstractQuorum.this.pipeline.contains(QuorumActorBase.this.serviceId)) {
                            AbstractQuorum.this.pipelineChange.await();
                        }
                    }
                });
            }
        }

        private void conditionalPipelineRemoveImpl() throws InterruptedException {
            if (AbstractQuorum.this.pipeline.contains(this.serviceId)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("serviceId=" + this.serviceId));
                }
                this.doPipelineRemove();
                AbstractQuorum.this.guard(new ThreadGuard.Guard(){

                    @Override
                    public void run() throws InterruptedException {
                        while (AbstractQuorum.this.pipeline.contains(QuorumActorBase.this.serviceId)) {
                            AbstractQuorum.this.pipelineChange.await();
                        }
                    }
                });
            }
        }

        private void conditionalServiceJoin() throws InterruptedException {
            Long lastCommitTime = AbstractQuorum.this.getCastVoteIfConsensus(this.serviceId);
            if (lastCommitTime == null) {
                throw new QuorumException(AbstractQuorum.ERR_NOT_IN_CONSENSUS + this.serviceId);
            }
            Object[] voteOrder = ((LinkedHashSet)AbstractQuorum.this.votes.get(lastCommitTime)).toArray(new UUID[0]);
            int index = AbstractQuorum.this.getIndexInVoteOrder(this.serviceId, (UUID[])voteOrder);
            if (index == -1) {
                throw new AssertionError((Object)AbstractQuorum.this.toString());
            }
            Object[] joined = AbstractQuorum.this.getJoined();
            for (int i = 0; i < index; ++i) {
                if (joined[i].equals(voteOrder[i])) continue;
                throw new QuorumException("Error in vote order: lastCommitTime=" + lastCommitTime + ",serviceId=" + this.serviceId + ",voteOrder=" + Arrays.toString(voteOrder) + ",joined=" + Arrays.toString(joined) + ",errorAtIndex=" + i);
            }
            if (joined.length > index && joined[index].equals(this.serviceId)) {
                return;
            }
            if (AbstractQuorum.this.joined.contains(this.serviceId)) {
                throw new AssertionError();
            }
            this.doServiceJoin();
            AbstractQuorum.this.guard(new ThreadGuard.Guard(){

                @Override
                public void run() throws InterruptedException {
                    while (!AbstractQuorum.this.joined.contains(QuorumActorBase.this.serviceId)) {
                        AbstractQuorum.this.joinedChange.await();
                    }
                }
            });
        }

        private void conditionalServiceLeaveImpl() throws InterruptedException {
            if (AbstractQuorum.this.joined.contains(this.serviceId)) {
                this.doServiceLeave();
                AbstractQuorum.this.guard(new ThreadGuard.Guard(){

                    @Override
                    public void run() throws InterruptedException {
                        while (AbstractQuorum.this.joined.contains(QuorumActorBase.this.serviceId)) {
                            AbstractQuorum.this.joinedChange.await();
                        }
                    }
                });
            }
        }

        private void conditionalClearToken() throws InterruptedException {
            final long oldValue = AbstractQuorum.this.token;
            if (oldValue == -1L) {
                return;
            }
            this.doClearToken();
            AbstractQuorum.this.guard(new ThreadGuard.Guard(){

                @Override
                public void run() throws InterruptedException {
                    while (AbstractQuorum.this.token == oldValue && AbstractQuorum.this.client != null) {
                        AbstractQuorum.this.quorumChange.await();
                    }
                }
            });
            if (AbstractQuorum.this.client == null) {
                throw new AsynchronousQuorumCloseException();
            }
            if (AbstractQuorum.this.token != -1L) {
                throw new QuorumException("Concurrent set of the token: old=" + oldValue + ", new=" + AbstractQuorum.this.token);
            }
            log.warn((Object)AbstractQuorum.ERR_QUORUM_BREAK);
        }

        private void conditionalSetToken(long newValue) throws InterruptedException {
            if (!AbstractQuorum.this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            if (AbstractQuorum.this.lastValidToken == newValue) {
                return;
            }
            if (AbstractQuorum.this.lastValidToken > newValue) {
                throw new QuorumException("Last valid token must advance: lastValidToken=" + AbstractQuorum.this.lastValidToken + ", newValue=" + newValue);
            }
            if (AbstractQuorum.this.token != -1L) {
                throw new QuorumException("Concurrent set of token: expected=-1, actual=" + AbstractQuorum.this.token);
            }
            final long oldValue = AbstractQuorum.this.lastValidToken;
            this.doSetToken(newValue);
            AbstractQuorum.this.guard(new ThreadGuard.Guard(){

                @Override
                public void run() throws InterruptedException {
                    while (AbstractQuorum.this.lastValidToken == oldValue && AbstractQuorum.this.client != null) {
                        AbstractQuorum.this.quorumChange.await();
                    }
                }
            });
            if (AbstractQuorum.this.client == null) {
                throw new AsynchronousQuorumCloseException();
            }
            if (AbstractQuorum.this.lastValidToken != newValue) {
                throw new QuorumException("Concurrent set of lastValidToken: old=" + oldValue + ", new=" + AbstractQuorum.this.lastValidToken + ", expected=" + newValue);
            }
            if (AbstractQuorum.this.token != newValue) {
                throw new QuorumException("Concurrent set of token: expected=" + newValue + ", actual=" + AbstractQuorum.this.token);
            }
        }

        protected abstract void doMemberAdd();

        protected final void doMemberRemove() {
            this.doMemberRemove(this.serviceId);
        }

        protected abstract void doMemberRemove(UUID var1);

        protected abstract void doCastVote(long var1);

        protected final void doWithdrawVote() {
            this.doWithdrawVote(this.serviceId);
        }

        protected abstract void doWithdrawVote(UUID var1);

        protected abstract void doPipelineAdd();

        protected final void doPipelineRemove() {
            this.doPipelineRemove(this.serviceId);
        }

        protected abstract void doPipelineRemove(UUID var1);

        protected abstract void doServiceJoin();

        protected final void doServiceLeave() {
            this.doServiceLeave(this.serviceId);
        }

        protected abstract void doServiceLeave(UUID var1);

        protected abstract void doSetToken(long var1);

        protected abstract void doClearToken();

        @Override
        public final void forceRemoveService(UUID psid) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Will force remove of service: thisService=" + this.serviceId + ", otherServiceId=" + psid));
            }
            this.runActorTask(new ForceRemoveServiceTask(psid));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean reorganizePipeline() {
            UUID leaderId;
            Object[] joined;
            Object[] pipeline;
            if (AbstractQuorum.this.lock.isHeldByCurrentThread()) {
                throw new IllegalMonitorStateException();
            }
            AbstractQuorum.this.lock.lock();
            try {
                pipeline = AbstractQuorum.this.getPipeline();
                joined = AbstractQuorum.this.getJoined();
                leaderId = joined[0];
            }
            finally {
                AbstractQuorum.this.lock.unlock();
            }
            if (qlog.isInfoEnabled()) {
                qlog.info((Object)("pipeline=" + Arrays.toString(pipeline)));
                qlog.info((Object)("joined  =" + Arrays.toString(joined)));
                qlog.info((Object)("leader  = " + leaderId));
                qlog.info((Object)("self    = " + this.serviceId));
            }
            boolean modified = false;
            for (int i = 0; i < pipeline.length; ++i) {
                Object otherId = pipeline[i];
                if (leaderId.equals(otherId)) {
                    return modified;
                }
                Object otherService = this.getQuorumMember().getService((UUID)otherId);
                if (otherService == null) {
                    throw new QuorumException("Could not discover service: serviceId=" + this.serviceId);
                }
                try {
                    ((HAPipelineGlue)otherService).moveToEndOfPipeline().get();
                    modified = true;
                    if (!qlog.isInfoEnabled()) continue;
                    qlog.info((Object)("moved   =" + otherId));
                    qlog.info((Object)("pipeline=" + Arrays.toString(AbstractQuorum.this.getPipeline())));
                    qlog.info((Object)("joined  =" + Arrays.toString(AbstractQuorum.this.getJoined())));
                    continue;
                }
                catch (IOException ex) {
                    throw new QuorumException("Could not move service to end of the pipeline: serviceId=" + this.serviceId + ", otherId=" + otherId, ex);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return modified;
                }
                catch (ExecutionException e) {
                    throw new QuorumException("Could not move service to end of the pipeline: serviceId=" + this.serviceId + ", otherId=" + otherId, e);
                }
            }
            return modified;
        }

        /*
         * Signature claims super is com.bigdata.quorum.AbstractQuorum$QuorumActorBase.ActorTask, not com.bigdata.quorum.AbstractQuorum$QuorumActorBase$ActorTask - discarding signature.
         */
        private class ForceRemoveServiceTask
        extends ActorTask {
            private final UUID psid;

            ForceRemoveServiceTask(UUID psid) {
                this.psid = psid;
            }

            @Override
            protected void doAction() throws InterruptedException {
                log.warn((Object)("Forcing remove of service: thisService=" + QuorumActorBase.this.serviceId + ", otherServiceId=" + this.psid));
                QuorumActorBase.this.doServiceLeave(this.psid);
                QuorumActorBase.this.doWithdrawVote(this.psid);
                QuorumActorBase.this.doPipelineRemove(this.psid);
                QuorumActorBase.this.doMemberRemove(this.psid);
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.AbstractQuorum$QuorumActorBase.ActorTask, not com.bigdata.quorum.AbstractQuorum$QuorumActorBase$ActorTask - discarding signature.
         */
        private final class ServiceLeaveTask
        extends ActorTask {
            private ServiceLeaveTask() {
            }

            @Override
            protected void doAction() throws InterruptedException {
                QuorumActorBase.this.conditionalWithdrawVoteImpl();
                QuorumActorBase.this.conditionalPipelineRemoveImpl();
                QuorumActorBase.this.conditionalServiceLeaveImpl();
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.AbstractQuorum$QuorumActorBase.ActorTask, not com.bigdata.quorum.AbstractQuorum$QuorumActorBase$ActorTask - discarding signature.
         */
        private final class PipelineRemoveTask
        extends ActorTask {
            private PipelineRemoveTask() {
            }

            @Override
            protected void doAction() throws InterruptedException {
                QuorumActorBase.this.conditionalWithdrawVoteImpl();
                QuorumActorBase.this.conditionalServiceLeaveImpl();
                QuorumActorBase.this.conditionalPipelineRemoveImpl();
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.AbstractQuorum$QuorumActorBase.ActorTask, not com.bigdata.quorum.AbstractQuorum$QuorumActorBase$ActorTask - discarding signature.
         */
        private final class WithdrawVoteTask
        extends ActorTask {
            private WithdrawVoteTask() {
            }

            @Override
            protected void doAction() throws InterruptedException {
                QuorumActorBase.this.conditionalServiceLeaveImpl();
                QuorumActorBase.this.conditionalPipelineRemoveImpl();
                QuorumActorBase.this.conditionalWithdrawVoteImpl();
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.AbstractQuorum$QuorumActorBase.ActorTask, not com.bigdata.quorum.AbstractQuorum$QuorumActorBase$ActorTask - discarding signature.
         */
        private final class MemberRemoveTask
        extends ActorTask {
            private MemberRemoveTask() {
            }

            @Override
            protected void doAction() throws InterruptedException {
                QuorumActorBase.this.conditionalServiceLeaveImpl();
                QuorumActorBase.this.conditionalPipelineRemoveImpl();
                QuorumActorBase.this.conditionalWithdrawVoteImpl();
                QuorumActorBase.this.conditionalMemberRemoveImpl();
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.AbstractQuorum$QuorumActorBase.ActorTask, not com.bigdata.quorum.AbstractQuorum$QuorumActorBase$ActorTask - discarding signature.
         */
        private final class ClearTokenTask
        extends ActorTask {
            private ClearTokenTask() {
            }

            @Override
            protected void doAction() throws InterruptedException {
                QuorumActorBase.this.conditionalClearToken();
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.AbstractQuorum$QuorumActorBase.ActorTask, not com.bigdata.quorum.AbstractQuorum$QuorumActorBase$ActorTask - discarding signature.
         */
        private final class SetTokenTask
        extends ActorTask {
            private final long newToken;

            public SetTokenTask(long newToken) {
                this.newToken = newToken;
            }

            @Override
            protected void doAction() throws InterruptedException {
                if (!AbstractQuorum.this.isQuorum(AbstractQuorum.this.joined.size())) {
                    throw new QuorumException("Quorum can not meet :  too few services are joined: #joined=" + AbstractQuorum.this.joined.size() + ", k=" + AbstractQuorum.this.k);
                }
                if (this.newToken <= AbstractQuorum.this.lastValidToken) {
                    throw new QuorumException("Bad token : lastValidToken=" + AbstractQuorum.this.lastValidToken + ", but newToken=" + this.newToken);
                }
                if (AbstractQuorum.this.token != -1L) {
                    throw new QuorumException(AbstractQuorum.ERR_QUORUM_MET);
                }
                QuorumActorBase.this.conditionalSetToken(this.newToken);
                log.warn((Object)"Quorum meet.");
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.AbstractQuorum$QuorumActorBase.ActorTask, not com.bigdata.quorum.AbstractQuorum$QuorumActorBase$ActorTask - discarding signature.
         */
        private final class ServiceJoinTask
        extends ActorTask {
            private ServiceJoinTask() {
            }

            @Override
            protected void doAction() throws InterruptedException {
                if (!AbstractQuorum.this.members.contains(QuorumActorBase.this.serviceId)) {
                    throw new QuorumException(AbstractQuorum.ERR_NOT_MEMBER + QuorumActorBase.this.serviceId);
                }
                if (!AbstractQuorum.this.pipeline.contains(QuorumActorBase.this.serviceId)) {
                    throw new QuorumException(AbstractQuorum.ERR_NOT_PIPELINE + QuorumActorBase.this.serviceId);
                }
                QuorumActorBase.this.conditionalServiceJoin();
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.AbstractQuorum$QuorumActorBase.ActorTask, not com.bigdata.quorum.AbstractQuorum$QuorumActorBase$ActorTask - discarding signature.
         */
        private final class PipelineAddTask
        extends ActorTask {
            private PipelineAddTask() {
            }

            @Override
            protected void doAction() throws InterruptedException {
                if (!AbstractQuorum.this.members.contains(QuorumActorBase.this.serviceId)) {
                    throw new QuorumException(AbstractQuorum.ERR_NOT_MEMBER + QuorumActorBase.this.serviceId);
                }
                QuorumActorBase.this.conditionalPipelineAddImpl();
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.AbstractQuorum$QuorumActorBase.ActorTask, not com.bigdata.quorum.AbstractQuorum$QuorumActorBase$ActorTask - discarding signature.
         */
        private final class CastVoteTask
        extends ActorTask {
            private final long lastCommitTime;

            public CastVoteTask(long lastCommitTime) {
                if (lastCommitTime < 0L) {
                    throw new IllegalArgumentException();
                }
                this.lastCommitTime = lastCommitTime;
            }

            @Override
            protected void doAction() throws InterruptedException {
                if (!AbstractQuorum.this.members.contains(QuorumActorBase.this.serviceId)) {
                    throw new QuorumException(AbstractQuorum.ERR_NOT_MEMBER + QuorumActorBase.this.serviceId);
                }
                QuorumActorBase.this.conditionalCastVoteImpl(this.lastCommitTime);
            }
        }

        /*
         * Signature claims super is com.bigdata.quorum.AbstractQuorum$QuorumActorBase.ActorTask, not com.bigdata.quorum.AbstractQuorum$QuorumActorBase$ActorTask - discarding signature.
         */
        private final class MemberAddTask
        extends ActorTask {
            private MemberAddTask() {
            }

            @Override
            protected void doAction() throws InterruptedException {
                QuorumActorBase.this.conditionalMemberAddImpl();
            }
        }

        protected abstract class ActorTask
        implements Callable<Void> {
            protected ActorTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                AbstractQuorum.this.lock.lockInterruptibly();
                try {
                    this.doAction();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    AbstractQuorum.this.lock.unlock();
                }
            }

            protected abstract void doAction() throws InterruptedException;
        }
    }
}

