/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.quorum;

import com.bigdata.quorum.QuorumStateChangeEvent;
import com.bigdata.quorum.QuorumStateChangeEventEnum;
import java.util.UUID;

public class QCE
implements QuorumStateChangeEvent {
    private final QuorumStateChangeEventEnum eventType;
    private final UUID[] downstreamOldAndNew;
    private final Long lastCommitTimeConsensus;
    private final Long token;
    private final UUID leaderId;

    public QCE(QuorumStateChangeEventEnum eventType) {
        this(eventType, null, null, null, null);
    }

    public QCE(QuorumStateChangeEventEnum eventType, UUID[] downstreamOldAndNew, Long lastCommitTimeConsensus, Long token, UUID leaderId) {
        if (eventType == null) {
            throw new IllegalArgumentException();
        }
        switch (eventType) {
            case PIPELINE_CHANGE: {
                if (downstreamOldAndNew == null) {
                    throw new IllegalArgumentException();
                }
                if (downstreamOldAndNew.length == 2) break;
                throw new IllegalArgumentException();
            }
            case CONSENSUS: {
                if (lastCommitTimeConsensus != null) break;
                throw new IllegalArgumentException();
            }
            case QUORUM_MEET: {
                if (token == null) {
                    throw new IllegalArgumentException();
                }
                if (leaderId != null) break;
                throw new IllegalArgumentException();
            }
        }
        this.eventType = eventType;
        this.downstreamOldAndNew = downstreamOldAndNew;
        this.lastCommitTimeConsensus = lastCommitTimeConsensus;
        this.token = token;
        this.leaderId = leaderId;
    }

    @Override
    public QuorumStateChangeEventEnum getEventType() {
        return this.eventType;
    }

    @Override
    public UUID[] getDownstreamOldAndNew() {
        if (this.eventType != QuorumStateChangeEventEnum.PIPELINE_CHANGE) {
            throw new UnsupportedOperationException();
        }
        return this.downstreamOldAndNew;
    }

    @Override
    public long getLastCommitTimeConsensus() {
        if (this.eventType != QuorumStateChangeEventEnum.CONSENSUS) {
            throw new UnsupportedOperationException();
        }
        return this.lastCommitTimeConsensus;
    }

    @Override
    public long getToken() {
        if (this.eventType != QuorumStateChangeEventEnum.QUORUM_MEET) {
            throw new UnsupportedOperationException();
        }
        return this.token;
    }

    @Override
    public UUID getLeaderId() {
        if (this.eventType != QuorumStateChangeEventEnum.QUORUM_MEET) {
            throw new UnsupportedOperationException();
        }
        return this.leaderId;
    }

    public String toString() {
        return "QuorumStateChangeEvent{type=" + (Object)((Object)this.eventType) + (this.eventType == QuorumStateChangeEventEnum.PIPELINE_CHANGE ? ",oldDownstreamId=" + this.downstreamOldAndNew[0] + ",newDownstreamId=" + this.downstreamOldAndNew[1] : "") + (this.eventType == QuorumStateChangeEventEnum.CONSENSUS ? ",lastCommitTime=" + this.lastCommitTimeConsensus : "") + (this.eventType == QuorumStateChangeEventEnum.QUORUM_MEET ? ",token=" + this.token + ",leaderId=" + this.leaderId : "") + "}";
    }
}

