/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.sail;

import com.bigdata.rdf.graph.IGASEngine;
import com.bigdata.rdf.graph.IGraphAccessor;
import com.bigdata.rdf.graph.impl.sail.SAILGASEngine;
import com.bigdata.rdf.graph.impl.util.GASRunnerBase;
import com.bigdata.rdf.graph.util.SailGraphLoader;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.memory.MemoryStore;

public class SAILGASRunner<VS, ES, ST>
extends GASRunnerBase<VS, ES, ST> {
    private static final Logger log = Logger.getLogger(SAILGASRunner.class);

    public SAILGASRunner(String[] args) throws ClassNotFoundException {
        super(args);
    }

    @Override
    protected SAILOptionData newOptionData() {
        return new SAILOptionData();
    }

    @Override
    protected IGASEngine newGASEngine() {
        return new SAILGASEngine(this.getOptionData().nthreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadFiles() throws Exception {
        SAILOptionData opt = this.getOptionData();
        String[] resources = opt.loadSet.toArray(new String[0]);
        boolean ok = false;
        SailConnection cxn = null;
        try {
            cxn = opt.cxn;
            new SailGraphLoader(cxn).loadGraph(null, resources);
            cxn.commit();
            ok = true;
        }
        finally {
            if (cxn != null && !ok) {
                cxn.rollback();
            }
        }
    }

    @Override
    protected SAILOptionData getOptionData() {
        return (SAILOptionData)super.getOptionData();
    }

    @Override
    protected IGraphAccessor newGraphAccessor() {
        return new SAILGASEngine.SAILGraphAccessor(this.getOptionData().cxn, false, new Resource[0]);
    }

    public static void main(String[] args) throws Exception {
        new SAILGASRunner(args).call();
    }

    protected class SAILOptionData
    extends GASRunnerBase.OptionData {
        private Sail sail;
        private SailConnection cxn;

        protected SAILOptionData() {
            super(SAILGASRunner.this);
            this.sail = null;
            this.cxn = null;
        }

        @Override
        public void init() throws Exception {
            super.init();
            this.sail = new MemoryStore();
            this.sail.initialize();
            this.cxn = this.sail.getConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            if (this.cxn != null) {
                try {
                    this.cxn.close();
                }
                catch (SailException e) {
                    log.error((Object)e, (Throwable)e);
                }
                finally {
                    this.cxn = null;
                }
            }
            if (this.sail != null) {
                try {
                    this.sail.shutDown();
                }
                catch (SailException e) {
                    log.error((Object)e, (Throwable)e);
                }
                finally {
                    this.sail = null;
                }
            }
        }

        @Override
        public boolean handleArg(AtomicInteger i, String[] args) {
            return super.handleArg(i, args);
        }

        @Override
        public void report(StringBuilder sb) {
        }
    }
}

