/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.inf;

import com.bigdata.rdf.inf.BackchainOwlSameAsIterator;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import com.bigdata.striterator.EmptyChunkedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.util.Arrays;

public class BackchainOwlSameAsPropertiesPOIterator
extends BackchainOwlSameAsIterator {
    private IChunkedOrderedIterator<ISPO> sameAs3It;
    private IChunkedOrderedIterator<ISPO> sameAs2It;
    private TempTripleStore sameAs3;
    private TempTripleStore sameAs2;
    private boolean canRemove = false;

    public BackchainOwlSameAsPropertiesPOIterator(IChunkedOrderedIterator<ISPO> src, IV p, IV o, AbstractTripleStore db, IV sameAs) {
        super(src, db, sameAs);
        boolean present;
        IChunkedOrderedIterator<ISPO> absent;
        ISPO[] spos = new SPO[100];
        int numSPOs = 0;
        for (IV same : this.getSames(o)) {
            IChunkedOrderedIterator<ISPO> reversePropsIt = db.getAccessPath(null, p, same).iterator();
            while (reversePropsIt.hasNext()) {
                ISPO reverseProp = (ISPO)reversePropsIt.next();
                if (IVUtility.equals(reverseProp.p(), sameAs) && IVUtility.equals(reverseProp.s(), o)) continue;
                if (numSPOs == 100) {
                    boolean present2 = false;
                    IChunkedOrderedIterator<ISPO> absent2 = db.bulkFilterStatements(spos, numSPOs, present2);
                    if (absent2.hasNext()) {
                        if (this.sameAs3 == null) {
                            this.sameAs3 = this.createTempTripleStore();
                        }
                        db.addStatements(this.sameAs3, true, absent2, null);
                    }
                    numSPOs = 0;
                }
                spos[numSPOs++] = new SPO(reverseProp.s(), reverseProp.p(), o, StatementEnum.Inferred);
                this.dumpSPO(spos[numSPOs - 1]);
            }
        }
        if (numSPOs > 0 && (absent = db.bulkFilterStatements(spos, numSPOs, present = false)).hasNext()) {
            if (this.sameAs3 == null) {
                this.sameAs3 = this.createTempTripleStore();
            }
            db.addStatements(this.sameAs3, true, absent, null);
        }
    }

    @Override
    public IKeyOrder<ISPO> getKeyOrder() {
        return this.src.getKeyOrder();
    }

    @Override
    public boolean hasNext() {
        if (this.sameAs3It == null) {
            this.sameAs3It = this.sameAs3 != null ? this.sameAs3.getAccessPath(SPOKeyOrder.SPO).iterator() : new EmptyChunkedIterator<ISPO>(SPOKeyOrder.SPO);
        }
        if (this.src.hasNext() || this.sameAs3It.hasNext()) {
            return true;
        }
        if (this.sameAs2It == null) {
            this.sameAs2It = this.sameAs2 != null ? this.sameAs2.getAccessPath(SPOKeyOrder.SPO).iterator() : new EmptyChunkedIterator<ISPO>(SPOKeyOrder.SPO);
        }
        return this.sameAs2It.hasNext();
    }

    @Override
    public ISPO next() {
        if (this.sameAs3It == null) {
            this.sameAs3It = this.sameAs3 != null ? this.sameAs3.getAccessPath(SPOKeyOrder.SPO).iterator() : new EmptyChunkedIterator<ISPO>(SPOKeyOrder.SPO);
        }
        this.canRemove = false;
        ISPO current = null;
        if (this.src.hasNext()) {
            current = (ISPO)this.src.next();
            this.processSameAs2(current);
            this.canRemove = true;
        } else if (this.sameAs3It.hasNext()) {
            current = (ISPO)this.sameAs3It.next();
            this.processSameAs2(current);
        } else {
            if (this.sameAs2It == null) {
                this.sameAs2It = this.sameAs2 != null ? this.sameAs2.getAccessPath(SPOKeyOrder.SPO).iterator() : new EmptyChunkedIterator<ISPO>(SPOKeyOrder.SPO);
            }
            if (this.sameAs2It.hasNext()) {
                current = (ISPO)this.sameAs2It.next();
            }
        }
        return current;
    }

    private void processSameAs2(ISPO spo) {
        boolean present;
        IChunkedOrderedIterator<ISPO> absent;
        ISPO[] spos = new ISPO[100];
        int numSPOs = 0;
        for (IV same : this.getSames(spo.s())) {
            if (IVUtility.equals(spo.p(), this.sameAs) && IVUtility.equals(same, spo.o())) continue;
            if (numSPOs == 100) {
                boolean present2 = false;
                IChunkedOrderedIterator<ISPO> absent2 = this.db.bulkFilterStatements(spos, numSPOs, present2);
                if (absent2.hasNext()) {
                    if (this.sameAs2 == null) {
                        this.sameAs2 = this.createTempTripleStore();
                    }
                    this.db.addStatements(this.sameAs2, true, absent2, null);
                }
                numSPOs = 0;
            }
            spos[numSPOs++] = new SPO(same, spo.p(), spo.o(), StatementEnum.Inferred);
            this.dumpSPO(spos[numSPOs - 1]);
        }
        if (numSPOs > 0 && (absent = this.db.bulkFilterStatements(spos, numSPOs, present = false)).hasNext()) {
            if (this.sameAs2 == null) {
                this.sameAs2 = this.createTempTripleStore();
            }
            this.db.addStatements(this.sameAs2, true, absent, null);
        }
    }

    public ISPO[] nextChunk() {
        ISPO[] s = new ISPO[100];
        int n = 0;
        while (this.hasNext() && n < 100) {
            s[n++] = this.next();
        }
        ISPO[] stmts = new ISPO[n];
        System.arraycopy(s, 0, stmts, 0, n);
        return stmts;
    }

    public ISPO[] nextChunk(IKeyOrder<ISPO> keyOrder) {
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        ISPO[] stmts = this.nextChunk();
        if (this.src.getKeyOrder() != keyOrder) {
            Arrays.sort(stmts, 0, stmts.length, keyOrder.getComparator());
        }
        return stmts;
    }

    @Override
    public void close() {
        this.src.close();
        if (this.sameAs3It != null) {
            this.sameAs3It.close();
        }
        if (this.sameAs2It != null) {
            this.sameAs2It.close();
        }
        if (this.sameAs3 != null) {
            this.sameAs3.close();
        }
        if (this.sameAs2 != null) {
            this.sameAs2.close();
        }
    }

    @Override
    public void remove() {
        if (this.canRemove) {
            this.src.remove();
        }
    }
}

