/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.inf;

import com.bigdata.rdf.inf.BackchainOwlSameAsIterator;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import com.bigdata.striterator.EmptyChunkedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.util.Arrays;

public class BackchainOwlSameAsPropertiesSPIterator
extends BackchainOwlSameAsIterator {
    private IChunkedOrderedIterator<ISPO> sameAs2It;
    private IChunkedOrderedIterator<ISPO> sameAs3It;
    private TempTripleStore sameAs2;
    private TempTripleStore sameAs3;
    private boolean canRemove = false;

    public BackchainOwlSameAsPropertiesSPIterator(IChunkedOrderedIterator<ISPO> src, IV s, IV p, AbstractTripleStore db, IV sameAs) {
        super(src, db, sameAs);
        boolean present;
        IChunkedOrderedIterator<ISPO> absent;
        ISPO[] spos = new SPO[100];
        int numSPOs = 0;
        for (IV same : this.getSames(s)) {
            IChunkedOrderedIterator<ISPO> propsIt = db.getAccessPath(same, p, null).iterator();
            while (propsIt.hasNext()) {
                ISPO prop = (ISPO)propsIt.next();
                if (IVUtility.equals(prop.p(), sameAs) && IVUtility.equals(s, prop.o())) continue;
                if (numSPOs == 100) {
                    boolean present2 = false;
                    IChunkedOrderedIterator<ISPO> absent2 = db.bulkFilterStatements(spos, numSPOs, present2);
                    if (absent2.hasNext()) {
                        if (this.sameAs2 == null) {
                            this.sameAs2 = this.createTempTripleStore();
                        }
                        db.addStatements(this.sameAs2, true, absent2, null);
                    }
                    numSPOs = 0;
                }
                spos[numSPOs++] = new SPO(s, prop.p(), prop.o(), StatementEnum.Inferred);
            }
        }
        if (numSPOs > 0 && (absent = db.bulkFilterStatements(spos, numSPOs, present = false)).hasNext()) {
            if (this.sameAs2 == null) {
                this.sameAs2 = this.createTempTripleStore();
            }
            db.addStatements(this.sameAs2, true, absent, null);
        }
    }

    @Override
    public IKeyOrder<ISPO> getKeyOrder() {
        return this.src.getKeyOrder();
    }

    @Override
    public boolean hasNext() {
        if (this.sameAs2It == null) {
            this.sameAs2It = this.sameAs2 != null ? this.sameAs2.getAccessPath(SPOKeyOrder.SPO).iterator() : new EmptyChunkedIterator<ISPO>(SPOKeyOrder.SPO);
        }
        if (this.src.hasNext() || this.sameAs2It.hasNext()) {
            return true;
        }
        if (this.sameAs3It == null && this.sameAs3It == null) {
            this.sameAs3It = this.sameAs3 != null ? this.sameAs3.getAccessPath(SPOKeyOrder.SPO).iterator() : new EmptyChunkedIterator<ISPO>(SPOKeyOrder.SPO);
        }
        return this.sameAs3It.hasNext();
    }

    @Override
    public ISPO next() {
        if (this.sameAs2It == null) {
            this.sameAs2It = this.sameAs2 != null ? this.sameAs2.getAccessPath(SPOKeyOrder.SPO).iterator() : new EmptyChunkedIterator<ISPO>(SPOKeyOrder.SPO);
        }
        this.canRemove = false;
        ISPO current = null;
        if (this.src.hasNext()) {
            current = (ISPO)this.src.next();
            this.processSameAs3(current);
            this.canRemove = true;
        } else if (this.sameAs2It.hasNext()) {
            current = (ISPO)this.sameAs2It.next();
            this.processSameAs3(current);
        } else {
            if (this.sameAs3It == null) {
                this.sameAs3It = this.sameAs3 != null ? this.sameAs3.getAccessPath(SPOKeyOrder.SPO).iterator() : new EmptyChunkedIterator<ISPO>(SPOKeyOrder.SPO);
            }
            if (this.sameAs3It.hasNext()) {
                current = (ISPO)this.sameAs3It.next();
            }
        }
        return current;
    }

    private void processSameAs3(ISPO spo) {
        boolean present;
        IChunkedOrderedIterator<ISPO> absent;
        ISPO[] spos = new ISPO[100];
        int numSPOs = 0;
        for (IV same : this.getSames(spo.o())) {
            if (spo.p().equals(this.sameAs) && spo.s().equals(same)) continue;
            if (numSPOs == 100) {
                boolean present2 = false;
                IChunkedOrderedIterator<ISPO> absent2 = this.db.bulkFilterStatements(spos, numSPOs, present2);
                if (absent2.hasNext()) {
                    if (this.sameAs3 == null) {
                        this.sameAs3 = this.createTempTripleStore();
                    }
                    this.db.addStatements(this.sameAs3, true, absent2, null);
                }
                numSPOs = 0;
            }
            spos[numSPOs++] = new SPO(spo.s(), spo.p(), same, StatementEnum.Inferred);
            this.dumpSPO(spos[numSPOs - 1]);
        }
        if (numSPOs > 0 && (absent = this.db.bulkFilterStatements(spos, numSPOs, present = false)).hasNext()) {
            if (this.sameAs3 == null) {
                this.sameAs3 = this.createTempTripleStore();
            }
            this.db.addStatements(this.sameAs3, true, absent, null);
        }
    }

    public ISPO[] nextChunk() {
        ISPO[] s = new ISPO[100];
        int n = 0;
        while (this.hasNext() && n < 100) {
            s[n++] = this.next();
        }
        ISPO[] stmts = new SPO[n];
        System.arraycopy(s, 0, stmts, 0, n);
        return stmts;
    }

    public ISPO[] nextChunk(IKeyOrder<ISPO> keyOrder) {
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        ISPO[] stmts = this.nextChunk();
        if (this.src.getKeyOrder() != keyOrder) {
            Arrays.sort(stmts, 0, stmts.length, keyOrder.getComparator());
        }
        return stmts;
    }

    @Override
    public void close() {
        this.src.close();
        if (this.sameAs2It != null) {
            this.sameAs2It.close();
        }
        if (this.sameAs3It != null) {
            this.sameAs3It.close();
        }
        if (this.sameAs2 != null) {
            this.sameAs2.close();
        }
        if (this.sameAs3 != null) {
            this.sameAs3.close();
        }
    }

    @Override
    public void remove() {
        if (this.canRemove) {
            this.src.remove();
        }
    }
}

