/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.inf;

import com.bigdata.rdf.inf.BackchainOwlSameAsIterator;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import com.bigdata.striterator.EmptyChunkedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import java.util.Arrays;
import java.util.Set;

public class BackchainOwlSameAsPropertiesSPOIterator
extends BackchainOwlSameAsIterator {
    private IChunkedOrderedIterator<ISPO> sameAs2and3It;
    private TempTripleStore sameAs2and3;
    private boolean canRemove = false;

    public BackchainOwlSameAsPropertiesSPOIterator(IChunkedOrderedIterator<ISPO> src, IV s, IV p, IV o, AbstractTripleStore db, IV sameAs) {
        super(src, db, sameAs);
        boolean present;
        IChunkedOrderedIterator<ISPO> absent;
        ISPO[] spos = new SPO[100];
        int numSPOs = 0;
        Set<IV> sAndSames = this.getSelfAndSames(s);
        Set<IV> oAndSames = this.getSelfAndSames(o);
        if (sAndSames.size() != 1 || oAndSames.size() == 1) {
            // empty if block
        }
        for (IV s1 : sAndSames) {
            for (IV o1 : oAndSames) {
                IChunkedOrderedIterator<ISPO> it = db.getAccessPath(s1, p, o1).iterator();
                while (it.hasNext()) {
                    IV p1 = ((ISPO)it.next()).p();
                    if (IVUtility.equals(p1, sameAs) && IVUtility.equals(s, o)) continue;
                    if (numSPOs == 100) {
                        boolean present2 = false;
                        IChunkedOrderedIterator<ISPO> absent2 = db.bulkFilterStatements(spos, numSPOs, present2);
                        if (absent2.hasNext()) {
                            if (this.sameAs2and3 == null) {
                                this.sameAs2and3 = this.createTempTripleStore();
                            }
                            db.addStatements(this.sameAs2and3, true, absent2, null);
                        }
                        numSPOs = 0;
                    }
                    spos[numSPOs++] = new SPO(s, p1, o, StatementEnum.Inferred);
                    this.dumpSPO(spos[numSPOs - 1]);
                }
            }
        }
        if (numSPOs > 0 && (absent = db.bulkFilterStatements(spos, numSPOs, present = false)).hasNext()) {
            if (this.sameAs2and3 == null) {
                this.sameAs2and3 = this.createTempTripleStore();
            }
            db.addStatements(this.sameAs2and3, true, absent, null);
        }
    }

    @Override
    public IKeyOrder<ISPO> getKeyOrder() {
        return this.src.getKeyOrder();
    }

    @Override
    public boolean hasNext() {
        if (this.sameAs2and3It == null) {
            this.sameAs2and3It = this.sameAs2and3 != null ? this.sameAs2and3.getAccessPath(SPOKeyOrder.SPO).iterator() : new EmptyChunkedIterator<ISPO>(SPOKeyOrder.SPO);
        }
        return this.src.hasNext() || this.sameAs2and3It.hasNext();
    }

    @Override
    public ISPO next() {
        if (this.sameAs2and3It == null) {
            this.sameAs2and3It = this.sameAs2and3 != null ? this.sameAs2and3.getAccessPath(SPOKeyOrder.SPO).iterator() : new EmptyChunkedIterator<ISPO>(SPOKeyOrder.SPO);
        }
        this.canRemove = false;
        ISPO current = null;
        if (this.src.hasNext()) {
            current = (ISPO)this.src.next();
            this.canRemove = true;
        } else if (this.sameAs2and3It.hasNext()) {
            current = (ISPO)this.sameAs2and3It.next();
        }
        return current;
    }

    public ISPO[] nextChunk() {
        ISPO[] s = new ISPO[100];
        int n = 0;
        while (this.hasNext() && n < 100) {
            s[n++] = this.next();
        }
        ISPO[] stmts = new ISPO[n];
        System.arraycopy(s, 0, stmts, 0, n);
        return stmts;
    }

    public ISPO[] nextChunk(IKeyOrder<ISPO> keyOrder) {
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        ISPO[] stmts = this.nextChunk();
        if (this.src.getKeyOrder() != keyOrder) {
            Arrays.sort(stmts, 0, stmts.length, keyOrder.getComparator());
        }
        return stmts;
    }

    @Override
    public void close() {
        this.src.close();
        if (this.sameAs2and3It != null) {
            this.sameAs2and3It.close();
        }
        if (this.sameAs2and3 != null) {
            this.sameAs2and3.close();
        }
    }

    @Override
    public void remove() {
        if (this.canRemove) {
            this.src.remove();
        }
    }
}

