/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.inf;

import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.lexicon.ITermIVFilter;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ExplicitSPOFilter;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.IChunkedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import cutthecrap.utils.striterators.Filter;
import cutthecrap.utils.striterators.FilterBase;
import cutthecrap.utils.striterators.ICloseable;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class BackchainTypeResourceIterator
implements IChunkedOrderedIterator<ISPO> {
    protected static final Logger log = Logger.getLogger(BackchainTypeResourceIterator.class);
    private final IChunkedOrderedIterator<ISPO> _src;
    private final Iterator<ISPO> src;
    private final IV rdfType;
    private final IV rdfsResource;
    private final IKeyOrder<ISPO> keyOrder;
    private final int chunkSize = 100;
    private PushbackIterator<IV> resourceIds;
    private PushbackIterator<IV> posItr;
    private boolean sourceExhausted = false;
    private boolean open = true;
    private IKeyOrder<ISPO> chunkKeyOrder = null;
    private ISPO current = null;

    public static IChunkedOrderedIterator<ISPO> newInstance(IChunkedOrderedIterator<ISPO> _src, IAccessPath<ISPO> accessPath, AbstractTripleStore db, final IV rdfType, final IV rdfsResource) {
        if (accessPath == null) {
            throw new IllegalArgumentException();
        }
        IPredicate<ISPO> pred = accessPath.getPredicate();
        IV s = BackchainTypeResourceIterator.getTerm(pred, 0);
        IV p = BackchainTypeResourceIterator.getTerm(pred, 1);
        IV o = BackchainTypeResourceIterator.getTerm(pred, 2);
        if (!(!(o != null && !o.equals(rdfsResource) || p != null && !p.equals(rdfType)))) {
            return _src;
        }
        if (_src == null) {
            throw new IllegalArgumentException();
        }
        if (db == null) {
            throw new IllegalArgumentException();
        }
        if (s != null) {
            return new BackchainSTypeResourceIterator(_src, accessPath, db, rdfType, rdfsResource);
        }
        PushbackIterator<IV> resourceIds = new PushbackIterator<IV>(new MergedOrderedIterator<IV>(db.getSPORelation().distinctTermScan(SPOKeyOrder.SPO), db.getSPORelation().distinctTermScan(SPOKeyOrder.OSP, new ITermIVFilter(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isValid(IV iv) {
                return !iv.isLiteral();
            }
        })));
        PushbackIterator<IV> posItr = new PushbackIterator<IV>(new Striterator(db.getAccessPath(null, rdfType, rdfsResource, ExplicitSPOFilter.INSTANCE).iterator()).addFilter(new Resolver(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Object resolve(Object obj) {
                return ((SPO)obj).s;
            }
        }));
        IStriterator src = new Striterator(_src).addFilter(new Filter(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isValid(Object arg0) {
                SPO o = (SPO)arg0;
                return !o.p.equals(rdfType) || !o.o.equals(rdfsResource);
            }
        });
        return new BackchainTypeResourceIterator(_src, src, resourceIds, posItr, rdfType, rdfsResource);
    }

    private static IV getTerm(IPredicate<ISPO> pred, int pos) {
        IVariableOrConstant term = pred.get(pos);
        return term == null || term.isVar() ? null : (IV)term.get();
    }

    private BackchainTypeResourceIterator(IChunkedOrderedIterator<ISPO> _src, Iterator<ISPO> src, PushbackIterator<IV> resourceIds, PushbackIterator<IV> posItr, IV rdfType, IV rdfsResource) {
        this._src = _src;
        this.keyOrder = _src.getKeyOrder();
        this.src = src;
        this.resourceIds = resourceIds;
        this.posItr = posItr;
        this.rdfType = rdfType;
        this.rdfsResource = rdfsResource;
    }

    @Override
    public IKeyOrder<ISPO> getKeyOrder() {
        return this.keyOrder;
    }

    @Override
    public void close() {
        if (!this.open) {
            return;
        }
        this.open = false;
        this._src.close();
        this.resourceIds.close();
        this.resourceIds = null;
        if (this.posItr != null) {
            this.posItr.close();
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.open) {
            return false;
        }
        if (!this.sourceExhausted) {
            if (this.src.hasNext()) {
                return true;
            }
            this.sourceExhausted = true;
            this._src.close();
        }
        return this.resourceIds.hasNext();
    }

    @Override
    public ISPO next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.src.hasNext()) {
            this.current = this.src.next();
            return this.current;
        }
        if (this.resourceIds.hasNext()) {
            IV s1 = this.resourceIds.next();
            if (this.posItr.hasNext()) {
                IV s2 = this.posItr.next();
                int cmp = s1.compareTo(s2);
                if (cmp < 0) {
                    this.current = new SPO(s1, this.rdfType, this.rdfsResource, StatementEnum.Inferred);
                    this.posItr.pushback();
                } else {
                    if (cmp != 0) {
                        this.resourceIds.pushback();
                    }
                    this.current = new SPO(s2, this.rdfType, this.rdfsResource, StatementEnum.Explicit);
                }
            } else {
                this.current = new SPO(s1, this.rdfType, this.rdfsResource, StatementEnum.Inferred);
            }
            return this.current;
        }
        assert (this.posItr.hasNext());
        return new SPO(this.posItr.next(), this.rdfType, this.rdfsResource, StatementEnum.Explicit);
    }

    public ISPO[] nextChunk() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (!this.sourceExhausted) {
            this.chunkKeyOrder = this.keyOrder;
            ISPO[] s = new ISPO[100];
            int n = 0;
            while (this.src.hasNext() && n < 100) {
                s[n++] = this.src.next();
            }
            ISPO[] stmts = new ISPO[n];
            System.arraycopy(s, 0, stmts, 0, n);
            return stmts;
        }
        IV[] s = new IV[100];
        int n = 0;
        while (this.resourceIds.hasNext() && n < 100) {
            s[n++] = this.resourceIds.next();
        }
        ISPO[] stmts = new SPO[n];
        for (int i = 0; i < n; ++i) {
            stmts[i] = new SPO(s[i], this.rdfType, this.rdfsResource, StatementEnum.Inferred);
        }
        if (this.keyOrder != null && this.keyOrder != SPOKeyOrder.POS) {
            Arrays.sort(stmts, 0, stmts.length, this.keyOrder.getComparator());
        }
        this.chunkKeyOrder = SPOKeyOrder.POS;
        return stmts;
    }

    public ISPO[] nextChunk(IKeyOrder<ISPO> keyOrder) {
        if (keyOrder == null) {
            throw new IllegalArgumentException();
        }
        ISPO[] stmts = this.nextChunk();
        if (this.chunkKeyOrder != keyOrder) {
            Arrays.sort(stmts, 0, stmts.length, keyOrder.getComparator());
        }
        return stmts;
    }

    @Override
    public void remove() {
        if (!this.open) {
            throw new IllegalStateException();
        }
        if (this.current == null) {
            throw new IllegalStateException();
        }
        if (this.current.isExplicit()) {
            this.src.remove();
        }
        this.current = null;
    }

    private static class BackchainSTypeResourceIterator
    implements IChunkedOrderedIterator<ISPO> {
        private final IChunkedOrderedIterator<ISPO> _src;
        private final IAccessPath<ISPO> accessPath;
        private final AbstractTripleStore db;
        private final IV rdfType;
        private final IV rdfsResource;
        private final IV s;
        private IChunkedOrderedIterator<ISPO> appender;
        private boolean canRemove;

        public BackchainSTypeResourceIterator(IChunkedOrderedIterator<ISPO> _src, IAccessPath<ISPO> accessPath, AbstractTripleStore db, IV rdfType, IV rdfsResource) {
            this._src = _src;
            this.accessPath = accessPath;
            this.db = db;
            this.rdfType = rdfType;
            this.rdfsResource = rdfsResource;
            this.s = (IV)accessPath.getPredicate().get(0).get();
            SPO spo = new SPO(this.s, rdfType, rdfsResource, StatementEnum.Inferred);
            this.appender = new ChunkedArrayIterator<ISPO>(1, new SPO[]{spo}, SPOKeyOrder.SPO);
        }

        private void testSPO(ISPO spo) {
            if (spo.s().equals(this.s) && spo.p().equals(this.rdfType) && spo.o().equals(this.rdfsResource)) {
                this.appender = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this._src.hasNext() || this.appender != null && this.appender.hasNext();
        }

        @Override
        public IKeyOrder<ISPO> getKeyOrder() {
            return this._src.getKeyOrder();
        }

        public ISPO[] nextChunk(IKeyOrder<ISPO> keyOrder) {
            if (this._src.hasNext()) {
                ISPO[] chunk;
                for (ISPO spo : chunk = this._src.nextChunk(keyOrder)) {
                    this.testSPO(spo);
                }
                this.canRemove = true;
                return chunk;
            }
            if (this.appender != null) {
                this.canRemove = false;
                return this.appender.nextChunk(keyOrder);
            }
            return null;
        }

        @Override
        public ISPO next() {
            if (this._src.hasNext()) {
                ISPO spo = (ISPO)this._src.next();
                this.testSPO(spo);
                this.canRemove = true;
                return spo;
            }
            if (this.appender != null) {
                this.canRemove = false;
                return (ISPO)this.appender.next();
            }
            return null;
        }

        public ISPO[] nextChunk() {
            if (this._src.hasNext()) {
                ISPO[] chunk;
                for (ISPO spo : chunk = (ISPO[])this._src.nextChunk()) {
                    this.testSPO(spo);
                }
                this.canRemove = true;
                return chunk;
            }
            if (this.appender != null) {
                this.canRemove = false;
                return (ISPO[])this.appender.nextChunk();
            }
            return null;
        }

        @Override
        public void remove() {
            if (this.canRemove) {
                this._src.remove();
            }
        }

        @Override
        public void close() {
            this._src.close();
        }
    }

    public static class PushbackIterator<E>
    implements Iterator<E>,
    ICloseableIterator<E> {
        private final Iterator<E> src;
        private E current;
        private E buffer;

        public PushbackIterator(Iterator<E> src) {
            if (src == null) {
                throw new IllegalArgumentException();
            }
            this.src = src;
        }

        @Override
        public boolean hasNext() {
            return this.buffer != null || this.src.hasNext();
        }

        @Override
        public E next() {
            E tmp;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.buffer != null) {
                tmp = this.buffer;
                this.buffer = null;
            } else {
                tmp = this.src.next();
            }
            this.current = tmp;
            return tmp;
        }

        public void pushback() {
            if (this.buffer != null) {
                throw new IllegalStateException();
            }
            this.buffer = this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            if (this.src instanceof ICloseable) {
                ((ICloseable)((Object)this.src)).close();
            }
        }
    }

    public static class PushbackFilter<E>
    extends FilterBase {
        private static final long serialVersionUID = -8010263934867149205L;

        @Override
        public PushbackIterator<E> filterOnce(Iterator src, Object context) {
            return new PushbackIterator(src);
        }
    }

    private static class MergedOrderedIterator<T extends Comparable<T>>
    implements IChunkedIterator<T> {
        private final IChunkedIterator<T> src1;
        private final IChunkedIterator<T> src2;
        private T tmp1;
        private T tmp2;

        public MergedOrderedIterator(IChunkedIterator<T> src1, IChunkedIterator<T> src2) {
            this.src1 = src1;
            this.src2 = src2;
        }

        @Override
        public void close() {
            this.src1.close();
            this.src2.close();
        }

        @Override
        public T[] nextChunk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.tmp1 != null || this.tmp2 != null || this.src1.hasNext() || this.src2.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.tmp1 == null && this.src1.hasNext()) {
                this.tmp1 = (Comparable)this.src1.next();
            }
            if (this.tmp2 == null && this.src2.hasNext()) {
                this.tmp2 = (Comparable)this.src2.next();
            }
            if (this.tmp1 == null) {
                T tmp = this.tmp2;
                this.tmp2 = null;
                return tmp;
            }
            if (this.tmp2 == null) {
                T tmp = this.tmp1;
                this.tmp1 = null;
                return tmp;
            }
            int cmp = this.tmp1.compareTo(this.tmp2);
            if (cmp == 0) {
                T tmp = this.tmp1;
                this.tmp2 = null;
                this.tmp1 = null;
                return tmp;
            }
            if (cmp < 0) {
                T tmp = this.tmp1;
                this.tmp1 = null;
                return tmp;
            }
            T tmp = this.tmp2;
            this.tmp2 = null;
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

