/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.IInlineURIFactory;
import com.bigdata.rdf.internal.InlineIPv4URIHandler;
import com.bigdata.rdf.internal.InlineURIHandler;
import com.bigdata.rdf.internal.InlineUUIDURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.internal.impl.uri.URIExtensionIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.vocab.Vocabulary;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openrdf.model.URI;

public class InlineURIFactory
implements IInlineURIFactory {
    private final List<InlineURIHandler> handlers = new LinkedList<InlineURIHandler>();
    private final Map<String, InlineURIHandler> handlersByNamespace = new HashMap<String, InlineURIHandler>();

    public InlineURIFactory() {
        this.addHandler(new InlineUUIDURIHandler("urn:uuid:"));
        this.addHandler(new InlineIPv4URIHandler("urn:ipv4:"));
    }

    protected void addHandler(InlineURIHandler handler) {
        this.handlers.add(handler);
        this.handlersByNamespace.put(handler.getNamespace(), handler);
    }

    @Override
    public void init(Vocabulary vocab) {
        for (InlineURIHandler handler : this.handlers) {
            handler.init(vocab);
        }
    }

    public URIExtensionIV createInlineURIIV(URI uri) {
        for (InlineURIHandler handler : this.handlers) {
            URIExtensionIV iv = handler.createInlineIV(uri);
            if (iv == null) continue;
            return iv;
        }
        return null;
    }

    @Override
    public String getLocalNameFromDelegate(URI namespace, AbstractLiteralIV<BigdataLiteral, ?> delegate) {
        InlineURIHandler handler = this.handlersByNamespace.get(namespace.stringValue());
        if (handler == null) {
            throw new IllegalArgumentException("Can't resolve uri handler for \"" + namespace + "\".  Maybe its be deregistered?");
        }
        return handler.getLocalNameFromDelegate(delegate);
    }
}

