/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.CompareBOp;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.constraints.XSDBooleanIVValueExpression;
import java.util.Map;
import org.openrdf.query.algebra.Compare;

public class ComputedIN
extends XSDBooleanIVValueExpression {
    private static final long serialVersionUID = 9066209752427789308L;
    private transient boolean not = false;

    public ComputedIN(boolean not, IValueExpression<? extends IV> ... ise) {
        this(ise, NV.asMap(Annotations.NOT, (Object)not));
    }

    public ComputedIN(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        if (this.getProperty(Annotations.NOT) == null) {
            throw new IllegalArgumentException();
        }
        this.not = (Boolean)this.getProperty(Annotations.NOT);
        BOp var = this.get(0);
        if (var == null) {
            throw new IllegalArgumentException();
        }
        if (this.arity() < 2) {
            throw new IllegalArgumentException();
        }
    }

    public ComputedIN(ComputedIN op) {
        super(op);
    }

    @Override
    public boolean accept(IBindingSet bindingSet) {
        IV iv = (IV)this.get(0).get(bindingSet);
        if (iv == null) {
            throw new SparqlTypeErrorException.UnboundVarException();
        }
        boolean found = false;
        for (int i = 1; i < this.arity(); ++i) {
            IV right = (IV)this.get(i).get(bindingSet);
            if (right == null || !CompareBOp.compare(iv, right, Compare.CompareOp.EQ)) continue;
            found = true;
            break;
        }
        return this.not ? !found : found;
    }

    public static interface Annotations
    extends IVValueExpression.Annotations {
        public static final String NOT = ComputedIN.class.getName() + ".not";
    }
}

