/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.MathBOp;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sparql.ast.DummyConstantNode;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;

public class DateTimeUtility {
    protected static final DatatypeFactory datatypeFactory;

    public static boolean checkDateTimeDatatype(Literal ... args) {
        for (Literal lit : args) {
            URI dt = lit.getDatatype();
            if (dt == null) {
                return false;
            }
            if (XMLDatatypeUtil.isCalendarDatatype((URI)dt) || dt.equals((Object)XMLSchema.DURATION)) continue;
            return false;
        }
        return true;
    }

    public static IV dateTimeMath(Literal l1, IV iv1, Literal l2, IV iv2, MathBOp.MathOp op, BigdataValueFactory vf) {
        Duration d2;
        if (!DateTimeUtility.checkDateTimeDatatype(l1, l2)) {
            throw new SparqlTypeErrorException();
        }
        URI dt1 = l1.getDatatype();
        URI dt2 = l2.getDatatype();
        XMLGregorianCalendar c1 = XMLDatatypeUtil.isCalendarDatatype((URI)dt1) ? l1.calendarValue() : null;
        XMLGregorianCalendar c2 = XMLDatatypeUtil.isCalendarDatatype((URI)dt2) ? l2.calendarValue() : null;
        Duration d1 = dt1.equals((Object)XMLSchema.DURATION) ? datatypeFactory.newDuration(l1.getLabel()) : null;
        Duration duration = d2 = dt2.equals((Object)XMLSchema.DURATION) ? datatypeFactory.newDuration(l2.getLabel()) : null;
        if (op == MathBOp.MathOp.PLUS) {
            if (c1 != null && c2 != null) {
                throw new IllegalArgumentException("Cannot add 2 calendar literals:" + l1 + ":" + l2);
            }
            if (c1 != null && d2 != null) {
                c1.add(d2);
                BigdataLiteral str = vf.createLiteral(c1);
                return DummyConstantNode.toDummyIV(str);
            }
            if (c2 != null && d1 != null) {
                c2.add(d1);
                BigdataLiteral str = vf.createLiteral(c2);
                return DummyConstantNode.toDummyIV(str);
            }
            if (d1 != null && d2 != null) {
                Duration result = d1.add(d2);
                BigdataLiteral str = vf.createLiteral(result.toString(), XMLSchema.DURATION);
                return DummyConstantNode.toDummyIV(str);
            }
            throw new IllegalArgumentException("Cannot add process datatype literals:" + l1 + ":" + l2);
        }
        if (op == MathBOp.MathOp.MINUS) {
            if (c1 != null && c2 != null) {
                long milliseconds = c1.toGregorianCalendar().getTimeInMillis() - c2.toGregorianCalendar().getTimeInMillis();
                double days = (double)milliseconds / 8.64E7;
                return new XSDNumericIV(days);
            }
            if (d1 != null && d2 != null) {
                Duration result = d1.subtract(d2);
                BigdataLiteral str = vf.createLiteral(result.toString(), XMLSchema.DURATION);
                return DummyConstantNode.toDummyIV(str);
            }
            throw new IllegalArgumentException("Cannot add process datatype literals:" + l1 + ":" + l2);
        }
        if (op == MathBOp.MathOp.MIN) {
            if (c1 != null && c2 != null) {
                int comp = c1.compare(c2);
                if (comp <= 0) {
                    return iv1;
                }
                return iv2;
            }
            if (d1 != null && d2 != null) {
                int comp = d1.compare(d2);
                if (comp <= 0) {
                    return iv1;
                }
                return iv2;
            }
            throw new IllegalArgumentException("Cannot add process datatype literals:" + l1 + ":" + l2);
        }
        if (op == MathBOp.MathOp.MAX) {
            if (c1 != null && c2 != null) {
                int comp = c1.compare(c2);
                if (comp >= 0) {
                    return iv1;
                }
                return iv2;
            }
            if (d1 != null && d2 != null) {
                int comp = d1.compare(d2);
                if (comp >= 0) {
                    return iv1;
                }
                return iv2;
            }
            throw new IllegalArgumentException("Cannot add process datatype literals:" + l1 + ":" + l2);
        }
        throw new SparqlTypeErrorException();
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

