/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.openrdf.model.Literal;

public class EncodeForURIBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = -8448763718374010166L;

    public EncodeForURIBOp(IValueExpression<? extends IV> x, GlobalAnnotations globals) {
        super(x, globals, new NV[0]);
    }

    public EncodeForURIBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null) {
            throw new IllegalArgumentException();
        }
    }

    public EncodeForURIBOp(EncodeForURIBOp op) {
        super(op);
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    @Override
    public IV get(IBindingSet bs) throws SparqlTypeErrorException {
        Literal lit = this.getAndCheckLiteralValue(0, bs);
        try {
            BigdataLiteral str = this.getValueFactory().createLiteral(URLEncoder.encode(lit.getLabel(), "UTF-8").replace("+", "%20"));
            return super.asIV(str, bs);
        }
        catch (UnsupportedEncodingException uee) {
            throw new SparqlTypeErrorException();
        }
    }
}

