/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.IPassesMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import java.util.Map;
import org.apache.log4j.Logger;

public class IfBOp
extends IVValueExpression<IV>
implements IPassesMaterialization {
    private static final long serialVersionUID = 7391999162162545704L;
    private static final transient Logger log = Logger.getLogger(IfBOp.class);

    @Override
    protected boolean areGlobalsRequired() {
        return false;
    }

    public IfBOp(IValueExpression<? extends IV> conditional, IValueExpression<? extends IV> expression1, IValueExpression<? extends IV> expression2) {
        this(new BOp[]{conditional, expression1, expression2}, BOp.NOANNS);
    }

    public IfBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 3 || args[0] == null || args[1] == null || args[2] == null) {
            throw new IllegalArgumentException();
        }
    }

    public IfBOp(IfBOp op) {
        super(op);
    }

    @Override
    public IV get(IBindingSet bs) {
        IV iv = (IV)this.get(0).get(bs);
        if (iv == null || !(iv instanceof XSDBooleanIV)) {
            throw new SparqlTypeErrorException();
        }
        if (iv.equals(XSDBooleanIV.TRUE)) {
            IV exp1 = (IV)this.get(1).get(bs);
            if (exp1 == null) {
                throw new SparqlTypeErrorException();
            }
            return exp1;
        }
        IV exp2 = (IV)this.get(2).get(bs);
        if (exp2 == null) {
            throw new SparqlTypeErrorException();
        }
        return exp2;
    }
}

