/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.internal.constraints.MathUtility;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.XMLSchema;

public class NumericBOp
extends IVValueExpression<IV> {
    private static final long serialVersionUID = 9136864442064392445L;
    private static final transient Logger log = Logger.getLogger(NumericBOp.class);

    @Override
    protected boolean areGlobalsRequired() {
        return false;
    }

    public NumericBOp(IValueExpression<? extends IV> left, NumericOp op) {
        this(new BOp[]{left}, NV.asMap(Annotations.OP, (Object)op));
    }

    public NumericBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null || this.getProperty(Annotations.OP) == null) {
            throw new IllegalArgumentException();
        }
    }

    public NumericBOp(NumericBOp op) {
        super(op);
    }

    public IValueExpression<? extends IV> left() {
        return this.get(0);
    }

    public NumericOp op() {
        return (NumericOp)((Object)this.getRequiredProperty(Annotations.OP));
    }

    @Override
    public IV get(IBindingSet bs) {
        Literal lit = super.getAndCheckLiteralValue(0, bs);
        URI dt = lit.getDatatype();
        NumericOp op = this.op();
        if ((dt.equals((Object)XMLSchema.INT) || dt.equals((Object)XMLSchema.INTEGER)) && (op == NumericOp.CEIL || op == NumericOp.FLOOR || op == NumericOp.ROUND)) {
            return (IV)this.get(0).get(bs);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)lit);
        }
        return MathUtility.numericalFunc(lit, this.op());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.op());
        sb.append("(").append(this.left()).append(")");
        return sb.toString();
    }

    public static enum NumericOp {
        ABS,
        ROUND,
        CEIL,
        FLOOR;

    }

    public static interface Annotations
    extends BOp.Annotations {
        public static final String OP = NumericBOp.class.getName() + ".op";
    }
}

