/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.ModifiableBOpBase;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RangeBOp
extends ModifiableBOpBase {
    private static final long serialVersionUID = 3368581489737593349L;

    public RangeBOp() {
        this(BOp.NOARGS, new LinkedHashMap<String, Object>());
    }

    public RangeBOp(IValueExpression<? extends IV> from, IValueExpression<? extends IV> to) {
        this(BOp.NOARGS, NV.asMap(new NV(Annotations.FROM, from), new NV(Annotations.TO, to)));
    }

    public RangeBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public RangeBOp(RangeBOp op) {
        super(op);
    }

    public IValueExpression<? extends IV> from() {
        return (IValueExpression)this.getProperty(Annotations.FROM);
    }

    public IValueExpression<? extends IV> to() {
        return (IValueExpression)this.getProperty(Annotations.TO);
    }

    public void setFrom(IValueExpression<? extends IV> from) {
        this.setProperty(Annotations.FROM, from);
    }

    public void setTo(IValueExpression<? extends IV> to) {
        this.setProperty(Annotations.TO, to);
    }

    public final RangeBOp asBound(IBindingSet bs) {
        IValueExpression<? extends IV> asBoundTo;
        IValueExpression<? extends IV> asBoundFrom;
        IValueExpression<? extends IV> origFrom = this.from();
        IValueExpression<? extends IV> origTo = this.to();
        if (origFrom == null) {
            asBoundFrom = null;
        } else if (origFrom instanceof IConstant) {
            asBoundFrom = origFrom;
        } else {
            try {
                IV iv = origFrom.get(bs);
                asBoundFrom = new Constant<IV>(iv);
            }
            catch (SparqlTypeErrorException ex) {
                asBoundFrom = origFrom;
            }
        }
        if (origTo == null) {
            asBoundTo = null;
        } else if (origTo instanceof IConstant) {
            asBoundTo = origTo;
        } else {
            try {
                IV iv = origTo.get(bs);
                asBoundTo = new Constant<IV>(iv);
            }
            catch (SparqlTypeErrorException ex) {
                asBoundTo = origTo;
            }
        }
        if (asBoundFrom == origFrom && asBoundTo == origTo) {
            return this;
        }
        RangeBOp asBound = new RangeBOp();
        if (asBoundFrom != null) {
            asBound.setFrom(asBoundFrom);
        }
        if (asBoundTo != null) {
            asBound.setTo(asBoundTo);
        }
        return asBound;
    }

    public final boolean isFromBound() {
        return this.from() instanceof IConstant;
    }

    public final boolean isToBound() {
        return this.to() instanceof IConstant;
    }

    public static interface Annotations
    extends BOp.Annotations {
        public static final String FROM = RangeBOp.class.getName() + ".from";
        public static final String TO = RangeBOp.class.getName() + ".to";
    }
}

