/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.util.Map;
import org.openrdf.model.Literal;

public class StrdtBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = -6571446625816081957L;

    public StrdtBOp(IValueExpression<? extends IV> x, IValueExpression<? extends IV> dt, GlobalAnnotations globals) {
        this(new BOp[]{x, dt}, StrdtBOp.anns(globals, new NV[0]));
    }

    public StrdtBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 2 || args[0] == null || args[1] == null) {
            throw new IllegalArgumentException();
        }
    }

    public StrdtBOp(StrdtBOp op) {
        super(op);
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    @Override
    public IV get(IBindingSet bs) throws SparqlTypeErrorException {
        IV iv = this.getAndCheckLiteral(0, bs);
        IV datatype = this.getAndCheckBound(1, bs);
        if (!datatype.isURI()) {
            throw new SparqlTypeErrorException();
        }
        BigdataURI dt = (BigdataURI)StrdtBOp.asValue(datatype);
        Literal lit = StrdtBOp.asLiteral(iv);
        if (lit.getDatatype() != null || lit.getLanguage() != null) {
            throw new SparqlTypeErrorException();
        }
        String label = lit.getLabel();
        BigdataLiteral str = this.getValueFactory().createLiteral(label, dt);
        return super.asIV(str, bs);
    }
}

