/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.encoder;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.btree.keys.ASCIIKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.encoder.IBindingSetDecoder;
import com.bigdata.rdf.internal.encoder.IBindingSetEncoder;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataValue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;

public class IVBindingSetEncoder
implements IBindingSetEncoder,
IBindingSetDecoder {
    protected final boolean filter;
    private final LinkedHashSet<IVariable<?>> schema;
    protected final LinkedHashSet<IVariable<?>> ivCacheSchema;
    final Map<IV<?, ?>, BigdataValue> cache;
    private final IKeyBuilder keyBuilder;

    public IVBindingSetEncoder(boolean filter) {
        this.filter = filter;
        this.schema = new LinkedHashSet();
        this.ivCacheSchema = filter ? null : new LinkedHashSet();
        this.keyBuilder = new ASCIIKeyBuilderFactory(128).getKeyBuilder();
        this.cache = filter ? null : new HashMap();
    }

    @Override
    public boolean isValueCache() {
        return false;
    }

    private void updateSchema(IBindingSet bset) {
        Iterator<IVariable> vitr = bset.vars();
        while (vitr.hasNext()) {
            this.schema.add(vitr.next());
        }
    }

    @Override
    public byte[] encodeSolution(IBindingSet bset) {
        return this.encodeSolution(bset, true);
    }

    @Override
    public byte[] encodeSolution(IBindingSet bset, boolean updateCache) {
        if (bset == null) {
            throw new IllegalArgumentException();
        }
        Map<IV<?, ?>, BigdataValue> cache = updateCache ? this.cache : null;
        this.updateSchema(bset);
        this.keyBuilder.reset();
        for (IVariable iVariable : this.schema) {
            IConstant c = bset.get(iVariable);
            if (c == null) {
                IVUtility.encode(this.keyBuilder, TermId.NullIV);
                continue;
            }
            IV iv = (IV)c.get();
            IVUtility.encode(this.keyBuilder, iv);
            if (iv.isInline() || !iv.hasValue() || this.filter) continue;
            this.ivCacheSchema.add(iVariable);
            if (cache == null) continue;
            cache.put(iv, (BigdataValue)iv.getValue());
        }
        return this.keyBuilder.getKey();
    }

    @Override
    public void flush() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public IBindingSet decodeSolution(byte[] val, int off, int len, boolean resolveCachedValues) {
        ListBindingSet bset = new ListBindingSet();
        IV[] ivs = IVUtility.decodeAll(val, off, len);
        int i = 0;
        for (IVariable iVariable : this.schema) {
            IV iv;
            if (i == ivs.length) break;
            if ((iv = ivs[i++]) == null) continue;
            bset.set(iVariable, new Constant<IV>(iv));
        }
        if (resolveCachedValues) {
            this.resolveCachedValues(bset);
        }
        return bset;
    }

    @Override
    public void resolveCachedValues(IBindingSet bset) {
    }

    @Override
    public void release() {
        this.schema.clear();
        if (this.ivCacheSchema != null) {
            this.ivCacheSchema.clear();
        }
    }
}

