/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.encoder;

import com.bigdata.bop.IBindingSet;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.rdf.internal.encoder.IVSolutionSetEncoder;
import com.bigdata.rdf.sparql.ast.ISolutionSetStats;
import com.bigdata.rdf.sparql.ast.SolutionSetStatserator;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SolutionSetStreamEncoder {
    private static final Logger log = Logger.getLogger(SolutionSetStreamEncoder.class);
    static int CHUNK_HEADER_SIZE = 12;
    static final int VERSION0 = 0;
    static int CURRENT_VERSION = 0;
    private final String name;
    private long nsolutions = 0L;
    private long nbytes = 0L;
    private long chunkCount = 0L;
    private ISolutionSetStats stats = null;

    public long getSolutionCount() {
        return this.nsolutions;
    }

    public ISolutionSetStats getStats() {
        return this.stats;
    }

    public SolutionSetStreamEncoder(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(DataOutputStream os, ICloseableIterator<IBindingSet[]> src2) throws IOException {
        SolutionSetStatserator src = new SolutionSetStatserator(src2);
        IVSolutionSetEncoder encoder = new IVSolutionSetEncoder();
        DataOutputBuffer buf = new DataOutputBuffer();
        try {
            while (src.hasNext()) {
                buf.reset();
                IBindingSet[] chunk = src.next();
                for (int i = 0; i < chunk.length; ++i) {
                    encoder.encodeSolution(buf, chunk[i]);
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("Wrote name=" + this.name + ", solution=" + chunk[i]));
                }
                int bytesBuffered = buf.limit();
                os.writeInt(CURRENT_VERSION);
                os.writeInt(chunk.length);
                os.writeInt(bytesBuffered);
                os.write(buf.array(), 0, bytesBuffered);
                this.nbytes += (long)(CHUNK_HEADER_SIZE + bytesBuffered);
                this.nsolutions += (long)chunk.length;
                ++this.chunkCount;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Wrote chunk: name=" + this.name + ", chunkSize=" + chunk.length + ", chunkCount=" + this.chunkCount + ", bytesBuffered=" + bytesBuffered + ", solutionSetSize=" + this.nsolutions));
            }
            this.stats = src.getStats();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Wrote solutionSet: name=" + this.name + ", solutionSetSize=" + this.nsolutions + ", chunkCount=" + this.chunkCount + ", encodedBytes=" + this.nbytes));
            }
        }
        finally {
            src.close();
        }
    }
}

