/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.uri;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.io.LongPacker;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.Inet4Address;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;

public class IPv4AddrIV<V extends BigdataLiteral>
extends AbstractLiteralIV<V, Inet4Address>
implements Serializable,
Literal {
    private static final long serialVersionUID = 685148537376856907L;
    private static final transient Logger log = Logger.getLogger(IPv4AddrIV.class);
    private final Inet4Address value;
    private transient String hostAddress;
    private transient byte[] key;
    private transient V uri;
    public static final Pattern pattern = Pattern.compile("((?:[0-9]{1,3}\\.){3}[0-9]{1,3})((\\/)(([0-9]{1,2})))?");

    @Override
    public IV<V, Inet4Address> clone(boolean clearCache) {
        IPv4AddrIV tmp = new IPv4AddrIV(this.value);
        tmp.key = this.key;
        tmp.uri = this.uri;
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public IPv4AddrIV(Inet4Address value) {
        super(DTE.Extension);
        this.value = value;
    }

    public IPv4AddrIV(String hostAddress) throws UnknownHostException {
        super(DTE.Extension);
        this.hostAddress = hostAddress;
        Matcher matcher = pattern.matcher(hostAddress);
        boolean matches = matcher.matches();
        if (matches) {
            String[] s;
            String ip = matcher.group(1);
            if (log.isDebugEnabled()) {
                log.debug((Object)ip);
            }
            String suffix = matcher.group(4);
            if (log.isDebugEnabled()) {
                log.debug((Object)suffix);
            }
            if (suffix != null) {
                s = new String[5];
                System.arraycopy(ip.split("\\.", -1), 0, s, 0, 4);
                s[4] = suffix;
            } else {
                s = ip.split("\\.", -1);
            }
            this.value = Inet4Address.textToAddr(s);
            if (this.value == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("not a valid IP: " + hostAddress));
                }
                throw new UnknownHostException("not a valid IP: " + hostAddress);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)this.value);
                log.debug((Object)this.byteLength());
                log.debug((Object)BytesUtil.toString(this.key()));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("not a valid IP: " + hostAddress));
            }
            throw new UnknownHostException("not a valid IP: " + hostAddress);
        }
    }

    @Override
    public Inet4Address getInlineValue() throws UnsupportedOperationException {
        return this.value;
    }

    @Override
    public V asValue(LexiconRelation lex) {
        if (this.uri == null) {
            this.uri = lex.getValueFactory().createLiteral(this.getLabel(), XSD.IPV4);
            this.uri.setIV((IV)this);
        }
        return this.uri;
    }

    @Override
    public int byteLength() {
        return 1 + this.key().length;
    }

    @Override
    public String toString() {
        return "IPv4(" + this.getLabel() + ")";
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String getLabel() {
        if (this.hostAddress == null) {
            this.hostAddress = this.value.toString();
        }
        return this.hostAddress;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IPv4AddrIV) {
            Inet4Address value2 = ((IPv4AddrIV)o).value;
            return this.value.equals(value2);
        }
        return false;
    }

    @Override
    public int _compareTo(IV o) {
        return BytesUtil.UnsignedByteArrayComparator.INSTANCE.compare(this.key(), ((IPv4AddrIV)o).key());
    }

    @Override
    public IKeyBuilder encode(IKeyBuilder keyBuilder) {
        keyBuilder.appendSigned(this.flags());
        keyBuilder.append(this.key());
        return keyBuilder;
    }

    private byte[] key() {
        if (this.key == null) {
            this.key = this.value.getBytes();
        }
        return this.key;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new IPAddrIVState(this);
    }

    private static class IPAddrIVState
    implements Externalizable {
        private static final long serialVersionUID = -1L;
        private byte[] key;

        public IPAddrIVState() {
        }

        private IPAddrIVState(IPv4AddrIV iv) {
            this.key = iv.key();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int nbytes = LongPacker.unpackInt(in);
            this.key = new byte[nbytes];
            in.readFully(this.key);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            LongPacker.packLong(out, (long)this.key.length);
            out.write(this.key);
        }

        private Object readResolve() throws ObjectStreamException {
            return new Inet4Address(this.key);
        }
    }
}

