/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.BytesUtil;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.Journal;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.impl.BlobIV;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.lexicon.LexiconKeyOrder;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.model.BigdataValueSerializer;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.service.IBigdataClient;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.jini.JiniClient;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;

public class DumpLexicon {
    private DumpLexicon() {
    }

    private static void usage() {
        System.err.println("usage: (-tuples) <namespace> <filename>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IIndexManager openIndexManager(String propertyFile) {
        IIndexManager indexManager;
        block12: {
            File file = new File(propertyFile);
            if (!file.exists()) {
                throw new RuntimeException("Could not find file: " + file);
            }
            boolean isJini = false;
            if (propertyFile.endsWith(".config")) {
                isJini = true;
            } else if (propertyFile.endsWith(".properties")) {
                isJini = false;
            } else {
                throw new RuntimeException("File must have '.config' or '.properties' extension: " + file);
            }
            try {
                if (isJini) {
                    JiniClient jiniClient = new JiniClient(new String[]{propertyFile});
                    indexManager = jiniClient.connect();
                    break block12;
                }
                Properties properties = new Properties();
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(propertyFile));){
                    properties.load(is);
                }
                if (System.getProperty(BigdataSail.Options.FILE) != null) {
                    properties.setProperty(BigdataSail.Options.FILE, System.getProperty(BigdataSail.Options.FILE));
                }
                Journal jnl = new Journal(properties);
                indexManager = jnl;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return indexManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String arg;
        int i;
        if (args.length < 2) {
            DumpLexicon.usage();
            System.exit(1);
        }
        boolean showTuples = false;
        for (i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if (!arg.equals("-tuples")) {
                throw new RuntimeException("Unknown argument: " + arg);
            }
            showTuples = true;
        }
        if (i + 2 != args.length) {
            DumpLexicon.usage();
            System.exit(1);
        }
        String namespace = args[i++];
        String propertyFile = args[i++];
        PrintWriter w = new PrintWriter(System.out);
        IIndexManager indexManager = null;
        try {
            w.println("namespace: " + namespace);
            w.println("filename : " + propertyFile);
            indexManager = DumpLexicon.openIndexManager(propertyFile);
            long timestamp = -1L;
            AbstractTripleStore tripleStore = (AbstractTripleStore)indexManager.getResourceLocator().locate(namespace, -1L);
            if (tripleStore == null) {
                throw new RuntimeException("Not found: namespace=" + namespace + ", timestamp=" + TimestampUtility.toString(-1L));
            }
            LexiconRelation lex = tripleStore.getLexiconRelation();
            w.println(lex.getLexiconConfiguration());
            w.flush();
            DumpLexicon.dump(tripleStore, w, showTuples);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            System.err.println("Error: " + ex + " on file: " + propertyFile);
            System.exit(2);
        }
        finally {
            w.flush();
            w.close();
            if (indexManager != null) {
                if (indexManager instanceof IJournal) {
                    if (((IJournal)indexManager).isOpen()) {
                        ((IJournal)indexManager).shutdownNow();
                    }
                } else {
                    IBigdataClient client = null;
                    try {
                        client = ((IBigdataFederation)indexManager).getClient();
                    }
                    catch (IllegalStateException ex) {}
                    if (client != null) {
                        client.disconnect(true);
                    }
                }
            }
        }
    }

    public static void dump(AbstractTripleStore store, Writer w, boolean showBlobs) {
        LexiconRelation r = store.getLexiconRelation();
        try {
            ITuple tuple;
            w.write(r.getFQN(LexiconKeyOrder.TERM2ID) + " (forward mapping)\n");
            IIndex ndx = store.getLexiconRelation().getTerm2IdIndex();
            ITupleIterator itr = ndx.rangeIterator();
            while (itr.hasNext()) {
                tuple = itr.next();
                byte[] key = tuple.getKey();
                TermId iv = (TermId)IVUtility.decode(tuple.getValue());
                w.write(BytesUtil.toString(key) + ":" + iv + "\n");
            }
            w.write(r.getFQN(LexiconKeyOrder.ID2TERM) + " (reverse mapping)\n");
            ndx = store.getLexiconRelation().getId2TermIndex();
            itr = ndx.rangeIterator();
            while (itr.hasNext()) {
                tuple = itr.next();
                BigdataValue term = (BigdataValue)tuple.getObject();
                w.write(term.getIV() + ":" + term + " (iv=" + term.getIV() + ")\n");
            }
            w.write(r.getFQN(LexiconKeyOrder.BLOBS) + " (large values)\n");
            DumpLexicon.dumpBlobs(w, showBlobs, r.getNamespace(), r.getBlobsIndex());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Appendable dump(LexiconRelation r) {
        StringWriter w = new StringWriter(102400);
        w.append(r.getLexiconConfiguration().toString());
        w.append("\n");
        DumpLexicon.dump(r.getContainer(), w, true);
        return w.getBuffer();
    }

    public static Appendable dumpBlobs(String namespace, IIndex ndx) {
        StringWriter w = new StringWriter(102400);
        DumpLexicon.dumpBlobs(w, true, namespace, ndx);
        return w.getBuffer();
    }

    public static void dumpBlobs(Writer w, boolean showEntries, String namespace, IIndex ndx) {
        int BIN_SIZE = 256;
        int NBINS = 256;
        try {
            int maxCollisionCounter = 0;
            long[] bins = new long[256];
            BigdataValueFactory vf = BigdataValueFactoryImpl.getInstance(namespace);
            BigdataValueSerializer<BigdataValue> valSer = vf.getValueSerializer();
            StringBuilder tmp = new StringBuilder();
            w.append("fastRangeCount=" + ndx.rangeCount() + "\n");
            ITupleIterator itr = ndx.rangeIterator();
            long nvisited = 0L;
            while (itr.hasNext()) {
                int bin;
                int counter;
                ITuple tuple = itr.next();
                ++nvisited;
                if (tuple.isNull()) {
                    if (!showEntries) continue;
                    w.append("NullIV: key=");
                    w.append(BytesUtil.toString(tuple.getKey()));
                    w.append("\n");
                    continue;
                }
                BlobIV iv = (BlobIV)IVUtility.decodeFromOffset(tuple.getKeyBuffer().array(), 0);
                BigdataValue value = valSer.deserialize(tuple.getValueStream(), tmp);
                if (showEntries) {
                    w.append(iv.toString());
                    w.append(" => ");
                    w.append(value.toString());
                    w.append("\n");
                }
                if ((counter = iv.counter()) > maxCollisionCounter) {
                    maxCollisionCounter = counter;
                }
                int n = bin = counter / 256;
                bins[n] = bins[n] + 1L;
            }
            w.append("nvisited=" + nvisited + "\n");
            w.append("binSize=256\n");
            w.append("nbins=256\n");
            int nnzero = 0;
            for (int bin = 0; bin < 256; ++bin) {
                long numberInBin = bins[bin];
                if (numberInBin == 0L) continue;
                w.append("bins[" + bin + "]=" + numberInBin + "\n");
                ++nnzero;
            }
            w.append("numNonZeroBins=" + nnzero + "\n");
            w.append("maxCollisionCounter=" + maxCollisionCounter + "\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

