/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.load;

import com.bigdata.counters.CounterSet;
import com.bigdata.rdf.load.MappedRDFDataLoadMaster;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.rio.AsynchronousStatementBufferFactory;
import com.bigdata.rdf.rio.RDFParserOptions;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.ScaleOutTripleStore;
import com.bigdata.relation.locator.DefaultResourceLocator;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.jini.JiniFederation;
import com.bigdata.service.jini.master.AbstractAsynchronousClientTask;
import com.bigdata.service.jini.master.ClientLocator;
import com.bigdata.service.jini.master.INotifyOutcome;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class MappedRDFFileLoadTask<S extends MappedRDFDataLoadMaster.JobState, V extends Serializable, L extends ClientLocator>
extends AbstractAsynchronousClientTask<Void, V, L>
implements Serializable {
    protected static final transient Logger log = Logger.getLogger(MappedRDFFileLoadTask.class);
    private static final long serialVersionUID = 2L;
    protected final S jobState;
    protected final L locator;
    private volatile transient AsynchronousStatementBufferFactory<BigdataStatement, V> statementBufferFactory;
    private volatile transient ReentrantLock lock;
    private volatile transient Condition allDone;
    private volatile transient Condition ready;
    private volatile transient boolean isReady;
    private volatile transient boolean isDone;
    private volatile transient CounterSet counters;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lock = new ReentrantLock();
        this.allDone = this.lock.newCondition();
        this.ready = this.lock.newCondition();
        this.isReady = false;
        this.isDone = false;
    }

    public String toString() {
        return this.getClass().getName() + "{clientNum=" + this.locator + ",jobState=" + this.jobState + ",ready=" + this.isReady + ",done=" + this.isDone + ",counters=" + this.counters + "}";
    }

    public MappedRDFFileLoadTask(S jobState, INotifyOutcome<V, L> notifyProxy, L locator) {
        super(notifyProxy);
        if (jobState == null) {
            throw new IllegalArgumentException();
        }
        if (locator == null) {
            throw new IllegalArgumentException();
        }
        this.jobState = jobState;
        this.locator = locator;
    }

    @Override
    public JiniFederation<?> getFederation() {
        return (JiniFederation)super.getFederation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            AbstractTripleStore tripleStore;
            if (log.isInfoEnabled()) {
                log.info((Object)this.toString());
            }
            if ((tripleStore = (AbstractTripleStore)((DefaultResourceLocator)((AbstractFederation)this.getFederation()).getResourceLocator()).locate(((MappedRDFDataLoadMaster.JobState)this.jobState).namespace, 0L)) == null) {
                throw new RuntimeException("KB not found: namespace=" + ((MappedRDFDataLoadMaster.JobState)this.jobState).namespace);
            }
            RDFParserOptions parserOptions = ((MappedRDFDataLoadMaster.JobState)this.jobState).parserOptions;
            if (tripleStore.getLexiconRelation().isStoreBlankNodes() && !parserOptions.getPreserveBNodeIDs()) {
                parserOptions.setPreserveBNodeIDs(true);
                log.warn((Object)("Overriding parser configuration to set preserveBNodeIDs true since the target stores blank node IDs: namespace=" + tripleStore.getNamespace()));
            }
            this.statementBufferFactory = new AsynchronousStatementBufferFactory<BigdataStatement, V>((ScaleOutTripleStore)tripleStore, ((MappedRDFDataLoadMaster.JobState)this.jobState).producerChunkSize, ((MappedRDFDataLoadMaster.JobState)this.jobState).valuesInitialCapacity, ((MappedRDFDataLoadMaster.JobState)this.jobState).bnodesInitialCapacity, ((MappedRDFDataLoadMaster.JobState)this.jobState).getRDFFormat(), ((MappedRDFDataLoadMaster.JobState)this.jobState).defaultGraph, parserOptions, false, ((MappedRDFDataLoadMaster.JobState)this.jobState).parserPoolSize, ((MappedRDFDataLoadMaster.JobState)this.jobState).parserQueueCapacity, ((MappedRDFDataLoadMaster.JobState)this.jobState).term2IdWriterPoolSize, ((MappedRDFDataLoadMaster.JobState)this.jobState).otherWriterPoolSize, ((MappedRDFDataLoadMaster.JobState)this.jobState).notifyPoolSize, ((MappedRDFDataLoadMaster.JobState)this.jobState).unbufferedStatementThreshold){

                @Override
                protected Runnable newSuccessTask(V resource) {
                    return new Runnable((Serializable)resource){
                        final /* synthetic */ Serializable val$resource;
                        {
                            this.val$resource = serializable;
                        }

                        @Override
                        public void run() {
                            if (MappedRDFFileLoadTask.this.isDone) {
                                return;
                            }
                            try {
                                MappedRDFFileLoadTask.this.getNotifyProxy().success(this.val$resource, MappedRDFFileLoadTask.this.locator);
                            }
                            catch (Throwable ex) {
                                log.error((Object)this.val$resource, ex);
                            }
                        }
                    };
                }

                @Override
                protected Runnable newFailureTask(V resource, Throwable cause) {
                    return new Runnable((Serializable)resource, cause){
                        final /* synthetic */ Serializable val$resource;
                        final /* synthetic */ Throwable val$cause;
                        {
                            this.val$resource = serializable;
                            this.val$cause = throwable;
                        }

                        @Override
                        public void run() {
                            if (MappedRDFFileLoadTask.this.isDone) {
                                return;
                            }
                            try {
                                MappedRDFFileLoadTask.this.getNotifyProxy().error(this.val$resource, MappedRDFFileLoadTask.this.locator, this.val$cause);
                            }
                            catch (Throwable ex) {
                                log.error((Object)this.val$resource, ex);
                            }
                        }
                    };
                }
            };
            CounterSet serviceRoot = ((AbstractFederation)this.getFederation()).getServiceCounterSet();
            String relPath = ((MappedRDFDataLoadMaster.JobState)this.jobState).jobName;
            CounterSet tmp = serviceRoot.makePath(relPath);
            CounterSet counters = this.statementBufferFactory.getCounters();
            tmp.attach(counters, true);
            this.counters = tmp;
            this.isReady = true;
            this.ready.signalAll();
            if (log.isInfoEnabled()) {
                log.info((Object)("ready: " + this.toString()));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        try {
            this.setUp();
            this.lock.lockInterruptibly();
            try {
                while (!this.isDone) {
                    this.allDone.await();
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("done: " + this.toString()));
                }
            }
            catch (InterruptedException ex) {
                log.error((Object)("Client cancelled by interrupt: " + this.toString()));
            }
            finally {
                this.isDone = true;
                this.lock.unlock();
            }
        }
        finally {
            if (this.statementBufferFactory != null) {
                try {
                    this.statementBufferFactory.cancelAll(true);
                }
                catch (Throwable t2) {
                    log.warn((Object)this, t2);
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Client terminated: " + this.toString()));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void awaitReady() throws InterruptedException {
        if (this.lock == null) {
            throw new IllegalStateException();
        }
        this.lock.lockInterruptibly();
        try {
            while (!this.isReady) {
                this.ready.await();
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("ready: " + this.toString()));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void accept(V[] chunk) throws RemoteException, InterruptedException {
        this.awaitReady();
        if (log.isDebugEnabled()) {
            log.debug((Object)("accepting: " + chunk.length + " resources : " + this.toString()));
        }
        for (V resource : chunk) {
            if (this.isDone) {
                throw new IllegalStateException("task done: " + this.toString());
            }
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("locator=" + this.locator + ", resource=" + resource));
                }
                this.statementBufferFactory.submitOne(resource, ((MappedRDFDataLoadMaster.JobState)this.jobState).rejectedExecutionDelay);
            }
            catch (InterruptedException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.error((Object)(ex.getMessage() + ", locator=" + this.locator + ", resource=" + resource));
                this.getNotifyProxy().error(resource, this.locator, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws RemoteException, InterruptedException {
        this.awaitReady();
        this.lock.lockInterruptibly();
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("awaiting StatementBufferFactory: " + this.toString()));
            }
            this.statementBufferFactory.awaitAll();
            if (log.isInfoEnabled()) {
                log.info((Object)("StatementBufferFactory complete: " + this.toString()));
            }
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                this.isDone = true;
                this.allDone.signalAll();
                if (log.isInfoEnabled()) {
                    log.info((Object)("done: " + this.toString()));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

