/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio.turtle;

import com.bigdata.rdf.model.BigdataValueFactory;
import info.aduna.text.ASCIIUtil;
import java.io.IOException;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.turtle.TurtleParser;
import org.openrdf.rio.turtle.TurtleUtil;

public class BigdataTurtleParser
extends TurtleParser {
    protected Value parseValue() throws IOException, RDFParseException {
        int c = this.peek();
        if (c == 60) {
            return this.parseURIOrSid();
        }
        if (c == 58 || TurtleUtil.isPrefixStartChar((int)c)) {
            return this.parseQNameOrBoolean();
        }
        if (c == 95) {
            return this.parseNodeID();
        }
        if (c == 34 || c == 39) {
            return this.parseQuotedLiteral();
        }
        if (ASCIIUtil.isNumber((int)c) || c == 46 || c == 43 || c == 45) {
            return this.parseNumber();
        }
        if (c == -1) {
            this.throwEOFException();
            return null;
        }
        this.reportFatalError("Expected an RDF value here, found '" + (char)c + "'");
        return null;
    }

    protected Value parseURIOrSid() throws IOException, RDFParseException {
        int c = this.read();
        this.verifyCharacterOrFail(c, "<");
        int n = this.peek();
        if (n == 60) {
            this.read();
            if (this.valueFactory == null) {
                this.reportFatalError("must use a BigdataValueFactory to use the RDR syntax");
            }
            return this.parseSid();
        }
        this.unread(c);
        return this.parseURI();
    }

    protected Value parseSid() throws IOException, RDFParseException {
        Resource s = (Resource)this.parseValue();
        this.skipWS();
        URI p = (URI)this.parseValue();
        this.skipWS();
        Value o = this.parseValue();
        int i = this.read();
        while (TurtleUtil.isWhitespace((int)i)) {
            i = this.read();
        }
        if (i == 62 && this.read() == 62) {
            if (this.valueFactory == null || !(this.valueFactory instanceof BigdataValueFactory)) {
                throw new RDFParseException("You must use a BigdataValueFactory to use the RDR syntax");
            }
            try {
                this.reportStatement(s, p, o);
            }
            catch (RDFHandlerException ex) {
                throw new IOException(ex);
            }
            BigdataValueFactory valueFactory = (BigdataValueFactory)this.valueFactory;
            return valueFactory.createBNode(valueFactory.createStatement(s, p, o));
        }
        this.reportFatalError("expecting >> to close statement identifier");
        throw new IOException("expecting >> to close statement identifier");
    }

    protected int skipWS() throws IOException {
        int c = this.read();
        while (TurtleUtil.isWhitespace((int)c)) {
            c = this.read();
        }
        this.unread(c);
        return c;
    }

    protected BNode parseNodeID() throws IOException, RDFParseException {
        this.verifyCharacterOrFail(this.read(), "_");
        this.verifyCharacterOrFail(this.read(), ":");
        int c = this.read();
        if (c == -1) {
            this.throwEOFException();
        }
        StringBuilder name = new StringBuilder(32);
        name.append((char)c);
        c = this.read();
        if (!TurtleUtil.isNameChar((int)c)) {
            this.unread(c);
        }
        while (TurtleUtil.isNameChar((int)c)) {
            int previous = c;
            c = this.read();
            if (previous == 46 && (c == -1 || TurtleUtil.isWhitespace((int)c) || c == 60 || c == 95)) {
                this.unread(c);
                this.unread(previous);
                break;
            }
            name.append((char)previous);
            if (TurtleUtil.isNameChar((int)c)) continue;
            this.unread(c);
        }
        return this.createBNode(name.toString());
    }
}

