/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.ITransactionService;
import com.bigdata.journal.Journal;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.changesets.DelegatingChangeLog;
import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.changesets.StatementWriter;
import com.bigdata.rdf.inf.TruthMaintenance;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import com.bigdata.rdf.rio.StatementBuffer;
import com.bigdata.rdf.rules.BackchainAccessPath;
import com.bigdata.rdf.rules.InferenceEngine;
import com.bigdata.rdf.sail.Bigdata2SesameIteration;
import com.bigdata.rdf.sail.ISPARQLUpdateListener;
import com.bigdata.rdf.sail.SPARQLUpdateEvent;
import com.bigdata.rdf.sail.SailBase;
import com.bigdata.rdf.sail.webapp.DatasetNotFoundException;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.eval.ASTEvalHelper;
import com.bigdata.rdf.sparql.ast.service.CustomServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import com.bigdata.rdf.spo.ExplicitSPOFilter;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.InferredSPOFilter;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.BD;
import com.bigdata.rdf.store.BigdataStatementIterator;
import com.bigdata.rdf.store.BigdataStatementIteratorImpl;
import com.bigdata.rdf.store.BigdataValueIteratorImpl;
import com.bigdata.rdf.store.EmptyStatementIterator;
import com.bigdata.rdf.store.LocalTripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import com.bigdata.rdf.vocab.NoVocabulary;
import com.bigdata.relation.accesspath.EmptyAccessPath;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.CloseableIteratorWrapper;
import com.bigdata.striterator.IChunkedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.util.InnerCause;
import cutthecrap.utils.striterators.Expander;
import cutthecrap.utils.striterators.Striterator;
import info.aduna.iteration.CloseableIteration;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailConnectionListener;
import org.openrdf.sail.SailException;
import org.openrdf.sail.UnknownSailTransactionStateException;
import org.openrdf.sail.UpdateContext;

public class BigdataSail
extends SailBase
implements Sail {
    private static final String ERR_OPENRDF_QUERY_MODEL = "Support is no longer provided for UpdateExpr or TupleExpr evaluation. Please make sure you are using a BigdataSailRepository.  It will use the bigdata native evaluation model.";
    private static final Logger log = Logger.getLogger(BigdataSail.class);
    private static final Logger txLog = Logger.getLogger((String)"com.bigdata.txLog");
    public static final transient URI NULL_GRAPH = BD.NULL_GRAPH;
    protected final AbstractTripleStore database;
    protected final Properties properties;
    private final int bufferCapacity;
    private final boolean quads;
    private final boolean scaleOut;
    private final boolean queryTimeExpander;
    private final boolean exactSize;
    private final boolean allowAutoCommit;
    private final boolean isolatable;
    private final boolean rejectQuadsInTripleMode;
    private boolean openSail;
    private boolean closeOnShutdown;
    private Map<String, String> namespaces;
    private final QueryEngine queryEngine;
    private final boolean truthMaintenanceIsSupportable;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);

    public InferenceEngine getInferenceEngine() {
        return this.database.getInferenceEngine();
    }

    public boolean isQuads() {
        return this.quads;
    }

    public AbstractTripleStore getDatabase() {
        return this.database;
    }

    private static Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.setProperty(Options.FILE, "bigdata.jnl");
        return properties;
    }

    public BigdataSail() {
        this(BigdataSail.getDefaultProperties());
    }

    public BigdataSail(Properties properties) {
        this(BigdataSail.createLTS(properties));
        this.closeOnShutdown = true;
    }

    private static LocalTripleStore createLTS(Properties properties) {
        Journal journal = new Journal(properties);
        return BigdataSail.createLTS(journal, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocalTripleStore createLTS(Journal journal, Properties properties) {
        ITransactionService txService = journal.getTransactionManager().getTransactionService();
        String namespace = properties.getProperty(Options.NAMESPACE, "kb");
        BigdataSail.checkProperties(properties);
        boolean acquiredConnection = false;
        try {
            try {
                journal.acquireUnisolatedConnection();
                acquiredConnection = true;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            LocalTripleStore lts = (LocalTripleStore)journal.getResourceLocator().locate(namespace, 0L);
            if (lts != null) {
                LocalTripleStore localTripleStore = lts;
                return localTripleStore;
            }
            if (Boolean.parseBoolean(properties.getProperty(Options.ISOLATABLE_INDICES, "false"))) {
                long txCreate = txService.newTx(0L);
                boolean ok = false;
                try {
                    LocalTripleStore txCreateView = new LocalTripleStore(journal, namespace, txCreate, properties);
                    txCreateView.create();
                    txService.commit(txCreate);
                    ok = true;
                }
                finally {
                    if (!ok) {
                        txService.abort(txCreate);
                    }
                }
            } else {
                lts = new LocalTripleStore(journal, namespace, 0L, properties);
                lts.create();
            }
            lts = (LocalTripleStore)journal.getResourceLocator().locate(namespace, 0L);
            if (lts == null) {
                throw new RuntimeException("Concurrent create/destroy: " + namespace);
            }
            LocalTripleStore localTripleStore = lts;
            return localTripleStore;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (acquiredConnection) {
                journal.releaseUnisolatedConnection();
            }
        }
    }

    public static void checkProperties(Properties properties) throws UnsupportedOperationException {
        boolean quads = Boolean.parseBoolean(properties.getProperty(Options.QUADS, "false"));
        boolean quadsMode = Boolean.parseBoolean(properties.getProperty(Options.QUADS_MODE, "false"));
        boolean isolatable = Boolean.parseBoolean(properties.getProperty(Options.ISOLATABLE_INDICES, "false"));
        boolean tm = Boolean.parseBoolean(properties.getProperty(Options.TRUTH_MAINTENANCE, "true"));
        boolean justify = Boolean.parseBoolean(properties.getProperty(Options.JUSTIFY, "true"));
        boolean noAxioms = properties.getProperty(Options.AXIOMS_CLASS, Options.DEFAULT_AXIOMS_CLASS).equals(NoAxioms.class.getName());
        boolean noVocab = properties.getProperty(Options.VOCABULARY_CLASS, Options.DEFAULT_VOCABULARY_CLASS).equals(NoVocabulary.class.getName());
        if (isolatable && !quadsMode) {
            if (tm) {
                throw new UnsupportedOperationException("Cannot use transactions with truth maintenance. Set option " + Options.TRUTH_MAINTENANCE + " = false");
            }
            if (!noAxioms) {
                throw new UnsupportedOperationException("Cannot use transactions with inference. Set option " + Options.AXIOMS_CLASS + " = " + NoAxioms.class.getName());
            }
            if (!noVocab) {
                throw new UnsupportedOperationException("Cannot use transactions with a vocabulary class. Set option " + Options.VOCABULARY_CLASS + " = " + NoVocabulary.class.getName());
            }
            if (justify) {
                throw new UnsupportedOperationException("Cannot use transactions with justification chains. Set option " + Options.JUSTIFY + " = " + Boolean.FALSE);
            }
        }
        if ((quads || quadsMode) && tm) {
            throw new UnsupportedOperationException(Options.TRUTH_MAINTENANCE + " is not supported with quads (" + Options.QUADS + ")");
        }
    }

    public BigdataSail(AbstractTripleStore database) {
        this(database, database);
    }

    public BigdataSail(AbstractTripleStore database, AbstractTripleStore mainDatabase) {
        if (database == null) {
            throw new IllegalArgumentException();
        }
        if (mainDatabase == null) {
            throw new IllegalArgumentException();
        }
        this.closeOnShutdown = false;
        this.database = database;
        this.properties = database.getProperties();
        this.quads = database.isQuads();
        this.scaleOut = database.getIndexManager() instanceof IBigdataFederation;
        BigdataSail.checkProperties(this.properties);
        if (database.getAxioms() instanceof NoAxioms || this.quads || this.scaleOut) {
            this.truthMaintenanceIsSupportable = false;
        } else {
            this.truthMaintenanceIsSupportable = Boolean.parseBoolean(this.properties.getProperty(Options.TRUTH_MAINTENANCE, "true"));
            if (log.isInfoEnabled()) {
                log.info((Object)(Options.TRUTH_MAINTENANCE + "=" + this.truthMaintenanceIsSupportable));
            }
        }
        this.bufferCapacity = Integer.parseInt(this.properties.getProperty(Options.BUFFER_CAPACITY, "10000"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.BUFFER_CAPACITY + "=" + this.bufferCapacity));
        }
        if (this.scaleOut) {
            this.queryTimeExpander = false;
        } else {
            this.queryTimeExpander = Boolean.parseBoolean(this.properties.getProperty(Options.QUERY_TIME_EXPANDER, "true"));
            if (log.isInfoEnabled()) {
                log.info((Object)(Options.QUERY_TIME_EXPANDER + "=" + this.queryTimeExpander));
            }
        }
        this.exactSize = Boolean.parseBoolean(this.properties.getProperty(Options.EXACT_SIZE, "false"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.EXACT_SIZE + "=" + this.exactSize));
        }
        this.allowAutoCommit = Boolean.parseBoolean(this.properties.getProperty(Options.ALLOW_AUTO_COMMIT, "false"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.ALLOW_AUTO_COMMIT + "=" + this.allowAutoCommit));
        }
        this.isolatable = Boolean.parseBoolean(this.properties.getProperty(Options.ISOLATABLE_INDICES, "false"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.ISOLATABLE_INDICES + "=" + this.isolatable));
        }
        this.rejectQuadsInTripleMode = Boolean.parseBoolean(this.properties.getProperty(Options.REJECT_QUADS_IN_TRIPLE_MODE, "false"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.REJECT_QUADS_IN_TRIPLE_MODE + "=" + this.rejectQuadsInTripleMode));
        }
        this.namespaces = Collections.synchronizedMap(new LinkedHashMap());
        this.queryEngine = QueryEngineFactory.getQueryController(mainDatabase.getIndexManager());
    }

    protected void assertOpenSail() {
        if (!this.openSail) {
            throw new IllegalStateException();
        }
    }

    public boolean isOpen() {
        return this.openSail;
    }

    @Override
    protected void initializeInternal() throws SailException {
        if (this.openSail) {
            throw new IllegalStateException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("closeOnShutdown=" + this.closeOnShutdown));
        }
        this.openSail = true;
    }

    protected void finalize() throws Throwable {
        if (this.isOpen()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"");
            }
            this.shutDown();
        }
        super.finalize();
    }

    @Override
    public void shutDown() throws SailException {
        this.assertOpenSail();
        super.shutDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shutDownInternal() throws SailException {
        if (this.openSail) {
            try {
                if (this.closeOnShutdown) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Closing the backing database");
                    }
                    ((BigdataValueFactoryImpl)this.getValueFactory()).remove();
                    this.database.close();
                }
            }
            finally {
                this.openSail = false;
            }
        }
    }

    public void __tearDownUnitTest() {
        this.closeOnShutdown = false;
        try {
            if (this.isOpen()) {
                this.shutDown();
            }
            this.database.__tearDownUnitTest();
        }
        catch (Throwable t) {
            log.error((Object)("Problem during shutdown: " + t), t);
        }
    }

    public final ValueFactory getValueFactory() {
        return this.database.getValueFactory();
    }

    public final boolean isWritable() throws SailException {
        return !this.database.isReadOnly();
    }

    protected NotifyingSailConnection getConnectionInternal() throws SailException {
        try {
            BigdataSailConnection conn = this.isolatable ? this.getReadWriteConnection() : this.getUnisolatedConnection();
            return conn;
        }
        catch (Exception ex) {
            throw new SailException((Throwable)ex);
        }
    }

    public BigdataSailConnection getConnection() throws SailException {
        return (BigdataSailConnection)super.getConnection();
    }

    public BigdataSailConnection getUnisolatedConnection() throws InterruptedException {
        if (this.lock.writeLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("UNISOLATED connection is not reentrant.");
        }
        boolean acquiredConnection = false;
        Lock writeLock = null;
        BigdataSailConnection conn = null;
        try {
            if (this.getDatabase().getIndexManager() instanceof Journal) {
                ((Journal)this.getDatabase().getIndexManager()).acquireUnisolatedConnection();
                acquiredConnection = true;
            }
            writeLock = this.lock.writeLock();
            writeLock.lock();
            assert (this.database != null);
            conn = new BigdataSailConnection(this.database, writeLock, true).startConn();
        }
        catch (DatasetNotFoundException ex) {
            throw new RuntimeException((Throwable)((Object)ex));
        }
        finally {
            if (conn == null) {
                if (writeLock != null) {
                    writeLock.unlock();
                }
                if (acquiredConnection) {
                    ((Journal)this.getDatabase().getIndexManager()).releaseUnisolatedConnection();
                }
            }
        }
        return conn;
    }

    public BigdataSailConnection getReadOnlyConnection() {
        return this.getReadOnlyConnection(-1L);
    }

    public BigdataSailConnection getReadOnlyConnection(long timestamp) {
        try {
            return this._getReadOnlyConnection(timestamp);
        }
        catch (DatasetNotFoundException | IOException e) {
            throw new RuntimeException((Throwable)e);
        }
    }

    private BigdataSailConnection _getReadOnlyConnection(long timestamp) throws IOException, DatasetNotFoundException {
        return new BigdataSailReadOnlyConnection(timestamp).startConn();
    }

    public BigdataSailConnection getReadWriteConnection() throws IOException {
        if (!this.isolatable) {
            throw new UnsupportedOperationException("Read/write transactions are not allowed on this database. See " + Options.ISOLATABLE_INDICES);
        }
        IIndexManager indexManager = this.database.getIndexManager();
        if (indexManager instanceof IBigdataFederation) {
            throw new UnsupportedOperationException("Read/write transactions are not yet supported in scale-out.");
        }
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        return new BigdataSailRWTxConnection(readLock).startConn();
    }

    protected ITransactionService getTxService() {
        IIndexManager indexManager = this.database.getIndexManager();
        ITransactionService txService = indexManager instanceof IJournal ? ((IJournal)indexManager).getLocalTransactionManager().getTransactionService() : ((AbstractFederation)indexManager).getTransactionService();
        return txService;
    }

    public QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    private class BigdataSailReadOnlyConnection
    extends BigdataSailConnection {
        private final ITransactionService txService;
        private long tx;
        private final boolean clusterCacheBugFix;

        BigdataSailReadOnlyConnection(long timestamp) throws IOException, DatasetNotFoundException {
            super(null, false, true);
            this.clusterCacheBugFix = BigdataSail.this.scaleOut;
            this.txService = BigdataSail.this.getTxService();
            this.newTx(timestamp);
        }

        protected void newTx(long timestamp) throws IOException, DatasetNotFoundException {
            AbstractTripleStore database = BigdataSail.this.database;
            String namespace = database.getNamespace();
            if (this.clusterCacheBugFix) {
                this.tx = timestamp;
                AbstractTripleStore txView = database.getTimestamp() == timestamp ? database : (AbstractTripleStore)database.getIndexManager().getResourceLocator().locate(namespace, this.tx);
                this.attach(txView);
            } else {
                this.tx = this.txService.newTx(timestamp);
                try {
                    AbstractTripleStore txView = (AbstractTripleStore)database.getIndexManager().getResourceLocator().locate(namespace, this.tx);
                    this.attach(txView);
                }
                catch (Throwable t) {
                    try {
                        this.txService.abort(this.tx);
                    }
                    catch (IOException ex) {
                        log.error((Object)ex, (Throwable)ex);
                    }
                    throw new RuntimeException(t);
                }
            }
        }

        @Override
        public synchronized long commit2() throws SailException {
            return 0L;
        }

        @Override
        public synchronized void rollback() throws SailException {
            if (txLog.isInfoEnabled()) {
                txLog.info((Object)("SAIL-ROLLBACK-CONN: " + this));
            }
        }

        @Override
        public synchronized void close() throws SailException {
            if (!this.openConn) {
                return;
            }
            super.close();
            if (!this.clusterCacheBugFix) {
                try {
                    this.txService.abort(this.tx);
                }
                catch (IOException ex) {
                    throw new SailException((Throwable)ex);
                }
            }
        }
    }

    private class BigdataSailRWTxConnection
    extends BigdataSailConnection {
        private final ITransactionService txService;
        private long tx;

        public BigdataSailRWTxConnection(Lock readLock) throws IOException {
            super(readLock, false, false);
            this.txService = BigdataSail.this.getTxService();
            this.newTx();
        }

        protected void newTx() throws IOException {
            AbstractTripleStore database = BigdataSail.this.database;
            String namespace = database.getNamespace();
            this.tx = this.txService.newTx(0L);
            try {
                AbstractTripleStore txView = (AbstractTripleStore)database.getIndexManager().getResourceLocator().locate(namespace, this.tx);
                this.attach(txView);
                if (txLog.isInfoEnabled()) {
                    txLog.info((Object)("SAIL-NEW-TX : txId=" + this.tx + ", conn=" + this));
                }
            }
            catch (Throwable t) {
                try {
                    this.txService.abort(this.tx);
                }
                catch (IOException ex) {
                    log.error((Object)ex, (Throwable)ex);
                }
                throw new RuntimeException(t);
            }
        }

        @Override
        public synchronized long commit2() throws SailException {
            this.assertWritableConn();
            this.flushStatementBuffers(true, true);
            try {
                if (this.changeLog != null) {
                    this.changeLog.transactionPrepare();
                }
                long commitTime = this.txService.commit(this.tx);
                if (txLog.isInfoEnabled()) {
                    txLog.info((Object)("SAIL-COMMIT-CONN : commitTime=" + commitTime + ", conn=" + this));
                }
                if (this.changeLog != null) {
                    this.changeLog.transactionCommited(commitTime);
                }
                this.newTx();
                if (this.changeLog != null) {
                    this.changeLog.transactionBegin();
                }
                this.dirty = false;
                return commitTime;
            }
            catch (IOException ex) {
                throw new SailException((Throwable)ex);
            }
        }

        @Override
        public synchronized void rollback() throws SailException {
            if (txLog.isInfoEnabled()) {
                txLog.info((Object)("SAIL-ROLLBACK-CONN: " + this));
            }
            try {
                this.txService.abort(this.tx);
                this.dirty = false;
                this.newTx();
            }
            catch (IOException ex) {
                throw new SailException((Throwable)ex);
            }
        }

        @Override
        public synchronized void close() throws SailException {
            if (!this.openConn) {
                return;
            }
            super.close();
            try {
                this.txService.abort(this.tx);
            }
            catch (IOException ex) {
                throw new SailException((Throwable)ex);
            }
        }
    }

    public class BigdataSailConnection
    implements NotifyingSailConnection {
        protected AbstractTripleStore database;
        protected final boolean readOnly;
        protected boolean openConn;
        private boolean truthMaintenance;
        private TruthMaintenance tm;
        private StatementBuffer<Statement> assertBuffer;
        private StatementBuffer<Statement> retractBuffer;
        protected boolean dirty = false;
        private Map<String, BigdataBNode> bnodes;
        private Map<IV, BigdataBNode> bnodes2;
        private final Lock lock;
        private final boolean unisolated;
        private final AtomicBoolean rollbackRequired = new AtomicBoolean(false);
        private Vector<SailConnectionListener> m_listeners = null;
        protected DelegatingChangeLog changeLog;
        private final CopyOnWriteArraySet<ISPARQLUpdateListener> listeners;

        public String toString() {
            return this.getClass().getName() + "{timestamp=" + TimestampUtility.toString(this.database.getTimestamp()) + ",open=" + this.openConn + "}";
        }

        public BigdataSail getBigdataSail() {
            return BigdataSail.this;
        }

        protected synchronized StatementBuffer<Statement> getAssertionBuffer() {
            if (this.assertBuffer == null) {
                if (this.truthMaintenance) {
                    this.assertBuffer = new StatementBuffer(this.tm.newTempTripleStore(), this.database, BigdataSail.this.bufferCapacity);
                } else {
                    this.assertBuffer = new StatementBuffer(this.database, BigdataSail.this.bufferCapacity);
                    this.assertBuffer.setChangeLog(this.changeLog);
                }
                this.assertBuffer.setBNodeMap(this.bnodes);
            }
            return this.assertBuffer;
        }

        protected synchronized StatementBuffer<Statement> getRetractionBuffer() {
            if (this.retractBuffer == null && this.truthMaintenance) {
                this.retractBuffer = new StatementBuffer(this.tm.newTempTripleStore(), this.database, BigdataSail.this.bufferCapacity);
                this.retractBuffer.setBNodeMap(this.bnodes);
            }
            return this.retractBuffer;
        }

        protected BigdataSailConnection(Lock lock, boolean unisolated, boolean readOnly) {
            this.lock = lock;
            this.unisolated = unisolated;
            this.readOnly = readOnly;
            this.truthMaintenance = BigdataSail.this.truthMaintenanceIsSupportable && unisolated;
            this.listeners = readOnly ? null : new CopyOnWriteArraySet();
        }

        protected BigdataSailConnection(AbstractTripleStore database, Lock lock, boolean unisolated) throws DatasetNotFoundException {
            this(lock, unisolated, database.isReadOnly());
            this.attach(database);
        }

        protected BigdataSailConnection startConn() {
            if (txLog.isInfoEnabled()) {
                txLog.info((Object)("SAIL-START-CONN : conn=" + this));
            }
            if (!this.isReadOnly()) {
                Iterator<CustomServiceFactory> itr = ServiceRegistry.getInstance().customServices();
                while (itr.hasNext()) {
                    CustomServiceFactory f = itr.next();
                    try {
                        f.startConnection(this);
                    }
                    catch (Throwable t) {
                        log.error((Object)t, t);
                    }
                }
                if (this.changeLog != null) {
                    this.changeLog.transactionBegin();
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getTruthMaintenance() {
            BigdataSailConnection bigdataSailConnection = this;
            synchronized (bigdataSailConnection) {
                return this.truthMaintenance;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setTruthMaintenance(boolean newValue) {
            if (!this.unisolated) {
                throw new UnsupportedOperationException("Not an unisolated connection");
            }
            if (!BigdataSail.this.truthMaintenanceIsSupportable) {
                throw new UnsupportedOperationException("Truth maintenance is not configured");
            }
            BigdataSailConnection bigdataSailConnection = this;
            synchronized (bigdataSailConnection) {
                if (this.truthMaintenance != newValue) {
                    this.flush();
                }
                boolean oldValue = this.truthMaintenance;
                this.truthMaintenance = newValue;
                return oldValue;
            }
        }

        protected synchronized void attach(AbstractTripleStore database) throws DatasetNotFoundException {
            if (database == null) {
                throw new DatasetNotFoundException();
            }
            BigdataSail.this.assertOpenSail();
            this.database = database;
            this.openConn = true;
            this.assertBuffer = null;
            this.retractBuffer = null;
            this.m_listeners = null;
            if (database.isReadOnly()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Read-only view");
                }
                this.tm = null;
                this.bnodes = null;
                this.bnodes2 = null;
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Read-write view");
                }
                this.bnodes = new ConcurrentHashMap<String, BigdataBNode>();
                this.bnodes2 = new ConcurrentHashMap<IV, BigdataBNode>();
                this.tm = this.truthMaintenance ? new TruthMaintenance(BigdataSail.this.getInferenceEngine()) : null;
            }
        }

        public AbstractTripleStore getTripleStore() {
            return this.database;
        }

        public final boolean isQueryTimeExpander() {
            return BigdataSail.this.queryTimeExpander;
        }

        public final boolean isReadOnly() {
            return this.database.isReadOnly();
        }

        public final boolean isUnisolated() {
            return this.database.getTimestamp() == 0L;
        }

        public boolean getAllowAutoCommit() {
            return BigdataSail.this.allowAutoCommit;
        }

        public synchronized void addConnectionListener(SailConnectionListener listener) {
            if (this.m_listeners == null) {
                this.m_listeners = new Vector();
                this.m_listeners.add(listener);
            } else {
                if (this.m_listeners.contains(listener)) {
                    throw new IllegalStateException("Already registered: listener=" + listener);
                }
                this.m_listeners.add(listener);
            }
            log.warn((Object)"Adding SailConnectionListener - performance will suffer!");
        }

        public synchronized void removeConnectionListener(SailConnectionListener listener) {
            if (this.m_listeners == null) {
                throw new IllegalStateException("Not registered: listener=" + listener);
            }
            if (!this.m_listeners.remove(listener)) {
                throw new IllegalStateException("Not registered: listener=" + listener);
            }
            if (this.m_listeners.isEmpty()) {
                this.m_listeners = null;
            }
        }

        protected synchronized void fireSailChangedEvent(boolean added, Statement stmt) {
            if (this.m_listeners == null) {
                return;
            }
            SailConnectionListener[] listeners = this.m_listeners.toArray(new SailConnectionListener[0]);
            for (int i = 0; i < listeners.length; ++i) {
                SailConnectionListener l = listeners[i];
                if (added) {
                    l.statementAdded(stmt);
                    continue;
                }
                l.statementRemoved(stmt);
            }
        }

        public void setNamespace(String prefix, String namespace) throws SailException {
            if (prefix == null) {
                throw new NullPointerException();
            }
            if (namespace == null) {
                throw new NullPointerException();
            }
            this.assertWritableConn();
            BigdataSail.this.namespaces.put(prefix, namespace);
        }

        public String getNamespace(String prefix) {
            if (prefix == null) {
                throw new NullPointerException();
            }
            return (String)BigdataSail.this.namespaces.get(prefix);
        }

        public void removeNamespace(String prefix) {
            if (prefix == null) {
                throw new NullPointerException();
            }
            BigdataSail.this.namespaces.remove(prefix);
        }

        public void clearNamespaces() {
            BigdataSail.this.namespaces.clear();
        }

        public NamespaceIterator getNamespaces() {
            return new NamespaceIterator(BigdataSail.this.namespaces.entrySet().iterator());
        }

        public void addStatement(Resource s, URI p, Value o, Resource ... contexts) throws SailException {
            if (log.isDebugEnabled()) {
                log.debug((Object)("s=" + s + ", p=" + p + ", o=" + o + ", contexts=" + Arrays.toString(contexts)));
            }
            OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
            if (contexts.length == 0) {
                this.addStatement(s, p, o, (Resource)null);
            }
            if (contexts.length == 1 && contexts[0] == null) {
                this.addStatement(s, p, o, (Resource)null);
            }
            for (Resource c : contexts) {
                this.addStatement(s, p, o, c);
            }
        }

        private synchronized void addStatement(Resource s, URI p, Value o, Resource c) throws SailException {
            if (!this.isOpen()) {
                throw new IllegalStateException();
            }
            this.assertWritableConn();
            this.flushStatementBuffers(false, true);
            if (BigdataSail.this.rejectQuadsInTripleMode && !BigdataSail.this.quads && c != null) {
                throw new SailException("Quad in triples mode is not allowed by configuration (set parameter rejectQuadsInTripleMode to false to allow for quads data)");
            }
            this.getAssertionBuffer().add(s, p, o, (Resource)(c == null && BigdataSail.this.quads ? NULL_GRAPH : c));
            if (this.m_listeners != null) {
                this.fireSailChangedEvent(true, (Statement)new ContextStatementImpl(s, p, o, c));
            }
        }

        public synchronized void clear(Resource ... contexts) throws SailException {
            OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
            if (log.isInfoEnabled()) {
                log.info((Object)("contexts=" + Arrays.toString(contexts)));
            }
            this.assertWritableConn();
            this.clearBuffers();
            if (contexts.length == 0) {
                this.database.getAccessPath((Resource)null, (URI)null, (Value)null, (Resource)null).removeAll();
                return;
            }
            if (contexts.length == 1 && contexts[0] == null) {
                this.database.getAccessPath(null, null, null, (Resource)(BigdataSail.this.quads ? NULL_GRAPH : null)).removeAll();
                return;
            }
            long size = 0L;
            for (Resource c : contexts) {
                size += this.database.getAccessPath(null, null, null, (Resource)(c == null && BigdataSail.this.quads ? NULL_GRAPH : c)).removeAll();
            }
        }

        private void clearBuffers() {
            if (this.assertBuffer != null) {
                this.assertBuffer.reset();
                if (this.truthMaintenance) {
                    this.assertBuffer.getStatementStore().close();
                    this.assertBuffer = null;
                }
            }
            if (this.retractBuffer != null) {
                this.retractBuffer.reset();
                if (this.truthMaintenance) {
                    this.retractBuffer.getStatementStore().close();
                    this.retractBuffer = null;
                }
            }
            this.bnodes.clear();
            this.bnodes2.clear();
        }

        public long size(Resource ... contexts) throws SailException {
            return this.size(BigdataSail.this.exactSize, contexts);
        }

        public long exactSize(Resource ... contexts) throws SailException {
            return this.size(true, contexts);
        }

        private synchronized long size(boolean exactSize, Resource ... contexts) throws SailException {
            this.flushStatementBuffers(true, true);
            OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
            if (log.isInfoEnabled()) {
                log.info((Object)("contexts=" + Arrays.toString(contexts)));
            }
            if (exactSize) {
                if (contexts.length == 0) {
                    return this.database.getExplicitStatementCount(null);
                }
                if (contexts.length == 1 && contexts[0] == null) {
                    return this.database.getExplicitStatementCount((Resource)(BigdataSail.this.quads ? NULL_GRAPH : null));
                }
                long size = 0L;
                for (Resource c : contexts) {
                    size += this.database.getExplicitStatementCount((Resource)(c == null && BigdataSail.this.quads ? NULL_GRAPH : c));
                }
                return size;
            }
            if (contexts.length == 0) {
                return this.database.getStatementCount(null, false);
            }
            if (contexts.length == 1 && contexts[0] == null) {
                return this.database.getStatementCount((Resource)(BigdataSail.this.quads ? NULL_GRAPH : null), false);
            }
            long size = 0L;
            for (Resource c : contexts) {
                size += this.database.getStatementCount((Resource)(c == null && BigdataSail.this.quads ? NULL_GRAPH : c), false);
            }
            return size;
        }

        public void removeStatements(Resource s, URI p, Value o, Resource ... contexts) throws SailException {
            OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
            if (log.isInfoEnabled()) {
                log.info((Object)("s=" + s + ", p=" + p + ", o=" + o + ", contexts=" + Arrays.toString(contexts)));
            }
            if (contexts.length == 0) {
                this.removeStatements(s, p, o, (Resource)null);
            } else if (contexts.length == 1 && contexts[0] == null) {
                this.removeStatements(s, p, o, (Resource)(BigdataSail.this.quads ? NULL_GRAPH : null));
            } else {
                for (Resource c : contexts) {
                    this.removeStatements(s, p, o, (Resource)(c == null && BigdataSail.this.quads ? NULL_GRAPH : c));
                }
            }
        }

        public synchronized int removeStatements(Resource s, URI p, Value o, Resource c) throws SailException {
            this.assertWritableConn();
            this.flushStatementBuffers(true, false);
            if (this.m_listeners != null) {
                throw new UnsupportedOperationException();
            }
            long n = 0L;
            if (this.getTruthMaintenance()) {
                IChunkedOrderedIterator<ISPO> itr = this.database.getAccessPath(s, p, o, ExplicitSPOFilter.INSTANCE).iterator();
                AbstractTripleStore tempStore = this.getRetractionBuffer().getStatementStore();
                n = tempStore.addStatements(tempStore, true, itr, null);
            } else if (this.changeLog == null) {
                n = this.database.removeStatements(s, p, o, c);
            } else {
                IChunkedOrderedIterator<ISPO> itr = this.database.computeClosureForStatementIdentifiers(this.database.getAccessPath(s, p, o, c).iterator());
                n = StatementWriter.removeStatements(this.database, itr, false, this.changeLog);
            }
            return (int)Math.min(Integer.MAX_VALUE, n);
        }

        public synchronized int removeStatements(ISPO[] stmts) throws SailException {
            this.assertWritableConn();
            this.flushStatementBuffers(true, false);
            if (this.m_listeners != null) {
                throw new UnsupportedOperationException();
            }
            long n = 0L;
            if (this.getTruthMaintenance()) {
                ChunkedArrayIterator<ISPO> itr = new ChunkedArrayIterator<ISPO>(stmts);
                AbstractTripleStore tempStore = this.getRetractionBuffer().getStatementStore();
                n = tempStore.addStatements(tempStore, true, itr, null);
            } else if (this.changeLog == null) {
                n = this.database.removeStatements(stmts, stmts.length);
            } else {
                IChunkedOrderedIterator<ISPO> itr = this.database.computeClosureForStatementIdentifiers(new ChunkedArrayIterator<ISPO>(stmts));
                n = StatementWriter.removeStatements(this.database, itr, false, this.changeLog);
            }
            return (int)Math.min(Integer.MAX_VALUE, n);
        }

        public synchronized CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
            if (!this.database.isQuads()) {
                throw new UnsupportedOperationException();
            }
            if (this.database.getSPORelation().oneAccessPath) {
                throw new UnsupportedOperationException();
            }
            this.flushStatementBuffers(true, true);
            IChunkedIterator<IV> itr = this.database.getSPORelation().distinctTermScan(SPOKeyOrder.CSPO);
            final BigdataValueIteratorImpl itr2 = new BigdataValueIteratorImpl(this.database, itr);
            return new CloseableIteration<Resource, SailException>(){
                private Resource next = null;
                private boolean open = true;

                public void close() throws SailException {
                    if (this.open) {
                        this.open = false;
                        this.next = null;
                        itr2.close();
                    }
                }

                public boolean hasNext() throws SailException {
                    if (this.open && this._hasNext()) {
                        return true;
                    }
                    this.close();
                    return false;
                }

                private boolean _hasNext() throws SailException {
                    if (this.next != null) {
                        return true;
                    }
                    while (itr2.hasNext()) {
                        this.next = (Resource)itr2.next();
                        if (this.next.equals(BD.NULL_GRAPH)) {
                            this.next = null;
                            continue;
                        }
                        return true;
                    }
                    return false;
                }

                public Resource next() throws SailException {
                    if (this.next == null) {
                        throw new SailException();
                    }
                    Resource tmp = this.next;
                    this.next = null;
                    return tmp;
                }

                public void remove() throws SailException {
                    throw new UnsupportedOperationException();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void rollback() throws SailException {
            boolean success = false;
            try {
                this.assertWritableConn();
                if (txLog.isInfoEnabled()) {
                    txLog.info((Object)("SAIL-ROLLBACK-CONN: " + this));
                }
                this.clearBuffers();
                this.database.abort();
                if (this.changeLog != null) {
                    this.changeLog.transactionAborted();
                }
                this.dirty = false;
                success = true;
                this.rollbackRequired.set(!success);
            }
            catch (Throwable throwable) {
                this.rollbackRequired.set(!success);
                throw throwable;
            }
        }

        public synchronized boolean isDirty() {
            return this.dirty;
        }

        public synchronized long commit2() throws SailException {
            if (this.rollbackRequired.get()) {
                throw new IllegalStateException("Rollback required");
            }
            this.assertWritableConn();
            this.flushStatementBuffers(true, true);
            if (this.changeLog != null) {
                this.changeLog.transactionPrepare();
            }
            long commitTime = this.database.commit();
            if (txLog.isInfoEnabled()) {
                txLog.info((Object)("SAIL-COMMIT-CONN : commitTime=" + commitTime + ", conn=" + this));
            }
            if (this.changeLog != null) {
                this.changeLog.transactionCommited(commitTime);
            }
            this.dirty = false;
            return commitTime;
        }

        public final synchronized void commit() throws SailException {
            this.commit2();
        }

        public final boolean isOpen() throws SailException {
            return this.openConn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() throws SailException {
            if (!this.openConn) {
                return;
            }
            if (txLog.isInfoEnabled()) {
                txLog.info((Object)("SAIL-CLOSE-CONN: conn=" + this));
            }
            IIndexManager im = BigdataSail.this.getDatabase().getIndexManager();
            if (this.isDirty()) {
                this.rollback();
            }
            try {
                BigdataSail.this.connectionClosed((SailConnection)this);
            }
            finally {
                if (this.lock != null) {
                    this.lock.unlock();
                }
                if (this.unisolated && im instanceof Journal) {
                    ((Journal)im).releaseUnisolatedConnection();
                }
                this.openConn = false;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }

        public void flush() {
            this.flushStatementBuffers(true, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void flushStatementBuffers(boolean flushAssertBuffer, boolean flushRetractBuffer) {
            if (this.readOnly) {
                return;
            }
            BigdataSailConnection bigdataSailConnection = this;
            synchronized (bigdataSailConnection) {
                if (flushAssertBuffer && this.assertBuffer != null) {
                    if (!this.assertBuffer.isEmpty()) {
                        this.dirty = true;
                    }
                    this.assertBuffer.flush();
                    if (this.getTruthMaintenance()) {
                        this.tm.assertAll((TempTripleStore)this.assertBuffer.getStatementStore(), this.changeLog);
                        this.assertBuffer = null;
                    }
                }
                if (flushRetractBuffer && this.retractBuffer != null) {
                    if (!this.retractBuffer.isEmpty()) {
                        this.dirty = true;
                    }
                    this.retractBuffer.flush();
                    if (this.getTruthMaintenance()) {
                        this.tm.retractAll((TempTripleStore)this.retractBuffer.getStatementStore(), this.changeLog);
                        this.retractBuffer = null;
                    }
                    this.dirty = true;
                }
            }
        }

        protected void assertOpenConn() throws SailException {
            if (!this.openConn) {
                throw new SailException("Closed");
            }
        }

        protected void assertWritableConn() throws SailException {
            this.assertOpenConn();
            if (this.readOnly) {
                throw new SailException("Read-only");
            }
        }

        public CloseableIteration<? extends Statement, SailException> getStatements(Resource s, URI p, Value o, Resource context) throws SailException {
            Resource[] resourceArray;
            if (context == null) {
                resourceArray = new Resource[]{};
            } else {
                Resource[] resourceArray2 = new Resource[1];
                resourceArray = resourceArray2;
                resourceArray2[0] = context;
            }
            return this.getStatements(s, p, o, true, resourceArray);
        }

        public CloseableIteration<? extends Statement, SailException> getStatements(final Resource s, final URI p, final Value o, final boolean includeInferred, Resource ... contexts) throws SailException {
            if (!this.isOpen()) {
                throw new IllegalStateException();
            }
            OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
            if (log.isInfoEnabled()) {
                log.info((Object)("s=" + s + ", p=" + p + ", o=" + o + ", includeInferred=" + includeInferred + ", contexts=" + Arrays.toString(contexts)));
            }
            if (contexts.length == 0) {
                return new Bigdata2SesameIteration<BigdataStatement, SailException>(this.getStatements(s, p, o, null, includeInferred));
            }
            if (contexts.length == 1 && contexts[0] == null) {
                return new Bigdata2SesameIteration<BigdataStatement, SailException>(this.getStatements(s, p, o, (Resource)(BigdataSail.this.quads ? NULL_GRAPH : null), includeInferred));
            }
            return new Bigdata2SesameIteration(new CloseableIteratorWrapper(new Striterator(Arrays.asList(contexts).iterator()).addFilter(new Expander(){
                private static final long serialVersionUID = 1L;

                @Override
                protected Iterator expand(Object c) {
                    return BigdataSailConnection.this.getStatements(s, p, o, (Resource)(c == null && BigdataSail.this.quads ? NULL_GRAPH : c), includeInferred);
                }
            })));
        }

        private synchronized BigdataStatementIterator getStatements(Resource s, URI p, Value o, Resource c, boolean includeInferred) {
            this.flushStatementBuffers(true, true);
            IElementFilter<ISPO> filter = includeInferred ? null : ExplicitSPOFilter.INSTANCE;
            IAccessPath<ISPO> accessPath = this.database.getAccessPath(s, p, o, c, filter, null);
            if (accessPath instanceof EmptyAccessPath) {
                return EmptyStatementIterator.INSTANCE;
            }
            boolean backchain = this.database.getAxioms().isRdfSchema() && includeInferred && this.isQueryTimeExpander();
            IChunkedOrderedIterator<ISPO> src = backchain ? new BackchainAccessPath(this.database, accessPath).iterator() : accessPath.iterator();
            return new BigdataStatementIteratorImpl(this.database, this.bnodes2, src).start(this.database.getExecutorService());
        }

        public synchronized void computeClosure() throws SailException {
            this.assertWritableConn();
            this.flushStatementBuffers(true, true);
            BigdataSail.this.getInferenceEngine().computeClosure(null);
        }

        public synchronized void removeAllEntailments() throws SailException {
            this.assertWritableConn();
            this.flushStatementBuffers(true, true);
            if (BigdataSail.this.quads) {
                throw new UnsupportedOperationException();
            }
            IV NULL = null;
            this.database.getAccessPath(NULL, NULL, NULL, InferredSPOFilter.INSTANCE).removeAll();
        }

        public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
            throw new SailException(BigdataSail.ERR_OPENRDF_QUERY_MODEL);
        }

        public CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(QueryRoot queryRoot, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
            ASTContainer astContainer = new ASTContainer(queryRoot);
            QueryRoot originalQuery = astContainer.getOriginalAST();
            originalQuery.setIncludeInferred(includeInferred);
            try {
                this.flushStatementBuffers(true, true);
                return ASTEvalHelper.evaluateTupleQuery(this.getTripleStore(), astContainer, new QueryBindingSet(bindings));
            }
            catch (QueryEvaluationException e) {
                throw new SailException((Throwable)e);
            }
        }

        public synchronized void addChangeLog(IChangeLog changeLog) {
            if (this.changeLog == null) {
                this.changeLog = new DelegatingChangeLog();
                if (this.assertBuffer != null && !this.getTruthMaintenance()) {
                    this.assertBuffer.setChangeLog(changeLog);
                }
            }
            this.changeLog.addDelegate(changeLog);
        }

        public void addListener(ISPARQLUpdateListener l) {
            if (this.isReadOnly()) {
                throw new UnsupportedOperationException();
            }
            if (l == null) {
                throw new IllegalArgumentException();
            }
            this.listeners.add(l);
        }

        public void removeListener(ISPARQLUpdateListener l) {
            if (this.isReadOnly()) {
                throw new UnsupportedOperationException();
            }
            if (l == null) {
                throw new IllegalArgumentException();
            }
            this.listeners.remove(l);
        }

        public void fireEvent(SPARQLUpdateEvent e) {
            ISPARQLUpdateListener[] a;
            if (this.isReadOnly()) {
                throw new UnsupportedOperationException();
            }
            if (e == null) {
                throw new IllegalArgumentException();
            }
            if (this.listeners.isEmpty()) {
                return;
            }
            ISPARQLUpdateListener[] arr$ = a = this.listeners.toArray(new ISPARQLUpdateListener[0]);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ISPARQLUpdateListener l;
                ISPARQLUpdateListener listener = l = arr$[i$];
                try {
                    listener.updateEvent(e);
                    continue;
                }
                catch (Throwable t) {
                    if (InnerCause.isInnerCause(t, InterruptedException.class)) {
                        throw new RuntimeException(t);
                    }
                    log.error((Object)t, t);
                }
            }
        }

        public void begin() throws SailException {
        }

        public boolean isActive() throws UnknownSailTransactionStateException {
            return true;
        }

        public void prepare() throws SailException {
        }

        public void startUpdate(UpdateContext op) throws SailException {
            throw new SailException(BigdataSail.ERR_OPENRDF_QUERY_MODEL);
        }

        public void addStatement(UpdateContext op, Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
            throw new SailException(BigdataSail.ERR_OPENRDF_QUERY_MODEL);
        }

        public void removeStatement(UpdateContext op, Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
            throw new SailException(BigdataSail.ERR_OPENRDF_QUERY_MODEL);
        }

        public void endUpdate(UpdateContext op) throws SailException {
            throw new SailException(BigdataSail.ERR_OPENRDF_QUERY_MODEL);
        }

        private class NamespaceIterator
        implements CloseableIteration<Namespace, SailException> {
            private final Iterator<Map.Entry<String, String>> src;

            public NamespaceIterator(Iterator<Map.Entry<String, String>> src) {
                assert (src != null);
                this.src = src;
            }

            public boolean hasNext() {
                return this.src.hasNext();
            }

            public Namespace next() {
                Map.Entry<String, String> current = this.src.next();
                return new NamespaceImpl(current.getKey(), current.getValue());
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void close() {
            }
        }
    }

    public static interface Options
    extends AbstractTripleStore.Options {
        public static final String TRUTH_MAINTENANCE = BigdataSail.class.getPackage().getName() + ".truthMaintenance";
        public static final String DEFAULT_TRUTH_MAINTENANCE = "true";
        public static final String BUFFER_CAPACITY = BigdataSail.class.getPackage().getName() + ".bufferCapacity";
        public static final String DEFAULT_BUFFER_CAPACITY = "10000";
        public static final String QUERY_TIME_EXPANDER = BigdataSail.class.getPackage().getName() + ".queryTimeExpander";
        public static final String DEFAULT_QUERY_TIME_EXPANDER = "true";
        public static final String EXACT_SIZE = BigdataSail.class.getPackage().getName() + ".exactSize";
        public static final String DEFAULT_EXACT_SIZE = "false";
        public static final String ALLOW_AUTO_COMMIT = BigdataSail.class.getPackage().getName() + ".allowAutoCommit";
        public static final String DEFAULT_ALLOW_AUTO_COMMIT = "false";
        public static final String ISOLATABLE_INDICES = BigdataSail.class.getPackage().getName() + ".isolatableIndices";
        public static final String DEFAULT_ISOLATABLE_INDICES = "false";
        public static final String NAMESPACE = BigdataSail.class.getPackage().getName() + ".namespace";
        public static final String DEFAULT_NAMESPACE = "kb";
        public static final String DESCRIBE_MODE = BigdataSail.class.getPackage().getName() + ".describeMode";
        public static final String DESCRIBE_ITERATION_LIMIT = BigdataSail.class.getPackage().getName() + ".describeIterationLimit";
        public static final String DESCRIBE_STATEMENT_LIMIT = BigdataSail.class.getPackage().getName() + ".describeIterationStatementLimit";
        public static final String DEFAULT_FILE = "bigdata.jnl";
        public static final String REJECT_QUADS_IN_TRIPLE_MODE = BigdataSail.class.getPackage().getName() + ".rejectQuadsInTripleMode";
        public static final String DEFAULT_REJECT_QUADS_IN_TRIPLE_MODE = "false";
    }
}

