/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.sail.BigdataSailQuery;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.BigdataValueReplacer;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.eval.ASTEvalHelper;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.concurrent.TimeUnit;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.repository.sail.SailGraphQuery;
import org.openrdf.repository.sail.SailRepositoryConnection;

public class BigdataSailGraphQuery
extends SailGraphQuery
implements BigdataSailQuery {
    private final ASTContainer astContainer;

    @Override
    public ASTContainer getASTContainer() {
        return this.astContainer;
    }

    public void setDataset(Dataset dataset) {
        Object[] tmp = new BigdataValueReplacer(this.getTripleStore()).replaceValues(dataset, null);
        this.astContainer.getOriginalAST().setDataset(new DatasetNode((Dataset)tmp[0], false));
    }

    public String toString() {
        return this.astContainer.toString();
    }

    @Override
    public AbstractTripleStore getTripleStore() {
        return ((BigdataSailRepositoryConnection)this.getConnection()).getTripleStore();
    }

    public BigdataSailGraphQuery(ASTContainer astContainer, BigdataSailRepositoryConnection con) {
        super(null, (SailRepositoryConnection)con);
        if (astContainer == null) {
            throw new IllegalArgumentException();
        }
        this.astContainer = astContainer;
    }

    public GraphQueryResult evaluate() throws QueryEvaluationException {
        return this.evaluate(null);
    }

    public GraphQueryResult evaluate(BindingsClause bc) throws QueryEvaluationException {
        QueryRoot originalQuery = this.astContainer.getOriginalAST();
        if (bc != null) {
            originalQuery.setBindingsClause(bc);
        }
        if (this.getMaxQueryTime() > 0) {
            originalQuery.setTimeout(TimeUnit.SECONDS.toMillis(this.getMaxQueryTime()));
        }
        originalQuery.setIncludeInferred(this.getIncludeInferred());
        GraphQueryResult queryResult = ASTEvalHelper.evaluateGraphQuery(this.getTripleStore(), this.astContainer, new QueryBindingSet(this.getBindings()));
        return queryResult;
    }

    public QueryRoot optimize() throws QueryEvaluationException {
        return this.optimize(null);
    }

    public QueryRoot optimize(BindingsClause bc) throws QueryEvaluationException {
        QueryRoot originalQuery = this.astContainer.getOriginalAST();
        if (bc != null) {
            originalQuery.setBindingsClause(bc);
        }
        if (this.getMaxQueryTime() > 0) {
            originalQuery.setTimeout(TimeUnit.SECONDS.toMillis(this.getMaxQueryTime()));
        }
        originalQuery.setIncludeInferred(this.getIncludeInferred());
        QueryRoot optimized = ASTEvalHelper.optimizeQuery(this.getTripleStore(), this.astContainer, new QueryBindingSet(this.getBindings()));
        return optimized;
    }
}

