/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.sparql.ast.Update;
import java.util.concurrent.TimeUnit;

public class SPARQLUpdateEvent {
    private final Update op;
    private final long elapsed;
    private final Throwable cause;

    public SPARQLUpdateEvent(Update op, long elapsed, Throwable cause) {
        if (op == null) {
            throw new IllegalArgumentException();
        }
        this.op = op;
        this.elapsed = elapsed;
        this.cause = cause;
    }

    public Update getUpdate() {
        return this.op;
    }

    public long getElapsedNanos() {
        return this.elapsed;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public static class LoadProgress
    extends SPARQLUpdateEvent {
        private final long nparsed;
        private final boolean done;

        public LoadProgress(Update op, long elapsed, long nparsed, boolean done) {
            super(op, elapsed, null);
            this.nparsed = nparsed;
            this.done = done;
        }

        public long getParsedCount() {
            return this.nparsed;
        }

        public boolean isDone() {
            return this.done;
        }

        public long triplesPerSecond() {
            long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(this.getElapsedNanos());
            if (elapsedMillis == 0L) {
                elapsedMillis = 1L;
            }
            return (long)((double)this.nparsed / (double)elapsedMillis * 1000.0);
        }
    }
}

