/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.bench;

import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.store.LocalTripleStore;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.rio.RDFFormat;

public class BigdataLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("USAGE: namespace propertyFile dataFile");
            System.exit(1);
        }
        try (AbstractJournal jnl = null;){
            String tmp;
            String namespace = args[0];
            File propertyFile = new File(args[1]);
            String dataFile = args[2];
            Properties properties = new Properties();
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(propertyFile));){
                properties.load(is);
            }
            if (System.getProperty(BigdataSail.Options.FILE) != null) {
                properties.setProperty(BigdataSail.Options.FILE, System.getProperty(BigdataSail.Options.FILE));
            }
            if ((tmp = properties.getProperty(BigdataSail.Options.FILE)) == null) {
                throw new RuntimeException("Required property not specified: " + BigdataSail.Options.FILE);
            }
            File journalFile = new File(tmp);
            if (journalFile.exists() && !journalFile.delete()) {
                throw new RuntimeException("could not delete old journal file");
            }
            System.out.println("Journal: " + journalFile);
            jnl = new Journal(properties);
            LocalTripleStore kb = new LocalTripleStore(jnl, namespace, 0L, properties);
            kb.create();
            BigdataSail sail = new BigdataSail(kb);
            BigdataSailRepository repo = new BigdataSailRepository(sail);
            repo.initialize();
            BigdataLoader.loadData(repo, dataFile);
            jnl.truncate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadData(BigdataSailRepository repo, String data) throws Exception {
        try (BigdataSailRepositoryConnection cxn = null;){
            RDFFormat format = null;
            if (data.toLowerCase().endsWith(".ttl")) {
                format = RDFFormat.TURTLE;
            } else if (data.toLowerCase().endsWith(".nt")) {
                format = RDFFormat.NTRIPLES;
            }
            cxn = repo.getConnection();
            cxn.setAutoCommit(false);
            String baseURI = "http://www4.wiwiss.fu-berlin.de/bizer/bsbm/v01";
            long start = System.currentTimeMillis();
            cxn.add(new File(data), baseURI, format, new Resource[0]);
            cxn.commit();
            long duration = System.currentTimeMillis() - start;
            long size = cxn.size(new Resource[0]);
            System.err.println("loaded " + size + " triples in " + duration + " millis.");
            long tps = (long)((double)size / (double)duration * 1000.0);
            System.err.println("tps: " + tps);
        }
    }
}

