/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.bench;

import com.bigdata.journal.Journal;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.striterator.IChunkedOrderedIterator;
import info.aduna.iteration.CloseableIteration;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sail.SailException;

public class Q14Test {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, SailException {
        String namespace = "LUBM_U1000";
        String propertyFile = "/root/workspace/bigdata-journal-HA/bigdata-perf/lubm/ant-build/bin/RWStore.properties";
        String journalFile = "/data/lubm/U1000/bigdata-lubm.RW.jnl";
        Properties properties = new Properties();
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream("/root/workspace/bigdata-journal-HA/bigdata-perf/lubm/ant-build/bin/RWStore.properties"));){
            properties.load(is);
        }
        if (System.getProperty(BigdataSail.Options.FILE) != null) {
            properties.setProperty(BigdataSail.Options.FILE, System.getProperty(BigdataSail.Options.FILE));
        }
        if (properties.getProperty(BigdataSail.Options.FILE) == null) {
            properties.setProperty(BigdataSail.Options.FILE, "/data/lubm/U1000/bigdata-lubm.RW.jnl");
        }
        try (Journal jnl = new Journal(properties);){
            AbstractTripleStore database = (AbstractTripleStore)jnl.getResourceLocator().locate("LUBM_U1000", jnl.getLastCommitTime());
            if (database == null) {
                throw new RuntimeException("Not found: LUBM_U1000");
            }
            BigdataValueFactory f = database.getLexiconRelation().getValueFactory();
            BigdataURI rdfType = f.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
            BigdataURI undergraduateStudent = f.createURI("http://www.lehigh.edu/~zhp2/2004/0401/univ-bench.owl#UndergraduateStudent");
            database.getLexiconRelation().addTerms(new BigdataValue[]{rdfType, undergraduateStudent}, 2, true);
            System.out.println("Running SPO only access path.");
            long begin = System.currentTimeMillis();
            IAccessPath<ISPO> accessPath = database.getAccessPath(null, rdfType, undergraduateStudent);
            try (IChunkedOrderedIterator<ISPO> itr = accessPath.iterator();){
                while (itr.hasNext()) {
                    itr.next();
                }
            }
            long elapsed = System.currentTimeMillis() - begin;
            System.err.println("Materialize SPOs      : elapsed=" + elapsed + "ms");
            BigdataSail sail = new BigdataSail(database);
            sail.initialize();
            try (BigdataSail.BigdataSailConnection conn = sail.getReadOnlyConnection();){
                System.out.println("Materializing statements.");
                long begin2 = System.currentTimeMillis();
                try (CloseableIteration<? extends Statement, SailException> itr = conn.getStatements(null, (URI)rdfType, (Value)undergraduateStudent, true, new Resource[0]);){
                    while (itr.hasNext()) {
                        itr.next();
                    }
                }
                long elapsed2 = System.currentTimeMillis() - begin2;
                System.err.println("Materialize statements: elapsed=" + elapsed2 + "ms");
            }
            sail.shutDown();
        }
    }
}

