/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.bench;

import com.bigdata.journal.Options;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepository;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.sail.SailTupleQuery;

public class RunQuery {
    private static final transient Logger log = Logger.getLogger(RunQuery.class);

    private static void usage() {
        System.err.println("(-namespace namespace|-f file) propertyFile");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            String[] overrides;
            String arg;
            int i;
            String namespace = null;
            String query = null;
            for (i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
                if (arg.equals("-namespace")) {
                    namespace = args[++i];
                    continue;
                }
                if (arg.equals("-f")) {
                    query = RunQuery.readFromFile(new File(args[++i]));
                    continue;
                }
                System.err.println("Unknown argument: " + arg);
                RunQuery.usage();
            }
            File propertyFile = new File(args[i++]);
            Properties properties = new Properties();
            try (FileInputStream is = new FileInputStream(propertyFile);){
                properties.load(is);
            }
            for (String s : overrides = new String[]{Options.FILE}) {
                if (System.getProperty(s) == null) continue;
                String v = System.getProperty(s);
                if (s.equalsIgnoreCase(Options.FILE)) {
                    v = new File(v).getAbsolutePath();
                }
                System.out.println("Using: " + s + "=" + v);
                properties.setProperty(s, v);
            }
            if (namespace != null) {
                properties.setProperty(BigdataSail.Options.NAMESPACE, namespace);
            }
            if (query == null) {
                System.err.println("Reading from stdin:");
                query = RunQuery.readFromStdin();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Query:\n" + query));
            }
            BigdataSail sail = new BigdataSail(properties);
            BigdataSailRepository repository = new BigdataSailRepository(sail);
            repository.initialize();
            try (BigdataSailRepositoryConnection cxn = repository.getReadOnlyConnection();){
                SailTupleQuery tupleQuery = (SailTupleQuery)cxn.prepareTupleQuery(QueryLanguage.SPARQL, query);
                tupleQuery.setIncludeInferred(true);
                long nsolutions = 0L;
                try (TupleQueryResult result = tupleQuery.evaluate();){
                    while (result.hasNext()) {
                        BindingSet bset = (BindingSet)result.next();
                        if (log.isInfoEnabled()) {
                            log.info((Object)bset);
                        }
                        ++nsolutions;
                    }
                }
                System.err.println("Done: #solutions=" + nsolutions);
            }
            finally {
                sail.shutDown();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            RunQuery.usage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFromFile(File file) throws IOException {
        try (LineNumberReader r = new LineNumberReader(new FileReader(file));){
            String s;
            StringBuilder sb = new StringBuilder();
            while ((s = r.readLine()) != null) {
                if (r.getLineNumber() > 1) {
                    sb.append("\n");
                }
                sb.append(s);
            }
            String string = sb.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFromStdin() throws IOException {
        try (LineNumberReader r = new LineNumberReader(new InputStreamReader(System.in));){
            String s;
            StringBuilder sb = new StringBuilder();
            while ((s = r.readLine()) != null) {
                if (r.getLineNumber() > 1) {
                    sb.append("\n");
                }
                sb.append(s);
            }
            String string = sb.toString();
            return string;
        }
    }
}

