/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.remote;

import com.bigdata.rdf.sail.remote.BigdataSailRemoteRepositoryConnection;
import com.bigdata.rdf.sail.webapp.client.HttpClientConfigurator;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryManager;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jetty.client.HttpClient;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;

public class BigdataSailRemoteRepository
implements Repository {
    private volatile boolean open = true;
    private final ExecutorService executor;
    private final HttpClient client;
    private final RemoteRepository nss;

    public RemoteRepository getRemoteRepository() {
        return this.nss;
    }

    public BigdataSailRemoteRepository(String sparqlEndpointURL) {
        this(sparqlEndpointURL, true);
    }

    public BigdataSailRemoteRepository(String sparqlEndpointURL, boolean useLBS) {
        if (sparqlEndpointURL == null) {
            throw new IllegalArgumentException();
        }
        this.executor = Executors.newCachedThreadPool();
        this.client = HttpClientConfigurator.getInstance().newInstance();
        this.nss = new RemoteRepositoryManager(sparqlEndpointURL, useLBS, this.client, this.executor);
    }

    public BigdataSailRemoteRepository(RemoteRepository nss) {
        if (nss == null) {
            throw new IllegalArgumentException();
        }
        this.executor = null;
        this.client = null;
        this.nss = nss;
    }

    public synchronized void shutDown() throws RepositoryException {
        if (this.executor != null) {
            this.executor.shutdownNow();
            assert (this.client != null);
            if (!(this.client instanceof AutoCloseable)) {
                try {
                    this.client.stop();
                }
                catch (Exception e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
            assert (this.nss instanceof AutoCloseable);
            try {
                ((AutoCloseable)((Object)this.nss)).close();
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
            this.open = false;
        }
    }

    public BigdataSailRemoteRepositoryConnection getConnection() throws RepositoryException {
        return new BigdataSailRemoteRepositoryConnection(this);
    }

    public void initialize() throws RepositoryException {
        if (!this.open) {
            throw new RepositoryException("Can not re-initialize");
        }
    }

    public boolean isInitialized() {
        return this.open;
    }

    public boolean isWritable() throws RepositoryException {
        return this.open;
    }

    public void setDataDir(File arg0) {
        throw new UnsupportedOperationException();
    }

    public File getDataDir() {
        throw new UnsupportedOperationException();
    }

    public ValueFactory getValueFactory() {
        throw new UnsupportedOperationException();
    }
}

