/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.remote;

import com.bigdata.rdf.sail.remote.BigdataSailRemoteRepository;
import com.bigdata.rdf.sail.webapp.client.IPreparedBooleanQuery;
import com.bigdata.rdf.sail.webapp.client.IPreparedGraphQuery;
import com.bigdata.rdf.sail.webapp.client.IPreparedSparqlUpdate;
import com.bigdata.rdf.sail.webapp.client.IPreparedTupleQuery;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.Iteration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.Update;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.UnknownTransactionStateException;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

public class BigdataSailRemoteRepositoryConnection
implements RepositoryConnection {
    private static final transient Logger log = Logger.getLogger(BigdataSailRemoteRepositoryConnection.class);
    private final BigdataSailRemoteRepository repo;

    public BigdataSailRemoteRepositoryConnection(BigdataSailRemoteRepository repo) {
        this.repo = repo;
    }

    public long count(Resource s, URI p, Value o, Resource ... c) throws RepositoryException {
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            return remote.rangeCount(s, p, o, c);
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public RepositoryResult<Statement> getStatements(Resource s, URI p, Value o, boolean includeInferred, Resource ... c) throws RepositoryException {
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            final GraphQueryResult src = remote.getStatements(s, p, o, includeInferred, c);
            return new RepositoryResult((CloseableIteration)new CloseableIteration<Statement, RepositoryException>(){

                public boolean hasNext() throws RepositoryException {
                    try {
                        return src.hasNext();
                    }
                    catch (Exception ex) {
                        throw new RepositoryException((Throwable)ex);
                    }
                }

                public Statement next() throws RepositoryException {
                    try {
                        return (Statement)src.next();
                    }
                    catch (Exception ex) {
                        throw new RepositoryException((Throwable)ex);
                    }
                }

                public void remove() throws RepositoryException {
                    try {
                        src.remove();
                    }
                    catch (Exception ex) {
                        throw new RepositoryException((Throwable)ex);
                    }
                }

                public void close() throws RepositoryException {
                    try {
                        src.close();
                    }
                    catch (Exception ex) {
                        throw new RepositoryException((Throwable)ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public boolean hasStatement(Resource s, URI p, Value o, boolean includeInferred, Resource ... c) throws RepositoryException {
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            return remote.hasStatement(s, p, o, includeInferred, c);
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException("unsupported query language: " + ql);
        }
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            final IPreparedBooleanQuery q = remote.prepareBooleanQuery(query);
            return new BooleanQuery(){

                public boolean evaluate() throws QueryEvaluationException {
                    try {
                        return q.evaluate();
                    }
                    catch (Exception ex) {
                        throw new QueryEvaluationException((Throwable)ex);
                    }
                }

                public int getMaxQueryTime() {
                    long millis = q.getMaxQueryMillis();
                    if (millis == -1L) {
                        return -1;
                    }
                    return (int)TimeUnit.MILLISECONDS.toSeconds(millis);
                }

                public void setMaxQueryTime(int seconds) {
                    q.setMaxQueryMillis(TimeUnit.SECONDS.toMillis(seconds));
                }

                public void clearBindings() {
                    throw new UnsupportedOperationException();
                }

                public BindingSet getBindings() {
                    throw new UnsupportedOperationException();
                }

                public Dataset getDataset() {
                    throw new UnsupportedOperationException();
                }

                public boolean getIncludeInferred() {
                    throw new UnsupportedOperationException();
                }

                public void removeBinding(String arg0) {
                    throw new UnsupportedOperationException();
                }

                public void setBinding(String arg0, Value arg1) {
                    throw new UnsupportedOperationException();
                }

                public void setDataset(Dataset arg0) {
                    throw new UnsupportedOperationException();
                }

                public void setIncludeInferred(boolean arg0) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
        if (baseURI != null) {
            throw new UnsupportedOperationException("baseURI not supported");
        }
        return this.prepareBooleanQuery(ql, query);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException("unsupported query language: " + ql);
        }
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            final IPreparedGraphQuery q = remote.prepareGraphQuery(query);
            return new GraphQuery(){

                public GraphQueryResult evaluate() throws QueryEvaluationException {
                    try {
                        return q.evaluate();
                    }
                    catch (Exception ex) {
                        throw new QueryEvaluationException((Throwable)ex);
                    }
                }

                public int getMaxQueryTime() {
                    long millis = q.getMaxQueryMillis();
                    if (millis == -1L) {
                        return -1;
                    }
                    return (int)TimeUnit.MILLISECONDS.toSeconds(millis);
                }

                public void setMaxQueryTime(int seconds) {
                    q.setMaxQueryMillis(TimeUnit.SECONDS.toMillis(seconds));
                }

                public void clearBindings() {
                    throw new UnsupportedOperationException();
                }

                public BindingSet getBindings() {
                    throw new UnsupportedOperationException();
                }

                public Dataset getDataset() {
                    throw new UnsupportedOperationException();
                }

                public boolean getIncludeInferred() {
                    throw new UnsupportedOperationException();
                }

                public void removeBinding(String arg0) {
                    throw new UnsupportedOperationException();
                }

                public void setBinding(String arg0, Value arg1) {
                    throw new UnsupportedOperationException();
                }

                public void setDataset(Dataset arg0) {
                    throw new UnsupportedOperationException();
                }

                public void setIncludeInferred(boolean arg0) {
                    throw new UnsupportedOperationException();
                }

                public void evaluate(RDFHandler arg0) throws QueryEvaluationException, RDFHandlerException {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
        if (baseURI != null) {
            throw new UnsupportedOperationException("baseURI not supported.");
        }
        return this.prepareGraphQuery(ql, query);
    }

    public Query prepareQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        throw new UnsupportedOperationException("please use the specific operation for your query type: prepare[Boolean/Tuple/Graph]Query");
    }

    public Query prepareQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
        if (baseURI != null) {
            throw new UnsupportedOperationException("baseURI not supported");
        }
        return this.prepareQuery(ql, query);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException("unsupported query language: " + ql);
        }
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            final IPreparedTupleQuery q = remote.prepareTupleQuery(query);
            return new TupleQuery(){

                public TupleQueryResult evaluate() throws QueryEvaluationException {
                    try {
                        return q.evaluate();
                    }
                    catch (Exception ex) {
                        throw new QueryEvaluationException((Throwable)ex);
                    }
                }

                public int getMaxQueryTime() {
                    long millis = q.getMaxQueryMillis();
                    if (millis == -1L) {
                        return -1;
                    }
                    return (int)TimeUnit.MILLISECONDS.toSeconds(millis);
                }

                public void setMaxQueryTime(int seconds) {
                    q.setMaxQueryMillis(TimeUnit.SECONDS.toMillis(seconds));
                }

                public void clearBindings() {
                    throw new UnsupportedOperationException();
                }

                public BindingSet getBindings() {
                    throw new UnsupportedOperationException();
                }

                public Dataset getDataset() {
                    throw new UnsupportedOperationException();
                }

                public boolean getIncludeInferred() {
                    throw new UnsupportedOperationException();
                }

                public void removeBinding(String arg0) {
                    throw new UnsupportedOperationException();
                }

                public void setBinding(String arg0, Value arg1) {
                    throw new UnsupportedOperationException();
                }

                public void setDataset(Dataset arg0) {
                    throw new UnsupportedOperationException();
                }

                public void setIncludeInferred(boolean arg0) {
                    throw new UnsupportedOperationException();
                }

                public void evaluate(TupleQueryResultHandler arg0) throws QueryEvaluationException {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
        if (baseURI != null) {
            throw new UnsupportedOperationException("baseURI not supported.");
        }
        return this.prepareTupleQuery(ql, query);
    }

    public boolean hasStatement(Statement s, boolean includeInferred, Resource ... c) throws RepositoryException {
        return this.hasStatement(s.getSubject(), s.getPredicate(), s.getObject(), includeInferred, c);
    }

    public <E extends Exception> void add(Iteration<? extends Statement, E> stmts, Resource ... c) throws RepositoryException, E {
        GraphImpl g = new GraphImpl();
        while (stmts.hasNext()) {
            g.add(stmts.next());
        }
        this.add((Iterable<? extends Statement>)g, c);
    }

    public void add(Resource s, URI p, Value o, Resource ... c) throws RepositoryException {
        this.add((Statement)new StatementImpl(s, p, o), c);
    }

    public void add(Statement stmt, Resource ... c) throws RepositoryException {
        GraphImpl g = new GraphImpl();
        g.add((Object)stmt);
        this.add((Iterable<? extends Statement>)g, c);
    }

    public void add(Iterable<? extends Statement> stmts, Resource ... c) throws RepositoryException {
        RemoteRepository.AddOp op = new RemoteRepository.AddOp(stmts);
        this.add(op, c);
    }

    public void add(Reader input, String baseURI, RDFFormat format, Resource ... c) throws IOException, RDFParseException, RepositoryException {
        RemoteRepository.AddOp op = new RemoteRepository.AddOp(input, format);
        this.add(op, c);
    }

    public void add(URL input, String baseURI, RDFFormat format, Resource ... c) throws IOException, RDFParseException, RepositoryException {
        RemoteRepository.AddOp op = new RemoteRepository.AddOp(input.toString());
        this.add(op, c);
    }

    public void add(File input, String baseURI, RDFFormat format, Resource ... c) throws IOException, RDFParseException, RepositoryException {
        RemoteRepository.AddOp op = new RemoteRepository.AddOp(input, format);
        this.add(op, c);
    }

    public void add(InputStream input, String baseURI, RDFFormat format, Resource ... c) throws IOException, RDFParseException, RepositoryException {
        RemoteRepository.AddOp op = new RemoteRepository.AddOp(input, format);
        this.add(op, c);
    }

    private void add(RemoteRepository.AddOp op, Resource ... c) throws RepositoryException {
        try {
            op.setContext(c);
            RemoteRepository remote = this.repo.getRemoteRepository();
            remote.add(op);
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public <E extends Exception> void remove(Iteration<? extends Statement, E> stmts, Resource ... c) throws RepositoryException, E {
        GraphImpl g = new GraphImpl();
        while (stmts.hasNext()) {
            g.add(stmts.next());
        }
        this.remove((Iterable<? extends Statement>)g, c);
    }

    public void remove(Statement stmt, Resource ... c) throws RepositoryException {
        log.warn((Object)"single statement updates not recommended");
        GraphImpl g = new GraphImpl();
        g.add((Object)stmt);
        this.remove((Iterable<? extends Statement>)g, c);
    }

    public void remove(Iterable<? extends Statement> stmts, Resource ... c) throws RepositoryException {
        RemoteRepository.RemoveOp op = new RemoteRepository.RemoveOp(stmts);
        this.remove(op, c);
    }

    public void remove(Resource s, URI p, Value o, Resource ... c) throws RepositoryException {
        RemoteRepository.RemoveOp op = new RemoteRepository.RemoveOp(s, p, o, c);
        this.remove(op, c);
    }

    private void remove(RemoteRepository.RemoveOp op, Resource ... c) throws RepositoryException {
        try {
            op.setContext(c);
            RemoteRepository remote = this.repo.getRemoteRepository();
            remote.remove(op);
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        if (!autoCommit) {
            throw new IllegalArgumentException("only auto-commit is currently supported");
        }
    }

    public void close() throws RepositoryException {
    }

    public boolean isOpen() throws RepositoryException {
        return true;
    }

    public void commit() throws RepositoryException {
    }

    public void rollback() throws RepositoryException {
    }

    public Repository getRepository() {
        return this.repo;
    }

    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            final Iterator<Resource> contexts = remote.getContexts().iterator();
            return new RepositoryResult((CloseableIteration)new CloseableIteration<Resource, RepositoryException>(){

                public boolean hasNext() throws RepositoryException {
                    return contexts.hasNext();
                }

                public Resource next() throws RepositoryException {
                    return (Resource)contexts.next();
                }

                public void remove() throws RepositoryException {
                    contexts.remove();
                }

                public void close() throws RepositoryException {
                }
            });
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public long size(Resource ... c) throws RepositoryException {
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            return remote.rangeCount(null, null, null, c);
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public void clear(Resource ... c) throws RepositoryException {
        this.remove((Resource)null, (URI)null, (Value)null, c);
    }

    public void export(RDFHandler handler, Resource ... c) throws RepositoryException, RDFHandlerException {
        this.exportStatements(null, null, null, true, handler, c);
    }

    public void exportStatements(Resource s, URI p, Value o, boolean includeInferred, RDFHandler handler, Resource ... c) throws RepositoryException, RDFHandlerException {
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            GraphQueryResult src = remote.getStatements(s, p, o, includeInferred, c);
            handler.startRDF();
            while (src.hasNext()) {
                handler.handleStatement((Statement)src.next());
            }
            handler.endRDF();
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public boolean isAutoCommit() throws RepositoryException {
        return true;
    }

    public boolean isEmpty() throws RepositoryException {
        return this.size(new Resource[0]) > 0L;
    }

    public Update prepareUpdate(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException("unsupported query language: " + ql);
        }
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            final IPreparedSparqlUpdate update = remote.prepareUpdate(query);
            return new Update(){

                public void execute() throws UpdateExecutionException {
                    try {
                        update.evaluate();
                    }
                    catch (Exception ex) {
                        throw new UpdateExecutionException((Throwable)ex);
                    }
                }

                public void clearBindings() {
                    throw new UnsupportedOperationException();
                }

                public BindingSet getBindings() {
                    throw new UnsupportedOperationException();
                }

                public Dataset getDataset() {
                    throw new UnsupportedOperationException();
                }

                public boolean getIncludeInferred() {
                    throw new UnsupportedOperationException();
                }

                public void removeBinding(String arg0) {
                    throw new UnsupportedOperationException();
                }

                public void setBinding(String arg0, Value arg1) {
                    throw new UnsupportedOperationException();
                }

                public void setDataset(Dataset arg0) {
                    throw new UnsupportedOperationException();
                }

                public void setIncludeInferred(boolean arg0) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (Exception ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    public Update prepareUpdate(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
        if (baseURI != null) {
            throw new UnsupportedOperationException("baseURI not supported");
        }
        return this.prepareUpdate(ql, query);
    }

    public void setNamespace(String arg0, String arg1) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public String getNamespace(String arg0) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void removeNamespace(String arg0) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void clearNamespaces() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setParserConfig(ParserConfig arg0) {
        throw new UnsupportedOperationException();
    }

    public ParserConfig getParserConfig() {
        throw new UnsupportedOperationException();
    }

    public ValueFactory getValueFactory() {
        throw new UnsupportedOperationException();
    }

    public void begin() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean isActive() throws UnknownTransactionStateException, RepositoryException {
        throw new UnsupportedOperationException();
    }
}

