/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.bop.BOpUtility;
import com.bigdata.rdf.sail.sparql.BaseDeclProcessor;
import com.bigdata.rdf.sail.sparql.BatchRDFValueResolver;
import com.bigdata.rdf.sail.sparql.BigdataASTContext;
import com.bigdata.rdf.sail.sparql.BigdataExprBuilder;
import com.bigdata.rdf.sail.sparql.BigdataParsedQuery;
import com.bigdata.rdf.sail.sparql.BigdataParsedUpdate;
import com.bigdata.rdf.sail.sparql.BlankNodeVarProcessor;
import com.bigdata.rdf.sail.sparql.DatasetDeclProcessor;
import com.bigdata.rdf.sail.sparql.PrefixDeclProcessor;
import com.bigdata.rdf.sail.sparql.StringEscapesProcessor;
import com.bigdata.rdf.sail.sparql.UpdateExprBuilder;
import com.bigdata.rdf.sail.sparql.ast.ASTPrefixDecl;
import com.bigdata.rdf.sail.sparql.ast.ASTQueryContainer;
import com.bigdata.rdf.sail.sparql.ast.ASTUpdate;
import com.bigdata.rdf.sail.sparql.ast.ASTUpdateContainer;
import com.bigdata.rdf.sail.sparql.ast.ASTUpdateSequence;
import com.bigdata.rdf.sail.sparql.ast.ParseException;
import com.bigdata.rdf.sail.sparql.ast.SyntaxTreeBuilder;
import com.bigdata.rdf.sail.sparql.ast.TokenMgrError;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.IDataSetNode;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.Update;
import com.bigdata.rdf.sparql.ast.UpdateRoot;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.hints.QueryHintScope;
import com.bigdata.rdf.sparql.ast.optimizers.ASTSetValueExpressionsOptimizer;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.ParsedOperation;
import org.openrdf.query.parser.ParsedUpdate;
import org.openrdf.query.parser.QueryParser;
import org.openrdf.query.parser.QueryParserUtil;

public class Bigdata2ASTSPARQLParser
implements QueryParser {
    private static final Logger log = Logger.getLogger(Bigdata2ASTSPARQLParser.class);
    private static final URI queryScope = new URIImpl("http://www.bigdata.com/queryHints#" + (Object)((Object)QueryHintScope.Query));
    private static final URI queryIdHint = new URIImpl("http://www.bigdata.com/queryHints#queryId");
    private final BigdataASTContext context;

    public Bigdata2ASTSPARQLParser(AbstractTripleStore tripleStore) {
        this.context = new BigdataASTContext(tripleStore);
    }

    public ParsedOperation parseOperation(String operation, String baseURI) throws MalformedQueryException {
        String strippedOperation = QueryParserUtil.removeSPARQLQueryProlog((String)operation).toUpperCase();
        BigdataParsedQuery parsedOperation = strippedOperation.startsWith("SELECT") || strippedOperation.startsWith("CONSTRUCT") || strippedOperation.startsWith("DESCRIBE") || strippedOperation.startsWith("ASK") ? this.parseQuery(operation, baseURI) : this.parseUpdate(operation, baseURI);
        return parsedOperation;
    }

    public BigdataParsedQuery parseQuery(String queryStr, String baseURI) throws MalformedQueryException {
        return new BigdataParsedQuery(this.parseQuery2(queryStr, baseURI));
    }

    public ParsedUpdate parseUpdate(String updateStr, String baseURI) throws MalformedQueryException {
        return new BigdataParsedUpdate(this.parseUpdate2(updateStr, baseURI));
    }

    public ASTContainer parseUpdate2(String updateStr, String baseURI) throws MalformedQueryException {
        if (log.isInfoEnabled()) {
            log.info((Object)updateStr);
        }
        try {
            ASTUpdateSequence updateSequence = SyntaxTreeBuilder.parseUpdateSequence(updateStr);
            UpdateRoot updateRoot = new UpdateRoot();
            ASTContainer astContainer = new ASTContainer(updateRoot);
            astContainer.setQueryString(updateStr);
            astContainer.setParseTree(updateSequence);
            UpdateExprBuilder updateExprBuilder = new UpdateExprBuilder(this.context);
            List<ASTUpdateContainer> updateOperations = updateSequence.getUpdateContainers();
            List<ASTPrefixDecl> sharedPrefixDeclarations = null;
            for (int i = 0; i < updateOperations.size(); ++i) {
                ASTUpdateContainer uc = updateOperations.get(i);
                if (uc.jjtGetNumChildren() == 0 && i > 0 && i < updateOperations.size() - 1) {
                    throw new MalformedQueryException("empty update in sequence not allowed");
                }
                StringEscapesProcessor.process(uc);
                BaseDeclProcessor.process(uc, baseURI);
                List<ASTPrefixDecl> prefixDeclList = uc.getPrefixDeclList();
                if (prefixDeclList == null || prefixDeclList.isEmpty()) {
                    if (sharedPrefixDeclarations != null) {
                        for (ASTPrefixDecl prefixDecl : sharedPrefixDeclarations) {
                            uc.jjtAppendChild(prefixDecl);
                        }
                    }
                } else {
                    sharedPrefixDeclarations = prefixDeclList;
                }
                PrefixDeclProcessor.process(uc);
                BlankNodeVarProcessor.process(uc);
                new BatchRDFValueResolver(this.context, true).process(uc);
                DatasetNode dataSetNode = new DatasetDeclProcessor(this.context).process(uc);
                ASTUpdate updateNode = uc.getUpdate();
                if (updateNode == null) continue;
                Update updateOp = (Update)updateNode.jjtAccept(updateExprBuilder, null);
                if (dataSetNode != null) {
                    ((IDataSetNode)((Object)updateOp)).setDataset(dataSetNode);
                }
                updateRoot.addChild(updateOp);
            }
            return astContainer;
        }
        catch (ParseException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
        catch (TokenMgrError e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
    }

    public ASTContainer parseQuery2(String queryStr, String baseURI) throws MalformedQueryException {
        if (log.isInfoEnabled()) {
            log.info((Object)queryStr);
        }
        try {
            ASTQueryContainer qc = SyntaxTreeBuilder.parseQuery(queryStr);
            StringEscapesProcessor.process(qc);
            BaseDeclProcessor.process(qc, baseURI);
            Map<String, String> prefixes = PrefixDeclProcessor.process(qc);
            BlankNodeVarProcessor.process(qc);
            new BatchRDFValueResolver(this.context, true).process(qc);
            QueryRoot queryRoot = this.buildQueryModel(qc, this.context);
            ASTContainer ast = new ASTContainer(queryRoot);
            ast.setQueryString(queryStr);
            ast.setParseTree(qc);
            this.doQueryIdHint(ast, queryRoot);
            queryRoot.setPrefixDecls(prefixes);
            DatasetNode dataSetNode = new DatasetDeclProcessor(this.context).process(qc);
            if (dataSetNode != null) {
                queryRoot.setDataset(dataSetNode);
            }
            ASTSetValueExpressionsOptimizer opt = new ASTSetValueExpressionsOptimizer();
            AST2BOpContext context2 = new AST2BOpContext(ast, this.context.tripleStore);
            QueryRoot queryRoot2 = (QueryRoot)opt.optimize(context2, queryRoot, null);
            BigdataExprBuilder.verifyAggregate(queryRoot2);
            return ast;
        }
        catch (IllegalArgumentException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
        catch (TokenMgrError e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
    }

    private QueryRoot buildQueryModel(ASTQueryContainer qc, BigdataASTContext context) throws MalformedQueryException {
        BigdataExprBuilder exprBuilder = new BigdataExprBuilder(context);
        try {
            return (QueryRoot)qc.jjtAccept(exprBuilder, null);
        }
        catch (VisitorException e) {
            throw new MalformedQueryException(e.getMessage(), (Throwable)e);
        }
    }

    private void doQueryIdHint(ASTContainer ast, QueryRoot queryRoot) throws MalformedQueryException {
        Iterator<StatementPatternNode> itr = BOpUtility.visitAll(queryRoot, StatementPatternNode.class);
        while (itr.hasNext()) {
            StatementPatternNode sp = itr.next();
            if (!queryIdHint.equals((Object)sp.p().getValue())) continue;
            if (!queryScope.equals((Object)sp.s().getValue())) {
                throw new MalformedQueryException("queryId must be in scope " + (Object)((Object)QueryHintScope.Query));
            }
            String queryIdStr = sp.o().getValue().stringValue();
            try {
                UUID.fromString(queryIdStr);
            }
            catch (IllegalArgumentException ex) {
                throw new MalformedQueryException("Not a valid UUID: " + queryIdStr);
            }
            ast.setQueryHint("queryId", queryIdStr);
            return;
        }
    }
}

