/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.internal.ILexiconConfiguration;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openrdf.model.Value;

public class BigdataASTContext {
    protected final AbstractTripleStore tripleStore;
    protected final LexiconRelation lexicon;
    protected final String lex;
    protected final ILexiconConfiguration<BigdataValue> conf;
    protected final BigdataValueFactory valueFactory;
    protected final Map<Value, BigdataValue> vocab;
    private int constantVarID = 1;

    public BigdataASTContext(AbstractTripleStore tripleStore) {
        this.tripleStore = tripleStore;
        this.valueFactory = tripleStore.getValueFactory();
        this.lexicon = tripleStore.getLexiconRelation();
        this.lex = this.lexicon.getNamespace();
        this.conf = this.lexicon.getLexiconConfiguration();
        this.vocab = new LinkedHashMap<Value, BigdataValue>();
    }

    protected VarNode createAnonVar(String varName) {
        VarNode var = new VarNode(varName + this.constantVarID++);
        var.setAnonymous(true);
        return var;
    }

    protected ConstantNode createConstVar(Value value) throws VisitorException {
        BigdataValue v = this.vocab.get(value);
        if (v == null) {
            throw new VisitorException("Undefined vocabulary: " + value);
        }
        return new ConstantNode(v.getIV());
    }

    protected VarNode createSidVar() {
        VarNode var = new VarNode("-sid-" + this.constantVarID++);
        return var;
    }
}

