/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sail.sparql.ASTVisitorBase;
import com.bigdata.rdf.sail.sparql.BigdataASTContext;
import com.bigdata.rdf.sail.sparql.GroupGraphPattern;
import com.bigdata.rdf.sail.sparql.ast.ASTBlankNode;
import com.bigdata.rdf.sail.sparql.ast.ASTFalse;
import com.bigdata.rdf.sail.sparql.ast.ASTGraphGraphPattern;
import com.bigdata.rdf.sail.sparql.ast.ASTIRI;
import com.bigdata.rdf.sail.sparql.ast.ASTNumericLiteral;
import com.bigdata.rdf.sail.sparql.ast.ASTQName;
import com.bigdata.rdf.sail.sparql.ast.ASTRDFLiteral;
import com.bigdata.rdf.sail.sparql.ast.ASTString;
import com.bigdata.rdf.sail.sparql.ast.ASTTrue;
import com.bigdata.rdf.sail.sparql.ast.ASTVar;
import com.bigdata.rdf.sail.sparql.ast.Node;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import org.openrdf.query.algebra.StatementPattern;

public abstract class BigdataASTVisitorBase
extends ASTVisitorBase {
    protected final BigdataASTContext context;
    private static final transient String ws = "                                                                                                                                                                                                                  ";

    protected BigdataASTVisitorBase(BigdataASTContext context) {
        this.context = context;
    }

    protected final int depth(Node node) {
        int i = 0;
        while ((node = node.jjtGetParent()) != null) {
            ++i;
        }
        return i;
    }

    protected final String indent(Node node) {
        return BigdataASTVisitorBase.indent(this.depth(node));
    }

    protected static String indent(int depth) {
        if (depth < 0) {
            return "";
        }
        return ws.substring(0, depth * 2);
    }

    private IV<BigdataValue, ?> makeIV(BigdataValue value) throws VisitorException {
        if (value == null) {
            throw new VisitorException("Value property not set?");
        }
        IV iv = value.getIV();
        if (iv == null) {
            throw new VisitorException("IV not resolved : " + value);
        }
        return iv;
    }

    @Override
    public final VarNode visit(ASTVar node, Object data) throws VisitorException {
        VarNode var = new VarNode(node.getName());
        if (node.isAnonymous()) {
            var.setAnonymous(true);
        }
        return var;
    }

    @Override
    public final Object visit(ASTQName node, Object data) throws VisitorException {
        throw new VisitorException("QNames must be resolved before building the query model");
    }

    @Override
    public final Object visit(ASTBlankNode node, Object data) throws VisitorException {
        throw new VisitorException("Blank nodes must be replaced with variables before building the query model");
    }

    @Override
    public final ConstantNode visit(ASTIRI node, Object data) throws VisitorException {
        return new ConstantNode(this.makeIV((BigdataValue)node.getRDFValue()));
    }

    @Override
    public final ConstantNode visit(ASTRDFLiteral node, Object data) throws VisitorException {
        return new ConstantNode(this.makeIV((BigdataValue)node.getRDFValue()));
    }

    @Override
    public final ConstantNode visit(ASTNumericLiteral node, Object data) throws VisitorException {
        return new ConstantNode(this.makeIV((BigdataValue)node.getRDFValue()));
    }

    @Override
    public final ConstantNode visit(ASTTrue node, Object data) throws VisitorException {
        return new ConstantNode(this.makeIV((BigdataValue)node.getRDFValue()));
    }

    @Override
    public final ConstantNode visit(ASTFalse node, Object data) throws VisitorException {
        return new ConstantNode(this.makeIV((BigdataValue)node.getRDFValue()));
    }

    @Override
    public final String visit(ASTString node, Object data) throws VisitorException {
        return node.getValue();
    }

    protected GroupGraphPattern scopedGroupGraphPattern(Node n) throws VisitorException {
        TermNode s;
        Node child;
        ASTGraphGraphPattern scopePattern = this.firstASTGraphGraphAncestor(n);
        if (scopePattern != null && (child = scopePattern.jjtGetChild(0)) != null && (s = (TermNode)scopePattern.jjtGetChild(0).jjtAccept(this, null)) != null) {
            return new GroupGraphPattern(s, StatementPattern.Scope.NAMED_CONTEXTS);
        }
        return new GroupGraphPattern();
    }

    protected ASTGraphGraphPattern firstASTGraphGraphAncestor(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ASTGraphGraphPattern) {
            return (ASTGraphGraphPattern)node;
        }
        return this.firstASTGraphGraphAncestor(node.jjtGetParent());
    }
}

