/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.BigdataStatics;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.webapp.NanoSparqlServer;
import com.bigdata.rdf.sail.webapp.client.HttpClientConfigurator;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryManager;
import com.bigdata.util.StackInfoReport;
import com.bigdata.util.config.NicUtil;
import java.net.URL;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.server.Server;

public class BigdataSailNSSWrapper {
    private static final transient Logger log = Logger.getLogger(BigdataSailNSSWrapper.class);
    private final BigdataSail sail;
    protected Server m_fixture;
    protected HttpClient m_httpClient = null;
    public RemoteRepositoryManager m_repo;
    protected String m_serviceURL;
    protected String m_rootURL;

    public BigdataSailNSSWrapper(BigdataSail sail) {
        this.sail = sail;
    }

    public void init() throws Exception {
        LinkedHashMap<String, String> initParams = new LinkedHashMap<String, String>();
        initParams.put("namespace", this.getSail().getDatabase().getNamespace());
        initParams.put("create", "false");
        this.m_fixture = NanoSparqlServer.newInstance(0, this.getSail().getDatabase().getIndexManager(), initParams);
        this.m_fixture.start();
        int port = NanoSparqlServer.getLocalPort(this.m_fixture);
        String hostAddr = NicUtil.getIpAddress("default.nic", "default", true);
        if (hostAddr == null) {
            throw new RuntimeException("Could not identify network address for this host.");
        }
        this.m_rootURL = new URL("http", hostAddr, port, "").toExternalForm();
        this.m_serviceURL = new URL("http", hostAddr, port, BigdataStatics.getContextPath()).toExternalForm();
        if (log.isInfoEnabled()) {
            log.info((Object)("Setup done: \nrootURL=" + this.m_rootURL + "\nserviceURL=" + this.m_serviceURL));
        }
        this.m_httpClient = HttpClientConfigurator.getInstance().newInstance();
        this.m_repo = new RemoteRepositoryManager(this.m_serviceURL, this.m_httpClient, this.getSail().getDatabase().getIndexManager().getExecutorService());
    }

    public void shutdown() throws Exception {
        if (this.m_fixture != null) {
            this.m_fixture.stop();
            this.m_fixture = null;
        }
        this.m_rootURL = null;
        this.m_serviceURL = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping", (Throwable)new StackInfoReport("Stopping HTTPClient"));
        }
        this.m_httpClient.stop();
        this.m_httpClient = null;
        this.m_repo.close();
        this.m_repo = null;
        if (log.isInfoEnabled()) {
            log.info((Object)"tear down done");
        }
    }

    public BigdataSail getSail() {
        return this.sail;
    }
}

