/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.counters.format.CounterSetFormat;
import com.bigdata.rdf.properties.PropertiesFormat;
import com.bigdata.rdf.sail.webapp.ConnegScore;
import com.bigdata.rdf.sail.webapp.client.MiniMime;
import info.aduna.lang.FileFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.rio.RDFFormat;

public class ConnegUtil {
    private static final transient Logger log = Logger.getLogger(ConnegUtil.class);
    private static final Pattern pattern = Pattern.compile("\\s*,\\s*");
    private final ConnegScore<?>[] scores;

    public static String getMimeTypeForQueryParameter(String outputFormat, String acceptHeader) {
        String acceptHeaderValue = null;
        if (outputFormat != null) {
            switch (outputFormat.toLowerCase()) {
                case "json": {
                    acceptHeaderValue = "application/sparql-results+json";
                    break;
                }
                case "xml": {
                    acceptHeaderValue = "application/sparql-results+xml";
                    break;
                }
                case "sparql-results+json": {
                    acceptHeaderValue = "application/sparql-results+json";
                    break;
                }
                case "sparql-results+xml": {
                    acceptHeaderValue = "application/sparql-results+xml";
                    break;
                }
                default: {
                    acceptHeaderValue = "application/sparql-results+xml";
                    log.warn((Object)("Unknown value for QUERY PARAMETER: format passed " + outputFormat + ".  Defaulting to XML."));
                    break;
                }
            }
        } else {
            acceptHeaderValue = acceptHeader;
        }
        return acceptHeaderValue;
    }

    public ConnegUtil(String acceptStr) {
        if (acceptStr == null) {
            acceptStr = "";
        }
        String[] a = pattern.split(acceptStr);
        LinkedList<ConnegScore<Object>> scores = new LinkedList<ConnegScore<Object>>();
        for (String s : a) {
            FileFormat format;
            BooleanQueryResultFormat booleanFormat;
            TupleQueryResultFormat tupleFormat;
            MiniMime t = new MiniMime(s);
            RDFFormat rdfFormat = RDFFormat.forMIMEType((String)t.getMimeType());
            if (rdfFormat != null) {
                scores.add(new ConnegScore<RDFFormat>(t.q, rdfFormat));
            }
            if ((tupleFormat = TupleQueryResultFormat.forMIMEType((String)t.getMimeType())) != null) {
                scores.add(new ConnegScore<TupleQueryResultFormat>(t.q, tupleFormat));
            }
            if ((booleanFormat = BooleanQueryResultFormat.forMIMEType((String)t.getMimeType())) != null) {
                scores.add(new ConnegScore<BooleanQueryResultFormat>(t.q, booleanFormat));
            }
            if ((format = PropertiesFormat.forMIMEType(t.getMimeType())) != null) {
                scores.add(new ConnegScore<PropertiesFormat>(t.q, (PropertiesFormat)format));
            }
            if ((format = CounterSetFormat.forMIMEType(t.getMimeType())) == null) continue;
            scores.add(new ConnegScore<PropertiesFormat>(t.q, (PropertiesFormat)format));
        }
        this.scores = scores.toArray(new ConnegScore[scores.size()]);
        Arrays.sort(this.scores);
    }

    public RDFFormat getRDFFormat() {
        return this.getRDFFormat(null);
    }

    public RDFFormat getRDFFormat(RDFFormat fallback) {
        for (ConnegScore<?> s : this.scores) {
            if (!(s.format instanceof RDFFormat)) continue;
            return (RDFFormat)s.format;
        }
        return fallback;
    }

    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return this.getTupleQueryResultFormat(null);
    }

    public TupleQueryResultFormat getTupleQueryResultFormat(TupleQueryResultFormat fallback) {
        for (ConnegScore<?> s : this.scores) {
            if (!(s.format instanceof TupleQueryResultFormat)) continue;
            return (TupleQueryResultFormat)s.format;
        }
        return fallback;
    }

    public BooleanQueryResultFormat getBooleanQueryResultFormat() {
        return this.getBooleanQueryResultFormat(null);
    }

    public BooleanQueryResultFormat getBooleanQueryResultFormat(BooleanQueryResultFormat fallback) {
        for (ConnegScore<?> s : this.scores) {
            if (!(s.format instanceof BooleanQueryResultFormat)) continue;
            return (BooleanQueryResultFormat)s.format;
        }
        return fallback;
    }

    public PropertiesFormat getPropertiesFormat() {
        return this.getPropertiesFormat(null);
    }

    public PropertiesFormat getPropertiesFormat(PropertiesFormat fallback) {
        for (ConnegScore<?> s : this.scores) {
            if (!(s.format instanceof PropertiesFormat)) continue;
            return (PropertiesFormat)s.format;
        }
        return fallback;
    }

    public CounterSetFormat getCounterSetFormat() {
        return this.getCounterSetFormat(null);
    }

    public CounterSetFormat getCounterSetFormat(CounterSetFormat fallback) {
        for (ConnegScore<?> s : this.scores) {
            if (!(s.format instanceof CounterSetFormat)) continue;
            return (CounterSetFormat)s.format;
        }
        return fallback;
    }

    public <E> ConnegScore<E>[] getScores(Class<E> cls) {
        if (cls == null) {
            throw new IllegalArgumentException();
        }
        LinkedList t = new LinkedList();
        for (ConnegScore<?> s : this.scores) {
            if (cls != s.format.getClass()) continue;
            t.add(s);
        }
        return t.toArray(new ConnegScore[t.size()]);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + Arrays.toString(this.scores) + "}";
    }
}

