/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.Banner;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.sail.webapp.ConfigParams;
import com.bigdata.util.config.NicUtil;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class NanoSparqlServer {
    private static final Logger log = Logger.getLogger(NanoSparqlServer.class);

    public static void main(String[] args) throws Exception {
        String s;
        String arg;
        int i;
        Banner.banner();
        int port = 80;
        String namespace = "kb";
        int queryThreadPoolSize = 16;
        boolean forceOverflow = false;
        Long readLock = null;
        String servletContextListenerClass = ConfigParams.DEFAULT_SERVLET_CONTEXT_LISTENER_CLASS;
        String jettyXml = System.getProperty("jettyXml", "bigdata-war/src/jetty.xml");
        for (i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if (arg.equals("-forceOverflow")) {
                forceOverflow = true;
                continue;
            }
            if (arg.equals("-nthreads")) {
                if ((queryThreadPoolSize = Integer.valueOf(s = args[++i]).intValue()) >= 0) continue;
                NanoSparqlServer.usage(1, "-nthreads must be non-negative, not: " + s);
                continue;
            }
            if (arg.equals("-readLock")) {
                if ((readLock = Long.valueOf(s = args[++i])) == -1L || TimestampUtility.isCommitTime(readLock)) continue;
                NanoSparqlServer.usage(1, "Read lock must be commit time or -1 (MINUS ONE) to assert a read lock on the last commit time: " + readLock);
                continue;
            }
            if (arg.equals("-servletContextListenerClass")) {
                servletContextListenerClass = args[++i];
                continue;
            }
            if (arg.equals("-jettyXml")) {
                jettyXml = args[++i];
                continue;
            }
            NanoSparqlServer.usage(1, "Unknown argument: " + arg);
        }
        int nremaining = args.length - i;
        if (nremaining != 3) {
            NanoSparqlServer.usage(1, nremaining < 3 ? "Too few arguments." : "Too many arguments");
        }
        s = args[i++];
        try {
            port = Integer.valueOf(s);
        }
        catch (NumberFormatException ex) {
            NanoSparqlServer.usage(1, "Could not parse as port# : '" + s + "'");
        }
        namespace = args[i++];
        String propertyFile = args[i++];
        LinkedHashMap<String, String> initParams = new LinkedHashMap<String, String>();
        initParams.put("propertyFile", propertyFile);
        initParams.put("namespace", namespace);
        initParams.put("queryThreadPoolSize", Integer.toString(queryThreadPoolSize));
        initParams.put("forceOverflow", Boolean.toString(forceOverflow));
        if (readLock != null) {
            initParams.put("readLock", Long.toString(readLock));
        }
        initParams.put("servletContextListenerClass", servletContextListenerClass);
        Server server = NanoSparqlServer.newInstance(port, jettyXml, null, initParams);
        NanoSparqlServer.awaitServerStart(server);
        server.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void awaitServerStart(Server server) throws InterruptedException, TimeoutException, Exception {
        long nanos;
        long timeout = Long.parseLong(System.getProperty("jetty.start.timeout", "10"));
        boolean ok = false;
        long begin = System.nanoTime();
        long remaining = nanos = TimeUnit.SECONDS.toNanos(timeout);
        try {
            log.warn((Object)"Starting NSS");
            server.start();
            remaining = nanos - (System.nanoTime() - begin);
            while (server.isStarting() && !server.isRunning() && remaining > 0L) {
                Thread.sleep(100L);
                remaining = nanos - (System.nanoTime() - begin);
            }
            if (remaining < 0L) {
                throw new TimeoutException();
            }
            ok = true;
        }
        finally {
            if (!ok) {
                String msg = "Server did not start.";
                System.err.println("Server did not start.");
                log.fatal((Object)"Server did not start.");
                if (server != null) {
                    if (Boolean.getBoolean("jetty.dump.start")) {
                        log.warn((Object)server.dump());
                    }
                    server.stop();
                    server.destroy();
                }
            }
        }
        if (Boolean.getBoolean("jetty.dump.start")) {
            log.warn((Object)server.dump());
        }
        int actualPort = NanoSparqlServer.getLocalPort(server);
        String hostAddr = NicUtil.getIpAddress("default.nic", "default", true);
        if (hostAddr == null) {
            hostAddr = "localhost";
        }
        String serviceURL = new URL("http", hostAddr, actualPort, "").toExternalForm();
        String msg = "serviceURL: " + serviceURL;
        System.out.println(msg);
        if (log.isInfoEnabled()) {
            log.warn((Object)msg);
        }
    }

    public static Server newInstance(int port, IIndexManager indexManager, Map<String, String> initParams) throws Exception {
        String jettyXml = System.getProperty("jettyXml", "jetty.xml");
        return NanoSparqlServer.newInstance(port, jettyXml, indexManager, initParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Server newInstance(int port, String jettyXml, IIndexManager indexManager, Map<String, String> initParams) throws Exception {
        if (jettyXml == null) {
            throw new IllegalArgumentException();
        }
        String oldport = System.setProperty("jetty.port", Integer.toString(port));
        try {
            Server server = NanoSparqlServer.newInstance(jettyXml, indexManager, initParams);
            return server;
        }
        finally {
            if (oldport != null) {
                System.setProperty("jetty.port", oldport);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Server newInstance(String jettyXml, IIndexManager indexManager, Map<String, String> initParams) throws Exception {
        XmlConfiguration configuration;
        if (jettyXml == null) {
            throw new IllegalArgumentException();
        }
        ClassLoader classLoader = NanoSparqlServer.class.getClassLoader();
        URL jettyXmlURL = NanoSparqlServer.getEffectiveJettyXmlURL(classLoader, jettyXml);
        Resource jettyConfig = Resource.newResource((URL)jettyXmlURL);
        try (InputStream is = null;){
            is = jettyConfig.getInputStream();
            configuration = new XmlConfiguration(is);
        }
        NanoSparqlServer.configureEffectiveResourceBase(classLoader);
        Server server = (Server)configuration.configure();
        NanoSparqlServer.configureWebAppOverrides(server, indexManager, initParams);
        return server;
    }

    private static URL getEffectiveJettyXmlURL(ClassLoader classLoader, String jettyXml) throws MalformedURLException {
        URL jettyXmlUrl;
        boolean isFile = false;
        boolean isClassPath = false;
        if (new File(jettyXml).exists()) {
            jettyXmlUrl = new URL("file:" + jettyXml);
            isFile = true;
        } else {
            jettyXmlUrl = classLoader.getResource(jettyXml);
            isClassPath = true;
        }
        if (jettyXmlUrl == null) {
            throw new RuntimeException("Not found: " + jettyXml);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("jetty configuration: jettyXml=" + jettyXml + ", isFile=" + isFile + ", isClassPath=" + isClassPath + ", jettyXmlUrl=" + jettyXmlUrl));
        }
        return jettyXmlUrl;
    }

    private static void configureEffectiveResourceBase(ClassLoader classLoader) throws MalformedURLException {
        String resourceBaseStr = System.getProperty("jetty.resourceBase");
        boolean isDeclared = resourceBaseStr != null && resourceBaseStr.trim().length() > 0;
        boolean isFile = false;
        boolean isClassPath = false;
        if (!isDeclared) {
            Object tmp;
            URL resourceBaseURL;
            File file = new File("bigdata-war/src");
            if (file.exists()) {
                resourceBaseURL = file.toURI().toURL();
                isFile = true;
            } else {
                tmp = null;
                String src = null;
                if (tmp == null) {
                    src = "/WEB-INF/web.xml";
                    tmp = classLoader.getResource("/WEB-INF/web.xml");
                }
                if (tmp == null) {
                    src = "bigdata-war/src/WEB-INF/web.xml";
                    tmp = ClassLoader.getSystemClassLoader().getResource("bigdata-war/src/WEB-INF/web.xml");
                }
                if (tmp != null) {
                    if (src != null && log.isInfoEnabled()) {
                        log.info((Object)("Found: src=" + src + ", url=" + tmp));
                    }
                    String s = ((URL)tmp).toExternalForm();
                    int endIndex = s.lastIndexOf("WEB-INF/web.xml");
                    String t = s.substring(0, endIndex);
                    resourceBaseURL = new URL(t);
                } else {
                    resourceBaseURL = null;
                }
                boolean bl = isClassPath = resourceBaseURL != null;
            }
            if (resourceBaseURL != null) {
                tmp = resourceBaseURL.toExternalForm();
                System.setProperty("jetty.resourceBase", (String)tmp);
                URL overrideWebXmlURL = new URL((String)tmp + (((String)tmp).endsWith("/") ? "" : "/") + "WEB-INF/override-web.xml");
                System.setProperty("jetty.overrideWebXml", overrideWebXmlURL.toExternalForm());
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("jetty configuration: resourceBaseStr=" + resourceBaseStr + ", isDeclared=" + isDeclared + ", isFile=" + isFile + ", isClassPath=" + isClassPath + ", jetty.resourceBase(effective)=" + System.getProperty("jetty.resourceBase") + ", jetty.overrideWebXml(effective)=" + System.getProperty("jetty.overrideWebXml")));
        }
    }

    private static void configureWebAppOverrides(Server server, IIndexManager indexManager, Map<String, String> initParams) {
        WebAppContext wac = NanoSparqlServer.getWebApp(server);
        if (wac == null) {
            throw new RuntimeException("Could not locate " + WebAppContext.class.getName());
        }
        if (indexManager != null) {
            wac.setAttribute(IIndexManager.class.getName(), (Object)indexManager);
        }
        if (initParams != null) {
            wac.setAttribute("INIT_PARAMS_OVERRIDES", initParams);
        }
    }

    public static WebAppContext getWebApp(Server server) {
        WebAppContext wac = (WebAppContext)server.getChildHandlerByClass(WebAppContext.class);
        return wac;
    }

    public static int getLocalPort(Server server) {
        if (server == null) {
            throw new IllegalArgumentException();
        }
        Connector[] a = server.getConnectors();
        if (a.length == 0) {
            throw new IllegalStateException("No connectors?");
        }
        return ((ServerConnector)a[0]).getLocalPort();
    }

    protected static void usage(int status, String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println("[options] port namespace (propertyFile|configFile)");
        System.exit(status);
    }

    public static interface SystemProperties {
        public static final String JETTY_PORT = "jetty.port";
        public static final String JETTY_XML = "jettyXml";
        public static final String DEFAULT_JETTY_XML = "jetty.xml";
        public static final String JETTY_STARTUP_TIMEOUT = "jetty.start.timeout";
        public static final String DEFAULT_JETTY_STARTUP_TIMEOUT = "10";
        public static final String JETTY_DUMP_START = "jetty.dump.start";
        public static final String JETTY_RESOURCE_BASE = "jetty.resourceBase";
        public static final String JETTY_OVERRIDE_WEB_XML = "jetty.overrideWebXml";
        public static final String BIGDATA_PROPERTY_FILE = "bigdata.propertyFile";
    }
}

