/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.webapp.AbstractRestApiTask;
import com.bigdata.rdf.sail.webapp.BigdataRDFContext;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.BigdataServlet;
import com.bigdata.rdf.sail.webapp.DeleteServlet;
import com.bigdata.rdf.sail.webapp.InsertServlet;
import com.bigdata.rdf.sail.webapp.client.MiniMime;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.helpers.RDFHandlerBase;

public class UpdateServlet
extends BigdataRDFServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(UpdateServlet.class);

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!UpdateServlet.isWritable(this.getServletContext(), req, resp)) {
            return;
        }
        String queryStr = req.getParameter("query");
        String contentType = req.getContentType();
        if (contentType == null) {
            resp.setStatus(400);
        }
        if (queryStr == null) {
            resp.setStatus(400);
        }
        this.doUpdateWithQuery(req, resp);
    }

    private void doUpdateWithQuery(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Object[] defaultContextDelete;
        Object[] defaultContextInsert;
        RDFFormat requestBodyFormat;
        String baseURI = req.getRequestURL().toString();
        String namespace = this.getNamespace(req);
        String queryStr = req.getParameter("query");
        if (queryStr == null) {
            throw new UnsupportedOperationException();
        }
        String contentType = req.getContentType();
        if (log.isInfoEnabled()) {
            log.info((Object)("Request body: " + contentType));
        }
        if ((requestBodyFormat = RDFFormat.forMIMEType((String)new MiniMime(contentType).getMimeType())) == null) {
            UpdateServlet.buildAndCommitResponse(resp, 400, "text/plain", "Content-Type not recognized as RDF: " + contentType);
            return;
        }
        RDFParserFactory rdfParserFactory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)requestBodyFormat);
        if (rdfParserFactory == null) {
            UpdateServlet.buildAndCommitResponse(resp, 500, "text/plain", "Parser factory not found: Content-Type=" + contentType + ", format=" + requestBodyFormat);
            return;
        }
        String[] s = req.getParameterValues("context-uri-insert");
        if (s != null && s.length > 0) {
            try {
                defaultContextInsert = UpdateServlet.toURIs(s);
            }
            catch (IllegalArgumentException ex) {
                UpdateServlet.buildAndCommitResponse(resp, 500, "text/plain", ex.getLocalizedMessage());
                return;
            }
        } else {
            defaultContextInsert = null;
        }
        String[] s2 = req.getParameterValues("context-uri-delete");
        if (s2 != null && s2.length > 0) {
            try {
                defaultContextDelete = UpdateServlet.toURIs(s2);
            }
            catch (IllegalArgumentException ex) {
                UpdateServlet.buildAndCommitResponse(resp, 500, "text/plain", ex.getLocalizedMessage());
                return;
            }
        } else {
            defaultContextDelete = null;
        }
        try {
            if (this.getIndexManager().isGroupCommit()) {
                this.submitApiTask(new UpdateWithQueryMaterializedTask(req, resp, namespace, 0L, queryStr, baseURI, rdfParserFactory, (Resource[])defaultContextDelete, (Resource[])defaultContextInsert)).get();
            } else {
                this.submitApiTask(new UpdateWithQueryStreamingTask(req, resp, namespace, 0L, queryStr, baseURI, rdfParserFactory, (Resource[])defaultContextDelete, (Resource[])defaultContextInsert)).get();
            }
        }
        catch (Throwable t) {
            UpdateServlet.launderThrowable(t, resp, "UPDATE-WITH-QUERY: queryStr=" + queryStr + ", baseURI=" + baseURI + (defaultContextInsert == null ? "" : ",context-uri-insert=" + Arrays.toString(defaultContextInsert)) + (defaultContextDelete == null ? "" : ",context-uri-delete=" + Arrays.toString(defaultContextDelete)));
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!UpdateServlet.isWritable(this.getServletContext(), req, resp)) {
            return;
        }
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            this.doUpdateWithBody(req, resp);
        } else {
            resp.setStatus(400);
        }
    }

    private void doUpdateWithBody(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Object[] defaultContextDelete;
        Object[] defaultContextInsert;
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        FileItem add = null;
        FileItem remove = null;
        try {
            List items = upload.parseRequest(req);
            for (FileItem item : items) {
                if (!(item.getFieldName().equals("add") ? !this.validateItem(resp, add = item) : item.getFieldName().equals("remove") && !this.validateItem(resp, remove = item))) continue;
                return;
            }
        }
        catch (FileUploadException ex) {
            throw new IOException(ex);
        }
        String baseURI = req.getRequestURL().toString();
        String[] s = req.getParameterValues("context-uri-insert");
        if (s != null && s.length > 0) {
            try {
                defaultContextInsert = UpdateServlet.toURIs(s);
            }
            catch (IllegalArgumentException ex) {
                UpdateServlet.buildAndCommitResponse(resp, 500, "text/plain", ex.getLocalizedMessage());
                return;
            }
        } else {
            defaultContextInsert = null;
        }
        String[] s2 = req.getParameterValues("context-uri-delete");
        if (s2 != null && s2.length > 0) {
            try {
                defaultContextDelete = UpdateServlet.toURIs(s2);
            }
            catch (IllegalArgumentException ex) {
                UpdateServlet.buildAndCommitResponse(resp, 500, "text/plain", ex.getLocalizedMessage());
                return;
            }
        } else {
            defaultContextDelete = null;
        }
        String namespace = this.getNamespace(req);
        try {
            this.submitApiTask(new UpdateWithBodyTask(req, resp, namespace, 0L, baseURI, remove, (Resource[])defaultContextDelete, add, (Resource[])defaultContextInsert)).get();
        }
        catch (Throwable t) {
            UpdateServlet.launderThrowable(t, resp, "UPDATE-WITH-BODY: baseURI=" + baseURI + (add == null ? null : ", add=" + add + (defaultContextInsert == null ? "" : ",context-uri-insert=" + Arrays.toString(defaultContextInsert))) + (remove == null ? null : ", remove=" + remove + (defaultContextDelete == null ? "" : ",context-uri-delete=" + Arrays.toString(defaultContextDelete))));
        }
    }

    private boolean validateItem(HttpServletResponse resp, FileItem item) throws IOException {
        String contentType = item.getContentType();
        if (contentType == null) {
            UpdateServlet.buildAndCommitResponse(resp, 400, "text/plain", "Content-Type not specified");
            return false;
        }
        RDFFormat format = RDFFormat.forMIMEType((String)new MiniMime(contentType).getMimeType());
        if (format == null) {
            UpdateServlet.buildAndCommitResponse(resp, 400, "text/plain", "Content-Type not recognized as RDF: " + contentType);
            return false;
        }
        RDFParserFactory rdfParserFactory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format);
        if (rdfParserFactory == null) {
            UpdateServlet.buildAndCommitResponse(resp, 500, "text/plain", "Parser factory not found: Content-Type=" + contentType + ", format=" + format);
            return false;
        }
        if (item.getInputStream() == null) {
            UpdateServlet.buildAndCommitResponse(resp, 400, "text/plain", "No content");
            return false;
        }
        return true;
    }

    private static class UpdateWithBodyTask
    extends AbstractRestApiTask<Void> {
        private final String baseURI;
        private final FileItem remove;
        private final FileItem add;
        private final Resource[] defaultContextDelete;
        private final Resource[] defaultContextInsert;

        public UpdateWithBodyTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, String baseURI, FileItem remove, Resource[] defaultContextDelete, FileItem add, Resource[] defaultContextInsert) {
            super(req, resp, namespace, timestamp);
            this.baseURI = baseURI;
            this.remove = remove;
            this.defaultContextDelete = defaultContextDelete;
            this.add = add;
            this.defaultContextInsert = defaultContextInsert;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            AtomicLong nmodified = new AtomicLong(0L);
            BigdataSailRepositoryConnection conn = null;
            boolean success = false;
            try {
                RDFHandlerBase handler;
                InputStream is;
                String contentType;
                conn = this.getUnisolatedConnection();
                if (this.remove != null) {
                    contentType = this.remove.getContentType();
                    is = this.remove.getInputStream();
                    handler = new DeleteServlet.RemoveStatementHandler(conn.getSailConnection(), nmodified, this.defaultContextDelete);
                    this.processData(conn, contentType, is, (RDFHandler)handler, this.baseURI);
                }
                if (this.add != null) {
                    contentType = this.add.getContentType();
                    is = this.add.getInputStream();
                    handler = new InsertServlet.AddStatementHandler(conn.getSailConnection(), nmodified, this.defaultContextInsert);
                    this.processData(conn, contentType, is, (RDFHandler)handler, this.baseURI);
                }
                conn.commit();
                success = true;
                long elapsed = System.currentTimeMillis() - begin;
                this.reportModifiedCount(nmodified.get(), elapsed);
                Void void_ = null;
                return void_;
            }
            finally {
                if (conn != null) {
                    if (!success) {
                        conn.rollback();
                    }
                    conn.close();
                }
            }
        }

        private void processData(BigdataSailRepositoryConnection conn, String contentType, InputStream is, RDFHandler handler, String baseURI) throws Exception {
            RDFFormat format = RDFFormat.forMIMEType((String)new MiniMime(contentType).getMimeType());
            RDFParserFactory rdfParserFactory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format);
            RDFParser rdfParser = rdfParserFactory.getParser();
            rdfParser.setValueFactory((ValueFactory)conn.getTripleStore().getValueFactory());
            rdfParser.setVerifyData(true);
            rdfParser.setStopAtFirstError(true);
            rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            rdfParser.setRDFHandler(handler);
            rdfParser.parse(is, baseURI);
        }
    }

    private static class UpdateWithQueryMaterializedTask
    extends AbstractRestApiTask<Void> {
        private final String queryStr;
        private final String baseURI;
        private final RDFParserFactory parserFactory;
        private final Resource[] defaultContextDelete;
        private final Resource[] defaultContextInsert;

        public UpdateWithQueryMaterializedTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, String queryStr, String baseURI, RDFParserFactory parserFactory, Resource[] defaultContextDelete, Resource[] defaultContextInsert) {
            super(req, resp, namespace, timestamp);
            this.queryStr = queryStr;
            this.baseURI = baseURI;
            this.parserFactory = parserFactory;
            this.defaultContextDelete = defaultContextDelete;
            this.defaultContextInsert = defaultContextInsert;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            AtomicLong nmodified = new AtomicLong(0L);
            BigdataSailRepositoryConnection conn = null;
            boolean success = false;
            try {
                conn = this.getUnisolatedConnection();
                if (log.isInfoEnabled()) {
                    log.info((Object)("update with query: " + this.queryStr));
                }
                BigdataRDFContext context = BigdataServlet.getBigdataRDFContext(this.req.getServletContext());
                PipedOutputStream os = new PipedOutputStream();
                RDFFormat deleteQueryFormat = RDFFormat.NTRIPLES;
                BigdataRDFContext.AbstractQueryTask queryTask = context.getQueryTask(conn, this.namespace, 0L, this.queryStr, deleteQueryFormat.getDefaultMIMEType(), this.req, this.resp, os);
                switch (queryTask.queryType) {
                    case DESCRIBE: 
                    case CONSTRUCT: {
                        break;
                    }
                    default: {
                        throw new MalformedQueryException("Must be DESCRIBE or CONSTRUCT query");
                    }
                }
                RDFParserFactory factory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)deleteQueryFormat);
                RDFParser rdfParser = factory.getParser();
                rdfParser.setValueFactory((ValueFactory)conn.getTripleStore().getValueFactory());
                rdfParser.setVerifyData(false);
                rdfParser.setStopAtFirstError(true);
                rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
                DeleteServlet.BufferStatementHandler buffer = new DeleteServlet.BufferStatementHandler(conn.getSailConnection(), nmodified, this.defaultContextDelete);
                rdfParser.setRDFHandler((RDFHandler)buffer);
                FutureTask<Void> ft = new FutureTask<Void>(queryTask);
                context.queryService.execute(ft);
                PipedInputStream is = BigdataRDFServlet.newPipedInputStream(os);
                rdfParser.parse((InputStream)is, this.baseURI);
                ft.get();
                buffer.removeAll();
                RDFParser rdfParser2 = this.parserFactory.getParser();
                rdfParser2.setValueFactory((ValueFactory)conn.getTripleStore().getValueFactory());
                rdfParser2.setVerifyData(true);
                rdfParser2.setStopAtFirstError(true);
                rdfParser2.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
                rdfParser2.setRDFHandler((RDFHandler)new InsertServlet.AddStatementHandler(conn.getSailConnection(), nmodified, this.defaultContextInsert));
                rdfParser2.parse((InputStream)this.req.getInputStream(), this.baseURI);
                conn.commit();
                success = true;
                long elapsed = System.currentTimeMillis() - begin;
                this.reportModifiedCount(nmodified.get(), elapsed);
                Void void_ = null;
                return void_;
            }
            finally {
                if (conn != null) {
                    if (!success) {
                        conn.rollback();
                    }
                    conn.close();
                }
            }
        }
    }

    private static class UpdateWithQueryStreamingTask
    extends AbstractRestApiTask<Void> {
        private final String queryStr;
        private final String baseURI;
        private final RDFParserFactory parserFactory;
        private final Resource[] defaultContextDelete;
        private final Resource[] defaultContextInsert;

        public UpdateWithQueryStreamingTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, String queryStr, String baseURI, RDFParserFactory parserFactory, Resource[] defaultContextDelete, Resource[] defaultContextInsert) {
            super(req, resp, namespace, timestamp);
            this.queryStr = queryStr;
            this.baseURI = baseURI;
            this.parserFactory = parserFactory;
            this.defaultContextDelete = defaultContextDelete;
            this.defaultContextInsert = defaultContextInsert;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            AtomicLong nmodified = new AtomicLong(0L);
            BigdataSailRepositoryConnection conn = null;
            boolean success = false;
            try {
                conn = this.getUnisolatedConnection();
                if (log.isInfoEnabled()) {
                    log.info((Object)("update with query: " + this.queryStr));
                }
                BigdataRDFContext context = BigdataServlet.getBigdataRDFContext(this.req.getServletContext());
                PipedOutputStream os = new PipedOutputStream();
                BigdataSailRepositoryConnection roconn = null;
                try {
                    long readOnlyTimestamp = -1L;
                    roconn = this.getQueryConnection(this.namespace, -1L);
                    RDFFormat deleteQueryFormat = RDFFormat.NTRIPLES;
                    BigdataRDFContext.AbstractQueryTask queryTask = context.getQueryTask(roconn, this.namespace, -1L, this.queryStr, deleteQueryFormat.getDefaultMIMEType(), this.req, this.resp, os);
                    switch (queryTask.queryType) {
                        case DESCRIBE: 
                        case CONSTRUCT: {
                            break;
                        }
                        default: {
                            throw new MalformedQueryException("Must be DESCRIBE or CONSTRUCT query");
                        }
                    }
                    RDFParserFactory factory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)deleteQueryFormat);
                    RDFParser rdfParser = factory.getParser();
                    rdfParser.setValueFactory((ValueFactory)conn.getTripleStore().getValueFactory());
                    rdfParser.setVerifyData(false);
                    rdfParser.setStopAtFirstError(true);
                    rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
                    rdfParser.setRDFHandler((RDFHandler)new DeleteServlet.RemoveStatementHandler(conn.getSailConnection(), nmodified, this.defaultContextDelete));
                    FutureTask<Void> ft = new FutureTask<Void>(queryTask);
                    context.queryService.execute(ft);
                    PipedInputStream is = BigdataRDFServlet.newPipedInputStream(os);
                    rdfParser.parse((InputStream)is, this.baseURI);
                    ft.get();
                    RDFParser rdfParser2 = this.parserFactory.getParser();
                    rdfParser2.setValueFactory((ValueFactory)conn.getTripleStore().getValueFactory());
                    rdfParser2.setVerifyData(true);
                    rdfParser2.setStopAtFirstError(true);
                    rdfParser2.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
                    rdfParser2.setRDFHandler((RDFHandler)new InsertServlet.AddStatementHandler(conn.getSailConnection(), nmodified, this.defaultContextInsert));
                    rdfParser2.parse((InputStream)this.req.getInputStream(), this.baseURI);
                }
                finally {
                    if (roconn != null) {
                        roconn.rollback();
                    }
                }
                conn.commit();
                success = true;
                long elapsed = System.currentTimeMillis() - begin;
                this.reportModifiedCount(nmodified.get(), elapsed);
                Void void_ = null;
                return void_;
            }
            finally {
                if (conn != null) {
                    if (!success) {
                        conn.rollback();
                    }
                    conn.close();
                }
            }
        }
    }
}

