/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import com.bigdata.rdf.sail.webapp.client.AcceptHeaderFactory;
import com.bigdata.rdf.sail.webapp.client.IMimeTypes;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;

public class AbstractConnectOptions
implements IMimeTypes {
    public final String serviceURL;
    public String method = "POST";
    public boolean update;
    public static final String DEFAULT_GRAPH_ACCEPT_HEADER;
    public static final String DEFAULT_SOLUTIONS_ACCEPT_HEADER;
    public static final String DEFAULT_BOOLEAN_ACCEPT_HEADER;
    public Map<String, String[]> requestParams;
    public Map<String, String> requestHeaders;

    public String toString() {
        return this.getClass().getName() + "{method=" + this.method + ",serviceURL=" + this.serviceURL + ",update=" + this.update + ",requestParams=" + this.requestParams + ",requestHeaders=" + this.requestHeaders + ",requestHeaders=" + this.requestHeaders + "}";
    }

    public AbstractConnectOptions(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public void addRequestParam(String name, String[] vals) {
        if (this.requestParams == null) {
            this.requestParams = new LinkedHashMap<String, String[]>();
        }
        this.requestParams.put(name, vals);
    }

    public void addRequestParam(String name, String val) {
        this.addRequestParam(name, new String[]{val});
    }

    public void addRequestParam(String name) {
        this.addRequestParam(name, (String[])null);
    }

    public String getRequestParam(String name) {
        return this.requestParams != null && this.requestParams.containsKey(name) ? this.requestParams.get(name)[0] : null;
    }

    public void setHeader(String name, String val) {
        if (this.requestHeaders == null) {
            this.requestHeaders = new LinkedHashMap<String, String>();
        }
        this.requestHeaders.put(name, val);
    }

    public void setAcceptHeader(String value) {
        this.setHeader("Accept", value);
    }

    public String getAcceptHeader() {
        return this.getHeader("Accept");
    }

    public String getHeader(String name) {
        if (this.requestHeaders == null) {
            return null;
        }
        return this.requestHeaders.get(name);
    }

    public static void addQueryParams(StringBuilder urlString, Map<String, String[]> requestParams) throws UnsupportedEncodingException {
        if (requestParams == null) {
            return;
        }
        boolean first = true;
        for (Map.Entry<String, String[]> e : requestParams.entrySet()) {
            String name = e.getKey();
            String[] vals = e.getValue();
            if (vals == null) {
                urlString.append(first ? "?" : "&");
                first = false;
                urlString.append(URLEncoder.encode(name, "UTF-8"));
                continue;
            }
            for (String val : vals) {
                urlString.append(first ? "?" : "&");
                first = false;
                urlString.append(URLEncoder.encode(name, "UTF-8"));
                urlString.append("=");
                if (val == null) continue;
                urlString.append(URLEncoder.encode(val, "UTF-8"));
            }
        }
    }

    public static String urlEncode(String in) {
        try {
            String out = URLEncoder.encode(in, "UTF-8");
            return out;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        boolean requireContext = false;
        DEFAULT_GRAPH_ACCEPT_HEADER = AcceptHeaderFactory.getDefaultGraphAcceptHeader(false);
        DEFAULT_SOLUTIONS_ACCEPT_HEADER = AcceptHeaderFactory.getDefaultSolutionsAcceptHeader();
        DEFAULT_BOOLEAN_ACCEPT_HEADER = AcceptHeaderFactory.getDefaultBooleanAcceptHeader();
    }
}

