/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import com.bigdata.rdf.sail.webapp.client.AST2SPARQLUtil;
import com.bigdata.rdf.sail.webapp.client.BackgroundGraphResult;
import com.bigdata.rdf.sail.webapp.client.BackgroundTupleResult;
import com.bigdata.rdf.sail.webapp.client.ConnectOptions;
import com.bigdata.rdf.sail.webapp.client.ContextsResult;
import com.bigdata.rdf.sail.webapp.client.EncodeDecodeValue;
import com.bigdata.rdf.sail.webapp.client.EntityContentProvider;
import com.bigdata.rdf.sail.webapp.client.HttpException;
import com.bigdata.rdf.sail.webapp.client.IPreparedBooleanQuery;
import com.bigdata.rdf.sail.webapp.client.IPreparedGraphQuery;
import com.bigdata.rdf.sail.webapp.client.IPreparedOperation;
import com.bigdata.rdf.sail.webapp.client.IPreparedQuery;
import com.bigdata.rdf.sail.webapp.client.IPreparedQueryListener;
import com.bigdata.rdf.sail.webapp.client.IPreparedSparqlUpdate;
import com.bigdata.rdf.sail.webapp.client.IPreparedTupleQuery;
import com.bigdata.rdf.sail.webapp.client.JettyResponseListener;
import com.bigdata.rdf.sail.webapp.client.MiniMime;
import com.bigdata.rdf.sail.webapp.client.MutationResult;
import com.bigdata.rdf.sail.webapp.client.RangeCountResult;
import com.bigdata.rdf.sail.webapp.client.StringUtil;
import info.aduna.io.IOUtil;
import info.aduna.iteration.CloseableIteration;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.log4j.Logger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpMethod;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerBase;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.query.impl.TupleQueryResultImpl;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.BooleanQueryResultParser;
import org.openrdf.query.resultio.BooleanQueryResultParserFactory;
import org.openrdf.query.resultio.BooleanQueryResultParserRegistry;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.query.resultio.TupleQueryResultParserFactory;
import org.openrdf.query.resultio.TupleQueryResultParserRegistry;
import org.openrdf.repository.sparql.query.InsertBindingSetCursor;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class RemoteRepository {
    private static final transient Logger log = Logger.getLogger(RemoteRepository.class);
    private static final String BD_NAMESPACE = "http://www.bigdata.com/rdf#";
    private static final URI BD_NULL_GRAPH = new URIImpl("http://www.bigdata.com/rdf#nullGraph");
    protected static final String UTF8 = "UTF-8";
    public static final String QUERY_METHOD = RemoteRepository.class.getName() + ".queryMethod";
    public static final String DEFAULT_QUERY_METHOD = "POST";
    public static final String MAX_REQUEST_URL_LENGTH = RemoteRepository.class.getName() + ".maxRequestURLLength";
    public static final int DEFAULT_MAX_REQUEST_URL_LENGTH = 1000;
    private static final String HTTP_HEADER_BIGDATA_MAX_QUERY_MILLIS = "X-BIGDATA-MAX-QUERY-MILLIS";
    protected final boolean useLBS;
    protected final String sparqlEndpointURL;
    protected final HttpClient httpClient;
    protected final Executor executor;
    private volatile int maxRequestURLLength;
    private volatile String queryMethod;
    public static final String OPTION_CREATE_KB_NAMESPACE = "com.bigdata.rdf.sail.namespace";

    public int getMaxRequestURLLength() {
        return this.maxRequestURLLength;
    }

    public void setMaxRequestURLLength(int newVal) {
        if (newVal <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxRequestURLLength = newVal;
    }

    public String getQueryMethod() {
        return this.queryMethod;
    }

    public void setQueryMethod(String method) {
        if (!DEFAULT_QUERY_METHOD.equalsIgnoreCase(method) && !"GET".equalsIgnoreCase(method)) {
            throw new IllegalArgumentException();
        }
        this.queryMethod = method.toUpperCase();
    }

    public RemoteRepository(String sparqlEndpointURL, boolean useLBS, HttpClient httpClient, Executor executor) {
        if (sparqlEndpointURL == null) {
            throw new IllegalArgumentException();
        }
        if (httpClient == null) {
            throw new IllegalArgumentException();
        }
        if (httpClient.isStopped()) {
            throw new IllegalStateException("Client is not running");
        }
        if (executor == null) {
            throw new IllegalArgumentException();
        }
        this.useLBS = useLBS;
        this.sparqlEndpointURL = sparqlEndpointURL;
        this.httpClient = httpClient;
        this.executor = executor;
        this.setMaxRequestURLLength(Integer.parseInt(System.getProperty(MAX_REQUEST_URL_LENGTH, Integer.toString(1000))));
        this.setQueryMethod(System.getProperty(QUERY_METHOD, DEFAULT_QUERY_METHOD));
    }

    public String toString() {
        return super.toString() + "{sparqlEndpoint=" + this.sparqlEndpointURL + ", useLBS=" + this.useLBS + "}";
    }

    public String getSparqlEndPoint() {
        return this.sparqlEndpointURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long postGraphML(String path) throws Exception {
        ConnectOptions opts = this.newConnectOptions();
        opts.addRequestParam("blueprints");
        JettyResponseListener response = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                throw new RuntimeException("cannot locate file: " + file.getAbsolutePath());
            }
            byte[] data = IOUtil.readBytes((File)file);
            ByteArrayEntity entity = new ByteArrayEntity(data);
            entity.setContentType("application/graphml+xml");
            opts.entity = entity;
            opts.setAcceptHeader("application/xml");
            response = this.doConnect(opts);
            RemoteRepository.checkResponseCode(response);
            MutationResult result = RemoteRepository.mutationResults(response);
            long l = result.mutationCount;
            return l;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    public GraphQueryResult getServiceDescription() throws Exception {
        ConnectOptions opts = this.newConnectOptions();
        opts.method = "GET";
        opts.setAcceptHeader(ConnectOptions.DEFAULT_GRAPH_ACCEPT_HEADER);
        return this.graphResults(opts, null, null);
    }

    public IPreparedTupleQuery prepareTupleQuery(String query) throws Exception {
        return new TupleQuery(this.newQueryConnectOptions(), UUID.randomUUID(), query);
    }

    public IPreparedGraphQuery prepareGraphQuery(String query) throws Exception {
        return new GraphQuery(this.newQueryConnectOptions(), UUID.randomUUID(), query);
    }

    public IPreparedBooleanQuery prepareBooleanQuery(String query) throws Exception {
        return new BooleanQuery(this.newQueryConnectOptions(), UUID.randomUUID(), query);
    }

    public IPreparedSparqlUpdate prepareUpdate(String updateStr) throws Exception {
        return new SparqlUpdate(this.newUpdateConnectOptions(), UUID.randomUUID(), updateStr);
    }

    public IPreparedGraphQuery getStatements2(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws Exception {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        Map<String, String> prefixDecls = Collections.emptyMap();
        AST2SPARQLUtil util = new AST2SPARQLUtil(prefixDecls);
        StringBuilder sb = new StringBuilder();
        if (contexts.length > 0) {
            sb.append("CONSTRUCT {\n");
            sb.append(this.asConstOrVar(util, "?s", (Value)subj));
            sb.append(" ");
            sb.append(this.asConstOrVar(util, "?p", (Value)pred));
            sb.append(" ");
            sb.append(this.asConstOrVar(util, "?o", obj));
            sb.append("\n}\n");
            for (int i = 0; i < contexts.length; ++i) {
                URI c = contexts[i] == null ? BD_NULL_GRAPH : contexts[i];
                sb.append("FROM " + util.toExternal((Value)c) + "\n");
            }
            sb.append("WHERE {\n");
        } else {
            sb.append("CONSTRUCT WHERE {\n");
        }
        sb.append(this.asConstOrVar(util, "?s", (Value)subj));
        sb.append(" ");
        sb.append(this.asConstOrVar(util, "?p", (Value)pred));
        sb.append(" ");
        sb.append(this.asConstOrVar(util, "?o", obj));
        sb.append("\n}");
        String queryStr = sb.toString();
        IPreparedGraphQuery query = this.prepareGraphQuery(queryStr);
        return query;
    }

    public GraphQueryResult getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws Exception {
        return this.getStatements2(subj, pred, obj, includeInferred, contexts).evaluate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasStatement(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws Exception {
        try (GraphQueryResult ret = this.getStatements(subj, pred, obj, includeInferred, contexts);){
            boolean bl = ret.hasNext();
            return bl;
        }
    }

    private String asConstOrVar(AST2SPARQLUtil util, String var, Value val) {
        if (val == null) {
            return var;
        }
        return util.toExternal(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(UUID queryId) throws Exception {
        if (queryId == null) {
            return;
        }
        ConnectOptions opts = this.newUpdateConnectOptions();
        opts.addRequestParam("cancelQuery");
        opts.addRequestParam("queryId", queryId.toString());
        JettyResponseListener response = null;
        try {
            response = this.doConnect(opts);
            RemoteRepository.checkResponseCode(response);
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long rangeCount(Resource s, URI p, Value o, Resource ... c) throws Exception {
        ConnectOptions opts = this.newQueryConnectOptions();
        opts.addRequestParam("ESTCARD");
        if (s != null) {
            opts.addRequestParam("s", EncodeDecodeValue.encodeValue((Value)s));
        }
        if (p != null) {
            opts.addRequestParam("p", EncodeDecodeValue.encodeValue((Value)p));
        }
        if (o != null) {
            opts.addRequestParam("o", EncodeDecodeValue.encodeValue(o));
        }
        if (c != null && c.length > 0) {
            opts.addRequestParam("c", EncodeDecodeValue.encodeValues((Value[])c));
        }
        JettyResponseListener resp = null;
        try {
            opts.setAcceptHeader("application/xml");
            resp = this.doConnect(opts);
            RemoteRepository.checkResponseCode(resp);
            RangeCountResult result = RemoteRepository.rangeCountResults(resp);
            long l = result.rangeCount;
            return l;
        }
        finally {
            if (resp != null) {
                resp.abort();
            }
        }
    }

    public long size() throws Exception {
        return this.rangeCount(null, null, null, new Resource[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Resource> getContexts() throws Exception {
        ConnectOptions opts = this.newQueryConnectOptions();
        opts.addRequestParam("CONTEXTS");
        JettyResponseListener resp = null;
        try {
            opts.setAcceptHeader("application/xml");
            resp = this.doConnect(opts);
            RemoteRepository.checkResponseCode(resp);
            ContextsResult result = RemoteRepository.contextsResults(resp);
            Collection<Resource> collection = result.contexts;
            return collection;
        }
        finally {
            if (resp != null) {
                resp.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(AddOp add) throws Exception {
        ConnectOptions opts = this.newUpdateConnectOptions();
        add.prepareForWire();
        if (add.format != null) {
            ByteArrayEntity entity = new ByteArrayEntity(add.data);
            entity.setContentType(add.format.getDefaultMIMEType());
            opts.entity = entity;
        }
        if (add.uri != null) {
            opts.addRequestParam("uri", add.uri);
        }
        if (add.context != null && add.context.length > 0) {
            opts.addRequestParam("context-uri", this.toStrings(add.context));
        }
        JettyResponseListener response = null;
        try {
            opts.setAcceptHeader("application/xml");
            response = this.doConnect(opts);
            RemoteRepository.checkResponseCode(response);
            MutationResult result = RemoteRepository.mutationResults(response);
            long l = result.mutationCount;
            return l;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long remove(RemoveOp remove) throws Exception {
        ConnectOptions opts = this.newUpdateConnectOptions();
        remove.prepareForWire();
        if (remove.format != null) {
            opts.method = DEFAULT_QUERY_METHOD;
            opts.addRequestParam("delete");
            ByteArrayEntity entity = new ByteArrayEntity(remove.data);
            entity.setContentType(remove.format.getDefaultMIMEType());
            opts.entity = entity;
            if (remove.context != null && remove.context.length > 0) {
                opts.addRequestParam("context-uri", this.toStrings(remove.context));
            }
        } else {
            opts.method = "DELETE";
            if (remove.query != null) {
                opts.addRequestParam("query", remove.query);
            }
            if (remove.s != null) {
                opts.addRequestParam("s", EncodeDecodeValue.encodeValue(remove.s));
            }
            if (remove.p != null) {
                opts.addRequestParam("p", EncodeDecodeValue.encodeValue(remove.p));
            }
            if (remove.o != null) {
                opts.addRequestParam("o", EncodeDecodeValue.encodeValue(remove.o));
            }
            if (remove.c != null && remove.c.length > 0) {
                opts.addRequestParam("c", EncodeDecodeValue.encodeValues(remove.c));
            }
        }
        JettyResponseListener response = null;
        try {
            opts.setAcceptHeader("application/xml");
            response = this.doConnect(opts);
            RemoteRepository.checkResponseCode(response);
            MutationResult result = RemoteRepository.mutationResults(response);
            long l = result.mutationCount;
            return l;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long update(RemoveOp remove, AddOp add) throws Exception {
        MultipartEntity entity;
        ConnectOptions opts = this.newUpdateConnectOptions();
        remove.prepareForWire();
        add.prepareForWire();
        if (remove.format != null) {
            opts.method = DEFAULT_QUERY_METHOD;
            opts.addRequestParam("update");
            entity = new MultipartEntity();
            entity.addPart(new FormBodyPart("remove", (ContentBody)new ByteArrayBody(remove.data, remove.format.getDefaultMIMEType(), "remove")));
            entity.addPart(new FormBodyPart("add", (ContentBody)new ByteArrayBody(add.data, add.format.getDefaultMIMEType(), "add")));
            opts.entity = entity;
        } else {
            opts.method = "PUT";
            opts.addRequestParam("query", remove.query);
            entity = new ByteArrayEntity(add.data);
            entity.setContentType(add.format.getDefaultMIMEType());
            opts.entity = entity;
        }
        if (add.context != null) {
            opts.addRequestParam("context-uri-insert", this.toStrings(add.context));
        }
        if (remove.context != null) {
            opts.addRequestParam("context-uri-delete", this.toStrings(remove.context));
        }
        JettyResponseListener response = null;
        try {
            opts.setAcceptHeader("application/xml");
            response = this.doConnect(opts);
            RemoteRepository.checkResponseCode(response);
            MutationResult result = RemoteRepository.mutationResults(response);
            long l = result.mutationCount;
            return l;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    public JettyResponseListener doConnect(ConnectOptions opts) throws Exception {
        boolean isLongRequestURL;
        String requestURL;
        if (this.httpClient.isStopped()) {
            throw new RuntimeException("The client has been stopped");
        }
        if (this.useLBS) {
            String CONTEXT_PATH = "/bigdata";
            int startContextPath = opts.serviceURL.indexOf("/bigdata");
            int endContextPath = startContextPath + "/bigdata".length();
            String baseURL = opts.serviceURL.substring(0, endContextPath);
            String rest = opts.serviceURL.substring(endContextPath);
            requestURL = opts.update ? baseURL + "/LBS/leader" + rest : baseURL + "/LBS/read" + rest;
        } else {
            requestURL = opts.serviceURL;
        }
        StringBuilder urlString = new StringBuilder(requestURL);
        ConnectOptions.addQueryParams(urlString, opts.requestParams);
        boolean bl = isLongRequestURL = urlString.length() > this.getMaxRequestURLLength();
        if (isLongRequestURL && opts.method.equals(DEFAULT_QUERY_METHOD) && opts.entity == null) {
            urlString.setLength(0);
            urlString.append(requestURL);
            opts.entity = ConnectOptions.getFormEntity(opts.requestParams);
        } else if (isLongRequestURL && opts.method.equals("GET") && opts.entity == null) {
            opts.method = DEFAULT_QUERY_METHOD;
            urlString.setLength(0);
            urlString.append(requestURL);
            opts.entity = ConnectOptions.getFormEntity(opts.requestParams);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"*** Request ***");
            log.debug((Object)requestURL);
            log.debug((Object)opts.method);
            log.debug((Object)("query=" + opts.getRequestParam("query")));
            log.debug((Object)urlString.toString());
        }
        HttpRequest request = null;
        try {
            String s;
            request = (HttpRequest)this.newRequest(urlString.toString(), opts.method);
            if (opts.requestHeaders != null) {
                for (Map.Entry e : opts.requestHeaders.entrySet()) {
                    request.header((String)e.getKey(), (String)e.getValue());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)((String)e.getKey() + ": " + (String)e.getValue()));
                }
            }
            if (opts.entity != null) {
                EntityContentProvider cp = new EntityContentProvider(opts.entity);
                request.content((ContentProvider)cp, cp.getContentType());
            }
            long queryTimeoutMillis = (s = opts.getHeader(HTTP_HEADER_BIGDATA_MAX_QUERY_MILLIS)) == null ? -1L : StringUtil.toLong(s);
            JettyResponseListener listener = new JettyResponseListener((Request)request, queryTimeoutMillis);
            request.send((Response.CompleteListener)listener);
            return listener;
        }
        catch (Throwable t) {
            try {
                if (request != null) {
                    request.abort(t);
                }
            }
            catch (Throwable t2) {
                log.warn((Object)t2);
            }
            throw new RuntimeException(this.sparqlEndpointURL + " : " + t, t);
        }
    }

    public Request newRequest(String uri, String method) {
        return RemoteRepository.newRequest(this.httpClient, uri, method);
    }

    public static Request newRequest(HttpClient httpClient, String uri, String method) {
        if (httpClient == null) {
            throw new IllegalArgumentException();
        }
        if (httpClient.isStopped()) {
            throw new IllegalStateException("The Client has been stopped");
        }
        return httpClient.newRequest(uri).method(RemoteRepository.getMethod(method));
    }

    static HttpMethod getMethod(String method) {
        if (method.equals("GET")) {
            return HttpMethod.GET;
        }
        if (method.equals(DEFAULT_QUERY_METHOD)) {
            return HttpMethod.POST;
        }
        if (method.equals("DELETE")) {
            return HttpMethod.DELETE;
        }
        if (method.equals("PUT")) {
            return HttpMethod.PUT;
        }
        throw new IllegalArgumentException();
    }

    public static JettyResponseListener checkResponseCode(JettyResponseListener responseListener) throws IOException {
        int rc = responseListener.getStatus();
        if (rc < 200 || rc >= 300) {
            throw new HttpException(rc, "Status Code=" + rc + ", Status Line=" + responseListener.getReason() + ", Response=" + responseListener.getResponseBody());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"*** Response ***");
            log.debug((Object)("Status Line: " + responseListener.getReason()));
        }
        return responseListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleQueryResult tupleResults(ConnectOptions opts, final UUID queryId, final IPreparedQueryListener listener) throws Exception {
        JettyResponseListener response = null;
        FutureTask<Object> ft = null;
        TupleQueryResultImpl tqrImpl = null;
        try {
            TupleQueryResultImpl tmp;
            response = this.doConnect(opts);
            RemoteRepository.checkResponseCode(response);
            String contentType = response.getContentType();
            MiniMime mimeType = new MiniMime(contentType);
            TupleQueryResultFormat format = TupleQueryResultFormat.forMIMEType((String)mimeType.getMimeType());
            if (format == null) {
                throw new IOException("Could not identify format for service response: serviceURI=" + this.sparqlEndpointURL + ", contentType=" + contentType + " : response=" + response.getResponseBody());
            }
            TupleQueryResultParserFactory parserFactory = (TupleQueryResultParserFactory)TupleQueryResultParserRegistry.getInstance().get((Object)format);
            if (parserFactory == null) {
                throw new IOException("No parser for format for service response: serviceURI=" + this.sparqlEndpointURL + ", contentType=" + contentType + ", format=" + format + " : response=" + response.getResponseBody());
            }
            TupleQueryResultParser parser = parserFactory.getParser();
            BackgroundTupleResult result = new BackgroundTupleResult(parser, response.getInputStream());
            MapBindingSet bindings = new MapBindingSet();
            InsertBindingSetCursor cursor = new InsertBindingSetCursor((CloseableIteration)result, (BindingSet)bindings);
            ft = new FutureTask<Object>(result, null);
            this.executor.execute(ft);
            ArrayList<String> list = new ArrayList<String>(result.getBindingNames());
            TupleQueryResultImpl tupleQueryResultImpl = tqrImpl = (tmp = new TupleQueryResultImpl(list, (CloseableIteration)cursor){
                private final AtomicBoolean notDone;
                {
                    super(x0, x1);
                    this.notDone = new AtomicBoolean(true);
                }

                public boolean hasNext() throws QueryEvaluationException {
                    boolean hasNext = super.hasNext();
                    if (!hasNext) {
                        this.notDone.set(false);
                    }
                    return hasNext;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleClose() throws QueryEvaluationException {
                    try {
                        super.handleClose();
                    }
                    finally {
                        if (this.notDone.compareAndSet(true, false)) {
                            try {
                                RemoteRepository.this.cancel(queryId);
                            }
                            catch (Exception ex) {
                                log.warn((Object)ex);
                            }
                        }
                        if (listener != null) {
                            listener.closed(queryId);
                        }
                    }
                }
            });
            return tupleQueryResultImpl;
        }
        finally {
            if (response != null && tqrImpl == null) {
                if (ft != null) {
                    ft.cancel(true);
                }
                response.abort();
                try {
                    this.cancel(queryId);
                }
                catch (Exception ex) {
                    log.warn((Object)ex);
                }
                if (listener != null) {
                    listener.closed(queryId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphQueryResult graphResults(ConnectOptions opts, final UUID queryId, final IPreparedQueryListener listener) throws Exception {
        JettyResponseListener response = null;
        BackgroundGraphResult result = null;
        try {
            response = this.doConnect(opts);
            RemoteRepository.checkResponseCode(response);
            String baseURI = "";
            String contentType = response.getContentType();
            if (contentType == null) {
                throw new RuntimeException("Not found: Content-Type");
            }
            MiniMime mimeType = new MiniMime(contentType);
            RDFFormat format = RDFFormat.forMIMEType((String)mimeType.getMimeType());
            if (format == null) {
                throw new IOException("Could not identify format for service response: serviceURI=" + this.sparqlEndpointURL + ", contentType=" + contentType + " : response=" + response.getResponseBody());
            }
            RDFParserFactory factory = (RDFParserFactory)RDFParserRegistry.getInstance().get((Object)format);
            if (factory == null) {
                throw new RuntimeException("RDFParserFactory not found: Content-Type=" + contentType + ", format=" + format);
            }
            RDFParser parser = factory.getParser();
            parser.setValueFactory((ValueFactory)new ValueFactoryImpl());
            parser.setVerifyData(true);
            parser.setStopAtFirstError(true);
            parser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            Charset charset = format.getCharset();
            try {
                String encoding = response.getContentEncoding();
                if (encoding != null) {
                    charset = Charset.forName(encoding);
                }
            }
            catch (IllegalCharsetNameException e) {
                // empty catch block
            }
            BackgroundGraphResult tmp = new BackgroundGraphResult(parser, response.getInputStream(), charset, ""){
                final AtomicBoolean notDone;
                {
                    super(x0, x1, x2, x3);
                    this.notDone = new AtomicBoolean(true);
                }

                @Override
                public boolean hasNext() throws QueryEvaluationException {
                    boolean hasNext = super.hasNext();
                    if (!hasNext) {
                        this.notDone.set(false);
                    }
                    return hasNext;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws QueryEvaluationException {
                    try {
                        super.close();
                    }
                    finally {
                        if (this.notDone.compareAndSet(true, false)) {
                            try {
                                RemoteRepository.this.cancel(queryId);
                            }
                            catch (Exception ex) {
                                log.warn((Object)ex);
                            }
                        }
                        if (listener != null) {
                            listener.closed(queryId);
                        }
                    }
                }
            };
            this.executor.execute(tmp);
            BackgroundGraphResult backgroundGraphResult = result = tmp;
            return backgroundGraphResult;
        }
        finally {
            if (response != null && result == null) {
                response.abort();
                try {
                    this.cancel(queryId);
                }
                catch (Exception ex) {
                    log.warn((Object)ex);
                }
                if (listener != null) {
                    listener.closed(queryId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean booleanResults(ConnectOptions opts, UUID queryId, IPreparedQueryListener listener) throws Exception {
        JettyResponseListener response = null;
        Boolean result = null;
        try {
            boolean bl;
            response = this.doConnect(opts);
            RemoteRepository.checkResponseCode(response);
            String contentType = response.getContentType();
            MiniMime mimeType = new MiniMime(contentType);
            BooleanQueryResultFormat format = BooleanQueryResultFormat.forMIMEType((String)mimeType.getMimeType());
            if (format == null) {
                throw new IOException("Could not identify format for service response: serviceURI=" + this.sparqlEndpointURL + ", contentType=" + contentType + " : response=" + response.getResponseBody());
            }
            BooleanQueryResultParserFactory factory = (BooleanQueryResultParserFactory)BooleanQueryResultParserRegistry.getInstance().get((Object)format);
            if (factory == null) {
                throw new RuntimeException("No factory for Content-Type: " + contentType);
            }
            BooleanQueryResultParser parser = factory.getParser();
            InputStream is = response.getInputStream();
            try {
                result = parser.parse(is);
                bl = result;
            }
            catch (Throwable throwable) {
                is.close();
                throw throwable;
            }
            is.close();
            return bl;
        }
        finally {
            if (result == null) {
                if (response != null) {
                    response.abort();
                }
                try {
                    this.cancel(queryId);
                }
                catch (Exception ex) {
                    log.warn((Object)ex);
                }
            }
            if (listener != null) {
                listener.closed(queryId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long countResults(JettyResponseListener response) throws Exception {
        try {
            String contentType = response.getContentType();
            MiniMime mimeType = new MiniMime(contentType);
            TupleQueryResultFormat format = TupleQueryResultFormat.forMIMEType((String)mimeType.getMimeType());
            if (format == null) {
                throw new IOException("Could not identify format for service response: serviceURI=" + this.sparqlEndpointURL + ", contentType=" + contentType + " : response=" + response.getResponseBody());
            }
            TupleQueryResultParserFactory factory = (TupleQueryResultParserFactory)TupleQueryResultParserRegistry.getInstance().get((Object)format);
            if (factory == null) {
                throw new RuntimeException("No factory for Content-Type: " + contentType);
            }
            TupleQueryResultParser parser = factory.getParser();
            final AtomicLong nsolutions = new AtomicLong();
            parser.setTupleQueryResultHandler((TupleQueryResultHandler)new TupleQueryResultHandlerBase(){

                public void endQueryResult() {
                }

                public void handleSolution(BindingSet bset) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)bset.toString());
                    }
                    nsolutions.incrementAndGet();
                }

                public void startQueryResult(List<String> bindingNames) {
                }
            });
            parser.parse(response.getInputStream());
            if (log.isInfoEnabled()) {
                log.info((Object)("nsolutions=" + nsolutions));
            }
            long l = nsolutions.longValue();
            return l;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MutationResult mutationResults(JettyResponseListener response) throws Exception {
        try {
            String contentType = response.getContentType();
            if (!contentType.startsWith("application/xml")) {
                throw new RuntimeException("Expecting Content-Type of application/xml, not " + contentType);
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            final AtomicLong mutationCount = new AtomicLong();
            final AtomicLong elapsedMillis = new AtomicLong();
            parser.parse(response.getInputStream(), (DefaultHandler)new DefaultHandler2(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    if (!"data".equals(qName)) {
                        throw new RuntimeException("Expecting: 'data', but have: uri=" + uri + ", localName=" + localName + ", qName=" + qName);
                    }
                    mutationCount.set(Long.valueOf(attributes.getValue("modified")));
                    elapsedMillis.set(Long.valueOf(attributes.getValue("milliseconds")));
                }
            });
            MutationResult mutationResult = new MutationResult(mutationCount.get(), elapsedMillis.get());
            return mutationResult;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static RangeCountResult rangeCountResults(JettyResponseListener response) throws Exception {
        try {
            String contentType = response.getContentType();
            if (!contentType.startsWith("application/xml")) {
                throw new RuntimeException("Expecting Content-Type of application/xml, not " + contentType);
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            final AtomicLong rangeCount = new AtomicLong();
            final AtomicLong elapsedMillis = new AtomicLong();
            parser.parse(response.getInputStream(), (DefaultHandler)new DefaultHandler2(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    if (!"data".equals(qName)) {
                        throw new RuntimeException("Expecting: 'data', but have: uri=" + uri + ", localName=" + localName + ", qName=" + qName);
                    }
                    rangeCount.set(Long.valueOf(attributes.getValue("rangeCount")));
                    elapsedMillis.set(Long.valueOf(attributes.getValue("milliseconds")));
                }
            });
            RangeCountResult rangeCountResult = new RangeCountResult(rangeCount.get(), elapsedMillis.get());
            return rangeCountResult;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ContextsResult contextsResults(JettyResponseListener response) throws Exception {
        try {
            String contentType = response.getContentType();
            if (!contentType.startsWith("application/xml")) {
                throw new RuntimeException("Expecting Content-Type of application/xml, not " + contentType);
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            final Collection<Resource> contexts = Collections.synchronizedCollection(new LinkedList());
            parser.parse(response.getInputStream(), (DefaultHandler)new DefaultHandler2(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    if ("context".equals(qName)) {
                        contexts.add(new URIImpl(attributes.getValue("uri")));
                    }
                }
            });
            ContextsResult contextsResult = new ContextsResult(contexts);
            return contextsResult;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    protected static byte[] serialize(Iterable<? extends Statement> stmts, RDFFormat format) throws Exception {
        RDFWriterFactory writerFactory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RDFWriter writer = writerFactory.getWriter((OutputStream)baos);
        writer.startRDF();
        for (Statement statement : stmts) {
            writer.handleStatement(statement);
        }
        writer.endRDF();
        byte[] data = baos.toByteArray();
        return data;
    }

    protected final ConnectOptions newQueryConnectOptions() {
        ConnectOptions opts = this.newConnectOptions(this.sparqlEndpointURL);
        opts.method = this.getQueryMethod();
        opts.update = false;
        return opts;
    }

    protected final ConnectOptions newUpdateConnectOptions() {
        ConnectOptions opts = this.newConnectOptions(this.sparqlEndpointURL);
        opts.method = DEFAULT_QUERY_METHOD;
        opts.update = true;
        return opts;
    }

    protected final ConnectOptions newConnectOptions() {
        return this.newConnectOptions(this.sparqlEndpointURL);
    }

    protected ConnectOptions newConnectOptions(String serviceURL) {
        ConnectOptions opts = new ConnectOptions(serviceURL);
        return opts;
    }

    public static Graph asGraph(GraphQueryResult result) throws Exception {
        GraphImpl g = new GraphImpl();
        while (result.hasNext()) {
            g.add(result.next());
        }
        return g;
    }

    protected String[] toStrings(Resource[] resources) {
        if (resources == null) {
            return null;
        }
        if (resources.length == 0) {
            return new String[0];
        }
        String[] uris = new String[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            uris[i] = resources[i].stringValue();
        }
        return uris;
    }

    public static class RemoveOp {
        private String query;
        private Iterable<? extends Statement> stmts;
        private Value s;
        private Value p;
        private Value o;
        private Value[] c;
        private byte[] data;
        private File file;
        private RDFFormat format;
        private Resource[] context;

        public RemoveOp(String query) {
            this.query = query;
        }

        public RemoveOp(Iterable<? extends Statement> stmts) {
            this.stmts = stmts;
        }

        public RemoveOp(Resource s, URI p, Value o, Resource ... c) {
            this.s = s;
            this.p = p;
            this.o = o;
            this.c = c;
        }

        public RemoveOp(File file, RDFFormat format) {
            this.file = file;
            this.format = format;
        }

        public RemoveOp(byte[] data, RDFFormat format) {
            this.data = data;
            this.format = format;
        }

        public void setContext(Resource ... context) {
            this.context = context;
        }

        private void prepareForWire() throws Exception {
            if (this.file != null) {
                this.data = IOUtil.readBytes((File)this.file);
            } else if (this.stmts != null) {
                this.format = RDFFormat.TRIG;
                this.data = RemoteRepository.serialize(this.stmts, this.format);
            }
        }
    }

    public static class AddOp {
        private String uri;
        private Iterable<? extends Statement> stmts;
        private byte[] data;
        private File file;
        private InputStream is;
        private Reader reader;
        private RDFFormat format;
        private Resource[] context;

        public AddOp(String uri) {
            this.uri = uri;
        }

        public AddOp(Iterable<? extends Statement> stmts) {
            this.stmts = stmts;
        }

        public AddOp(File file, RDFFormat format) {
            this.file = file;
            this.format = format;
        }

        public AddOp(InputStream is, RDFFormat format) {
            this.is = is;
            this.format = format;
        }

        public AddOp(Reader reader, RDFFormat format) {
            this.reader = reader;
            this.format = format;
        }

        public AddOp(byte[] data, RDFFormat format) {
            this.data = data;
            this.format = format;
        }

        public void setContext(Resource ... context) {
            this.context = context;
        }

        private void prepareForWire() throws Exception {
            if (this.file != null) {
                this.data = IOUtil.readBytes((File)this.file);
            } else if (this.is != null) {
                this.data = IOUtil.readBytes((InputStream)this.is);
            } else if (this.reader != null) {
                this.data = IOUtil.readString((Reader)this.reader).getBytes();
            } else if (this.stmts != null) {
                this.format = RDFFormat.TRIG;
                this.data = RemoteRepository.serialize(this.stmts, this.format);
            }
        }
    }

    private final class SparqlUpdate
    extends Query
    implements IPreparedSparqlUpdate {
        public SparqlUpdate(ConnectOptions opts, UUID id, String updateStr) {
            super(opts, id, updateStr, true);
        }

        @Override
        public void evaluate() throws Exception {
            this.evaluate(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void evaluate(IPreparedQueryListener listener) throws Exception {
            JettyResponseListener response = null;
            try {
                this.setupConnectOptions();
                response = RemoteRepository.this.doConnect(this.opts);
                RemoteRepository.checkResponseCode(response);
            }
            finally {
                if (response != null) {
                    response.abort();
                }
            }
        }
    }

    private final class BooleanQuery
    extends Query
    implements IPreparedBooleanQuery {
        public BooleanQuery(ConnectOptions opts, UUID id, String query) {
            super(opts, id, query);
        }

        @Override
        protected void setupConnectOptions() {
            super.setupConnectOptions();
            if (this.opts.getAcceptHeader() == null) {
                this.opts.setAcceptHeader(ConnectOptions.DEFAULT_BOOLEAN_ACCEPT_HEADER);
            }
        }

        @Override
        public boolean evaluate() throws Exception {
            return this.evaluate(null);
        }

        @Override
        public boolean evaluate(IPreparedQueryListener listener) throws Exception {
            this.setupConnectOptions();
            return RemoteRepository.this.booleanResults(this.opts, this.getQueryId(), listener);
        }
    }

    private final class GraphQuery
    extends Query
    implements IPreparedGraphQuery {
        public GraphQuery(ConnectOptions opts, UUID id, String query) {
            super(opts, id, query);
        }

        @Override
        protected void setupConnectOptions() {
            super.setupConnectOptions();
            if (this.opts.getAcceptHeader() == null) {
                this.opts.setAcceptHeader(ConnectOptions.DEFAULT_GRAPH_ACCEPT_HEADER);
            }
        }

        @Override
        public GraphQueryResult evaluate() throws Exception {
            return this.evaluate(null);
        }

        @Override
        public GraphQueryResult evaluate(IPreparedQueryListener listener) throws Exception {
            this.setupConnectOptions();
            return RemoteRepository.this.graphResults(this.opts, this.getQueryId(), listener);
        }
    }

    private final class TupleQuery
    extends Query
    implements IPreparedTupleQuery {
        public TupleQuery(ConnectOptions opts, UUID id, String query) {
            super(opts, id, query);
        }

        @Override
        protected void setupConnectOptions() {
            super.setupConnectOptions();
            if (this.opts.getAcceptHeader() == null) {
                this.opts.setAcceptHeader(ConnectOptions.DEFAULT_SOLUTIONS_ACCEPT_HEADER);
            }
        }

        @Override
        public TupleQueryResult evaluate() throws Exception {
            return this.evaluate(null);
        }

        @Override
        public TupleQueryResult evaluate(IPreparedQueryListener listener) throws Exception {
            this.setupConnectOptions();
            return RemoteRepository.this.tupleResults(this.opts, this.getQueryId(), listener);
        }
    }

    protected abstract class Query
    implements IPreparedOperation,
    IPreparedQuery {
        protected final ConnectOptions opts;
        protected final UUID id;
        protected final String query;
        private final boolean update;

        public Query(ConnectOptions opts, UUID id, String query) {
            this(opts, id, query, false);
        }

        public Query(ConnectOptions opts, UUID id, String query, boolean update) {
            if (opts == null) {
                throw new IllegalArgumentException();
            }
            if (query == null) {
                throw new IllegalArgumentException();
            }
            this.opts = opts;
            this.id = id;
            this.query = query;
            this.update = update;
        }

        @Override
        public final UUID getQueryId() {
            return this.id;
        }

        @Override
        public final boolean isUpdate() {
            return this.update;
        }

        protected void setupConnectOptions() {
            this.opts.method = RemoteRepository.this.getQueryMethod();
            if (this.update) {
                this.opts.addRequestParam("update", this.query);
            } else {
                this.opts.addRequestParam("query", this.query);
            }
            if (this.id != null) {
                this.opts.addRequestParam("queryId", this.getQueryId().toString());
            }
        }

        @Override
        public void setAcceptHeader(String value) {
            this.opts.setAcceptHeader(value);
        }

        @Override
        public void setHeader(String name, String value) {
            this.opts.setHeader(name, value);
        }

        @Override
        public void setMaxQueryMillis(long timeout) {
            this.opts.setHeader(RemoteRepository.HTTP_HEADER_BIGDATA_MAX_QUERY_MILLIS, Long.toString(timeout));
        }

        @Override
        public long getMaxQueryMillis() {
            String s = this.opts.getHeader(RemoteRepository.HTTP_HEADER_BIGDATA_MAX_QUERY_MILLIS);
            if (s == null) {
                return -1L;
            }
            return StringUtil.toLong(s);
        }

        @Override
        public String getHeader(String name) {
            return this.opts.getHeader(name);
        }
    }
}

