/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import com.bigdata.rdf.properties.PropertiesFormat;
import com.bigdata.rdf.properties.PropertiesParser;
import com.bigdata.rdf.properties.PropertiesParserFactory;
import com.bigdata.rdf.properties.PropertiesParserRegistry;
import com.bigdata.rdf.properties.PropertiesWriter;
import com.bigdata.rdf.properties.PropertiesWriterFactory;
import com.bigdata.rdf.properties.PropertiesWriterRegistry;
import com.bigdata.rdf.sail.webapp.client.ConnectOptions;
import com.bigdata.rdf.sail.webapp.client.HttpException;
import com.bigdata.rdf.sail.webapp.client.JettyResponseListener;
import com.bigdata.rdf.sail.webapp.client.MiniMime;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.util.InnerCause;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.http.entity.ByteArrayEntity;
import org.eclipse.jetty.client.HttpClient;
import org.openrdf.query.GraphQueryResult;

public class RemoteRepositoryManager
extends RemoteRepository
implements AutoCloseable {
    private final String baseServiceURL;
    private volatile boolean m_closed = false;

    public String getBaseServiceURL() {
        return this.baseServiceURL;
    }

    public RemoteRepositoryManager(String serviceURL, HttpClient httpClient, Executor executor) {
        this(serviceURL, false, httpClient, executor);
    }

    public RemoteRepositoryManager(String serviceURL, boolean useLBS, HttpClient httpClient, Executor executor) {
        super(serviceURL + "/sparql", useLBS, httpClient, executor);
        this.baseServiceURL = serviceURL;
    }

    protected String getRepositoryBaseURLForNamespace(String namespace) {
        return this.baseServiceURL + "/namespace/" + ConnectOptions.urlEncode(namespace);
    }

    public RemoteRepository getRepositoryForNamespace(String namespace) {
        return new RemoteRepository(this.getRepositoryBaseURLForNamespace(namespace) + "/sparql", this.useLBS, this.httpClient, this.executor);
    }

    public RemoteRepository getRepositoryForURL(String sparqlEndpointURL, boolean useLBS) {
        return new RemoteRepository(sparqlEndpointURL, useLBS, this.httpClient, this.executor);
    }

    public RemoteRepository getRepositoryForURL(String sparqlEndpointURL) {
        return new RemoteRepository(sparqlEndpointURL, this.useLBS, this.httpClient, this.executor);
    }

    public GraphQueryResult getRepositoryDescriptions() throws Exception {
        ConnectOptions opts = new ConnectOptions(this.baseServiceURL + "/namespace");
        opts.method = "GET";
        opts.setAcceptHeader(ConnectOptions.DEFAULT_GRAPH_ACCEPT_HEADER);
        return this.graphResults(opts, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRepository(String namespace, Properties properties) throws Exception {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        if (properties.getProperty("com.bigdata.rdf.sail.namespace") == null) {
            throw new IllegalArgumentException("Property not defined: com.bigdata.rdf.sail.namespace");
        }
        ConnectOptions opts = new ConnectOptions(this.baseServiceURL + "/namespace");
        opts.method = "POST";
        JettyResponseListener response = null;
        PropertiesFormat format = PropertiesFormat.XML;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PropertiesWriter writer = ((PropertiesWriterFactory)PropertiesWriterRegistry.getInstance().get(format)).getWriter(baos);
        writer.write(properties);
        byte[] data = baos.toByteArray();
        ByteArrayEntity entity = new ByteArrayEntity(data);
        entity.setContentType(format.getDefaultMIMEType());
        opts.entity = entity;
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRepository(String namespace) throws Exception {
        ConnectOptions opts = this.newConnectOptions(this.getRepositoryBaseURLForNamespace(namespace));
        opts.method = "DELETE";
        JettyResponseListener response = null;
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    public Properties getRepositoryProperties(String namespace) throws Exception {
        ConnectOptions opts = this.newConnectOptions(this.getRepositoryBaseURLForNamespace(namespace) + "/properties");
        opts.method = "GET";
        JettyResponseListener response = null;
        opts.setAcceptHeader("application/xml");
        boolean consumeNeeded = true;
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
            String contentType = response.getContentType();
            if (contentType == null) {
                throw new RuntimeException("Not found: Content-Type");
            }
            MiniMime mimeType = new MiniMime(contentType);
            PropertiesFormat format = PropertiesFormat.forMIMEType(mimeType.getMimeType());
            if (format == null) {
                throw new IOException("Could not identify format for service response: serviceURI=" + this.sparqlEndpointURL + ", contentType=" + contentType + " : response=" + response.getResponseBody());
            }
            PropertiesParserFactory factory = (PropertiesParserFactory)PropertiesParserRegistry.getInstance().get(format);
            if (factory == null) {
                throw new RuntimeException("ParserFactory not found: Content-Type=" + contentType + ", format=" + format);
            }
            PropertiesParser parser = factory.getParser();
            Properties properties = parser.parse(response.getInputStream());
            consumeNeeded = false;
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception e) {
            consumeNeeded = !InnerCause.isInnerCause(e, HttpException.class);
            throw e;
        }
        finally {
            if (response != null && consumeNeeded) {
                response.abort();
            }
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.m_closed) {
            return;
        }
        if (this.httpClient instanceof AutoCloseable) {
            ((AutoCloseable)this.httpClient).close();
        }
        this.m_closed = true;
    }
}

