/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.rdf.sparql.ast.QueryNodeBase;
import com.bigdata.rdf.sparql.ast.SolutionModifierBase;
import java.util.Map;

public class SliceNode
extends SolutionModifierBase {
    private static final long serialVersionUID = 1L;

    public SliceNode(SliceNode op) {
        super(op);
    }

    public SliceNode(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public SliceNode() {
    }

    public SliceNode(long offset, long limit) {
        this.setOffset(offset);
        this.setLimit(limit);
    }

    public void setOffset(long offset) {
        this.setProperty("offset", offset);
    }

    public long getOffset() {
        return this.getProperty("offset", 0L);
    }

    public void setLimit(long limit) {
        this.setProperty("limit", limit);
    }

    public long getLimit() {
        return this.getProperty("limit", Long.MAX_VALUE);
    }

    public boolean hasSlice() {
        return this.getOffset() > 0L || this.getLimit() < Long.MAX_VALUE;
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(SliceNode.indent(indent));
        sb.append("slice(");
        long offset = this.getOffset();
        long limit = this.getLimit();
        if (offset != 0L) {
            sb.append("offset=" + offset);
        }
        if (limit != Long.MAX_VALUE) {
            if (offset != 0L) {
                sb.append(",");
            }
            sb.append("limit=" + limit);
        }
        sb.append(")");
        if (this.getQueryHints() != null && !this.getQueryHints().isEmpty()) {
            sb.append("\n");
            sb.append(SliceNode.indent(indent + 1));
            sb.append("queryHints");
            sb.append("=");
            sb.append(this.getQueryHints().toString());
        }
        return sb.toString();
    }

    static interface Annotations
    extends QueryNodeBase.Annotations {
        public static final String OFFSET = "offset";
        public static final long DEFAULT_OFFSET = 0L;
        public static final String LIMIT = "limit";
        public static final long DEFAULT_LIMIT = Long.MAX_VALUE;
    }
}

