/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GroupMemberNodeBase;
import com.bigdata.rdf.sparql.ast.IJoinNode;
import com.bigdata.rdf.sparql.ast.IReorderableNode;
import com.bigdata.rdf.sparql.ast.IStatementContainer;
import com.bigdata.rdf.sparql.ast.RangeNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpBase;
import com.bigdata.rdf.sparql.ast.optimizers.StaticOptimizer;
import com.bigdata.striterator.IKeyOrder;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.query.algebra.StatementPattern;

public class StatementPatternNode
extends GroupMemberNodeBase<StatementPatternNode>
implements IJoinNode,
IStatementContainer,
IReorderableNode {
    private static final long serialVersionUID = 1L;

    public StatementPatternNode(StatementPatternNode op) {
        super(op);
    }

    public StatementPatternNode(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
    }

    public StatementPatternNode(TermNode s, TermNode p, TermNode o) {
        this(s, p, o, null, StatementPattern.Scope.DEFAULT_CONTEXTS);
    }

    public StatementPatternNode(TermNode s, TermNode p, TermNode o, TermNode c, StatementPattern.Scope scope) {
        super(new BOp[]{s, p, o, c}, scope == null ? null : NV.asMap(new NV("scope", scope)));
        if (scope == null) {
            throw new IllegalArgumentException();
        }
        if (s == null || p == null || o == null) {
            throw new IllegalArgumentException();
        }
        if (scope == StatementPattern.Scope.NAMED_CONTEXTS && c == null) {
            throw new IllegalArgumentException();
        }
    }

    public final TermNode s() {
        return this.get(0);
    }

    public final TermNode p() {
        return this.get(1);
    }

    public final TermNode o() {
        return this.get(2);
    }

    public final TermNode c() {
        return this.get(3);
    }

    @Override
    public TermNode get(int i) {
        return (TermNode)super.get(i);
    }

    public final void setC(TermNode c) {
        this.setArg(3, c);
    }

    public final VarNode sid() {
        return (VarNode)this.getProperty("sid");
    }

    public final void setSid(VarNode sid) {
        this.setProperty("sid", sid);
    }

    public final StatementPattern.Scope getScope() {
        return (StatementPattern.Scope)this.getRequiredProperty("scope");
    }

    public final void setScope(StatementPattern.Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException();
        }
        this.setProperty("scope", scope);
    }

    public final VarNode getFastRangeCountVar() {
        return (VarNode)this.getProperty("fastRangeCountVar");
    }

    public final void setFastRangeCount(VarNode var) {
        if (var == null) {
            throw new IllegalArgumentException();
        }
        this.setProperty("fastRangeCountVar", var);
    }

    public final VarNode getDistinctTermScanVar() {
        return (VarNode)this.getProperty("distinctTermScanVar");
    }

    public final void setDistinctTermScanVar(VarNode var) {
        this.setProperty("distinctTermScanVar", var);
    }

    @Override
    public final boolean isOptional() {
        return this.getProperty("optional", false);
    }

    @Override
    public final boolean isMinus() {
        return false;
    }

    public final void setOptional(boolean optional) {
        this.setProperty("optional", optional);
    }

    public final void setRange(RangeNode range) {
        this.setProperty("range", range);
    }

    public final RangeNode getRange() {
        return (RangeNode)this.getProperty("range");
    }

    @Override
    public final List<FilterNode> getAttachedJoinFilters() {
        List filters = (List)this.getProperty("filters");
        if (filters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(filters);
    }

    @Override
    public final void setAttachedJoinFilters(List<FilterNode> filters) {
        this.setProperty("filters", filters);
    }

    public boolean isGround() {
        if (this.s() instanceof VarNode) {
            return false;
        }
        if (this.p() instanceof VarNode) {
            return false;
        }
        if (this.o() instanceof VarNode) {
            return false;
        }
        return !(this.c() instanceof VarNode);
    }

    public Set<IVariable<?>> getProducedBindings() {
        LinkedHashSet producedBindings = new LinkedHashSet();
        TermNode s = this.s();
        TermNode p = this.p();
        TermNode o = this.o();
        TermNode c = this.c();
        this.addProducedBindings(s, producedBindings);
        this.addProducedBindings(p, producedBindings);
        this.addProducedBindings(o, producedBindings);
        this.addProducedBindings(c, producedBindings);
        return producedBindings;
    }

    private void addProducedBindings(TermNode t, Set<IVariable<?>> producedBindings) {
        ConstantNode cNode;
        Constant c;
        IVariable var;
        if (t instanceof VarNode) {
            producedBindings.add((IVariable<?>)((VarNode)t).getValueExpression());
        } else if (t instanceof ConstantNode && (var = (c = (Constant)(cNode = (ConstantNode)t).getValueExpression()).getVar()) != null) {
            producedBindings.add(var);
        }
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append(StatementPatternNode.indent(indent)).append(this.toShortString());
        List<FilterNode> filters = this.getAttachedJoinFilters();
        if (!filters.isEmpty()) {
            for (FilterNode filter : filters) {
                sb.append(filter.toString(indent + 1));
            }
        }
        if (this.getQueryHints() != null && !this.getQueryHints().isEmpty()) {
            sb.append("\n");
            sb.append(StatementPatternNode.indent(indent + 1));
            this.shortenName(sb, "queryHints");
            sb.append("=");
            sb.append(this.getQueryHints().toString());
        }
        Long rangeCount = (Long)this.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY);
        IKeyOrder keyOrder = (IKeyOrder)this.getProperty(AST2BOpBase.Annotations.ORIGINAL_INDEX);
        if (rangeCount != null) {
            sb.append("\n");
            sb.append(StatementPatternNode.indent(indent + 1));
            this.shortenName(sb, AST2BOpBase.Annotations.ESTIMATED_CARDINALITY);
            sb.append("=");
            sb.append(rangeCount.toString());
        }
        if (keyOrder != null) {
            sb.append("\n");
            sb.append(StatementPatternNode.indent(indent + 1));
            this.shortenName(sb, AST2BOpBase.Annotations.ORIGINAL_INDEX);
            sb.append("=");
            sb.append(keyOrder.toString());
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        VarNode distinctTermScanVar;
        VarNode fastRangeCountVar;
        StatementPattern.Scope scope;
        StringBuilder sb = new StringBuilder();
        Integer id = (Integer)this.getProperty(BOp.Annotations.BOP_ID);
        sb.append("StatementPatternNode");
        if (id != null) {
            sb.append("[").append(id.toString()).append("]");
        }
        sb.append("(");
        sb.append(this.s()).append(", ");
        sb.append(this.p()).append(", ");
        sb.append(this.o());
        TermNode c = this.c();
        if (c != null) {
            sb.append(", ").append(c);
        }
        sb.append(")");
        VarNode sid = this.sid();
        if (sid != null) {
            sb.append(" [sid=" + sid + "]");
        }
        if ((scope = this.getScope()) != null) {
            sb.append(" [scope=" + scope + "]");
        }
        if ((fastRangeCountVar = this.getFastRangeCountVar()) != null) {
            sb.append(" [fastRangeCount=" + fastRangeCountVar + "]");
        }
        if ((distinctTermScanVar = this.getDistinctTermScanVar()) != null) {
            sb.append(" [distinctTermScan=" + distinctTermScanVar + "]");
        }
        if (this.isOptional()) {
            sb.append(" [optional]");
        }
        if (!this.getAttachedJoinFilters().isEmpty()) {
            sb.append(" [#filters=" + this.getAttachedJoinFilters().size() + "]");
        }
        return sb.toString();
    }

    @Override
    public boolean isReorderable() {
        return !this.isOptional();
    }

    @Override
    public long getEstimatedCardinality(StaticOptimizer opt) {
        return this.getProperty(AST2BOpBase.Annotations.ESTIMATED_CARDINALITY, -1L);
    }

    public static interface Annotations
    extends GroupMemberNodeBase.Annotations,
    IJoinNode.Annotations {
        public static final String SCOPE = "scope";
        public static final String DISTINCT = "distinct";
        public static final boolean DEFAULT_DISTINCT = false;
        public static final String EXISTS = "exists";
        public static final String INLINE = "inline";
        public static final String RANGE = "range";
        public static final String SID = "sid";
        public static final String FAST_RANGE_COUNT_VAR = "fastRangeCountVar";
        public static final String DISTINCT_TERM_SCAN_VAR = "distinctTermScanVar";
    }
}

