/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.store.BD;
import java.util.concurrent.atomic.AtomicLong;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;
import org.openrdf.sail.SailException;

public class AST2BOpUpdateContext
extends AST2BOpContext {
    public final BigdataSail sail;
    public final BigdataValueFactory f;
    public final BigdataSailRepositoryConnection conn;
    private boolean includeInferred;
    private QueryBindingSet qbs;
    private IBindingSet[] bindingSets;
    private AtomicLong commitTime = new AtomicLong(-1L);
    private BigdataURI nullGraph = null;

    public final boolean isIncludeInferred() {
        return this.includeInferred;
    }

    public final void setIncludeInferred(boolean includeInferred) {
        this.includeInferred = includeInferred;
    }

    public long getCommitTime() {
        return this.commitTime.get();
    }

    public void setCommitTime(long commitTime) {
        this.commitTime.set(commitTime);
    }

    public AST2BOpUpdateContext(ASTContainer astContainer, BigdataSailRepositoryConnection conn) throws SailException {
        super(astContainer, conn.getSailConnection().getBigdataSail().getDatabase());
        this.conn = conn;
        this.sail = conn.getSailConnection().getBigdataSail();
        this.f = (BigdataValueFactory)this.sail.getValueFactory();
    }

    @Override
    public long getTimestamp() {
        return this.conn.getTripleStore().getTimestamp();
    }

    public BigdataURI getNullGraph() {
        if (this.nullGraph == null) {
            this.nullGraph = this.db.getValueFactory().asValue(BD.NULL_GRAPH);
            this.db.addTerm(this.nullGraph);
            this.nullGraph.getIV().setValue(this.nullGraph);
        }
        return this.nullGraph;
    }

    public IBindingSet[] getBindings() {
        return this.bindingSets;
    }

    public void setBindings(IBindingSet[] bindingSets) {
        this.bindingSets = bindingSets;
    }

    public QueryBindingSet getQueryBindingSet() {
        return this.qbs;
    }

    public void setQueryBindingSet(QueryBindingSet qbs) {
        this.qbs = qbs;
    }
}

