/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpBase;
import com.bigdata.bop.BOpEvaluationContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Bind;
import com.bigdata.bop.BufferAnnotations;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBind;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.NV;
import com.bigdata.bop.NamedSolutionSetRefUtility;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.Var;
import com.bigdata.bop.aggregate.IAggregate;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.bop.bindingSet.EmptyBindingSet;
import com.bigdata.bop.bset.ConditionalRoutingOp;
import com.bigdata.bop.bset.CopyOp;
import com.bigdata.bop.bset.EndOp;
import com.bigdata.bop.bset.StartOp;
import com.bigdata.bop.bset.Tee;
import com.bigdata.bop.controller.AbstractSubqueryOp;
import com.bigdata.bop.controller.HTreeNamedSubqueryOp;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.controller.JVMNamedSubqueryOp;
import com.bigdata.bop.controller.ServiceCallJoin;
import com.bigdata.bop.controller.SubqueryOp;
import com.bigdata.bop.controller.Union;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.join.HTreeHashIndexOp;
import com.bigdata.bop.join.HTreeMergeJoin;
import com.bigdata.bop.join.HTreeSolutionSetHashJoinOp;
import com.bigdata.bop.join.HashIndexOp;
import com.bigdata.bop.join.HashJoinAnnotations;
import com.bigdata.bop.join.JVMHashIndexOp;
import com.bigdata.bop.join.JVMMergeJoin;
import com.bigdata.bop.join.JVMSolutionSetHashJoinOp;
import com.bigdata.bop.join.JoinAnnotations;
import com.bigdata.bop.join.JoinTypeEnum;
import com.bigdata.bop.join.NestedLoopJoinOp;
import com.bigdata.bop.join.SolutionSetHashJoinOp;
import com.bigdata.bop.paths.ArbitraryLengthPathOp;
import com.bigdata.bop.paths.ZeroLengthPathOp;
import com.bigdata.bop.rdf.join.ChunkedMaterializationOp;
import com.bigdata.bop.rdf.join.DataSetJoin;
import com.bigdata.bop.rdf.join.MockTermResolverOp;
import com.bigdata.bop.rdf.join.VariableUnificationOp;
import com.bigdata.bop.solutions.DropOp;
import com.bigdata.bop.solutions.GroupByOp;
import com.bigdata.bop.solutions.GroupByRewriter;
import com.bigdata.bop.solutions.GroupByState;
import com.bigdata.bop.solutions.HTreeDistinctBindingSetsOp;
import com.bigdata.bop.solutions.ISortOrder;
import com.bigdata.bop.solutions.IVComparator;
import com.bigdata.bop.solutions.JVMDistinctBindingSetsOp;
import com.bigdata.bop.solutions.MemoryGroupByOp;
import com.bigdata.bop.solutions.MemorySortOp;
import com.bigdata.bop.solutions.PipelinedAggregationOp;
import com.bigdata.bop.solutions.ProjectionOp;
import com.bigdata.bop.solutions.SliceOp;
import com.bigdata.bop.solutions.SortOp;
import com.bigdata.bop.solutions.SortOrder;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.constraints.CoalesceBOp;
import com.bigdata.rdf.internal.constraints.ConditionalBind;
import com.bigdata.rdf.internal.constraints.ContextNotAvailableException;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.InBOp;
import com.bigdata.rdf.internal.constraints.IsBoundBOp;
import com.bigdata.rdf.internal.constraints.MathBOp;
import com.bigdata.rdf.internal.constraints.ProjectedConstraint;
import com.bigdata.rdf.internal.constraints.SPARQLConstraint;
import com.bigdata.rdf.internal.constraints.TryBeforeMaterializationConstraint;
import com.bigdata.rdf.internal.constraints.UUIDBOp;
import com.bigdata.rdf.internal.constraints.XSDBooleanIVValueExpression;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.internal.impl.literal.NumericIV;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.sparql.ast.ASTBase;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.ASTUtil;
import com.bigdata.rdf.sparql.ast.ArbitraryLengthPathNode;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.ComputedMaterializationRequirement;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.FilterExistsModeEnum;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupByNode;
import com.bigdata.rdf.sparql.ast.HavingNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IGroupNode;
import com.bigdata.rdf.sparql.ast.ISolutionSetStats;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.OrderByExpr;
import com.bigdata.rdf.sparql.ast.OrderByNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryOptimizerEnum;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.RangeNode;
import com.bigdata.rdf.sparql.ast.SliceNode;
import com.bigdata.rdf.sparql.ast.SolutionSetStatserator;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.ZeroLengthPathNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpBase;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpRTO;
import com.bigdata.rdf.sparql.ast.service.ServiceCall;
import com.bigdata.rdf.sparql.ast.service.ServiceCallUtility;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import com.bigdata.rdf.spo.DistinctTermAdvancer;
import com.bigdata.rdf.spo.ExplicitSPOFilter;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.ElementFilter;
import com.bigdata.striterator.Chunkerator;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.NOPFilter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;

public class AST2BOpUtility
extends AST2BOpRTO {
    private static final transient Logger log = Logger.getLogger(AST2BOpUtility.class);

    static PipelineOp convert(AST2BOpContext ctx, IBindingSet[] bindingSets) {
        ASTContainer astContainer = ctx.astContainer;
        QueryRoot originalQuery = astContainer.getOriginalAST();
        ctx.setSolutionSetStats(SolutionSetStatserator.get(bindingSets));
        QueryRoot optimizedQuery = (QueryRoot)ctx.optimizers.optimize(ctx, originalQuery, bindingSets);
        astContainer.setOptimizedAST(optimizedQuery);
        ctx.sa = new StaticAnalysis(optimizedQuery, ctx);
        LinkedHashSet doneSet = new LinkedHashSet();
        boolean materializeProjection = ctx.materializeProjectionInQuery && !optimizedQuery.hasSlice();
        PipelineOp left = AST2BOpUtility.convertQueryBaseWithScopedVars(null, optimizedQuery, doneSet, materializeProjection, ctx);
        if (left == null) {
            left = AST2BOpUtility.addStartOp(optimizedQuery, ctx);
        }
        left = (PipelineOp)left.setProperty(QueryEngine.Annotations.QUERY_ID, ctx.queryId);
        astContainer.setQueryPlan(left);
        if (log.isInfoEnabled()) {
            log.info((Object)astContainer);
        }
        return left;
    }

    private static PipelineOp convertQueryBase(PipelineOp left, QueryBase query, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        ProjectionNode projection = query.getProjection();
        IVariable[] projectedVars = projection == null || projection.isEmpty() ? null : projection.getProjectionVars();
        List<Object> projectedVarList = projectedVars == null ? new LinkedList() : Arrays.asList(projectedVars);
        LinkedHashSet tmp = new LinkedHashSet();
        tmp.addAll(doneSet);
        tmp.retainAll(projectedVarList);
        left = AST2BOpUtility.convertQueryBaseWithScopedVars(left, query, tmp, false, ctx);
        tmp.retainAll(projectedVarList);
        doneSet.addAll(tmp);
        return left;
    }

    private static PipelineOp convertQueryBaseWithScopedVars(PipelineOp left, QueryBase queryBase, Set<IVariable<?>> doneSet, boolean materializeProjection, AST2BOpContext ctx) {
        ProjectionNode projection;
        NamedSubqueriesNode namedSubqueries;
        GraphPatternGroup root = queryBase.getWhereClause();
        if (root == null) {
            throw new IllegalArgumentException("No group node");
        }
        if (left == null) {
            left = AST2BOpUtility.addStartOpOnCluster(queryBase, ctx);
        }
        if (queryBase instanceof QueryRoot && (namedSubqueries = ((QueryRoot)queryBase).getNamedSubqueries()) != null && !namedSubqueries.isEmpty()) {
            left = AST2BOpUtility.addNamedSubqueries(left, namedSubqueries, (QueryRoot)queryBase, doneSet, ctx);
        }
        left = AST2BOpUtility.convertJoinGroupOrUnion(left, root, doneSet, ctx);
        OrderByNode orderBy = queryBase.getOrderBy();
        ProjectionNode projectionNode = queryBase.getProjection() == null ? null : (projection = queryBase.getProjection().isEmpty() ? null : queryBase.getProjection());
        if (projection != null) {
            boolean preserveOrder;
            GroupByNode groupBy;
            if (projection.isWildcard()) {
                throw new AssertionError((Object)"Wildcard projection was not rewritten.");
            }
            GroupByNode groupByNode = queryBase.getGroupBy() == null ? null : (groupBy = queryBase.getGroupBy().isEmpty() ? null : queryBase.getGroupBy());
            HavingNode having = queryBase.getHaving() == null ? null : (queryBase.getHaving().isEmpty() ? null : queryBase.getHaving());
            boolean isAggregate = StaticAnalysis.isAggregate(projection, groupBy, having);
            if (isAggregate) {
                left = AST2BOpUtility.addAggregation(left, projection, groupBy, having, ctx);
            } else {
                for (AssignmentNode assignmentNode : projection.getAssignmentProjections()) {
                    left = AST2BOpUtility.addAssignment(left, assignmentNode, doneSet, projection.getQueryHints(), ctx, true);
                }
            }
            if (orderBy != null && !orderBy.isEmpty()) {
                preserveOrder = true;
                left = AST2BOpUtility.addOrderBy(left, queryBase, orderBy, ctx);
            } else {
                preserveOrder = false;
            }
            if (projection.isDistinct() || projection.isReduced()) {
                left = AST2BOpUtility.addDistinct(left, queryBase, preserveOrder, ctx);
            }
        } else if (orderBy != null && !orderBy.isEmpty()) {
            left = AST2BOpUtility.addOrderBy(left, queryBase, orderBy, ctx);
        }
        if (projection != null) {
            boolean preserveOrder = orderBy != null;
            IVariable[] projectedVars = projection.getProjectionVars();
            LinkedList<NV> anns = new LinkedList<NV>();
            anns.add(new NV(BOp.Annotations.BOP_ID, ctx.nextId()));
            anns.add(new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER));
            anns.add(new NV(PipelineOp.Annotations.SHARED_STATE, true));
            anns.add(new NV(ProjectionOp.Annotations.SELECT, projectedVars));
            if (preserveOrder) {
                anns.add(new NV(PipelineOp.Annotations.MAX_PARALLEL, 1));
                anns.add(new NV(SliceOp.Annotations.REORDER_SOLUTIONS, false));
            }
            left = AST2BOpUtility.applyQueryHints((PipelineOp)new ProjectionOp(AST2BOpUtility.leftOrEmpty(left), anns.toArray(new NV[anns.size()])), queryBase, ctx);
            if (materializeProjection) {
                Set<IVariable<IVariable<?>>> tmp = projection.getProjectionVars(new LinkedHashSet());
                tmp.removeAll(doneSet);
                if (!tmp.isEmpty()) {
                    long timestamp = ctx.getLexiconReadTimestamp();
                    String ns = ctx.getLexiconNamespace();
                    IVariable[] vars = tmp.toArray(new IVariable[tmp.size()]);
                    LinkedList<NV> anns2 = new LinkedList<NV>();
                    anns2.add(new NV(ChunkedMaterializationOp.Annotations.VARS, vars));
                    anns2.add(new NV(ChunkedMaterializationOp.Annotations.RELATION_NAME, new String[]{ns}));
                    anns2.add(new NV(ChunkedMaterializationOp.Annotations.TIMESTAMP, timestamp));
                    anns2.add(new NV(ChunkedMaterializationOp.Annotations.MATERIALIZE_INLINE_IVS, true));
                    anns2.add(new NV(PipelineOp.Annotations.SHARED_STATE, !ctx.isCluster()));
                    anns2.add(new NV(BOp.Annotations.BOP_ID, ctx.nextId()));
                    if (preserveOrder) {
                        anns2.add(new NV(PipelineOp.Annotations.MAX_PARALLEL, 1));
                        anns2.add(new NV(SliceOp.Annotations.REORDER_SOLUTIONS, false));
                    }
                    left = AST2BOpUtility.applyQueryHints((PipelineOp)new ChunkedMaterializationOp(AST2BOpUtility.leftOrEmpty(left), anns2.toArray(new NV[anns2.size()])), queryBase, ctx);
                    doneSet.addAll(tmp);
                }
            }
        }
        if (queryBase.hasSlice()) {
            left = AST2BOpUtility.addSlice(left, queryBase, queryBase.getSlice(), ctx);
        }
        left = AST2BOpUtility.addEndOp(left, ctx);
        long timeout = queryBase.getTimeout();
        if (timeout > 0L && timeout != Long.MAX_VALUE) {
            left = (PipelineOp)left.setProperty(BOp.Annotations.TIMEOUT, timeout);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("\nqueryOrSubquery:\n" + queryBase + "\nplan:\n" + BOpUtility.toString(left)));
        }
        return left;
    }

    private static PipelineOp addNamedSubqueries(PipelineOp left, NamedSubqueriesNode namedSubquerieNode, QueryRoot queryRoot, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        LinkedList runFirst = new LinkedList();
        LinkedList<NamedSubqueryRoot> remainder = new LinkedList<NamedSubqueryRoot>();
        for (NamedSubqueryRoot subqueryRoot : namedSubquerieNode) {
            String[] dependsOn = subqueryRoot.getDependsOn();
            if (dependsOn.length == 0) {
                // empty if block
            }
            remainder.add(subqueryRoot);
        }
        int nfirst = runFirst.size();
        if (nfirst > 0) {
            if (nfirst == 1) {
                left = AST2BOpUtility.addNamedSubquery(left, (NamedSubqueryRoot)runFirst.get(0), doneSet, ctx);
            } else {
                PipelineOp[] steps = new PipelineOp[nfirst];
                int i = 0;
                for (NamedSubqueryRoot subqueryRoot : runFirst) {
                    steps[i++] = AST2BOpUtility.addNamedSubquery(null, subqueryRoot, doneSet, ctx);
                }
                int maxParallelSubqueries = Math.min(steps.length, 10);
                left = new Union(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(AbstractSubqueryOp.Annotations.SUBQUERIES, steps), new NV(AbstractSubqueryOp.Annotations.MAX_PARALLEL_SUBQUERIES, maxParallelSubqueries));
            }
        }
        for (NamedSubqueryRoot subqueryRoot : remainder) {
            left = AST2BOpUtility.addNamedSubquery(left, subqueryRoot, doneSet, ctx);
        }
        return left;
    }

    private static PipelineOp addNamedSubquery(PipelineOp left, NamedSubqueryRoot subqueryRoot, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        PipelineOp subqueryPlan = AST2BOpUtility.convertQueryBase(null, subqueryRoot, doneSet, ctx);
        subqueryRoot.setProperty("doneSet", doneSet);
        if (log.isInfoEnabled()) {
            log.info((Object)("\nsubquery: " + subqueryRoot + "\nplan=" + subqueryPlan));
        }
        IVariable[] joinVars = ASTUtil.convert(subqueryRoot.getJoinVars());
        INamedSolutionSetRef namedSolutionSet = NamedSolutionSetRefUtility.newInstance(ctx.queryId, subqueryRoot.getName(), joinVars);
        left = ctx.nativeHashJoins ? AST2BOpUtility.applyQueryHints((PipelineOp)new HTreeNamedSubqueryOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.PIPELINED, false), new NV(PipelineOp.Annotations.MAX_MEMORY, Long.MAX_VALUE), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(HTreeNamedSubqueryOp.Annotations.RELATION_NAME, new String[]{ctx.getLexiconNamespace()}), new NV(HTreeNamedSubqueryOp.Annotations.SUBQUERY, subqueryPlan), new NV(HTreeNamedSubqueryOp.Annotations.JOIN_VARS, joinVars), new NV("namedSetRef", namedSolutionSet)), subqueryRoot, ctx) : AST2BOpUtility.applyQueryHints((PipelineOp)new JVMNamedSubqueryOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.PIPELINED, false), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(HTreeNamedSubqueryOp.Annotations.SUBQUERY, subqueryPlan), new NV(HTreeNamedSubqueryOp.Annotations.JOIN_VARS, joinVars), new NV("namedSetRef", namedSolutionSet)), subqueryRoot, ctx);
        return left;
    }

    private static PipelineOp addServiceCall(PipelineOp left, ServiceNode serviceNode, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        boolean isMaterialize;
        Properties queryHints = serviceNode.getQueryHints();
        LinkedHashMap<IConstraint, Set<IVariable<IV>>> needsMaterialization = new LinkedHashMap<IConstraint, Set<IVariable<IV>>>();
        IConstraint[] joinConstraints = AST2BOpUtility.getJoinConstraints(AST2BOpUtility.getJoinConstraints(serviceNode), needsMaterialization);
        IValueExpression serviceRef = serviceNode.getServiceRef().getValueExpression();
        if (serviceRef instanceof IConstant) {
            BigdataURI serviceURI = ServiceCallUtility.getConstantServiceURI(serviceRef);
            ServiceCall<? extends Object> serviceCall = ServiceRegistry.getInstance().toServiceCall(ctx.db, ctx.queryEngine.getClientConnectionManager(), serviceURI, serviceNode);
            boolean isBigdata = serviceCall.getServiceOptions().isBigdataNativeService();
            isMaterialize = !isBigdata;
        } else {
            isMaterialize = true;
        }
        Set<IVariable<?>> projectedVars = ctx.sa.getMaybeProducedBindings(serviceNode);
        Iterator<IVariable<?>> itr = projectedVars.iterator();
        while (itr.hasNext()) {
            IVariable<?> v = itr.next();
            if (!v.getName().startsWith("-anon-")) continue;
            itr.remove();
        }
        serviceNode.setProjectedVars(projectedVars);
        int rightId = ctx.nextId();
        if (isMaterialize) {
            Set<IVariable<?>> maybeBound = ctx.sa.getMaybeIncomingBindings(serviceNode, new LinkedHashSet());
            LinkedHashSet<IVariable<IV>> vars = new LinkedHashSet<IVariable<IV>>();
            vars.addAll(projectedVars);
            vars.retainAll(maybeBound);
            if (serviceRef instanceof IVariable) {
                vars.add((IVariable)serviceRef);
            }
            vars.removeAll(doneSet);
            if (!vars.isEmpty()) {
                left = AST2BOpUtility.addMaterializationSteps2(left, rightId, vars, queryHints, ctx);
                doneSet.addAll(vars);
            }
        }
        Set<IVariable<?>> joinVarSet = ctx.sa.getJoinVars(serviceNode, new LinkedHashSet());
        LinkedHashMap<String, Object> anns = new LinkedHashMap<String, Object>();
        anns.put(BOp.Annotations.BOP_ID, rightId);
        anns.put(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER);
        anns.put(PipelineOp.Annotations.PIPELINED, false);
        anns.put(PipelineOp.Annotations.SHARED_STATE, true);
        anns.put(ServiceCallJoin.Annotations.SERVICE_NODE, serviceNode);
        anns.put(ServiceCallJoin.Annotations.NAMESPACE, ctx.getNamespace());
        anns.put(ServiceCallJoin.Annotations.TIMESTAMP, ctx.getTimestamp());
        anns.put(ServiceCallJoin.Annotations.JOIN_VARS, joinVarSet.toArray(new IVariable[0]));
        anns.put(JoinAnnotations.CONSTRAINTS, joinConstraints);
        left = AST2BOpUtility.applyQueryHints((PipelineOp)new ServiceCallJoin(AST2BOpUtility.leftOrEmpty(left), anns), queryHints, ctx);
        left = AST2BOpUtility.addMaterializationSteps3(left, doneSet, needsMaterialization, queryHints, ctx);
        return left;
    }

    private static PipelineOp addNamedSubqueryInclude(PipelineOp left, NamedSubqueryInclude nsi, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        boolean release;
        IVariable[] joinVars;
        Object joinvars;
        NamedSubqueryRoot nsr;
        String name = nsi.getName();
        if (log.isInfoEnabled()) {
            log.info((Object)("include: solutionSet=" + name));
        }
        if ((nsr = ctx.sa.getNamedSubqueryRoot(name)) != null) {
            Set nsrDoneSet = (Set)nsr.getProperty("doneSet");
            if (nsrDoneSet == null) {
                throw new AssertionError((Object)("NamedSubqueryRoot doneSet not found: " + name));
            }
            doneSet.addAll(nsrDoneSet);
            joinvars = nsi.getJoinVars();
            if (joinvars == null) {
                throw new AssertionError();
            }
            joinVars = ASTUtil.convert((VarNode[])joinvars);
            release = false;
        } else {
            ISolutionSetStats stats = ctx.sa.getSolutionSetStats(name);
            doneSet.addAll(stats.getMaterialized());
            if (AST2BOpUtility.isNamedSolutionSetScan(ctx, nsi)) {
                return AST2BOpUtility.convertNamedSolutionSetScan(left, nsi, doneSet, ctx);
            }
            joinvars = ctx.sa.getJoinVars(nsi, name, new LinkedHashSet());
            joinVars = joinvars.toArray(new IVariable[0]);
            Object selectVars = null;
            INamedSolutionSetRef sourceSet = NamedSolutionSetRefUtility.newInstance(ctx.getNamespace(), ctx.getTimestamp(), name, IVariable.EMPTY);
            INamedSolutionSetRef generatedSet = NamedSolutionSetRefUtility.newInstance(ctx.queryId, name, joinVars);
            JoinTypeEnum joinType = JoinTypeEnum.Normal;
            left = ctx.nativeHashJoins ? AST2BOpUtility.applyQueryHints((PipelineOp)new HTreeHashIndexOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.LAST_PASS, true), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(HTreeHashIndexOp.Annotations.RELATION_NAME, new String[]{ctx.getLexiconNamespace()}), new NV(HashIndexOp.Annotations.JOIN_TYPE, (Object)joinType), new NV(HashIndexOp.Annotations.JOIN_VARS, joinVars), new NV(HashIndexOp.Annotations.SELECT, selectVars), new NV("namedSetSourceRef", sourceSet), new NV("namedSetRef", generatedSet)), nsi, ctx) : AST2BOpUtility.applyQueryHints((PipelineOp)new JVMHashIndexOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.LAST_PASS, true), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(HashIndexOp.Annotations.JOIN_TYPE, (Object)joinType), new NV(HashIndexOp.Annotations.JOIN_VARS, joinVars), new NV(HashIndexOp.Annotations.SELECT, selectVars), new NV("namedSetSourceRef", sourceSet), new NV("namedSetRef", generatedSet)), nsi, ctx);
            release = true;
        }
        INamedSolutionSetRef namedSolutionSetRef = NamedSolutionSetRefUtility.newInstance(ctx.queryId, name, joinVars);
        LinkedHashMap<IConstraint, Set<IVariable<IV>>> needsMaterialization = new LinkedHashMap<IConstraint, Set<IVariable<IV>>>();
        IConstraint[] joinConstraints = AST2BOpUtility.getJoinConstraints(AST2BOpUtility.getJoinConstraints(nsi), needsMaterialization);
        release = false;
        left = ctx.nativeHashJoins ? AST2BOpUtility.applyQueryHints((PipelineOp)new HTreeSolutionSetHashJoinOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV("namedSetRef", namedSolutionSetRef), new NV(SolutionSetHashJoinOp.Annotations.CONSTRAINTS, joinConstraints), new NV(SolutionSetHashJoinOp.Annotations.RELEASE, release)), nsi, ctx) : AST2BOpUtility.applyQueryHints((PipelineOp)new JVMSolutionSetHashJoinOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV("namedSetRef", namedSolutionSetRef), new NV(SolutionSetHashJoinOp.Annotations.CONSTRAINTS, joinConstraints), new NV(SolutionSetHashJoinOp.Annotations.RELEASE, release)), nsi, ctx);
        left = AST2BOpUtility.addMaterializationSteps3(left, doneSet, needsMaterialization, nsi.getQueryHints(), ctx);
        return left;
    }

    private static PipelineOp addValues(PipelineOp left, BindingsClause bindingsClause, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        IBindingSet[] bindingSets = BOpUtility.toArray(new Chunkerator<IBindingSet>(bindingsClause.getBindingSets().iterator()), null);
        ISolutionSetStats bindingsClauseStats = SolutionSetStatserator.get(bindingSets);
        LinkedHashMap<IConstraint, Set<IVariable<IV>>> needsMaterialization = new LinkedHashMap<IConstraint, Set<IVariable<IV>>>();
        IConstraint[] joinConstraints = AST2BOpUtility.getJoinConstraints(AST2BOpUtility.getJoinConstraints(bindingsClause), needsMaterialization);
        String solutionSetName = "--values-" + ctx.nextId();
        Set<IVariable<?>> joinVarSet = ctx.sa.getJoinVars(bindingsClause, bindingsClauseStats, new LinkedHashSet());
        IVariable[] joinVars = joinVarSet.toArray(new IVariable[0]);
        INamedSolutionSetRef namedSolutionSet = NamedSolutionSetRefUtility.newInstance(ctx.queryId, solutionSetName, joinVars);
        JoinTypeEnum joinType = JoinTypeEnum.Normal;
        boolean lastPass = false;
        boolean release = false;
        int maxParallel = ctx.maxParallelForSolutionSetHashJoin;
        left = ctx.nativeHashJoins ? AST2BOpUtility.applyQueryHints((PipelineOp)new HTreeHashIndexOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.LAST_PASS, true), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(HTreeHashIndexOp.Annotations.RELATION_NAME, new String[]{ctx.getLexiconNamespace()}), new NV(HTreeHashIndexOp.Annotations.JOIN_TYPE, (Object)joinType), new NV(HTreeHashIndexOp.Annotations.JOIN_VARS, joinVars), new NV(HTreeHashIndexOp.Annotations.CONSTRAINTS, joinConstraints), new NV("bindingSets", bindingSets), new NV("namedSetRef", namedSolutionSet)), bindingsClause, ctx) : AST2BOpUtility.applyQueryHints((PipelineOp)new JVMHashIndexOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.LAST_PASS, true), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(JVMHashIndexOp.Annotations.JOIN_TYPE, (Object)joinType), new NV(JVMHashIndexOp.Annotations.JOIN_VARS, joinVars), new NV(JVMHashIndexOp.Annotations.CONSTRAINTS, joinConstraints), new NV("bindingSets", bindingSets), new NV("namedSetRef", namedSolutionSet)), bindingsClause, ctx);
        left = ctx.nativeHashJoins ? AST2BOpUtility.applyQueryHints((PipelineOp)new HTreeSolutionSetHashJoinOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, maxParallel), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(SolutionSetHashJoinOp.Annotations.RELEASE, false), new NV(SolutionSetHashJoinOp.Annotations.LAST_PASS, false), new NV("namedSetRef", namedSolutionSet)), bindingsClause, ctx) : AST2BOpUtility.applyQueryHints((PipelineOp)new JVMSolutionSetHashJoinOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, maxParallel), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(SolutionSetHashJoinOp.Annotations.RELEASE, false), new NV(SolutionSetHashJoinOp.Annotations.LAST_PASS, false), new NV("namedSetRef", namedSolutionSet)), bindingsClause, ctx);
        left = AST2BOpUtility.addMaterializationSteps3(left, doneSet, needsMaterialization, bindingsClause.getQueryHints(), ctx);
        return left;
    }

    private static boolean isNamedSolutionSetScan(AST2BOpContext ctx, NamedSubqueryInclude nsi) {
        ISolutionSetStats exogenousStats;
        QueryBase dominatingQuery;
        boolean firstInJoinGroup;
        JoinGroupNode parentJoinGroup = nsi.getParentJoinGroup();
        boolean bl = firstInJoinGroup = parentJoinGroup.get(0) == nsi;
        return firstInJoinGroup && parentJoinGroup.getParent() == null && ((dominatingQuery = (QueryBase)ctx.sa.findParent(parentJoinGroup)) instanceof QueryRoot || dominatingQuery instanceof NamedSubqueryRoot) && (exogenousStats = ctx.getSolutionSetStats()).getSolutionSetSize() <= 100L;
    }

    private static PipelineOp convertNamedSolutionSetScan(PipelineOp left, NamedSubqueryInclude nsi, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        LinkedHashMap<IConstraint, Set<IVariable<IV>>> needsMaterialization = new LinkedHashMap<IConstraint, Set<IVariable<IV>>>();
        IConstraint[] joinConstraints = AST2BOpUtility.getJoinConstraints(AST2BOpUtility.getJoinConstraints(nsi), needsMaterialization);
        String name = nsi.getName();
        INamedSolutionSetRef namedSolutionSet = NamedSolutionSetRefUtility.newInstance(ctx.getNamespace(), ctx.getTimestamp(), name, IVariable.EMPTY);
        left = new NestedLoopJoinOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV("namedSetRef", namedSolutionSet), new NV(NestedLoopJoinOp.Annotations.CONSTRAINTS, joinConstraints));
        left = AST2BOpUtility.addMaterializationSteps3(left, doneSet, needsMaterialization, nsi.getQueryHints(), ctx);
        return left;
    }

    private static PipelineOp addSparql11Subquery(PipelineOp left, SubqueryRoot subqueryRoot, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        ProjectionNode projection = subqueryRoot.getProjection();
        IVariable[] projectedVars = projection.getProjectionVars();
        LinkedHashMap<IConstraint, Set<IVariable<IV>>> needsMaterialization = new LinkedHashMap<IConstraint, Set<IVariable<IV>>>();
        IConstraint[] joinConstraints = AST2BOpUtility.getJoinConstraints(AST2BOpUtility.getJoinConstraints(subqueryRoot), needsMaterialization);
        switch (subqueryRoot.getQueryType()) {
            case SELECT: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        String solutionSetName = "--set-" + ctx.nextId();
        Set<IVariable<?>> joinVarSet = ctx.sa.getJoinVars(subqueryRoot, new LinkedHashSet());
        IVariable[] joinVars = joinVarSet.toArray(new IVariable[0]);
        INamedSolutionSetRef namedSolutionSet = NamedSolutionSetRefUtility.newInstance(ctx.queryId, solutionSetName, joinVars);
        JoinTypeEnum joinType = JoinTypeEnum.Normal;
        boolean lastPass = false;
        boolean release = false;
        int maxParallel = ctx.maxParallelForSolutionSetHashJoin;
        left = AST2BOpUtility.addHashIndexOp(left, ctx, subqueryRoot, joinType, joinVars, joinConstraints, projectedVars, namedSolutionSet);
        left = AST2BOpUtility.convertQueryBase(left, subqueryRoot, doneSet, ctx);
        left = ctx.nativeHashJoins ? AST2BOpUtility.applyQueryHints((PipelineOp)new HTreeSolutionSetHashJoinOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, maxParallel), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(SolutionSetHashJoinOp.Annotations.RELEASE, false), new NV(SolutionSetHashJoinOp.Annotations.LAST_PASS, false), new NV("namedSetRef", namedSolutionSet)), subqueryRoot, ctx) : AST2BOpUtility.applyQueryHints((PipelineOp)new JVMSolutionSetHashJoinOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, maxParallel), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(SolutionSetHashJoinOp.Annotations.RELEASE, false), new NV(SolutionSetHashJoinOp.Annotations.LAST_PASS, false), new NV("namedSetRef", namedSolutionSet)), subqueryRoot, ctx);
        left = AST2BOpUtility.addMaterializationSteps3(left, doneSet, needsMaterialization, subqueryRoot.getQueryHints(), ctx);
        return left;
    }

    private static PipelineOp addExistsSubquery(PipelineOp left, SubqueryRoot subqueryRoot, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        FilterExistsModeEnum filterExistsMode = subqueryRoot.getFilterExistsMode();
        switch (filterExistsMode) {
            case VectoredSubPlan: {
                return AST2BOpUtility.addExistsSubqueryFast(left, subqueryRoot, doneSet, ctx);
            }
            case SubQueryLimitOne: {
                return AST2BOpUtility.addExistsSubquerySubquery(left, subqueryRoot, doneSet, ctx);
            }
        }
        throw new UnsupportedOperationException("filterExists=" + (Object)((Object)filterExistsMode));
    }

    private static PipelineOp addExistsSubqueryFast(PipelineOp left, SubqueryRoot subqueryRoot, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        switch (subqueryRoot.getQueryType()) {
            case ASK: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        LinkedHashMap<IConstraint, Set<IVariable<IV>>> needsMaterialization = new LinkedHashMap<IConstraint, Set<IVariable<IV>>>();
        IConstraint[] joinConstraints = AST2BOpUtility.getJoinConstraints(AST2BOpUtility.getJoinConstraints(subqueryRoot), needsMaterialization);
        String solutionSetName = "--set-" + ctx.nextId();
        Set<IVariable<?>> joinVarSet = ctx.sa.getJoinVars(subqueryRoot, new LinkedHashSet());
        IVariable[] joinVars = joinVarSet.toArray(new IVariable[0]);
        INamedSolutionSetRef namedSolutionSet = NamedSolutionSetRefUtility.newInstance(ctx.queryId, solutionSetName, joinVars);
        JoinTypeEnum joinType = JoinTypeEnum.Exists;
        boolean lastPass = true;
        boolean release = true;
        Object selectVars = null;
        IVariable<?> askVar = subqueryRoot.getAskVar();
        if (askVar == null) {
            throw new UnsupportedOperationException();
        }
        left = ctx.nativeHashJoins ? AST2BOpUtility.applyQueryHints((PipelineOp)new HTreeHashIndexOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.LAST_PASS, true), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(HTreeHashIndexOp.Annotations.RELATION_NAME, new String[]{ctx.getLexiconNamespace()}), new NV(HTreeHashIndexOp.Annotations.JOIN_TYPE, (Object)joinType), new NV(HTreeHashIndexOp.Annotations.JOIN_VARS, joinVars), new NV(HTreeHashIndexOp.Annotations.CONSTRAINTS, joinConstraints), new NV(HTreeHashIndexOp.Annotations.SELECT, selectVars), new NV(HTreeHashIndexOp.Annotations.ASK_VAR, askVar), new NV("namedSetRef", namedSolutionSet)), subqueryRoot, ctx) : AST2BOpUtility.applyQueryHints((PipelineOp)new JVMHashIndexOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.LAST_PASS, true), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(JVMHashIndexOp.Annotations.JOIN_TYPE, (Object)joinType), new NV(JVMHashIndexOp.Annotations.JOIN_VARS, joinVars), new NV(JVMHashIndexOp.Annotations.CONSTRAINTS, joinConstraints), new NV(HTreeHashIndexOp.Annotations.SELECT, selectVars), new NV(HTreeHashIndexOp.Annotations.ASK_VAR, askVar), new NV("namedSetRef", namedSolutionSet)), subqueryRoot, ctx);
        left = AST2BOpUtility.convertJoinGroupOrUnion(left, subqueryRoot.getWhereClause(), new LinkedHashSet(doneSet), ctx);
        left = ctx.nativeHashJoins ? AST2BOpUtility.applyQueryHints((PipelineOp)new HTreeSolutionSetHashJoinOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(SolutionSetHashJoinOp.Annotations.RELEASE, true), new NV(SolutionSetHashJoinOp.Annotations.LAST_PASS, true), new NV("namedSetRef", namedSolutionSet)), subqueryRoot, ctx) : AST2BOpUtility.applyQueryHints((PipelineOp)new JVMSolutionSetHashJoinOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(SolutionSetHashJoinOp.Annotations.RELEASE, true), new NV(SolutionSetHashJoinOp.Annotations.LAST_PASS, true), new NV("namedSetRef", namedSolutionSet)), subqueryRoot, ctx);
        left = AST2BOpUtility.addMaterializationSteps3(left, doneSet, needsMaterialization, subqueryRoot.getQueryHints(), ctx);
        return left;
    }

    private static PipelineOp addExistsSubquerySubquery(PipelineOp left, SubqueryRoot subqueryRoot, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        switch (subqueryRoot.getQueryType()) {
            case ASK: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        LinkedHashMap<IConstraint, Set<IVariable<IV>>> needsMaterialization = new LinkedHashMap<IConstraint, Set<IVariable<IV>>>();
        IConstraint[] joinConstraints = AST2BOpUtility.getJoinConstraints(AST2BOpUtility.getJoinConstraints(subqueryRoot), needsMaterialization);
        boolean aggregate = StaticAnalysis.isAggregate(subqueryRoot);
        IVariable<?> askVar = subqueryRoot.getAskVar();
        if (askVar == null) {
            throw new UnsupportedOperationException();
        }
        subqueryRoot.setSlice(new SliceNode(0L, 1L));
        PipelineOp subqueryPlan = AST2BOpUtility.convertQueryBase(null, subqueryRoot, doneSet, ctx);
        left = new SubqueryOp(AST2BOpUtility.leftOrEmpty(left), new NV(Predicate.Annotations.BOP_ID, ctx.nextId()), new NV(SubqueryOp.Annotations.SUBQUERY, subqueryPlan), new NV(SubqueryOp.Annotations.JOIN_TYPE, (Object)JoinTypeEnum.Normal), new NV(SubqueryOp.Annotations.ASK_VAR, askVar), new NV(SubqueryOp.Annotations.SELECT, subqueryRoot.getProjection().getProjectionVars()), new NV(SubqueryOp.Annotations.CONSTRAINTS, joinConstraints), new NV(SubqueryOp.Annotations.IS_AGGREGATE, aggregate));
        left = AST2BOpUtility.addMaterializationSteps3(left, doneSet, needsMaterialization, subqueryRoot.getQueryHints(), ctx);
        return left;
    }

    private static PipelineOp convertJoinGroupOrUnion(PipelineOp left, IGroupNode<? extends IGroupMemberNode> groupNode, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        if (groupNode instanceof UnionNode) {
            return AST2BOpUtility.convertUnion(left, (UnionNode)groupNode, doneSet, ctx);
        }
        if (groupNode instanceof JoinGroupNode) {
            return AST2BOpUtility.convertJoinGroup(left, (JoinGroupNode)groupNode, doneSet, ctx, true);
        }
        throw new IllegalArgumentException();
    }

    private static PipelineOp convertUnion(PipelineOp left, UnionNode unionNode, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        int arity;
        if (unionNode.isOptional()) {
            log.warn((Object)("Optional union? : " + ctx.astContainer));
        }
        if ((arity = unionNode.size()) == 0) {
            throw new IllegalArgumentException();
        }
        int downstreamId = ctx.nextId();
        int[] subqueryIds = new int[arity];
        for (int i = 0; i < arity; ++i) {
            subqueryIds[i] = ctx.nextId();
        }
        int thisTeeId = ctx.nextId();
        int nextTeeId = ctx.nextId();
        for (int j = 0; j < arity - 1; ++j) {
            LinkedList<NV> anns = new LinkedList<NV>();
            anns.add(new NV(BOp.Annotations.BOP_ID, thisTeeId));
            if (j < arity - 2) {
                anns.add(new NV(PipelineOp.Annotations.SINK_REF, nextTeeId));
                anns.add(new NV(PipelineOp.Annotations.ALT_SINK_REF, subqueryIds[j]));
                thisTeeId = nextTeeId;
                nextTeeId = ctx.nextId();
            } else {
                anns.add(new NV(PipelineOp.Annotations.SINK_REF, subqueryIds[j]));
                anns.add(new NV(PipelineOp.Annotations.ALT_SINK_REF, subqueryIds[j + 1]));
            }
            left = AST2BOpUtility.applyQueryHints((PipelineOp)new Tee(AST2BOpUtility.leftOrEmpty(left), NV.asMap(anns.toArray(new NV[anns.size()]))), unionNode, ctx);
        }
        int i = 0;
        LinkedHashSet doneSetsIntersection = new LinkedHashSet(doneSet);
        for (IGroupMemberNode child : unionNode) {
            if (!(child instanceof JoinGroupNode)) {
                throw new RuntimeException("Illegal child type for union: " + child.getClass());
            }
            left = new CopyOp(AST2BOpUtility.leftOrEmpty(left), NV.asMap(new NV(Predicate.Annotations.BOP_ID, subqueryIds[i++])));
            LinkedHashSet tmp = new LinkedHashSet(doneSet);
            PipelineOp subquery = AST2BOpUtility.convertJoinGroup(left, (JoinGroupNode)child, tmp, ctx, false);
            doneSetsIntersection.retainAll(tmp);
            left = (PipelineOp)subquery.setProperty(PipelineOp.Annotations.SINK_REF, downstreamId);
        }
        left = AST2BOpUtility.applyQueryHints((PipelineOp)new CopyOp(AST2BOpUtility.leftOrEmpty(left), new NV(Predicate.Annotations.BOP_ID, downstreamId), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER)), unionNode, ctx);
        doneSet.addAll(doneSetsIntersection);
        return left;
    }

    private static PipelineOp convertArbitraryLengthPath(PipelineOp left, ArbitraryLengthPathNode alpNode, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        Set<IVariable<?>> alpVars = ctx.sa.getDefinitelyProducedBindings(alpNode, new LinkedHashSet(), true);
        Set<IVariable<IVariable<?>>> joinVarsSet = ctx.sa.getDefinitelyIncomingBindings(alpNode, new LinkedHashSet());
        joinVarsSet.retainAll(alpVars);
        IVariable[] joinVars = joinVarsSet.toArray(new IVariable[joinVarsSet.size()]);
        Set<IVariable<IVariable<?>>> projectInVars = ctx.sa.getMaybeIncomingBindings(alpNode, new LinkedHashSet());
        projectInVars.retainAll(alpVars);
        IVariable[] projectInVarsArr = projectInVars.toArray(new IVariable[projectInVars.size()]);
        String solutionSetName = "--set-" + ctx.nextId();
        INamedSolutionSetRef namedSolutionSet = NamedSolutionSetRefUtility.newInstance(ctx.queryId, solutionSetName, joinVars);
        left = AST2BOpUtility.addHashIndexOp(left, ctx, alpNode, JoinTypeEnum.Normal, joinVars, null, projectInVarsArr, namedSolutionSet);
        JoinGroupNode subgroup = alpNode.subgroup();
        PipelineOp subquery = AST2BOpUtility.convertJoinGroup(null, subgroup, doneSet, ctx, false);
        if (ctx.isCluster()) {
            subquery = AST2BOpUtility.applyQueryHints((PipelineOp)new StartOp(BOp.NOARGS, NV.asMap(new NV(Predicate.Annotations.BOP_ID, ctx.nextId()), new NV(SliceOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER))), alpNode, ctx);
        }
        IValueExpression leftTerm = alpNode.left().getValueExpression();
        IValueExpression rightTerm = alpNode.right().getValueExpression();
        IVariableOrConstant tVarLeft = alpNode.tVarLeft().getValueExpression();
        IVariableOrConstant tVarRight = alpNode.tVarRight().getValueExpression();
        left = AST2BOpUtility.applyQueryHints((PipelineOp)new ArbitraryLengthPathOp(AST2BOpUtility.leftOrEmpty(left), new NV(ArbitraryLengthPathOp.Annotations.SUBQUERY, subquery), new NV(ArbitraryLengthPathOp.Annotations.LEFT_TERM, leftTerm), new NV(ArbitraryLengthPathOp.Annotations.RIGHT_TERM, rightTerm), new NV(ArbitraryLengthPathOp.Annotations.TRANSITIVITY_VAR_LEFT, tVarLeft), new NV(ArbitraryLengthPathOp.Annotations.TRANSITIVITY_VAR_RIGHT, tVarRight), new NV(ArbitraryLengthPathOp.Annotations.LOWER_BOUND, alpNode.lowerBound()), new NV(ArbitraryLengthPathOp.Annotations.UPPER_BOUND, alpNode.upperBound()), new NV(Predicate.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER)), alpNode, ctx);
        left = ctx.nativeHashJoins ? AST2BOpUtility.applyQueryHints((PipelineOp)new HTreeSolutionSetHashJoinOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(SolutionSetHashJoinOp.Annotations.CONSTRAINTS, null), new NV(SolutionSetHashJoinOp.Annotations.RELEASE, true), new NV(SolutionSetHashJoinOp.Annotations.LAST_PASS, true), new NV("namedSetRef", namedSolutionSet)), subgroup, ctx) : AST2BOpUtility.applyQueryHints((PipelineOp)new JVMSolutionSetHashJoinOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(SolutionSetHashJoinOp.Annotations.CONSTRAINTS, null), new NV(SolutionSetHashJoinOp.Annotations.RELEASE, true), new NV(SolutionSetHashJoinOp.Annotations.LAST_PASS, true), new NV("namedSetRef", namedSolutionSet)), subgroup, ctx);
        return left;
    }

    private static PipelineOp convertZeroLengthPath(PipelineOp left, ZeroLengthPathNode zlpNode, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        IValueExpression leftTerm = zlpNode.left().getValueExpression();
        IValueExpression rightTerm = zlpNode.right().getValueExpression();
        left = AST2BOpUtility.applyQueryHints((PipelineOp)new ZeroLengthPathOp(AST2BOpUtility.leftOrEmpty(left), new NV(ZeroLengthPathOp.Annotations.LEFT_TERM, leftTerm), new NV(ZeroLengthPathOp.Annotations.RIGHT_TERM, rightTerm), new NV(Predicate.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER)), zlpNode, ctx);
        return left;
    }

    private static PipelineOp convertJoinGroup(PipelineOp left, JoinGroupNode joinGroup, Set<IVariable<?>> doneSet, AST2BOpContext ctx, boolean needsEndOp) {
        LinkedList dropVars = new LinkedList();
        LinkedHashSet<FilterNode> inFilters = new LinkedHashSet<FilterNode>();
        inFilters.addAll(joinGroup.getInFilters());
        AtomicInteger start = new AtomicInteger(0);
        if (joinGroup.getQueryHintAsBoolean("mergeJoin", ctx.mergeJoin)) {
            left = AST2BOpUtility.doMergeJoin(left, joinGroup, doneSet, start, ctx);
        }
        if (QueryOptimizerEnum.Runtime.equals((Object)joinGroup.getQueryOptimizer())) {
            left = AST2BOpUtility.convertRTOJoinGraph(left, joinGroup, doneSet, ctx, start);
        }
        int arity = joinGroup.arity();
        block4: for (int i = start.get(); i < arity; ++i) {
            IGroupMemberNode child = (IGroupMemberNode)joinGroup.get(i);
            if (child instanceof StatementPatternNode) {
                StatementPatternNode sp = (StatementPatternNode)child;
                Predicate pred = AST2BOpUtility.toPredicate(sp, ctx);
                boolean optional = sp.isOptional();
                left = AST2BOpUtility.join(left, pred, optional ? new LinkedHashSet(doneSet) : doneSet, AST2BOpUtility.getJoinConstraints(sp), null, sp.getQueryHints(), ctx);
                continue;
            }
            if (child instanceof ArbitraryLengthPathNode) {
                ArbitraryLengthPathNode alpNode = (ArbitraryLengthPathNode)child;
                left = AST2BOpUtility.convertArbitraryLengthPath(left, alpNode, doneSet, ctx);
                continue;
            }
            if (child instanceof ZeroLengthPathNode) {
                ZeroLengthPathNode zlpNode = (ZeroLengthPathNode)child;
                left = AST2BOpUtility.convertZeroLengthPath(left, zlpNode, doneSet, ctx);
                continue;
            }
            if (child instanceof ServiceNode) {
                left = AST2BOpUtility.addServiceCall(left, (ServiceNode)child, doneSet, ctx);
                continue;
            }
            if (child instanceof NamedSubqueryInclude) {
                left = AST2BOpUtility.addNamedSubqueryInclude(left, (NamedSubqueryInclude)child, doneSet, ctx);
                continue;
            }
            if (child instanceof BindingsClause) {
                left = AST2BOpUtility.addValues(left, (BindingsClause)child, doneSet, ctx);
                continue;
            }
            if (child instanceof SubqueryRoot) {
                SubqueryRoot subquery = (SubqueryRoot)child;
                switch (subquery.getQueryType()) {
                    case ASK: {
                        dropVars.add(subquery.getAskVar());
                        left = AST2BOpUtility.addExistsSubquery(left, subquery, doneSet, ctx);
                        continue block4;
                    }
                    case SELECT: {
                        left = AST2BOpUtility.addSparql11Subquery(left, subquery, doneSet, ctx);
                        continue block4;
                    }
                    default: {
                        throw new UnsupportedOperationException("Subquery has queryType=" + (Object)((Object)subquery.getQueryType()));
                    }
                }
            }
            if (child instanceof UnionNode) {
                UnionNode unionNode = (UnionNode)child;
                left = AST2BOpUtility.convertUnion(left, unionNode, doneSet, ctx);
                continue;
            }
            if (child instanceof GraphPatternGroup) {
                GraphPatternGroup subgroup = (GraphPatternGroup)child;
                boolean required = !subgroup.isOptional() && !subgroup.isMinus();
                left = AST2BOpUtility.addSubgroup(left, subgroup, required ? doneSet : new LinkedHashSet(doneSet), ctx);
                continue;
            }
            if (child instanceof FilterNode) {
                FilterNode filter = (FilterNode)child;
                if (inFilters.contains(filter)) {
                    left = AST2BOpUtility.addKnownInConditional(left, filter, ctx);
                    continue;
                }
                left = AST2BOpUtility.addConditional(left, joinGroup, filter, doneSet, ctx);
                continue;
            }
            if (child instanceof AssignmentNode) {
                if (AST2BOpUtility.mustBeResolvedInContext((AssignmentNode)child, ctx)) {
                    left = AST2BOpUtility.addResolvedAssignment(left, (AssignmentNode)child, doneSet, joinGroup.getQueryHints(), ctx);
                    continue;
                }
                left = AST2BOpUtility.addAssignment(left, (AssignmentNode)child, doneSet, joinGroup.getQueryHints(), ctx, false);
                continue;
            }
            if (child instanceof BindingsClause) continue;
            throw new UnsupportedOperationException("child: " + child);
        }
        if (!dropVars.isEmpty()) {
            IVariable[] a = dropVars.toArray(new IVariable[dropVars.size()]);
            left = AST2BOpUtility.applyQueryHints((PipelineOp)new DropOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(DropOp.Annotations.DROP_VARS, a)), joinGroup, ctx);
        }
        if (needsEndOp && joinGroup.getParent() != null) {
            left = AST2BOpUtility.addEndOp(left, ctx);
        }
        return left;
    }

    private static PipelineOp doMergeJoin(PipelineOp left, JoinGroupNode joinGroup, Set<IVariable<?>> doneSet, AtomicInteger start, AST2BOpContext ctx) {
        int j;
        boolean mergeJoin = true;
        int arity = joinGroup.arity();
        if (arity < 2 || !(joinGroup.get(0) instanceof NamedSubqueryInclude)) {
            return left;
        }
        NamedSubqueryInclude firstInclude = (NamedSubqueryInclude)joinGroup.get(0);
        LinkedList<NamedSubqueryInclude> requiredIncludes = new LinkedList<NamedSubqueryInclude>();
        LinkedList<NamedSubqueryInclude> optionalIncludes = new LinkedList<NamedSubqueryInclude>();
        LinkedList<FilterNode> joinConstraints = new LinkedList<FilterNode>();
        LinkedHashSet joinVars = new LinkedHashSet();
        for (j = 1; j < arity && mergeJoin; ++j) {
            Set<IVariable<?>> theJoinVars;
            NamedSubqueryInclude nsi;
            IGroupMemberNode child = (IGroupMemberNode)joinGroup.get(j);
            if (requiredIncludes.isEmpty() && child instanceof JoinGroupNode && ((JoinGroupNode)child).isOptional() && ((JoinGroupNode)child).arity() == 1 && ((JoinGroupNode)child).get(0) instanceof NamedSubqueryInclude) {
                nsi = (NamedSubqueryInclude)((JoinGroupNode)child).get(0);
                theJoinVars = nsi.getJoinVarSet();
                if (joinVars.isEmpty()) {
                    joinVars.addAll(theJoinVars);
                } else if (!joinVars.equals(theJoinVars)) break;
                optionalIncludes.add(nsi);
                joinConstraints.addAll(nsi.getAttachedJoinFilters());
                continue;
            }
            if (!optionalIncludes.isEmpty() || !(child instanceof NamedSubqueryInclude)) break;
            nsi = (NamedSubqueryInclude)child;
            theJoinVars = nsi.getJoinVarSet();
            if (joinVars.isEmpty()) {
                if (theJoinVars.isEmpty()) break;
                joinVars.addAll(theJoinVars);
            } else if (!joinVars.equals(theJoinVars)) break;
            requiredIncludes.add(nsi);
            joinConstraints.addAll(nsi.getAttachedJoinFilters());
        }
        boolean minIncludes = true;
        if (requiredIncludes.size() < 1 && optionalIncludes.size() < 1) {
            mergeJoin = false;
        }
        if (!mergeJoin) {
            return left;
        }
        boolean optional = requiredIncludes.isEmpty();
        JoinTypeEnum joinType = optional ? JoinTypeEnum.Optional : JoinTypeEnum.Normal;
        LinkedList<NamedSubqueryInclude> includes = optional ? optionalIncludes : requiredIncludes;
        IVariable[] joinvars2 = joinVars.toArray(new IVariable[joinVars.size()]);
        INamedSolutionSetRef firstNamedSolutionSetRef = NamedSolutionSetRefUtility.newInstance(ctx.queryId, firstInclude.getName(), joinvars2);
        if (!firstInclude.getJoinVarSet().equals(joinVars)) {
            left = AST2BOpUtility.addNamedSubqueryInclude(left, firstInclude, doneSet, ctx);
            left = ctx.nativeHashJoins ? AST2BOpUtility.applyQueryHints((PipelineOp)new HTreeHashIndexOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.LAST_PASS, true), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(HTreeHashIndexOp.Annotations.RELATION_NAME, new String[]{ctx.getLexiconNamespace()}), new NV(HTreeHashIndexOp.Annotations.JOIN_TYPE, (Object)joinType), new NV(HTreeHashIndexOp.Annotations.JOIN_VARS, joinvars2), new NV("namedSetRef", firstNamedSolutionSetRef)), joinGroup, ctx) : AST2BOpUtility.applyQueryHints((PipelineOp)new JVMHashIndexOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.LAST_PASS, true), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(JVMHashIndexOp.Annotations.JOIN_TYPE, (Object)joinType), new NV(JVMHashIndexOp.Annotations.JOIN_VARS, joinvars2), new NV("namedSetRef", firstNamedSolutionSetRef)), joinGroup, ctx);
        }
        LinkedList<INamedSolutionSetRef> list = new LinkedList<INamedSolutionSetRef>();
        list.add(firstNamedSolutionSetRef);
        for (NamedSubqueryInclude nsi : includes) {
            list.add(NamedSolutionSetRefUtility.newInstance(ctx.queryId, nsi.getName(), joinvars2));
        }
        INamedSolutionSetRef[] namedSolutionSetRefs = list.toArray(new INamedSolutionSetRef[list.size()]);
        boolean release = false;
        IConstraint[] c = joinConstraints.toArray(new IConstraint[0]);
        left = ctx.nativeHashJoins ? AST2BOpUtility.applyQueryHints((PipelineOp)new HTreeMergeJoin(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.LAST_PASS, true), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV("namedSetRef", namedSolutionSetRefs), new NV(HTreeMergeJoin.Annotations.CONSTRAINTS, c), new NV(HTreeMergeJoin.Annotations.RELEASE, release)), joinGroup, ctx) : AST2BOpUtility.applyQueryHints((PipelineOp)new JVMMergeJoin(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.LAST_PASS, true), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV("namedSetRef", namedSolutionSetRefs), new NV(JVMMergeJoin.Annotations.CONSTRAINTS, c), new NV(JVMMergeJoin.Annotations.RELEASE, release)), joinGroup, ctx);
        start.set(j);
        return left;
    }

    private static final PipelineOp addStartOpOnCluster(QueryBase queryBase, AST2BOpContext ctx) {
        if (ctx.isCluster()) {
            return AST2BOpUtility.addStartOp(queryBase, ctx);
        }
        return null;
    }

    private static final PipelineOp addStartOp(QueryBase queryBase, AST2BOpContext ctx) {
        PipelineOp start = AST2BOpUtility.applyQueryHints((PipelineOp)new StartOp(BOp.NOARGS, NV.asMap(new NV(Predicate.Annotations.BOP_ID, ctx.nextId()), new NV(SliceOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER))), queryBase, ctx);
        return start;
    }

    private static final PipelineOp addAssignment(PipelineOp left, AssignmentNode assignmentNode, Set<IVariable<?>> doneSet, Properties queryHints, AST2BOpContext ctx, boolean projection) {
        IValueExpression<IV> ve = assignmentNode.getValueExpression();
        LinkedHashSet<IVariable<IV>> vars = new LinkedHashSet<IVariable<IV>>();
        ComputedMaterializationRequirement req = assignmentNode.getMaterializationRequirement();
        vars.addAll(req.getVarsToMaterialize());
        vars.removeAll(doneSet);
        int bopId = ctx.nextId();
        ConditionalBind<? extends IV> b = new ConditionalBind<IV>(assignmentNode.getVar(), assignmentNode.getValueExpression(), projection);
        BOpBase c = new ProjectedConstraint(b);
        if (vars.size() > 0) {
            left = AST2BOpUtility.addMaterializationSteps1(left, bopId, ve, vars, queryHints, ctx);
            if (req.getRequirement() == INeedsMaterialization.Requirement.ALWAYS) {
                doneSet.addAll(vars);
            }
            c = new TryBeforeMaterializationConstraint((IConstraint)((Object)c));
        }
        left = AST2BOpUtility.applyQueryHints((PipelineOp)new ConditionalRoutingOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, bopId), new NV(ConditionalRoutingOp.Annotations.CONDITION, c)), queryHints, ctx);
        return left;
    }

    private static PipelineOp addResolvedAssignment(PipelineOp left, AssignmentNode assignmentNode, Set<IVariable<?>> doneSet, Properties queryHints, AST2BOpContext ctx) {
        IValueExpression<IV> ve = assignmentNode.getValueExpression();
        LinkedHashSet<IVariable<IV>> vars = new LinkedHashSet<IVariable<IV>>();
        ComputedMaterializationRequirement req = assignmentNode.getMaterializationRequirement();
        vars.addAll(req.getVarsToMaterialize());
        vars.removeAll(doneSet);
        int bopId = ctx.nextId();
        Var<IV> freshVar = Var.var();
        ConditionalBind<? extends IV> b = new ConditionalBind<IV>(freshVar, assignmentNode.getValueExpression(), false);
        ProjectedConstraint c = new ProjectedConstraint(b);
        if (vars.size() > 0) {
            left = AST2BOpUtility.addMaterializationSteps1(left, bopId, ve, vars, queryHints, ctx);
            if (req.getRequirement() == INeedsMaterialization.Requirement.ALWAYS) {
                doneSet.addAll(vars);
            }
        }
        left = AST2BOpUtility.applyQueryHints((PipelineOp)new ConditionalRoutingOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, bopId), new NV(ConditionalRoutingOp.Annotations.CONDITION, c)), queryHints, ctx);
        LinkedHashSet<IVariable<IV>> iVars = new LinkedHashSet<IVariable<IV>>();
        iVars.add(freshVar);
        left = AST2BOpUtility.addMockTermResolverOp(left, iVars, false, null, assignmentNode.getQueryHints(), ctx);
        left = AST2BOpUtility.addVariableUnificationOp(left, assignmentNode.getVar(), freshVar, ctx);
        doneSet.add(assignmentNode.getVar());
        return left;
    }

    private static final PipelineOp addConditional(PipelineOp left, JoinGroupNode joinGroup, FilterNode filter, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        IValueExpression<IV> ve = filter.getValueExpression();
        LinkedHashSet<IVariable<IV>> vars = new LinkedHashSet<IVariable<IV>>();
        ComputedMaterializationRequirement req = filter.getMaterializationRequirement();
        vars.addAll(req.getVarsToMaterialize());
        vars.removeAll(doneSet);
        int bopId = ctx.nextId();
        if (!vars.isEmpty()) {
            left = AST2BOpUtility.addMaterializationSteps1(left, bopId, ve, vars, joinGroup.getQueryHints(), ctx);
            if (req.getRequirement() == INeedsMaterialization.Requirement.ALWAYS) {
                doneSet.addAll(vars);
            }
        }
        SPARQLConstraint c = new SPARQLConstraint(ve);
        left = AST2BOpUtility.applyQueryHints((PipelineOp)new ConditionalRoutingOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, bopId), new NV(ConditionalRoutingOp.Annotations.CONDITION, c)), joinGroup, ctx);
        return left;
    }

    private static final PipelineOp addKnownInConditional(PipelineOp left, FilterNode filter, AST2BOpContext ctx) {
        InBOp bop = (InBOp)filter.getValueExpression();
        IConstant<IV>[] set = bop.getSet();
        LinkedHashSet ivs = new LinkedHashSet();
        for (IConstant<IV> iv : set) {
            ivs.add(iv.get());
        }
        IVariable var = (IVariable)bop.getValueExpression();
        left = new DataSetJoin(AST2BOpUtility.leftOrEmpty(left), NV.asMap(new NV(DataSetJoin.Annotations.VAR, var), new NV(DataSetJoin.Annotations.BOP_ID, ctx.nextId()), new NV(DataSetJoin.Annotations.GRAPHS, ivs)));
        return left;
    }

    private static PipelineOp addSubgroup(PipelineOp left, GraphPatternGroup<IGroupMemberNode> subgroup, Set<IVariable<?>> doneSet, AST2BOpContext ctx) {
        boolean minus;
        if (ctx.isCluster() && BOpUtility.visitAll(subgroup, NamedSubqueryInclude.class).hasNext()) {
            left = new CopyOp(AST2BOpUtility.leftOrEmpty(left), NV.asMap(new NV(Predicate.Annotations.BOP_ID, ctx.nextId()), new NV(SliceOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER)));
        }
        boolean optional = subgroup.isOptional();
        boolean bl = minus = subgroup instanceof JoinGroupNode && ((JoinGroupNode)subgroup).isMinus();
        JoinTypeEnum joinType = optional ? JoinTypeEnum.Optional : (minus ? JoinTypeEnum.NotExists : JoinTypeEnum.Normal);
        LinkedHashMap<IConstraint, Set<IVariable<IV>>> needsMaterialization = new LinkedHashMap<IConstraint, Set<IVariable<IV>>>();
        IConstraint[] joinConstraints = AST2BOpUtility.getJoinConstraints(AST2BOpUtility.getJoinConstraints(subgroup), needsMaterialization);
        if (!joinType.isNormal() && joinConstraints != null) {
            throw new AssertionError((Object)("Non-required group has attached join filters: " + subgroup));
        }
        String solutionSetName = "--set-" + ctx.nextId();
        IVariable[] joinVars = subgroup.getJoinVars();
        if (joinVars == null) {
            throw new RuntimeException("Join variables not specified: " + subgroup);
        }
        INamedSolutionSetRef namedSolutionSet = NamedSolutionSetRefUtility.newInstance(ctx.queryId, solutionSetName, joinVars);
        IVariable<?>[] projectInVars = subgroup.getProjectInVars();
        left = AST2BOpUtility.addHashIndexOp(left, ctx, subgroup, joinType, joinVars, joinConstraints, projectInVars, namedSolutionSet);
        PipelineOp subqueryPlan = AST2BOpUtility.convertJoinGroupOrUnion(left, subgroup, doneSet, ctx);
        boolean lastPass = !joinType.isNormal();
        boolean release = lastPass;
        int maxParallel = lastPass ? 1 : ctx.maxParallelForSolutionSetHashJoin;
        left = ctx.nativeHashJoins ? AST2BOpUtility.applyQueryHints((PipelineOp)new HTreeSolutionSetHashJoinOp(new BOp[]{subqueryPlan}, new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, maxParallel), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(SolutionSetHashJoinOp.Annotations.CONSTRAINTS, joinConstraints), new NV(SolutionSetHashJoinOp.Annotations.RELEASE, release), new NV(SolutionSetHashJoinOp.Annotations.LAST_PASS, lastPass), new NV("namedSetRef", namedSolutionSet)), subgroup, ctx) : AST2BOpUtility.applyQueryHints((PipelineOp)new JVMSolutionSetHashJoinOp(new BOp[]{subqueryPlan}, new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, maxParallel), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(SolutionSetHashJoinOp.Annotations.CONSTRAINTS, joinConstraints), new NV(SolutionSetHashJoinOp.Annotations.RELEASE, release), new NV(SolutionSetHashJoinOp.Annotations.LAST_PASS, lastPass), new NV("namedSetRef", namedSolutionSet)), subgroup, ctx);
        left = AST2BOpUtility.addMaterializationSteps3(left, doneSet, needsMaterialization, subgroup.getQueryHints(), ctx);
        return left;
    }

    private static final PipelineOp addEndOp(PipelineOp left, AST2BOpContext ctx) {
        if (left != null && ctx.isCluster() && !left.getEvaluationContext().equals((Object)BOpEvaluationContext.CONTROLLER)) {
            left = new EndOp(AST2BOpUtility.leftOrEmpty(left), NV.asMap(new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER)));
        }
        return left;
    }

    private static final PipelineOp addDistinct(PipelineOp left, QueryBase query, boolean preserveOrder, AST2BOpContext ctx) {
        PipelineOp op;
        int bopId = ctx.nextId();
        ProjectionNode projection = query.getProjection();
        if (projection.isWildcard()) {
            throw new AssertionError((Object)"Wildcard projection was not rewritten.");
        }
        IVariable[] vars = projection.getProjectionVars();
        if (!ctx.nativeDistinctSolutions || preserveOrder) {
            LinkedList<NV> anns = new LinkedList<NV>();
            anns.add(new NV(JVMDistinctBindingSetsOp.Annotations.BOP_ID, bopId));
            anns.add(new NV(JVMDistinctBindingSetsOp.Annotations.VARIABLES, vars));
            anns.add(new NV(JVMDistinctBindingSetsOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER));
            anns.add(new NV(JVMDistinctBindingSetsOp.Annotations.SHARED_STATE, true));
            if (preserveOrder) {
                anns.add(new NV(PipelineOp.Annotations.MAX_PARALLEL, 1));
                anns.add(new NV(SliceOp.Annotations.REORDER_SOLUTIONS, false));
            }
            op = new JVMDistinctBindingSetsOp(AST2BOpUtility.leftOrEmpty(left), anns.toArray(new NV[anns.size()]));
        } else {
            if (preserveOrder) {
                throw new UnsupportedOperationException();
            }
            INamedSolutionSetRef namedSolutionSet = NamedSolutionSetRefUtility.newInstance(ctx.queryId, "--distinct-" + ctx.nextId(), vars);
            op = new HTreeDistinctBindingSetsOp(AST2BOpUtility.leftOrEmpty(left), new NV(HTreeDistinctBindingSetsOp.Annotations.BOP_ID, bopId), new NV(HTreeDistinctBindingSetsOp.Annotations.VARIABLES, vars), new NV(PipelineOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV("namedSetRef", namedSolutionSet), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1));
        }
        left = AST2BOpUtility.applyQueryHints(op, query, ctx);
        return left;
    }

    private static final PipelineOp addAggregation(PipelineOp left, ProjectionNode projection, GroupByNode groupBy, HavingNode having, AST2BOpContext ctx) {
        IValueExpression[] projectExprs = projection.getValueExpressions();
        IValueExpression[] groupByExprs = groupBy == null ? null : groupBy.getValueExpressions();
        IConstraint[] havingExprs = having == null ? null : having.getConstraints();
        GroupByState groupByState = new GroupByState(projectExprs, groupByExprs, havingExprs);
        GroupByRewriter groupByRewrite = new GroupByRewriter(groupByState);
        Properties queryHints = projection.getQueryHints();
        int bopId = ctx.nextId();
        LinkedHashSet<IVariable<IV>> vars = new LinkedHashSet<IVariable<IV>>();
        if (projectExprs != null) {
            for (IValueExpression expr : projectExprs) {
                if (expr instanceof Bind) {
                    expr = ((Bind)expr).getExpr();
                }
                if (expr instanceof IVariable) continue;
                StaticAnalysis.gatherVarsToMaterialize(expr, vars);
            }
        }
        if (groupByExprs != null) {
            for (IValueExpression expr : groupByExprs) {
                if (expr instanceof Bind) {
                    expr = ((Bind)expr).getExpr();
                }
                if (expr instanceof IVariable) continue;
                StaticAnalysis.gatherVarsToMaterialize(expr, vars);
            }
        }
        left = AST2BOpUtility.addMaterializationSteps2(left, bopId, vars, queryHints, ctx);
        GroupByOp op = !groupByState.isAnyDistinct() && !groupByState.isSelectDependency() && !groupByState.isNestedAggregates() ? new PipelinedAggregationOp(AST2BOpUtility.leftOrEmpty(left), NV.asMap(new NV(BOp.Annotations.BOP_ID, bopId), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.PIPELINED, true), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(GroupByOp.Annotations.GROUP_BY_STATE, groupByState), new NV(GroupByOp.Annotations.GROUP_BY_REWRITE, groupByRewrite), new NV(PipelineOp.Annotations.LAST_PASS, true))) : new MemoryGroupByOp(AST2BOpUtility.leftOrEmpty(left), NV.asMap(new NV(BOp.Annotations.BOP_ID, bopId), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.PIPELINED, false), new NV(PipelineOp.Annotations.MAX_MEMORY, 0), new NV(GroupByOp.Annotations.GROUP_BY_STATE, groupByState), new NV(GroupByOp.Annotations.GROUP_BY_REWRITE, groupByRewrite)));
        left = AST2BOpUtility.applyQueryHints((PipelineOp)op, queryHints, ctx);
        return left;
    }

    private static final PipelineOp addOrderBy(PipelineOp left, QueryBase queryBase, OrderByNode orderBy, AST2BOpContext ctx) {
        Properties queryHints = queryBase.getQueryHints();
        LinkedHashSet<IVariable<IV>> vars = new LinkedHashSet<IVariable<IV>>();
        ISortOrder[] sortOrders = new ISortOrder[orderBy.size()];
        Iterator<OrderByExpr> it = orderBy.iterator();
        int i = 0;
        while (it.hasNext()) {
            OrderByExpr orderByExpr = it.next();
            IValueExpression<? extends IV> expr = orderByExpr.getValueExpression();
            if (!(expr instanceof IVariableOrConstant) || expr instanceof IBind) {
                expr = new Bind<IV>(Var.var("--anon" + ctx.nextId()), expr);
            }
            if (expr instanceof IVariable) {
                vars.add((IVariable)expr);
            } else {
                StaticAnalysis.gatherVarsToMaterialize(expr, vars);
            }
            sortOrders[i] = new SortOrder<IV>(expr, orderByExpr.isAscending());
            ++i;
        }
        int sortId = ctx.nextId();
        left = AST2BOpUtility.addMaterializationSteps2(left, sortId, vars, queryHints, ctx);
        left = AST2BOpUtility.applyQueryHints((PipelineOp)new MemorySortOp(AST2BOpUtility.leftOrEmpty(left), NV.asMap(new NV(SortOp.Annotations.BOP_ID, sortId), new NV(SortOp.Annotations.SORT_ORDER, sortOrders), new NV(SortOp.Annotations.VALUE_COMPARATOR, new IVComparator()), new NV(SortOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(SortOp.Annotations.PIPELINED, true), new NV(SortOp.Annotations.MAX_PARALLEL, 1), new NV(SortOp.Annotations.REORDER_SOLUTIONS, false), new NV(SortOp.Annotations.LAST_PASS, true))), queryHints, ctx);
        return left;
    }

    private static final PipelineOp addSlice(PipelineOp left, QueryBase queryBase, SliceNode slice, AST2BOpContext ctx) {
        int bopId = ctx.nextId();
        left = AST2BOpUtility.applyQueryHints((PipelineOp)new SliceOp(AST2BOpUtility.leftOrEmpty(left), new NV(SliceOp.Annotations.BOP_ID, bopId), new NV(SliceOp.Annotations.OFFSET, slice.getOffset()), new NV(SliceOp.Annotations.LIMIT, slice.getLimit()), new NV(SliceOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(SliceOp.Annotations.PIPELINED, true), new NV(SliceOp.Annotations.MAX_PARALLEL, 1), new NV(SliceOp.Annotations.REORDER_SOLUTIONS, false), new NV(SliceOp.Annotations.SHARED_STATE, true)), queryBase, ctx);
        return left;
    }

    protected static final Predicate toPredicate(StatementPatternNode sp, AST2BOpContext ctx) {
        int nfilters;
        Properties queryHints;
        RangeNode range;
        VarNode sidVar;
        QueryRoot query = ctx.astContainer.getOptimizedAST();
        AbstractTripleStore database = ctx.getAbstractTripleStore();
        DatasetNode dataset = query.getDataset();
        IValueExpression s = sp.s().getValueExpression();
        IValueExpression p = sp.p().getValueExpression();
        IValueExpression o = sp.o().getValueExpression();
        TermNode cvar = sp.c();
        IValueExpression c = cvar == null ? null : cvar.getValueExpression();
        LinkedList<NV> anns = new LinkedList<NV>();
        anns.add(new NV(IPredicate.Annotations.RELATION_NAME, new String[]{database.getSPORelation().getNamespace()}));
        anns.add(new NV(IPredicate.Annotations.TIMESTAMP, database.getSPORelation().getTimestamp()));
        anns.add(new NV(IPredicate.Annotations.BOP_ID, ctx.nextId()));
        anns.add(new NV(AST2BOpRTO.Annotations.ESTIMATED_CARDINALITY, sp.getProperty(AST2BOpRTO.Annotations.ESTIMATED_CARDINALITY)));
        anns.add(new NV(AST2BOpRTO.Annotations.ORIGINAL_INDEX, sp.getProperty(AST2BOpRTO.Annotations.ORIGINAL_INDEX)));
        Properties queryHints2 = sp.getQueryHints();
        AST2BOpUtility.conditionalCopy(anns, queryHints2, BufferAnnotations.CHUNK_CAPACITY);
        AST2BOpUtility.conditionalCopy(anns, queryHints2, BufferAnnotations.CHUNK_OF_CHUNKS_CAPACITY);
        AST2BOpUtility.conditionalCopy(anns, queryHints2, IPredicate.Annotations.FULLY_BUFFERED_READ_THRESHOLD);
        AST2BOpUtility.conditionalCopy(anns, queryHints2, IPredicate.Annotations.KEY_ORDER);
        AST2BOpUtility.conditionalCopy(anns, queryHints2, IPredicate.Annotations.CUTOFF_LIMIT);
        if (sp.isOptional()) {
            anns.add(new NV(IPredicate.Annotations.OPTIONAL, Boolean.TRUE));
        }
        if (sp.getProperty("distinctTermScanVar") != null) {
            anns.add(new NV("distinctTermScanVar", sp.getProperty("distinctTermScanVar")));
        }
        if (sp.getProperty("fastRangeCountVar") != null) {
            anns.add(new NV("fastRangeCountVar", sp.getProperty("fastRangeCountVar")));
        }
        if ((sidVar = sp.sid()) != null) {
            anns.add(new NV(SPOPredicate.Annotations.SID, sidVar.getValueExpression()));
        }
        if ((range = sp.getRange()) != null) {
            anns.add(new NV(IPredicate.Annotations.RANGE, range.getRangeBOp()));
        }
        if ((queryHints = sp.getQueryHints()) != null && Boolean.parseBoolean(queryHints.getProperty("hashJoin", "false"))) {
            Set<IVariable<IVariable<?>>> joinVars = ctx.sa.getDefinitelyIncomingBindings(sp, new LinkedHashSet());
            Set<IVariable<?>> predVars = ctx.sa.getDefinitelyProducedBindings(sp, new LinkedHashSet(), false);
            joinVars.retainAll(predVars);
            if (!joinVars.isEmpty()) {
                anns.add(new NV("hashJoin", true));
                anns.add(new NV(HashJoinAnnotations.JOIN_VARS, joinVars.toArray(new IVariable[joinVars.size()])));
            }
        }
        if (!database.isQuads()) {
            if (cvar != null && database.isStatementIdentifiers() && cvar.getValue() != null) {
                throw new IllegalArgumentException("Context position is a statement identifier and may not be bound in the original query: " + sp);
            }
        } else {
            anns.add(new NV(AST2BOpBase.Annotations.QUADS, true));
            anns.add(new NV(AST2BOpBase.Annotations.SCOPE, sp.getScope()));
            if (dataset != null) {
                anns.add(new NV(AST2BOpBase.Annotations.DATASET, dataset));
                switch (sp.getScope()) {
                    case DEFAULT_CONTEXTS: {
                        if (dataset.getDefaultGraphFilter() == null) break;
                        anns.add(new NV(IPredicate.Annotations.INDEX_LOCAL_FILTER, ElementFilter.newInstance(dataset.getDefaultGraphFilter())));
                        break;
                    }
                    case NAMED_CONTEXTS: {
                        if (dataset.getNamedGraphFilter() == null) break;
                        anns.add(new NV(IPredicate.Annotations.INDEX_LOCAL_FILTER, ElementFilter.newInstance(dataset.getNamedGraphFilter())));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
        LinkedList<IFilter> filters = new LinkedList<IFilter>();
        if (Boolean.valueOf(sp.getProperty("distinct", false)).booleanValue()) {
            filters.add(new DistinctTermAdvancer(database.isQuads() ? 4 : 3));
        }
        if (!query.getIncludeInferred()) {
            filters.add(ElementFilter.newInstance(ExplicitSPOFilter.INSTANCE));
        }
        if ((nfilters = filters.size()) > 0) {
            IFilter filter;
            if (nfilters == 1) {
                filter = (IFilter)filters.get(0);
            } else {
                NOPFilter tmp = new NOPFilter();
                for (IFilter f : filters) {
                    tmp.addFilter(f);
                }
                filter = tmp;
            }
            anns.add(new NV(IPredicate.Annotations.INDEX_LOCAL_FILTER, filter));
        }
        int flags = 267;
        anns.add(new NV(IPredicate.Annotations.FLAGS, 267));
        BOp[] vars = !database.isQuads() && !database.isStatementIdentifiers() ? new BOp[]{s, p, o} : (c == null ? new BOp[]{s, p, o, Var.var("--anon-" + ctx.nextId())} : new BOp[]{s, p, o, c});
        return new SPOPredicate(vars, anns.toArray(new NV[anns.size()]));
    }

    private static void conditionalCopy(List<NV> anns, Properties queryHints, String name) {
        if (queryHints == null) {
            return;
        }
        String val = queryHints.getProperty(name);
        if (val != null) {
            anns.add(new NV(name, val));
        }
    }

    public static final IValueExpression<? extends IV> toVE(GlobalAnnotations globals, IValueExpressionNode node) {
        IValueExpression<? extends IV> ve1 = AST2BOpUtility.toVE1(globals, node);
        try {
            IValueExpression<? extends IV> ve2 = AST2BOpUtility.toVE2(ve1);
            if (ve2 != ve1) {
                node.setValueExpression(ve2);
                return ve2;
            }
            return ve1;
        }
        catch (ContextNotAvailableException ex) {
            return ve1;
        }
        catch (SparqlTypeErrorException ex) {
            return ve1;
        }
    }

    private static final IValueExpression<? extends IV> toVE2(IValueExpression<? extends IV> ve) {
        if (ve instanceof IVariableOrConstant) {
            return ve;
        }
        Iterator<BOp> itr = BOpUtility.preOrderIterator(ve);
        while (itr.hasNext()) {
            BOp op = itr.next();
            if (op instanceof IAggregate) {
                return ve;
            }
            if (op instanceof IsBoundBOp || op instanceof CoalesceBOp) {
                return ve;
            }
            if (op instanceof FunctionRegistry.UnknownFunctionBOp) {
                return ve;
            }
            if (!(op instanceof UUIDBOp)) continue;
            return ve;
        }
        Constant<IV> ve2 = new Constant<IV>(ve.get(EmptyBindingSet.INSTANCE));
        return ve2;
    }

    private static final IValueExpression<? extends IV> toVE1(GlobalAnnotations globals, IValueExpressionNode node) {
        if (node.getValueExpression() != null) {
            return node.getValueExpression();
        }
        if (node instanceof VarNode) {
            return node.getValueExpression();
        }
        if (node instanceof ConstantNode) {
            return node.getValueExpression();
        }
        if (node instanceof AssignmentNode) {
            AssignmentNode assignment = (AssignmentNode)node;
            IValueExpressionNode valueExpr = assignment.getValueExpressionNode();
            IValueExpression<? extends IV> ve = AST2BOpUtility.toVE(globals, valueExpr);
            return ve;
        }
        if (node instanceof FunctionNode) {
            FunctionNode functionNode = (FunctionNode)node;
            URI functionURI = functionNode.getFunctionURI();
            Map<String, Object> scalarValues = functionNode.getScalarValues();
            ValueExpressionNode[] args = functionNode.args().toArray(new ValueExpressionNode[functionNode.arity()]);
            IValueExpression<? extends IV> ve = FunctionRegistry.toVE(globals, functionURI, scalarValues, args);
            functionNode.setValueExpression(ve);
            return ve;
        }
        throw new IllegalArgumentException(node.toString());
    }

    private static PipelineOp addMockTermResolverOp(PipelineOp left, Set<IVariable<IV>> vars, boolean materializeInlineIvs, Long cutoffLimit, Properties queryHints, AST2BOpContext ctx) {
        int nvars = vars.size();
        if (nvars == 0) {
            return left;
        }
        long timestamp = ctx.getLexiconReadTimestamp();
        String ns = ctx.getLexiconNamespace();
        return AST2BOpUtility.applyQueryHints((PipelineOp)new MockTermResolverOp(AST2BOpUtility.leftOrEmpty(left), new NV(MockTermResolverOp.Annotations.VARS, vars.toArray(new IVariable[nvars])), new NV(MockTermResolverOp.Annotations.RELATION_NAME, new String[]{ns}), new NV(MockTermResolverOp.Annotations.TIMESTAMP, timestamp), new NV(PipelineOp.Annotations.SHARED_STATE, !ctx.isCluster()), new NV(BOp.Annotations.BOP_ID, ctx.nextId())), queryHints, ctx);
    }

    private static PipelineOp addVariableUnificationOp(PipelineOp left, IVariable<IV> targetVar, IVariable<IV> tmpVar, AST2BOpContext ctx) {
        return new VariableUnificationOp(AST2BOpUtility.leftOrEmpty(left), new NV(VariableUnificationOp.Annotations.VARS, new IVariable[]{targetVar, tmpVar}), new NV(BOp.Annotations.BOP_ID, ctx.nextId()));
    }

    private static PipelineOp addHashIndexOp(PipelineOp left, AST2BOpContext ctx, ASTBase node, JoinTypeEnum joinType, IVariable<?>[] joinVars, IConstraint[] joinConstraints, IVariable<?>[] projectInVars, INamedSolutionSetRef namedSolutionSet) {
        left = ctx.nativeHashJoins ? AST2BOpUtility.applyQueryHints((PipelineOp)new HTreeHashIndexOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.LAST_PASS, true), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(HTreeHashIndexOp.Annotations.RELATION_NAME, new String[]{ctx.getLexiconNamespace()}), new NV(HTreeHashIndexOp.Annotations.JOIN_TYPE, (Object)joinType), new NV(HTreeHashIndexOp.Annotations.JOIN_VARS, joinVars), new NV(HTreeHashIndexOp.Annotations.PROJECT_IN_VARS, projectInVars), new NV(HTreeHashIndexOp.Annotations.CONSTRAINTS, joinConstraints), new NV("namedSetRef", namedSolutionSet)), node, ctx) : AST2BOpUtility.applyQueryHints((PipelineOp)new JVMHashIndexOp(AST2BOpUtility.leftOrEmpty(left), new NV(BOp.Annotations.BOP_ID, ctx.nextId()), new NV(BOp.Annotations.EVALUATION_CONTEXT, (Object)BOpEvaluationContext.CONTROLLER), new NV(PipelineOp.Annotations.MAX_PARALLEL, 1), new NV(PipelineOp.Annotations.LAST_PASS, true), new NV(PipelineOp.Annotations.SHARED_STATE, true), new NV(JVMHashIndexOp.Annotations.JOIN_TYPE, (Object)joinType), new NV(JVMHashIndexOp.Annotations.JOIN_VARS, joinVars), new NV(JVMHashIndexOp.Annotations.PROJECT_IN_VARS, projectInVars), new NV(JVMHashIndexOp.Annotations.CONSTRAINTS, joinConstraints), new NV("namedSetRef", namedSolutionSet)), node, ctx);
        return left;
    }

    private static boolean mustBeResolvedInContext(AssignmentNode ass, AST2BOpContext ctx) {
        TermId valAsTermId;
        IConstant vexpAsConst;
        Object val;
        IValueExpression<? extends IV> vexp = ass.getValueExpression();
        if (vexp instanceof MathBOp || vexp instanceof XSDBooleanIVValueExpression) {
            return false;
        }
        if (vexp instanceof IConstant && ((val = (vexpAsConst = (IConstant)vexp).get()) instanceof TermId ? !(valAsTermId = (TermId)val).isNullIV() : val instanceof NumericIV)) {
            return false;
        }
        return BOpUtility.countOccurrencesOf(ctx.sa.getQueryRoot().getWhereClause(), ass.getVar()) > 1;
    }
}

