/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.DatasetNode;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.store.BDS;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;
import org.openrdf.query.algebra.StatementPattern;

public class ASTSearchOptimizer
implements IASTOptimizer {
    private static final Logger log = Logger.getLogger(ASTSearchOptimizer.class);
    static final Set<URI> searchUris;

    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSets) {
        if (!(queryNode instanceof QueryRoot)) {
            return queryNode;
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        if (queryRoot.getNamedSubqueries() != null) {
            for (NamedSubqueryRoot namedSubquery : queryRoot.getNamedSubqueries()) {
                this.extractSearches(context, queryRoot, namedSubquery, namedSubquery.getWhereClause());
            }
        }
        if (queryRoot.getWhereClause() != null) {
            this.extractSearches(context, queryRoot, queryRoot, queryRoot.getWhereClause());
        }
        return queryRoot;
    }

    private void extractSearches(AST2BOpContext ctx, QueryRoot queryRoot, QueryBase queryBase, GroupNodeBase<IGroupMemberNode> group) {
        LinkedHashMap<IVariableOrConstant, LinkedHashMap<URI, StatementPatternNode>> tmp = null;
        int arity = group.arity();
        for (int i = 0; i < arity; ++i) {
            BOp child = group.get(i);
            if (child instanceof StatementPatternNode) {
                LinkedHashMap<URI, StatementPatternNode> statementPatterns;
                URI uri;
                StatementPatternNode sp = (StatementPatternNode)child;
                TermNode p = sp.p();
                if (!p.isConstant() || !(p.getValue() instanceof URI) || (uri = (URI)((ConstantNode)p).getValue()) == null || !uri.stringValue().startsWith("http://www.bigdata.com/rdf/search#")) continue;
                if (!searchUris.contains(uri)) {
                    throw new RuntimeException("Unknown search predicate: " + uri);
                }
                TermNode s = sp.s();
                if (!s.isVariable()) {
                    throw new RuntimeException("Subject of search predicate is constant: " + sp);
                }
                IVariableOrConstant searchVar = ((VarNode)s).getValueExpression();
                if (tmp == null) {
                    tmp = new LinkedHashMap<IVariableOrConstant, LinkedHashMap<URI, StatementPatternNode>>();
                }
                if ((statementPatterns = (LinkedHashMap<URI, StatementPatternNode>)tmp.get(searchVar)) == null) {
                    statementPatterns = new LinkedHashMap<URI, StatementPatternNode>();
                    tmp.put(searchVar, statementPatterns);
                }
                statementPatterns.put(uri, sp);
                continue;
            }
            if (!(child instanceof GroupNodeBase)) continue;
            GroupNodeBase subGroup = (GroupNodeBase)child;
            this.extractSearches(ctx, queryRoot, queryBase, subGroup);
        }
        if (tmp != null) {
            for (Map.Entry e : tmp.entrySet()) {
                IVariable searchVar = (IVariable)e.getKey();
                Map statementPatterns = (Map)e.getValue();
                this.removeSearchPredicates(group, statementPatterns);
                ServiceNode serviceNode = this.createServiceNode(ctx, queryBase, group, searchVar, statementPatterns);
                group.addChild(serviceNode);
                this.enforceGraphConstraint(ctx, queryRoot, searchVar, group);
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("Rewrote group: " + group));
            }
        }
    }

    private void enforceGraphConstraint(AST2BOpContext ctx, QueryRoot queryRoot, IVariable<?> searchVar, GroupNodeBase<IGroupMemberNode> group) {
        StatementPatternNode subjectJoin = null;
        for (IGroupMemberNode child : group) {
            StatementPatternNode sp;
            if (!(child instanceof StatementPatternNode) || !searchVar.equals((sp = (StatementPatternNode)child).o().getValueExpression())) continue;
            subjectJoin = sp;
            break;
        }
        if (subjectJoin != null) {
            return;
        }
        if (group.getContext() != null) {
            group.addChild(new StatementPatternNode(new VarNode("--anon-" + ctx.nextId()), new VarNode("--anon-" + ctx.nextId()), new VarNode(searchVar.getName()), group.getContext(), StatementPattern.Scope.NAMED_CONTEXTS));
            if (log.isInfoEnabled()) {
                log.info((Object)("Added subject join to imposed named graph constraint: " + group));
            }
        } else {
            DatasetNode datasetNode = queryRoot.getDataset();
            if (datasetNode == null) {
                return;
            }
            if (datasetNode.getDefaultGraphs() == null && datasetNode.getDefaultGraphFilter() != null) {
                return;
            }
            group.addChild(new StatementPatternNode(new VarNode("--anon-" + ctx.nextId()), new VarNode("--anon-" + ctx.nextId()), new VarNode(searchVar.getName()), null, StatementPattern.Scope.DEFAULT_CONTEXTS));
            if (log.isInfoEnabled()) {
                log.info((Object)("Added subject join to imposed default graph constraint: " + group));
            }
        }
    }

    private ServiceNode createServiceNode(AST2BOpContext ctx, QueryBase queryBase, GroupNodeBase<IGroupMemberNode> group, IVariable<?> searchVar, Map<URI, StatementPatternNode> statementPatterns) {
        JoinGroupNode groupNode = new JoinGroupNode();
        for (StatementPatternNode sp : statementPatterns.values()) {
            groupNode.addChild(sp);
        }
        TermId<?> iv = TermId.mockIV(VTE.URI);
        iv.setValue(ctx.db.getValueFactory().asValue(BDS.SEARCH));
        return new ServiceNode(new ConstantNode(iv), groupNode);
    }

    private void removeSearchPredicates(GroupNodeBase<IGroupMemberNode> group, Map<URI, StatementPatternNode> statementPatterns) {
        for (StatementPatternNode sp : statementPatterns.values()) {
            if (!group.removeArg(sp)) {
                throw new AssertionError();
            }
        }
    }

    static {
        LinkedHashSet<URI> set = new LinkedHashSet<URI>();
        set.add(BDS.SEARCH);
        set.add(BDS.RELEVANCE);
        set.add(BDS.RANK);
        set.add(BDS.MAX_RANK);
        set.add(BDS.MIN_RANK);
        set.add(BDS.MAX_RELEVANCE);
        set.add(BDS.MIN_RELEVANCE);
        set.add(BDS.MATCH_ALL_TERMS);
        set.add(BDS.MATCH_EXACT);
        set.add(BDS.SUBJECT_SEARCH);
        set.add(BDS.SEARCH_TIMEOUT);
        set.add(BDS.MATCH_REGEX);
        set.add(BDS.RANGE_COUNT);
        searchUris = Collections.unmodifiableSet(set);
    }
}

