/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class ASTBatchResolveTermsOptimizer
implements IASTOptimizer {
    private static final transient Logger log = Logger.getLogger(ASTBatchResolveTermsOptimizer.class);

    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSets) {
        LinkedList<ConstantNode> unknown = null;
        Iterator<ConstantNode> itr = BOpUtility.visitAll(queryNode, ConstantNode.class);
        while (itr.hasNext()) {
            ConstantNode cnode = itr.next();
            IVariableOrConstant c = cnode.getValueExpression();
            IV iv = (IV)c.get();
            if (!iv.isNullIV()) continue;
            if (unknown == null) {
                unknown = new LinkedList<ConstantNode>();
            }
            unknown.add(cnode);
        }
        if (unknown != null) {
            IV iv;
            Object[] values = new BigdataValue[unknown.size()];
            int i = 0;
            for (ConstantNode cnode : unknown) {
                IVariableOrConstant c = cnode.getValueExpression();
                iv = (IV)c.get();
                Object v = iv.getValue();
                v.clearInternalValue();
                values[i++] = v;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("UNKNOWNS: " + Arrays.toString(values)));
            }
            context.getAbstractTripleStore().getLexiconRelation().addTerms((BigdataValue[])values, values.length, true);
            i = 0;
            for (ConstantNode cnode : unknown) {
                IVariable var;
                Object v;
                if (!(v = values[i++]).isRealIV()) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)("RESOLVED: " + v + " => " + v.getIV()));
                }
                iv = v.getIV();
                Constant oldc = (Constant)cnode.getValueExpression();
                IV oldIv = (IV)oldc.get();
                if (oldIv.hasValue()) {
                    iv.setValue(oldIv.getValue());
                }
                Constant<IV> newc = (var = (IVariable)oldc.getProperty(Constant.Annotations.VAR)) == null ? new Constant<IV>(iv) : new Constant<IV>(var, iv);
                cnode.setArg(0, newc);
            }
        }
        return queryNode;
    }
}

