/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import cutthecrap.utils.striterators.EmptyIterator;
import cutthecrap.utils.striterators.Expander;
import cutthecrap.utils.striterators.SingleValueIterator;
import cutthecrap.utils.striterators.Striterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;

public class ASTBindingAssigner
implements IASTOptimizer {
    private static final Logger log = Logger.getLogger(ASTBindingAssigner.class);

    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSet) {
        if (bindingSet == null || bindingSet.length != 1) {
            return queryNode;
        }
        if (!(queryNode instanceof QueryRoot)) {
            return queryNode;
        }
        IBindingSet bset = bindingSet[0];
        QueryRoot queryRoot = (QueryRoot)queryNode;
        GraphPatternGroup whereClause = queryRoot.getWhereClause();
        if (whereClause != null) {
            this.doBindingAssignment(whereClause, bset);
        }
        if (queryRoot.getNamedSubqueries() != null) {
            NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
            for (int i = 0; i < namedSubqueries.size(); ++i) {
                NamedSubqueryRoot namedSubquery = (NamedSubqueryRoot)namedSubqueries.get(i);
                GraphPatternGroup whereClause2 = namedSubquery.getWhereClause();
                if (whereClause2 == null) continue;
                this.doBindingAssignment(whereClause2, bset);
            }
        }
        return queryNode;
    }

    private void doBindingAssignment(GroupNodeBase<IGroupMemberNode> whereClause, IBindingSet bset) {
        this.doBindingAssignment(whereClause, Collections.EMPTY_MAP, bset);
    }

    private void doBindingAssignment(GroupNodeBase<IGroupMemberNode> whereClause, Map<VarNode, ConstantNode> parentReplacements, IBindingSet bset) {
        LinkedHashMap<VarNode, ConstantNode> replacements = new LinkedHashMap<VarNode, ConstantNode>();
        replacements.putAll(parentReplacements);
        Iterator<BOp> itr = this.iterateExcludeGroups(whereClause);
        while (itr.hasNext()) {
            VarNode varNode;
            BOp node = itr.next();
            if (node instanceof FilterNode) {
                this.tryReplace(replacements, (FilterNode)node);
                continue;
            }
            if (!(node instanceof VarNode) || replacements.containsKey(varNode = (VarNode)node)) continue;
            this.tryReplace(replacements, varNode, bset);
        }
        int ntotal = 0;
        for (Map.Entry e : replacements.entrySet()) {
            VarNode oldVal = (VarNode)e.getKey();
            ConstantNode newVal = (ConstantNode)e.getValue();
            int nmods = whereClause.replaceAllWith(oldVal, newVal);
            nmods += whereClause.replaceAllWith(oldVal, newVal);
            if (log.isInfoEnabled()) {
                log.info((Object)("Replaced " + nmods + " instances of " + oldVal + " with " + newVal));
            }
            ntotal += nmods;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Replaced " + ntotal + " instances of " + replacements.size() + " bound variables with constants"));
        }
        for (IGroupMemberNode node : whereClause) {
            if (!(node instanceof GroupNodeBase)) continue;
            this.doBindingAssignment((GroupNodeBase)node, replacements, bset);
        }
    }

    private Iterator<BOp> iterateExcludeGroups(BOp op) {
        return this.iterateExcludeGroups(0, op);
    }

    private Iterator<BOp> iterateExcludeGroups(final int depth, BOp op) {
        if (op == null || op.arity() == 0) {
            return EmptyIterator.DEFAULT;
        }
        if (depth > 0 && op instanceof GroupNodeBase) {
            return EmptyIterator.DEFAULT;
        }
        return new Striterator(op.argIterator()).addFilter(new Expander(){
            private static final long serialVersionUID = 1L;

            @Override
            protected Iterator expand(Object childObj) {
                BOp child = (BOp)childObj;
                if (child != null && child.arity() > 0) {
                    Striterator itr = new Striterator(new SingleValueIterator<BOp>(child));
                    itr.append(ASTBindingAssigner.this.iterateExcludeGroups(depth + 1, child));
                    return itr;
                }
                return new SingleValueIterator<BOp>(child);
            }
        });
    }

    private void tryReplace(Map<VarNode, ConstantNode> replacements, VarNode varNode, IBindingSet bset) {
        IVariableOrConstant var = varNode.getValueExpression();
        if (bset.isBound((IVariable)var)) {
            IV asBound = (IV)bset.get((IVariable)var).get();
            this.willReplace(replacements, varNode, asBound);
        }
    }

    private void tryReplace(Map<VarNode, ConstantNode> replacements, FilterNode filter) {
        IValueExpressionNode vexpr = filter.getValueExpressionNode();
        if (!(vexpr instanceof FunctionNode)) {
            return;
        }
        FunctionNode functionNode = (FunctionNode)vexpr;
        URI functionURI = functionNode.getFunctionURI();
        if (!functionURI.equals((Object)FunctionRegistry.SAME_TERM) && !functionURI.equals((Object)FunctionRegistry.EQ)) {
            return;
        }
        IValueExpressionNode left = (IValueExpressionNode)((Object)functionNode.get(0));
        IValueExpressionNode right = (IValueExpressionNode)((Object)functionNode.get(1));
        if (left instanceof VarNode && right instanceof ConstantNode) {
            IV constant = (IV)((ConstantNode)right).getValueExpression().get();
            if (functionURI.equals((Object)FunctionRegistry.EQ) && constant.isLiteral()) {
                return;
            }
            this.willReplace(replacements, (VarNode)left, constant);
        } else if (left instanceof ConstantNode && right instanceof VarNode) {
            IV constant = (IV)((ConstantNode)left).getValueExpression().get();
            if (functionURI.equals((Object)FunctionRegistry.EQ) && constant.isLiteral()) {
                return;
            }
            this.willReplace(replacements, (VarNode)right, constant);
        }
    }

    private void willReplace(Map<VarNode, ConstantNode> replacements, VarNode varNode, IV<?, ?> asBound) {
        if (replacements.containsKey(varNode)) {
            return;
        }
        ConstantNode constNode = new ConstantNode((IConstant<IV>)new Constant<IV>((IVariable<IV>)varNode.getValueExpression(), asBound));
        if (log.isInfoEnabled()) {
            log.info((Object)("Will replace: var=" + varNode + " with (" + asBound + ") as " + constNode));
        }
        replacements.put(varNode, constNode);
    }
}

