/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.ExistsNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.IValueExpressionNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.NotExistsNode;
import com.bigdata.rdf.sparql.ast.ProjectionNode;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryFunctionNodeBase;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.LinkedHashSet;
import java.util.Set;

public class ASTExistsOptimizer
implements IASTOptimizer {
    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSets) {
        GraphPatternGroup whereClause;
        if (!(queryNode instanceof QueryRoot)) {
            return queryNode;
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        StaticAnalysis sa = new StaticAnalysis(queryRoot, context);
        Set<IVariable<?>> exogenousVars = context.getSolutionSetStats().getUsedVars();
        if (queryRoot.getNamedSubqueries() != null) {
            for (NamedSubqueryRoot subqueryRoot : queryRoot.getNamedSubqueries()) {
                GraphPatternGroup whereClause2 = subqueryRoot.getWhereClause();
                this.rewrite(sa, exogenousVars, subqueryRoot, whereClause2);
            }
        }
        if ((whereClause = queryRoot.getWhereClause()) == null) {
            throw new RuntimeException("Missing where clause? : " + queryNode);
        }
        this.rewrite(sa, exogenousVars, queryRoot, whereClause);
        return queryRoot;
    }

    private void rewrite(StaticAnalysis sa, Set<IVariable<?>> exogenousVars, QueryBase query, GraphPatternGroup<IGroupMemberNode> p) {
        int arity = p.size();
        for (int i = 0; i < arity; ++i) {
            IGroupMemberNode child = (IGroupMemberNode)p.get(i);
            if (child instanceof FilterNode) {
                FilterNode filter = (FilterNode)child;
                this.rewrite(sa, exogenousVars, query, p, filter, filter.getValueExpressionNode());
            }
            if (child instanceof GraphPatternGroup) {
                this.rewrite(sa, exogenousVars, query, (GraphPatternGroup)child);
            }
            if (!(child instanceof SubqueryRoot)) continue;
            SubqueryRoot subquery = (SubqueryRoot)child;
            this.rewrite(sa, exogenousVars, subquery, subquery.getWhereClause());
        }
    }

    private void rewrite(StaticAnalysis sa, Set<IVariable<?>> exogenousVars, QueryBase query, GraphPatternGroup<IGroupMemberNode> p, FilterNode filter, IValueExpressionNode ve) {
        SubqueryFunctionNodeBase subqueryFunction;
        GraphPatternGroup<IGroupMemberNode> graphPattern;
        if (ve instanceof SubqueryFunctionNodeBase && (graphPattern = (subqueryFunction = (SubqueryFunctionNodeBase)ve).getGraphPattern()) != null && (subqueryFunction instanceof ExistsNode || subqueryFunction instanceof NotExistsNode)) {
            SubqueryRoot subquery = new SubqueryRoot(QueryType.ASK);
            subquery.setFilterExistsMode(subqueryFunction.getFilterExistsMode());
            ProjectionNode projection = new ProjectionNode();
            subquery.setProjection(projection);
            VarNode anonVar = (VarNode)subqueryFunction.get(0);
            subquery.setAskVar((IVariable<?>)anonVar.getValueExpression());
            LinkedHashSet vars = new LinkedHashSet();
            vars.addAll(exogenousVars);
            sa.getMaybeIncomingBindings(p, vars);
            sa.getMaybeProducedBindings(p, vars, true);
            Set<IVariable<?>> usedVars = sa.getSpannedVariables(graphPattern, new LinkedHashSet());
            vars.retainAll(usedVars);
            for (IVariable iVariable : vars) {
                projection.addProjectionVar(new VarNode(iVariable.getName()));
            }
            projection.addProjectionVar(anonVar);
            subquery.setWhereClause(graphPattern);
            p.addChild(subquery);
        }
        int arity = ((BOp)((Object)ve)).arity();
        for (int i = 0; i < arity; ++i) {
            BOp child = ((BOp)((Object)ve)).get(i);
            if (!(child instanceof IValueExpressionNode)) continue;
            this.rewrite(sa, exogenousVars, query, p, filter, (IValueExpressionNode)((Object)child));
        }
    }
}

