/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.IGroupNode;
import com.bigdata.rdf.sparql.ast.IQueryNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueriesNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryRoot;
import com.bigdata.rdf.sparql.ast.QueryBase;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.LinkedList;

public class ASTFlattenJoinGroupsOptimizer
implements IASTOptimizer {
    @Override
    public IQueryNode optimize(AST2BOpContext context, IQueryNode queryNode, IBindingSet[] bindingSets) {
        if (!(queryNode instanceof QueryRoot)) {
            return queryNode;
        }
        QueryRoot queryRoot = (QueryRoot)queryNode;
        GraphPatternGroup whereClause = queryRoot.getWhereClause();
        if (whereClause != null) {
            ASTFlattenJoinGroupsOptimizer.flattenGroups(whereClause);
        }
        if (queryRoot.getNamedSubqueries() != null) {
            NamedSubqueriesNode namedSubqueries = queryRoot.getNamedSubqueries();
            for (int i = 0; i < namedSubqueries.size(); ++i) {
                NamedSubqueryRoot namedSubquery = (NamedSubqueryRoot)namedSubqueries.get(i);
                GraphPatternGroup whereClause2 = namedSubquery.getWhereClause();
                if (whereClause2 == null) continue;
                ASTFlattenJoinGroupsOptimizer.flattenGroups(whereClause2);
            }
        }
        return queryNode;
    }

    private static void flattenGroups(GroupNodeBase<?> op) {
        for (int i = 0; i < op.arity(); ++i) {
            BOp child = op.get(i);
            if (child instanceof GroupNodeBase) {
                GroupNodeBase childGroup = (GroupNodeBase)child;
                ASTFlattenJoinGroupsOptimizer.flattenGroups(childGroup);
                continue;
            }
            if (!(child instanceof QueryBase)) continue;
            QueryBase subquery = (QueryBase)child;
            GraphPatternGroup childGroup = subquery.getWhereClause();
            ASTFlattenJoinGroupsOptimizer.flattenGroups(childGroup);
        }
        IGroupNode<IGroupMemberNode> parent = op.getParent();
        if (op instanceof JoinGroupNode && !((JoinGroupNode)op).isOptional() && !((JoinGroupNode)op).isMinus() && parent != null && parent instanceof JoinGroupNode) {
            JoinGroupNode thisJoinGroup = (JoinGroupNode)op;
            JoinGroupNode parentJoinGroup = (JoinGroupNode)parent;
            int pos = parentJoinGroup.indexOf(thisJoinGroup);
            LinkedList children = new LinkedList(thisJoinGroup.getChildren());
            for (IGroupMemberNode child : children) {
                thisJoinGroup.removeChild(child);
                parentJoinGroup.addArg(pos++, child);
            }
            parentJoinGroup.removeChild(thisJoinGroup);
        }
    }
}

