/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IValueExpression;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.sparql.ast.ArbitraryLengthPathNode;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.PropertyPathUnionNode;
import com.bigdata.rdf.sparql.ast.QueryType;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.ZeroLengthPathNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.ASTStaticJoinOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractJoinGroupOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import com.bigdata.rdf.sparql.ast.service.ServiceFactory;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openrdf.model.URI;

public class ASTJoinOrderByTypeOptimizer
extends AbstractJoinGroupOptimizer
implements IASTOptimizer {
    /*
     * WARNING - void declaration
     */
    @Override
    protected void optimizeJoinGroup(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode joinGroup) {
        void var10_43;
        GraphPatternGroup subgroup;
        StatementPatternNode sp;
        if (!ASTStaticJoinOptimizer.isStaticOptimizer(ctx, joinGroup)) {
            return;
        }
        LinkedList<IGroupMemberNode> ordered = new LinkedList<IGroupMemberNode>();
        List<AssignmentNode> assignments = joinGroup.getAssignments();
        List<ServiceNode> serviceNodes = joinGroup.getServiceNodes();
        LinkedList<SubqueryRoot> askSubqueries = new LinkedList<SubqueryRoot>();
        for (BindingsClause bindingsClause : joinGroup.getChildren(BindingsClause.class)) {
            ordered.add(bindingsClause);
        }
        Iterator<AssignmentNode> aitr = assignments.iterator();
        while (aitr.hasNext()) {
            AssignmentNode assignmentNode = aitr.next();
            IValueExpression<? extends IV> valExpr = assignmentNode.getValueExpression();
            if (!(valExpr instanceof IConstant)) continue;
            ordered.add(assignmentNode);
            aitr.remove();
        }
        for (IGroupMemberNode iGroupMemberNode : sa.getPreFilters(joinGroup)) {
            ordered.add(iGroupMemberNode);
        }
        for (IGroupMemberNode iGroupMemberNode : joinGroup.getInFilters()) {
            ordered.add(iGroupMemberNode);
        }
        Iterator<ServiceNode> sitr = serviceNodes.iterator();
        while (sitr.hasNext()) {
            ServiceNode serviceNode = sitr.next();
            if (!serviceNode.getServiceRef().isConstant()) continue;
            URI serviceURI = (URI)serviceNode.getServiceRef().getValue();
            ServiceFactory f = ServiceRegistry.getInstance().get(serviceURI);
            if (f == null || !f.getServiceOptions().isRunFirst()) continue;
            ordered.add(serviceNode);
            sitr.remove();
        }
        for (IGroupMemberNode iGroupMemberNode : joinGroup) {
            if (!(iGroupMemberNode instanceof NamedSubqueryInclude)) continue;
            ordered.add(iGroupMemberNode);
        }
        for (IGroupMemberNode iGroupMemberNode : joinGroup) {
            if (iGroupMemberNode instanceof StatementPatternNode) {
                sp = (StatementPatternNode)iGroupMemberNode;
                if (sp.isOptional()) continue;
                ordered.add(iGroupMemberNode);
                continue;
            }
            if (!(iGroupMemberNode instanceof ArbitraryLengthPathNode) && !(iGroupMemberNode instanceof ZeroLengthPathNode) && !(iGroupMemberNode instanceof PropertyPathUnionNode)) continue;
            ordered.add(iGroupMemberNode);
        }
        for (IGroupMemberNode iGroupMemberNode : sa.getJoinFilters(joinGroup)) {
            ordered.add(iGroupMemberNode);
        }
        for (IGroupMemberNode iGroupMemberNode : joinGroup) {
            if (!(iGroupMemberNode instanceof SubqueryRoot)) continue;
            SubqueryRoot subquery = (SubqueryRoot)iGroupMemberNode;
            if (subquery.getQueryType() == QueryType.ASK) {
                askSubqueries.add(subquery);
                continue;
            }
            ordered.add(iGroupMemberNode);
        }
        for (IGroupMemberNode iGroupMemberNode : joinGroup) {
            if (!(iGroupMemberNode instanceof GraphPatternGroup) || (subgroup = (GraphPatternGroup)iGroupMemberNode).isOptional() || subgroup instanceof PropertyPathUnionNode) continue;
            ordered.add(subgroup);
        }
        sitr = serviceNodes.iterator();
        while (sitr.hasNext()) {
            ServiceNode serviceNode = sitr.next();
            if (!serviceNode.getServiceRef().isConstant()) continue;
            sitr.remove();
            ordered.add(serviceNode);
        }
        for (ServiceNode serviceNode : serviceNodes) {
            ordered.add(serviceNode);
        }
        for (SubqueryRoot subqueryRoot : askSubqueries) {
            ordered.add(subqueryRoot);
        }
        for (IGroupMemberNode iGroupMemberNode : joinGroup) {
            if (iGroupMemberNode instanceof StatementPatternNode && (sp = (StatementPatternNode)iGroupMemberNode).isOptional()) {
                ordered.add(sp);
            }
            if (!(iGroupMemberNode instanceof GraphPatternGroup) || !(subgroup = (GraphPatternGroup)iGroupMemberNode).isOptional() || subgroup instanceof PropertyPathUnionNode) continue;
            ordered.add(subgroup);
        }
        for (AssignmentNode assignmentNode : assignments) {
            ordered.add(assignmentNode);
        }
        for (IGroupMemberNode iGroupMemberNode : sa.getPostFilters(joinGroup)) {
            ordered.add(iGroupMemberNode);
        }
        int arity = joinGroup.arity();
        if (ordered.size() != arity) {
            throw new AssertionError((Object)"should not be pruning any children");
        }
        boolean bl = false;
        while (var10_43 < arity) {
            joinGroup.setArg((int)var10_43, (BOp)ordered.get((int)var10_43));
            ++var10_43;
        }
    }
}

