/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.optimizers;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.rdf.sparql.ast.ArbitraryLengthPathNode;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.FunctionNode;
import com.bigdata.rdf.sparql.ast.FunctionRegistry;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.PathNode;
import com.bigdata.rdf.sparql.ast.PropertyPathNode;
import com.bigdata.rdf.sparql.ast.PropertyPathUnionNode;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.ZeroLengthPathNode;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpContext;
import com.bigdata.rdf.sparql.ast.optimizers.AbstractJoinGroupOptimizer;
import com.bigdata.rdf.sparql.ast.optimizers.IASTOptimizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import org.openrdf.query.algebra.StatementPattern;

public class ASTPropertyPathOptimizer
extends AbstractJoinGroupOptimizer
implements IASTOptimizer {
    private final String anon = "--pp-anon-";
    int i = 1;

    @Override
    protected void optimizeJoinGroup(AST2BOpContext ctx, StaticAnalysis sa, IBindingSet[] bSets, JoinGroupNode group) {
        for (PropertyPathNode node : group.getChildren(PropertyPathNode.class)) {
            this.optimize(ctx, sa, group, node);
        }
    }

    protected void optimize(AST2BOpContext ctx, StaticAnalysis sa, JoinGroupNode group, PropertyPathNode ppNode) {
        PathNode.PathAlternative pathRoot = ppNode.p().getPathAlternative();
        PropertyPathInfo sp = new PropertyPathInfo(ppNode.s(), ppNode.o(), ppNode.c(), ppNode.getScope());
        this.optimize(ctx, sa, (GraphPatternGroup<? extends IGroupMemberNode>)group, sp, pathRoot);
        group.removeChild(ppNode);
    }

    protected void optimize(AST2BOpContext ctx, StaticAnalysis sa, GraphPatternGroup<? extends IGroupMemberNode> group, PropertyPathInfo ppInfo, PathNode.PathAlternative pathAlt) {
        if (pathAlt.arity() == 1) {
            PathNode.PathSequence pathSeq = (PathNode.PathSequence)pathAlt.get(0);
            this.optimize(ctx, sa, group, ppInfo, pathSeq);
        } else {
            PropertyPathUnionNode union = new PropertyPathUnionNode();
            group.addArg(union);
            Iterator<BOp> it = pathAlt.argIterator();
            while (it.hasNext()) {
                JoinGroupNode subgroup = new JoinGroupNode();
                union.addArg(subgroup);
                PathNode.PathSequence pathSeq = (PathNode.PathSequence)it.next();
                this.optimize(ctx, sa, (GraphPatternGroup<? extends IGroupMemberNode>)subgroup, ppInfo, pathSeq);
            }
        }
    }

    protected void optimize(AST2BOpContext ctx, StaticAnalysis sa, GraphPatternGroup<? extends IGroupMemberNode> group, PropertyPathInfo ppInfo, PathNode.PathSequence pathSeq) {
        if (pathSeq.arity() == 0) {
            return;
        }
        if (pathSeq.arity() == 1) {
            PathNode.PathElt pathElt = (PathNode.PathElt)pathSeq.get(0);
            this.optimize(ctx, sa, group, ppInfo, pathElt);
        } else {
            for (int i = 0; i < pathSeq.arity(); ++i) {
                PathNode.PathElt pathElt = (PathNode.PathElt)pathSeq.get(i);
                PathNode.PathMod mod = pathElt.getMod();
                if (i >= pathSeq.arity() - 1 || mod != PathNode.PathMod.ZERO_OR_ONE && mod != PathNode.PathMod.ZERO_OR_MORE) continue;
                ArrayList<PathNode.PathElt> newSeq = new ArrayList<PathNode.PathElt>(i + 1);
                ArrayList<PathNode.PathElt> with = new ArrayList<PathNode.PathElt>(pathSeq.arity() - i);
                ArrayList<PathNode.PathElt> without = new ArrayList<PathNode.PathElt>(pathSeq.arity() - i - 1);
                for (int j = 0; j < pathSeq.arity(); ++j) {
                    PathNode.PathElt elt = (PathNode.PathElt)pathSeq.get(j);
                    if (j < i) {
                        newSeq.add(elt);
                        continue;
                    }
                    if (j == i) {
                        PathNode.PathElt _pathElt = new PathNode.PathElt(pathElt);
                        if (mod == PathNode.PathMod.ZERO_OR_ONE) {
                            _pathElt.setMod(null);
                        } else {
                            _pathElt.setMod(PathNode.PathMod.ONE_OR_MORE);
                        }
                        with.add(_pathElt);
                        continue;
                    }
                    with.add(new PathNode.PathElt(elt));
                    without.add(new PathNode.PathElt(elt));
                }
                newSeq.add(new PathNode.PathElt((BOp)new PathNode.PathAlternative(new PathNode.PathSequence(with.toArray(new PathNode.PathElt[with.size()])), new PathNode.PathSequence(without.toArray(new PathNode.PathElt[without.size()])))));
                PathNode.PathSequence pathSeq2 = new PathNode.PathSequence(newSeq.toArray(new PathNode.PathElt[newSeq.size()]));
                this.optimize(ctx, sa, group, ppInfo, pathSeq2);
                return;
            }
            TermNode last = ppInfo.s;
            for (int i = 0; i < pathSeq.arity(); ++i) {
                TermNode next = i == pathSeq.arity() - 1 ? ppInfo.o : this.anonVar();
                PropertyPathInfo _ppInfo = new PropertyPathInfo(last, next, ppInfo);
                PathNode.PathElt pathElt = (PathNode.PathElt)pathSeq.get(i);
                this.optimize(ctx, sa, group, _ppInfo, pathElt);
                last = next;
            }
        }
    }

    private VarNode anonVar() {
        VarNode v = new VarNode("--pp-anon-" + UUID.randomUUID().toString());
        v.setAnonymous(true);
        return v;
    }

    protected VarNode anonVar(String anon) {
        VarNode v = new VarNode(anon + UUID.randomUUID().toString());
        v.setAnonymous(true);
        return v;
    }

    protected void optimize(AST2BOpContext ctx, StaticAnalysis sa, GraphPatternGroup<? extends IGroupMemberNode> group, PropertyPathInfo ppInfo, PathNode.PathElt pathElt) {
        ppInfo = pathElt.inverse() ? ppInfo.inverse() : ppInfo;
        PathNode.PathMod mod = pathElt.getMod();
        if (mod != null) {
            VarNode tVarLeft = new VarNode(this.anonVar("-tVarLeft-"));
            VarNode tVarRight = new VarNode(this.anonVar("-tVarRight-"));
            ArbitraryLengthPathNode alpNode = new ArbitraryLengthPathNode(ppInfo.s, ppInfo.o, tVarLeft, tVarRight, mod);
            group.addArg(alpNode);
            ppInfo = new PropertyPathInfo(tVarLeft, tVarRight, ppInfo);
            group = alpNode.subgroup();
        }
        if (pathElt.isNestedPath()) {
            PathNode.PathAlternative pathAlt = (PathNode.PathAlternative)pathElt.get(0);
            this.optimize(ctx, sa, group, ppInfo, pathAlt);
        } else if (pathElt.isNegatedPropertySet()) {
            PathNode.PathNegatedPropertySet pathNPS = (PathNode.PathNegatedPropertySet)pathElt.get(0);
            this.optimize(ctx, sa, group, ppInfo, pathNPS);
        } else if (pathElt.isZeroLengthPath()) {
            ZeroLengthPathNode zlpNode = (ZeroLengthPathNode)pathElt.get(0);
            this.optimize(ctx, sa, group, ppInfo, zlpNode);
        } else {
            ConstantNode termNode = (ConstantNode)pathElt.get(0);
            this.optimize(ctx, sa, group, ppInfo, termNode);
        }
    }

    protected void optimize(AST2BOpContext ctx, StaticAnalysis sa, GraphPatternGroup<? extends IGroupMemberNode> group, PropertyPathInfo ppInfo, TermNode termNode) {
        StatementPatternNode sp = ppInfo.toStatementPattern(termNode);
        group.addArg(sp);
    }

    protected void optimize(AST2BOpContext ctx, StaticAnalysis sa, GraphPatternGroup<? extends IGroupMemberNode> group, PropertyPathInfo ppInfo, ZeroLengthPathNode zlpNode) {
        zlpNode.setLeft(ppInfo.s);
        zlpNode.setRight(ppInfo.o);
        group.addArg(zlpNode);
    }

    protected void optimize(AST2BOpContext ctx, StaticAnalysis sa, GraphPatternGroup<? extends IGroupMemberNode> group, PropertyPathInfo ppInfo, PathNode.PathNegatedPropertySet pathNPS) {
        ArrayList<ConstantNode> forward = null;
        ArrayList<ConstantNode> back = null;
        for (BOp child : pathNPS.args()) {
            PathNode.PathOneInPropertySet pathOIPS = (PathNode.PathOneInPropertySet)child;
            ConstantNode iri = (ConstantNode)pathOIPS.get(0);
            if (pathOIPS.inverse()) {
                if (back == null) {
                    back = new ArrayList<ConstantNode>();
                }
                back.add(iri);
                continue;
            }
            if (forward == null) {
                forward = new ArrayList<ConstantNode>();
            }
            forward.add(iri);
        }
        if (forward != null && back != null) {
            PropertyPathUnionNode union = new PropertyPathUnionNode();
            JoinGroupNode forwardGroup = new JoinGroupNode();
            JoinGroupNode backGroup = new JoinGroupNode();
            union.addArg(forwardGroup);
            union.addArg(backGroup);
            group.addArg(union);
            this.addNegateds(forwardGroup, forward, ppInfo);
            this.addNegateds(backGroup, back, ppInfo.inverse());
        } else if (forward != null) {
            this.addNegateds(group, forward, ppInfo);
        } else {
            this.addNegateds(group, back, ppInfo.inverse());
        }
    }

    protected void addNegateds(GraphPatternGroup<? extends IGroupMemberNode> group, ArrayList<ConstantNode> constants, PropertyPathInfo ppInfo) {
        VarNode p = this.anonVar();
        StatementPatternNode sp = ppInfo.toStatementPattern(p);
        ValueExpressionNode[] args = new TermNode[constants.size() + 1];
        args[0] = p;
        System.arraycopy(constants.toArray(new ConstantNode[constants.size()]), 0, args, 1, constants.size());
        FunctionNode function = new FunctionNode(FunctionRegistry.NOT_IN, null, args);
        FilterNode filter = new FilterNode(function);
        group.addArg(sp);
        group.addArg(filter);
    }

    public static final boolean isSimpleIRI(PathNode.PathAlternative pathAlt) {
        PathNode.PathSequence pathSeq;
        if (pathAlt.arity() == 1 && (pathSeq = (PathNode.PathSequence)pathAlt.get(0)).arity() == 1) {
            PathNode.PathElt pathElt = (PathNode.PathElt)pathSeq.get(0);
            return !pathElt.inverse() && pathElt.getMod() == null && pathElt.isIRI();
        }
        return false;
    }

    public static final ConstantNode getSimpleIRI(PathNode.PathAlternative pathAlt) {
        PathNode.PathElt pathElt;
        PathNode.PathSequence pathSeq;
        if (pathAlt.arity() == 1 && (pathSeq = (PathNode.PathSequence)pathAlt.get(0)).arity() == 1 && !(pathElt = (PathNode.PathElt)pathSeq.get(0)).inverse() && pathElt.getMod() == null && pathElt.isIRI()) {
            return (ConstantNode)pathElt.get(0);
        }
        return null;
    }

    private static class PropertyPathInfo {
        public final TermNode s;
        public final TermNode o;
        public final TermNode c;
        public final StatementPattern.Scope scope;

        public PropertyPathInfo(TermNode s, TermNode o, TermNode c, StatementPattern.Scope scope) {
            this.s = s;
            this.o = o;
            this.c = c;
            this.scope = scope;
        }

        public PropertyPathInfo(TermNode s, TermNode o, PropertyPathInfo base) {
            this(s, o, base.c, base.scope);
        }

        public PropertyPathInfo inverse() {
            return new PropertyPathInfo(this.o, this.s, this.c, this.scope);
        }

        public StatementPatternNode toStatementPattern(TermNode p) {
            return new StatementPatternNode(this.s, p, this.o, this.c, this.scope);
        }
    }
}

